/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.onetoonejointable;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.RelationTableMechanism;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.testing.models.onetoonejointable.Address;
import org.eclipse.persistence.testing.models.onetoonejointable.Child;
import org.eclipse.persistence.testing.models.onetoonejointable.Employee;
import org.eclipse.persistence.testing.models.onetoonejointable.LargeProject;
import org.eclipse.persistence.testing.models.onetoonejointable.Project;
import org.eclipse.persistence.testing.models.onetoonejointable.SmallProject;

public class EmployeeProject
extends org.eclipse.persistence.sessions.Project {
    public EmployeeProject() {
        this.setName("OTOJT_Employee");
        this.setDatasourceLogin((Login)new DatabaseLogin());
        this.addDescriptor(this.buildAddressDescriptor());
        this.addDescriptor(this.buildChildDescriptor());
        this.addDescriptor(this.buildEmployeeDescriptor());
        this.addDescriptor(this.buildLargeProjectDescriptor());
        this.addDescriptor(this.buildProjectDescriptor());
        this.addDescriptor(this.buildSmallProjectDescriptor());
    }

    public ClassDescriptor buildAddressDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Address.class);
        descriptor.addTableName("OTOJT_ADDRESS");
        descriptor.addPrimaryKeyFieldName("OTOJT_ADDRESS.ADDRESS_ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("OTOJT_ADDRESS.ADDRESS_ID");
        descriptor.setSequenceNumberName("OTOJT_ADDRESS_SEQ");
        descriptor.setAlias("OTOJT_Address");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping cityMapping = new DirectToFieldMapping();
        cityMapping.setAttributeName("city");
        cityMapping.setFieldName("OTOJT_ADDRESS.CITY");
        descriptor.addMapping((DatabaseMapping)cityMapping);
        DirectToFieldMapping countryMapping = new DirectToFieldMapping();
        countryMapping.setAttributeName("country");
        countryMapping.setFieldName("OTOJT_ADDRESS.COUNTRY");
        descriptor.addMapping((DatabaseMapping)countryMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("OTOJT_ADDRESS.ADDRESS_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping postalCodeMapping = new DirectToFieldMapping();
        postalCodeMapping.setAttributeName("postalCode");
        postalCodeMapping.setFieldName("OTOJT_ADDRESS.P_CODE");
        descriptor.addMapping((DatabaseMapping)postalCodeMapping);
        DirectToFieldMapping provinceMapping = new DirectToFieldMapping();
        provinceMapping.setAttributeName("province");
        provinceMapping.setFieldName("OTOJT_ADDRESS.PROVINCE");
        descriptor.addMapping((DatabaseMapping)provinceMapping);
        DirectToFieldMapping streetMapping = new DirectToFieldMapping();
        streetMapping.setAttributeName("street");
        streetMapping.setFieldName("OTOJT_ADDRESS.STREET");
        descriptor.addMapping((DatabaseMapping)streetMapping);
        return descriptor;
    }

    public ClassDescriptor buildChildDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Child.class);
        descriptor.addTableName("OTOJT_CHILD");
        descriptor.addPrimaryKeyFieldName("OTOJT_CHILD.CHILD_ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(50);
        descriptor.setSequenceNumberFieldName("OTOJT_CHILD.CHILD_ID");
        descriptor.setSequenceNumberName("OTOJT_CHILD_SEQ");
        descriptor.setAlias("OTOJT_Child");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping firstNameMapping = new DirectToFieldMapping();
        firstNameMapping.setAttributeName("firstName");
        firstNameMapping.setFieldName("F_NAME");
        firstNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)firstNameMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("CHILD_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping lastNameMapping = new DirectToFieldMapping();
        lastNameMapping.setAttributeName("lastName");
        lastNameMapping.setFieldName("L_NAME");
        lastNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)lastNameMapping);
        DirectToFieldMapping genderMapping = new DirectToFieldMapping();
        genderMapping.setAttributeName("gender");
        genderMapping.setFieldName("GENDER");
        ObjectTypeConverter genderMappingConverter = new ObjectTypeConverter();
        genderMappingConverter.addConversionValue((Object)"F", (Object)"Female");
        genderMappingConverter.addConversionValue((Object)"M", (Object)"Male");
        genderMapping.setConverter((Converter)genderMappingConverter);
        descriptor.addMapping((DatabaseMapping)genderMapping);
        DirectToFieldMapping birthdayMapping = new DirectToFieldMapping();
        birthdayMapping.setAttributeName("birthday");
        birthdayMapping.setFieldName("BIRTHDAY");
        descriptor.addMapping((DatabaseMapping)birthdayMapping);
        OneToOneMapping parentMapping = new OneToOneMapping();
        parentMapping.setAttributeName("parent");
        parentMapping.setReferenceClass(Employee.class);
        parentMapping.dontUseIndirection();
        parentMapping.setRelationTableMechanism(new RelationTableMechanism());
        parentMapping.getRelationTableMechanism().setRelationTableName("OTOJT_CHILD_PARENT");
        parentMapping.getRelationTableMechanism().addSourceRelationKeyFieldName("OTOJT_CHILD_PARENT.CHILD_ID", "OTOJT_CHILD.CHILD_ID");
        parentMapping.getRelationTableMechanism().addTargetRelationKeyFieldName("OTOJT_CHILD_PARENT.EMP_ID", "OTOJT_EMPLOYEE.EMP_ID");
        parentMapping.readOnly();
        descriptor.addMapping((DatabaseMapping)parentMapping);
        return descriptor;
    }

    public ClassDescriptor buildEmployeeDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Employee.class);
        descriptor.addTableName("OTOJT_EMPLOYEE");
        descriptor.addTableName("OTOJT_SALARY");
        descriptor.addPrimaryKeyFieldName("OTOJT_EMPLOYEE.EMP_ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("OTOJT_EMPLOYEE.EMP_ID");
        descriptor.setSequenceNumberName("OTOJT_EMP_SEQ");
        VersionLockingPolicy lockingPolicy = new VersionLockingPolicy();
        lockingPolicy.setWriteLockFieldName("OTOJT_EMPLOYEE.VERSION");
        descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)lockingPolicy);
        descriptor.setAlias("OTOJT_Employee");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping firstNameMapping = new DirectToFieldMapping();
        firstNameMapping.setAttributeName("firstName");
        firstNameMapping.setFieldName("OTOJT_EMPLOYEE.F_NAME");
        firstNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)firstNameMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("OTOJT_EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping lastNameMapping = new DirectToFieldMapping();
        lastNameMapping.setAttributeName("lastName");
        lastNameMapping.setFieldName("OTOJT_EMPLOYEE.L_NAME");
        lastNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)lastNameMapping);
        DirectToFieldMapping salaryMapping = new DirectToFieldMapping();
        salaryMapping.setAttributeName("salary");
        salaryMapping.setFieldName("OTOJT_SALARY.SALARY");
        descriptor.addMapping((DatabaseMapping)salaryMapping);
        DirectToFieldMapping genderMapping = new DirectToFieldMapping();
        genderMapping.setAttributeName("gender");
        genderMapping.setFieldName("OTOJT_EMPLOYEE.GENDER");
        ObjectTypeConverter genderMappingConverter = new ObjectTypeConverter();
        genderMappingConverter.addConversionValue((Object)"F", (Object)"Female");
        genderMappingConverter.addConversionValue((Object)"M", (Object)"Male");
        genderMapping.setConverter((Converter)genderMappingConverter);
        descriptor.addMapping((DatabaseMapping)genderMapping);
        DirectCollectionMapping responsibilitiesListMapping = new DirectCollectionMapping();
        responsibilitiesListMapping.setAttributeName("responsibilitiesList");
        responsibilitiesListMapping.useTransparentList();
        responsibilitiesListMapping.setReferenceTableName("OTOJT_RESPONS");
        responsibilitiesListMapping.setDirectFieldName("OTOJT_RESPONS.DESCRIP");
        responsibilitiesListMapping.addReferenceKeyFieldName("OTOJT_RESPONS.EMP_ID", "OTOJT_EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)responsibilitiesListMapping);
        OneToOneMapping addressMapping = new OneToOneMapping();
        addressMapping.setAttributeName("address");
        addressMapping.setReferenceClass(Address.class);
        addressMapping.useBasicIndirection();
        addressMapping.privateOwnedRelationship();
        addressMapping.setRelationTableMechanism(new RelationTableMechanism());
        addressMapping.getRelationTableMechanism().setRelationTableName("OTOJT_EMP_ADDRESS");
        addressMapping.getRelationTableMechanism().addSourceRelationKeyFieldName("OTOJT_EMP_ADDRESS.EMP_ID", "OTOJT_EMPLOYEE.EMP_ID");
        addressMapping.getRelationTableMechanism().addTargetRelationKeyFieldName("OTOJT_EMP_ADDRESS.ADDR_ID", "OTOJT_ADDRESS.ADDRESS_ID");
        descriptor.addMapping((DatabaseMapping)addressMapping);
        OneToOneMapping managerMapping = new OneToOneMapping();
        managerMapping.setAttributeName("manager");
        managerMapping.setReferenceClass(Employee.class);
        managerMapping.useBasicIndirection();
        managerMapping.setRelationTableMechanism(new RelationTableMechanism());
        managerMapping.getRelationTableMechanism().setRelationTableName("OTOJT_EMP_MANAGER");
        managerMapping.getRelationTableMechanism().addSourceRelationKeyFieldName("OTOJT_EMP_MANAGER.EMP_ID", "OTOJT_EMPLOYEE.EMP_ID");
        managerMapping.getRelationTableMechanism().addTargetRelationKeyFieldName("OTOJT_EMP_MANAGER.MANAGER_ID", "OTOJT_EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)managerMapping);
        ManyToManyMapping managedEmployeesMapping = new ManyToManyMapping();
        managedEmployeesMapping.setAttributeName("managedEmployees");
        managedEmployeesMapping.setReferenceClass(Employee.class);
        managedEmployeesMapping.useTransparentList();
        managedEmployeesMapping.setRelationTableName("OTOJT_EMP_MANAGER");
        managedEmployeesMapping.addSourceRelationKeyFieldName("OTOJT_EMP_MANAGER.MANAGER_ID", "OTOJT_EMPLOYEE.EMP_ID");
        managedEmployeesMapping.addTargetRelationKeyFieldName("OTOJT_EMP_MANAGER.EMP_ID", "OTOJT_EMPLOYEE.EMP_ID");
        managedEmployeesMapping.readOnly();
        descriptor.addMapping((DatabaseMapping)managedEmployeesMapping);
        ManyToManyMapping childrenMapping = new ManyToManyMapping();
        childrenMapping.setAttributeName("children");
        childrenMapping.setReferenceClass(Child.class);
        childrenMapping.addAscendingOrdering("birthday");
        childrenMapping.useTransparentList();
        childrenMapping.privateOwnedRelationship();
        childrenMapping.setRelationTableName("OTOJT_CHILD_PARENT");
        childrenMapping.addSourceRelationKeyFieldName("OTOJT_CHILD_PARENT.EMP_ID", "OTOJT_EMPLOYEE.EMP_ID");
        childrenMapping.addTargetRelationKeyFieldName("OTOJT_CHILD_PARENT.CHILD_ID", "OTOJT_CHILD.CHILD_ID");
        descriptor.addMapping((DatabaseMapping)childrenMapping);
        ManyToManyMapping projectsMapping = new ManyToManyMapping();
        projectsMapping.setAttributeName("projects");
        projectsMapping.setReferenceClass(Project.class);
        projectsMapping.useTransparentList();
        projectsMapping.setRelationTableName("OTOJT_PROJ_EMP");
        projectsMapping.addSourceRelationKeyFieldName("OTOJT_PROJ_EMP.EMP_ID", "OTOJT_EMPLOYEE.EMP_ID");
        projectsMapping.addTargetRelationKeyFieldName("OTOJT_PROJ_EMP.PROJ_ID", "OTOJT_PROJECT.PROJ_ID");
        descriptor.addMapping((DatabaseMapping)projectsMapping);
        OneToOneMapping projectLedMapping = new OneToOneMapping();
        projectLedMapping.setAttributeName("projectLed");
        projectLedMapping.setReferenceClass(Project.class);
        projectLedMapping.useBasicIndirection();
        projectLedMapping.setRelationTableMechanism(new RelationTableMechanism());
        projectLedMapping.getRelationTableMechanism().setRelationTableName("OTOJT_PROJ_LEADER");
        projectLedMapping.getRelationTableMechanism().addSourceRelationKeyFieldName("OTOJT_PROJ_LEADER.EMP_ID", "OTOJT_EMPLOYEE.EMP_ID");
        projectLedMapping.getRelationTableMechanism().addTargetRelationKeyFieldName("OTOJT_PROJ_LEADER.PROJ_ID", "PROJ_ID");
        projectLedMapping.readOnly();
        descriptor.addMapping((DatabaseMapping)projectLedMapping);
        return descriptor;
    }

    public ClassDescriptor buildLargeProjectDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(LargeProject.class);
        descriptor.addTableName("OTOJT_LPROJECT");
        descriptor.getInheritancePolicy().setParentClass(Project.class);
        descriptor.getInheritancePolicy().dontReadSubclassesOnQueries();
        descriptor.setAlias("OTOJT_LargeProject");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping budgetMapping = new DirectToFieldMapping();
        budgetMapping.setAttributeName("budget");
        budgetMapping.setFieldName("OTOJT_LPROJECT.BUDGET");
        descriptor.addMapping((DatabaseMapping)budgetMapping);
        DirectToFieldMapping milestoneVersionMapping = new DirectToFieldMapping();
        milestoneVersionMapping.setAttributeName("milestoneVersion");
        milestoneVersionMapping.setFieldName("OTOJT_LPROJECT.MILESTONE");
        descriptor.addMapping((DatabaseMapping)milestoneVersionMapping);
        return descriptor;
    }

    public ClassDescriptor buildProjectDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Project.class);
        descriptor.addTableName("OTOJT_PROJECT");
        descriptor.addPrimaryKeyFieldName("OTOJT_PROJECT.PROJ_ID");
        descriptor.getInheritancePolicy().setClassIndicatorFieldName("OTOJT_PROJECT.PROJ_TYPE");
        descriptor.getInheritancePolicy().addClassIndicator(SmallProject.class, (Object)"S");
        descriptor.getInheritancePolicy().addClassIndicator(LargeProject.class, (Object)"L");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("OTOJT_PROJECT.PROJ_ID");
        descriptor.setSequenceNumberName("OTOJT_PROJ_SEQ");
        VersionLockingPolicy lockingPolicy = new VersionLockingPolicy();
        lockingPolicy.setWriteLockFieldName("OTOJT_PROJECT.VERSION");
        descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)lockingPolicy);
        descriptor.setAlias("OTOJT_Project");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping descriptionMapping = new DirectToFieldMapping();
        descriptionMapping.setAttributeName("description");
        descriptionMapping.setFieldName("OTOJT_PROJECT.DESCRIP");
        descriptionMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)descriptionMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("OTOJT_PROJECT.PROJ_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("OTOJT_PROJECT.PROJ_NAME");
        nameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        OneToOneMapping teamLeaderMapping = new OneToOneMapping();
        teamLeaderMapping.setAttributeName("teamLeader");
        teamLeaderMapping.setReferenceClass(Employee.class);
        teamLeaderMapping.useBasicIndirection();
        teamLeaderMapping.setRelationTableMechanism(new RelationTableMechanism());
        teamLeaderMapping.getRelationTableMechanism().setRelationTableName("OTOJT_PROJ_LEADER");
        teamLeaderMapping.getRelationTableMechanism().addSourceRelationKeyFieldName("OTOJT_PROJ_LEADER.PROJ_ID", "PROJ_ID");
        teamLeaderMapping.getRelationTableMechanism().addTargetRelationKeyFieldName("OTOJT_PROJ_LEADER.EMP_ID", "OTOJT_EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)teamLeaderMapping);
        ManyToManyMapping employeesMapping = new ManyToManyMapping();
        employeesMapping.setAttributeName("employees");
        employeesMapping.setReferenceClass(Employee.class);
        employeesMapping.readOnly();
        employeesMapping.useTransparentList();
        employeesMapping.setRelationTableName("OTOJT_PROJ_EMP");
        employeesMapping.addSourceRelationKeyFieldName("OTOJT_PROJ_EMP.PROJ_ID", "PROJ_ID");
        employeesMapping.addTargetRelationKeyFieldName("OTOJT_PROJ_EMP.EMP_ID", "OTOJT_EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)employeesMapping);
        return descriptor;
    }

    public ClassDescriptor buildSmallProjectDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(SmallProject.class);
        descriptor.addTableName("OTOJT_PROJECT");
        descriptor.getInheritancePolicy().setParentClass(Project.class);
        descriptor.getInheritancePolicy().dontReadSubclassesOnQueries();
        descriptor.setAlias("OTOJT_SmallProject");
        descriptor.getQueryManager().checkCacheForDoesExist();
        return descriptor;
    }
}

