/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.migration;

import com.sleepycat.persist.model.Persistent;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import oracle.kv.impl.rep.admin.RepNodeAdmin;

@Persistent
public class PartitionMigrationStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TARGET_PREFIX = "Target ";
    private static final String SOURCE_PREFIX = "Source ";
    private boolean forTarget;
    private static final String PARTITION_KEY = "Partition";
    private int partition;
    private static final String TARGET_SHARD_KEY = "Target Shard";
    private int targetShard;
    private static final String SOURCE_SHARD_KEY = "Source Shard";
    private int sourceShard;
    private long operations;
    private static final String START_TIME_KEY = "Start Time";
    private long startTime;
    private static final String END_TIME_KEY = "End Time";
    private long endTime;
    private static final String STATE_KEY = "State";
    private RepNodeAdmin.PartitionMigrationState state;
    private static final String REQUEST_TIME_KEY = "Request Time";
    private long requestTime;
    private static final String ATTEMPTS_KEY = "Attempts";
    private int attempts;
    private static final String BUSY_RESPONSES_KEY = "Busy Responses";
    private int busyResponses;
    private static final String ERRORS_KEY = "Errors";
    private int errors;
    private static final String RECORDS_SENT_KEY = "Records Sent";
    private long recordsSent;
    private static final String CLIENT_OPS_SENT_KEY = "Client Ops Sent";
    private long clientOpsSent;

    public static PartitionMigrationStatus parseTargetStatus(Map<String, String> map) {
        String v = map.get(PARTITION_KEY);
        if (v == null) {
            return null;
        }
        int partition = Integer.valueOf(v);
        v = map.get(TARGET_SHARD_KEY);
        if (v == null) {
            return null;
        }
        int targetShard = Integer.valueOf(v);
        v = map.get(SOURCE_SHARD_KEY);
        if (v == null) {
            return null;
        }
        int sourceShard = Integer.valueOf(v);
        v = map.get(STATE_KEY);
        if (v == null) {
            return null;
        }
        RepNodeAdmin.PartitionMigrationState state = RepNodeAdmin.PartitionMigrationState.valueOf(v);
        v = map.get(REQUEST_TIME_KEY);
        long requestTime = v == null ? 0L : Long.valueOf(v);
        v = map.get("Target Start Time");
        long startTime = v == null ? 0L : Long.valueOf(v);
        v = map.get("Target End Time");
        long endTime = v == null ? 0L : Long.valueOf(v);
        v = map.get(ATTEMPTS_KEY);
        int attempts = v == null ? 0 : Integer.valueOf(v);
        v = map.get(BUSY_RESPONSES_KEY);
        int busyResponses = v == null ? 0 : Integer.valueOf(v);
        v = map.get(ERRORS_KEY);
        int errors = v == null ? 0 : Integer.valueOf(v);
        return new PartitionMigrationStatus(state, partition, targetShard, sourceShard, 0L, requestTime, startTime, endTime, attempts, busyResponses, errors);
    }

    public static PartitionMigrationStatus parseSourceStatus(Map<String, String> map) {
        String v = map.get(PARTITION_KEY);
        if (v == null) {
            return null;
        }
        int partition = Integer.valueOf(v);
        v = map.get(TARGET_SHARD_KEY);
        if (v == null) {
            return null;
        }
        int targetShard = Integer.valueOf(v);
        v = map.get(SOURCE_SHARD_KEY);
        if (v == null) {
            return null;
        }
        int sourceShard = Integer.valueOf(v);
        v = map.get("Source Start Time");
        long startTime = v == null ? 0L : Long.valueOf(v);
        v = map.get("Source End Time");
        long endTime = v == null ? 0L : Long.valueOf(v);
        v = map.get(RECORDS_SENT_KEY);
        long recordsSent = v == null ? 0L : Long.valueOf(v);
        v = map.get(CLIENT_OPS_SENT_KEY);
        long clientOpsSent = v == null ? 0L : Long.valueOf(v);
        return new PartitionMigrationStatus(partition, targetShard, sourceShard, 0L, startTime, endTime, recordsSent, clientOpsSent);
    }

    PartitionMigrationStatus(RepNodeAdmin.PartitionMigrationState state, int partition, int targetShard, int sourceShard, long operations, long requestTime, long startTime, long endTime, int attempts, int busyResponses, int errors) {
        assert (state != null);
        this.state = state;
        this.partition = partition;
        this.targetShard = targetShard;
        this.sourceShard = sourceShard;
        this.operations = operations;
        this.requestTime = requestTime;
        this.startTime = startTime;
        this.endTime = endTime;
        this.attempts = attempts;
        this.busyResponses = busyResponses;
        this.errors = errors;
        this.recordsSent = 0L;
        this.clientOpsSent = 0L;
        this.forTarget = true;
    }

    PartitionMigrationStatus(int partition, int targetShard, int sourceShard, long operations, long startTime, long endTime, long recordsSent, long clientOpsSent) {
        this.state = null;
        this.partition = partition;
        this.targetShard = targetShard;
        this.sourceShard = sourceShard;
        this.requestTime = 0L;
        this.startTime = startTime;
        this.endTime = endTime;
        this.attempts = 0;
        this.busyResponses = 0;
        this.errors = 0;
        this.operations = operations;
        this.recordsSent = recordsSent;
        this.clientOpsSent = clientOpsSent;
        this.forTarget = false;
    }

    private PartitionMigrationStatus() {
    }

    public boolean forTarget() {
        return this.forTarget;
    }

    public boolean forSource() {
        return !this.forTarget;
    }

    public RepNodeAdmin.PartitionMigrationState getState() {
        return this.state;
    }

    public int getPartition() {
        return this.partition;
    }

    public int getTargetShard() {
        return this.targetShard;
    }

    public int getSourceShard() {
        return this.sourceShard;
    }

    public long getOperations() {
        return this.operations;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public int getBusyResponses() {
        return this.busyResponses;
    }

    public int getErrors() {
        return this.errors;
    }

    public long getRecordsSent() {
        return this.recordsSent;
    }

    public long getClientOpsSent() {
        return this.clientOpsSent;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PARTITION_KEY, String.valueOf(this.partition));
        map.put(TARGET_SHARD_KEY, String.valueOf(this.targetShard));
        map.put(SOURCE_SHARD_KEY, String.valueOf(this.sourceShard));
        if (this.forTarget) {
            map.put(STATE_KEY, this.state.name());
            map.put(REQUEST_TIME_KEY, String.valueOf(this.requestTime));
            map.put("Target Start Time", String.valueOf(this.startTime));
            map.put("Target End Time", String.valueOf(this.endTime));
            map.put(ATTEMPTS_KEY, String.valueOf(this.attempts));
            map.put(BUSY_RESPONSES_KEY, String.valueOf(this.busyResponses));
            map.put(ERRORS_KEY, String.valueOf(this.errors));
        } else {
            map.put("Source Start Time", String.valueOf(this.startTime));
            map.put("Source End Time", String.valueOf(this.endTime));
            map.put(RECORDS_SENT_KEY, String.valueOf(this.recordsSent));
            map.put(CLIENT_OPS_SENT_KEY, String.valueOf(this.clientOpsSent));
        }
        return map;
    }

    public String toString() {
        return this.display("");
    }

    public String display(String prefix) {
        StringBuilder sb = new StringBuilder();
        if (this.forTarget) {
            sb.append(prefix).append("Partition migration target status:");
            sb.append("\n").append(prefix);
            sb.append("State=").append(this.state.name());
        } else {
            sb.append(prefix).append("Partition migration source status:");
        }
        sb.append("\n").append(prefix);
        sb.append("Partition=").append(this.partition);
        sb.append("\n").append(prefix);
        sb.append("Target Shard=").append(this.targetShard);
        sb.append("\n").append(prefix);
        sb.append("Source Shard=").append(this.sourceShard);
        if (this.forTarget) {
            sb.append("\n").append(prefix);
            sb.append("Request Time=").append(this.toDate(this.requestTime));
        }
        sb.append("\n").append(prefix);
        sb.append("Start Time=").append(this.toDate(this.startTime));
        sb.append("\n").append(prefix);
        sb.append("End Time=").append(this.toDate(this.endTime));
        if (this.forTarget) {
            sb.append("\n").append(prefix);
            sb.append("Attempts=").append(this.attempts);
            sb.append("\n").append(prefix);
            sb.append("Busy Responses=").append(this.busyResponses);
            sb.append("\n").append(prefix);
            sb.append("Errors=").append(this.errors);
        } else {
            sb.append("\n").append(prefix);
            sb.append("Records Sent=").append(this.recordsSent);
            sb.append("\n").append(prefix);
            sb.append("Client Ops Sent=").append(this.clientOpsSent);
        }
        return sb.toString();
    }

    private String toDate(long t) {
        return t == 0L ? "N/A" : new Date(t).toString();
    }
}

