/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.tinybundles.core.intern;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Jar;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;
import org.ops4j.io.StreamUtils;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.tinybundles.core.BuildStrategy;
import org.ops4j.pax.tinybundles.core.intern.UIDProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BndBuilder
implements BuildStrategy {
    private static Logger LOG = LoggerFactory.getLogger(BndBuilder.class);
    private final BuildStrategy m_builder;

    public BndBuilder(BuildStrategy builder) {
        this.m_builder = builder;
    }

    @Override
    public InputStream build(Map<String, URL> resources, Map<String, String> headers) {
        return this.wrapWithBnd(headers, this.m_builder.build(resources, headers));
    }

    private InputStream wrapWithBnd(Map<String, String> headers, InputStream in) {
        try {
            Properties p = new Properties();
            p.putAll(headers);
            return this.createBundle(in, p, "BuildByTinyBundles" + UIDProvider.getUID());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private InputStream createBundle(InputStream jarInputStream, Properties instructions, String symbolicName) throws Exception {
        NullArgumentException.validateNotNull((Object)jarInputStream, (String)"Jar URL");
        NullArgumentException.validateNotNull((Object)instructions, (String)"Instructions");
        NullArgumentException.validateNotEmpty((String)symbolicName, (String)"Jar info");
        Jar jar = new Jar("dot", this.sink(jarInputStream));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)instructions);
        Analyzer analyzer = new Analyzer();
        analyzer.setJar(jar);
        analyzer.setProperties(properties);
        analyzer.mergeManifest(jar.getManifest());
        this.checkMandatoryProperties(analyzer, jar, symbolicName);
        Manifest manifest = analyzer.calcManifest();
        jar.setManifest(manifest);
        return this.createInputStream(jar);
    }

    private InputStream sink(InputStream in) throws IOException {
        File f = File.createTempFile("mylitte", "jar");
        LOG.debug("Write: " + f.getAbsolutePath());
        FileOutputStream fout = new FileOutputStream(f);
        StreamUtils.copyStream((InputStream)in, (OutputStream)fout, (boolean)true);
        return new FileInputStream(f);
    }

    private PipedInputStream createInputStream(final Jar jar) throws IOException {
        PipedInputStream pin = new PipedInputStream();
        final PipedOutputStream pout = new PipedOutputStream(pin);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    jar.write((OutputStream)pout);
                }
                catch (Exception e) {
                }
                finally {
                    try {
                        pout.close();
                    }
                    catch (IOException e) {
                        LOG.warn("Close ?", (Throwable)e);
                    }
                }
            }
        }.start();
        return pin;
    }

    private void checkMandatoryProperties(Analyzer analyzer, Jar jar, String symbolicName) {
        String importPackage = analyzer.getProperty("Import-Package");
        analyzer.setProperty("Import-Package", "*");
        String exportPackage = analyzer.getProperty("Export-Package");
        if (exportPackage == null || exportPackage.trim().length() == 0) {
            // empty if block
        }
        String localSymbolicName = analyzer.getProperty("Bundle-SymbolicName", symbolicName);
        analyzer.setProperty("Bundle-SymbolicName", BndBuilder.generateSymbolicName(localSymbolicName));
    }

    private static String generateSymbolicName(String symbolicName) {
        return symbolicName.replaceAll("[^a-zA-Z_0-9.-]", "_");
    }
}

