/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.rmi.server.ObjID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.WrappingValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.mappings.DatabaseMapping;

public abstract class UnitOfWorkValueHolder<T>
extends DatabaseValueHolder<T>
implements WrappingValueHolder<T> {
    protected transient ValueHolderInterface<T> wrappedValueHolder;
    protected transient DatabaseMapping mapping;
    protected ValueHolderInterface<T> backupValueHolder;
    protected UnitOfWorkImpl remoteUnitOfWork;
    protected Object sourceObject;
    protected transient Object relationshipSourceObject;
    protected String sourceAttributeName;
    protected ObjID wrappedValueHolderRemoteID;
    private final Lock wrappedValueHolderLock = new ReentrantLock();

    protected UnitOfWorkValueHolder() {
    }

    protected UnitOfWorkValueHolder(ValueHolderInterface<T> attributeValue, Object clone, DatabaseMapping mapping, UnitOfWorkImpl unitOfWork) {
        this.wrappedValueHolder = attributeValue;
        this.mapping = mapping;
        this.session = unitOfWork;
        this.sourceAttributeName = mapping.getAttributeName();
        this.relationshipSourceObject = clone;
        if (unitOfWork.isRemoteUnitOfWork()) {
            if (attributeValue instanceof RemoteValueHolder) {
                this.wrappedValueHolderRemoteID = ((RemoteValueHolder)attributeValue).getID();
            }
            this.remoteUnitOfWork = unitOfWork;
            this.sourceObject = clone;
        }
    }

    protected abstract Object buildBackupCloneFor(Object var1);

    public abstract T buildCloneFor(Object var1);

    protected ValueHolderInterface<T> getBackupValueHolder() {
        return this.backupValueHolder;
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    protected UnitOfWorkImpl getRemoteUnitOfWork() {
        return this.remoteUnitOfWork;
    }

    protected String getSourceAttributeName() {
        return this.sourceAttributeName;
    }

    protected Object getSourceObject() {
        return this.sourceObject;
    }

    protected Object getRelationshipSourceObject() {
        return this.relationshipSourceObject;
    }

    protected UnitOfWorkImpl getUnitOfWork() {
        return (UnitOfWorkImpl)this.session;
    }

    protected T getValueFromServerObject() {
        this.setSession(this.getRemoteUnitOfWork());
        Object primaryKey = this.getSession().getId(this.getSourceObject());
        Object originalObject = this.getUnitOfWork().getParent().getIdentityMapAccessor().getFromIdentityMap(primaryKey, this.getSourceObject().getClass());
        if (originalObject == null) {
            originalObject = this.getUnitOfWork().getParent().readObject(this.getSourceObject());
        }
        ClassDescriptor descriptor = this.getSession().getDescriptor(originalObject);
        DatabaseMapping mapping = descriptor.getObjectBuilder().getMappingForAttributeName(this.getSourceAttributeName());
        this.setMapping(mapping);
        return (T)this.getMapping().getRealAttributeValueFromObject(originalObject, this.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T instantiateImpl() {
        T value;
        this.wrappedValueHolderLock.lock();
        try {
            if (this.wrappedValueHolder instanceof DatabaseValueHolder) {
                Object result;
                DatabaseValueHolder wrapped = (DatabaseValueHolder)this.wrappedValueHolder;
                UnitOfWorkImpl unitOfWork = this.getUnitOfWork();
                if (!wrapped.isEasilyInstantiated()) {
                    if (wrapped.isPessimisticLockingValueHolder()) {
                        if (!unitOfWork.getCommitManager().isActive() && !unitOfWork.wasTransactionBegunPrematurely()) {
                            unitOfWork.beginEarlyTransaction();
                        }
                        unitOfWork.log(1, "transaction", "instantiate_pl_relationship");
                    }
                    if (unitOfWork.getCommitManager().isActive() || unitOfWork.wasTransactionBegunPrematurely()) {
                        Object t = wrapped.instantiateForUnitOfWorkValueHolder(this);
                        return t;
                    }
                }
                if (!wrapped.isInstantiated() && (result = wrapped.getValue((UnitOfWorkImpl)this.session)) != null) {
                    Object t = result;
                    return t;
                }
            }
            value = this.wrappedValueHolder.getValue();
        }
        finally {
            this.wrappedValueHolderLock.unlock();
        }
        return this.buildCloneFor(value);
    }

    @Override
    public boolean isEasilyInstantiated() {
        return this.isInstantiated || this.wrappedValueHolder != null && (!(this.wrappedValueHolder instanceof DatabaseValueHolder) || ((DatabaseValueHolder)this.wrappedValueHolder).isEasilyInstantiated());
    }

    @Override
    public boolean isPessimisticLockingValueHolder() {
        return this.wrappedValueHolder != null && this.wrappedValueHolder instanceof DatabaseValueHolder && ((DatabaseValueHolder)this.wrappedValueHolder).isPessimisticLockingValueHolder();
    }

    @Override
    public ValueHolderInterface<T> getWrappedValueHolder() {
        return this.wrappedValueHolder;
    }

    public ObjID getWrappedValueHolderRemoteID() {
        return this.wrappedValueHolderRemoteID;
    }

    @Override
    public boolean isSerializedRemoteUnitOfWorkValueHolder() {
        return this.remoteUnitOfWork != null && this.remoteUnitOfWork.getParent() != null && this.wrappedValueHolder == null;
    }

    @Override
    protected T instantiate() {
        T cloneAttributeValue;
        if (this.isSerializedRemoteUnitOfWorkValueHolder()) {
            T originalAttributeValue = this.getValueFromServerObject();
            cloneAttributeValue = this.buildCloneFor(originalAttributeValue);
        } else {
            if (this.getUnitOfWork() == null) {
                throw ValidationException.instantiatingValueholderWithNullSession();
            }
            cloneAttributeValue = this.instantiateImpl();
        }
        if (this.backupValueHolder != null) {
            this.backupValueHolder.setValue(this.buildBackupCloneFor(cloneAttributeValue));
        }
        return cloneAttributeValue;
    }

    @Override
    public T instantiateForUnitOfWorkValueHolder(UnitOfWorkValueHolder<T> unitOfWorkValueHolder) {
        return this.instantiate();
    }

    @Override
    public void releaseWrappedValueHolder(AbstractSession targetSession) {
    }

    @Override
    protected void resetFields() {
    }

    public void setBackupValueHolder(ValueHolderInterface<T> backupValueHolder) {
        this.backupValueHolder = backupValueHolder;
    }

    protected void setMapping(DatabaseMapping mapping) {
        this.mapping = mapping;
    }

    protected void setRemoteUnitOfWork(UnitOfWorkImpl remoteUnitOfWork) {
        this.remoteUnitOfWork = remoteUnitOfWork;
    }

    protected void setSourceAttributeName(String name) {
        this.sourceAttributeName = name;
    }

    protected void setSourceObject(Object sourceObject) {
        this.sourceObject = sourceObject;
    }

    protected void setRelationshipSourceObject(Object relationshipSourceObject) {
        this.relationshipSourceObject = relationshipSourceObject;
    }

    protected void setWrappedValueHolder(DatabaseValueHolder<T> valueHolder) {
        this.wrappedValueHolder = valueHolder;
    }

    @Override
    public boolean shouldAllowInstantiationDeferral() {
        return ((WeavedAttributeValueHolderInterface)this.wrappedValueHolder).shouldAllowInstantiationDeferral();
    }
}

