/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.sessions.CopyGroup;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ObjectCopyingTest
extends TransactionalTestCase {
    public ObjectCopyingTest() {
        this.setDescription("Test the object copying feature.");
    }

    public void test() {
        Employee original = (Employee)this.getSession().readObject(Employee.class);
        CopyGroup group = new CopyGroup();
        group.setShouldResetPrimaryKey(true);
        Employee copy = (Employee)this.getSession().copy((Object)original, (AttributeGroup)group);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerObject((Object)copy);
        uow.commit();
        copy = (Employee)this.getSession().readObject((Object)copy);
        if (original == copy || original.getAddress() == copy.getAddress()) {
            throw new TestErrorException("Copies are not copies.");
        }
        if (!original.getFirstName().equals(copy.getFirstName()) || !original.getAddress().getCity().equals(copy.getAddress().getCity())) {
            throw new TestErrorException("Copies are not the same.");
        }
    }
}

