/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.testing.framework.TestProblemException;

class JDBCIsoLevelSwitchListener
extends SessionEventAdapter {
    Map<Connection, Integer> connections = new HashMap<Connection, Integer>();

    JDBCIsoLevelSwitchListener() {
    }

    public void postAcquireConnection(SessionEvent event) {
        Connection conn = ((DatabaseAccessor)event.getResult()).getConnection();
        try {
            int old = conn.getTransactionIsolation();
            if (old != 1) {
                conn.setTransactionIsolation(1);
                this.connections.put(conn, old);
            }
        }
        catch (SQLException sqlException) {
            throw new TestProblemException("postAcquireConnection failed. ", sqlException);
        }
    }

    public void preReleaseConnection(SessionEvent event) {
        Connection conn = ((DatabaseAccessor)event.getResult()).getConnection();
        try {
            Integer old = this.connections.remove(conn);
            if (old != null) {
                conn.setTransactionIsolation(old);
            }
        }
        catch (SQLException sqlException) {
            throw new TestProblemException("preReleaseConnection failed. ", sqlException);
        }
    }
}

