/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprVar;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

class ExprSeqMap
extends Expr {
    private Expr theInput;
    private Expr theMapExpr;
    private ExprVar theCtxItemVar;

    ExprSeqMap(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location) {
        super(qcb, sctx, Expr.ExprKind.SEQ_MAP, location);
    }

    void addCtxVar(ExprVar v) {
        this.theCtxItemVar = v;
    }

    void addInputExpr(Expr input) {
        this.theInput = input;
        this.theInput.addParent(this);
    }

    void addMapExpr(Expr map) {
        this.theMapExpr = map;
        this.theMapExpr.addParent(this);
    }

    void setInput(Expr newExpr, boolean destroy) {
        this.theInput.removeParent(this, destroy);
        this.theInput = newExpr;
        newExpr.addParent(this);
    }

    void setMapExpr(Expr newExpr, boolean destroy) {
        this.theMapExpr.removeParent(this, destroy);
        this.theMapExpr = newExpr;
        newExpr.addParent(this);
    }

    @Override
    int getNumChildren() {
        return 2;
    }

    @Override
    Expr getInput() {
        return this.theInput;
    }

    Expr getMapExpr() {
        return this.theMapExpr;
    }

    ExprVar getCtxVar() {
        return this.theCtxItemVar;
    }

    @Override
    public ExprType computeType() {
        ExprType.Quantifier q1 = this.theInput.getType().getQuantifier();
        ExprType.Quantifier q2 = this.theMapExpr.getType().getQuantifier();
        ExprType.Quantifier q = TypeManager.getUnionQuant(q1, q2);
        this.theType = TypeManager.createType(this.theMapExpr.getType(), q);
        return this.theType;
    }

    @Override
    public boolean mayReturnNULL() {
        return this.theMapExpr.mayReturnNULL();
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
    }
}

