/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.systables.SGAttributesTableDesc;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.Row;

public class SequenceImpl {
    private SequenceImpl() {
    }

    public static String getSgName(TableImpl table) {
        if (!table.hasIdentityColumn()) {
            return null;
        }
        int identityColumn = table.getIdentityColumn();
        return SequenceImpl.getSgName(table, identityColumn);
    }

    public static String getSgName(TableImpl table, int identityColumn) {
        if (table.getIdentityColumn() != identityColumn) {
            throw new IllegalStateException("Wrong identity column number.");
        }
        String idname = table.getFieldMap().getFieldName(identityColumn);
        return table.getId() + "." + idname;
    }

    public static class SGAttributes
    implements FastExternalizable {
        private BigDecimal start = null;
        private Long increment = null;
        private BigDecimal max = null;
        private BigDecimal min = null;
        private Long cache = null;
        private boolean cycle = false;
        private long version;

        public SGAttributes(Row row) {
            if (row == null) {
                throw new IllegalArgumentException("Row must be non-null.");
            }
            this.start = row.get("StartWith").asNumber().get();
            this.increment = row.get("IncrementBy").asLong().get();
            FieldValue maxField = row.get("MaxValue");
            this.max = !maxField.isNull() ? row.get("MaxValue").asNumber().get() : null;
            FieldValue minField = row.get("MinValue");
            this.min = !minField.isNull() ? row.get("MinValue").asNumber().get() : null;
            this.cache = row.get("Cache").asLong().get();
            this.cycle = row.get("Cycle").asBoolean().get();
            this.version = row.get("SGAttrVersion").asLong().get();
        }

        private SGAttributes(BigDecimal start, Long increment, BigDecimal max, BigDecimal min, Long cache, boolean cycle, long version) {
            this.start = start;
            this.increment = increment;
            this.max = max;
            this.min = min;
            this.cache = cache;
            this.cycle = cycle;
            this.version = version;
        }

        private static SGAttributes createSGAttributes(DataInput in, short serialVersion) throws IOException {
            BigDecimal start = in.readByte() != 0 ? new BigDecimal(SerializationUtil.readString(in, serialVersion)) : null;
            Long increment = in.readLong();
            BigDecimal max = in.readByte() != 0 ? new BigDecimal(SerializationUtil.readString(in, serialVersion)) : null;
            BigDecimal min = in.readByte() != 0 ? new BigDecimal(SerializationUtil.readString(in, serialVersion)) : null;
            Long cache = in.readLong();
            Boolean cycle = in.readBoolean();
            Long version = in.readLong();
            return new SGAttributes(start, increment, max, min, cache, cycle, version);
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            if (this.start != null) {
                out.writeBoolean(true);
                SerializationUtil.writeString(out, serialVersion, this.start.toString());
            } else {
                out.writeBoolean(false);
            }
            out.writeLong(this.increment);
            if (this.max != null) {
                out.writeBoolean(true);
                SerializationUtil.writeString(out, serialVersion, this.max.toString());
            } else {
                out.writeBoolean(false);
            }
            if (this.min != null) {
                out.writeBoolean(true);
                SerializationUtil.writeString(out, serialVersion, this.min.toString());
            } else {
                out.writeBoolean(false);
            }
            out.writeLong(this.cache);
            out.writeBoolean(this.cycle);
            out.writeLong(this.version);
        }

        public void setVersion(long version) {
            this.version = version;
        }

        public long getVersion() {
            return this.version;
        }

        public BigDecimal getStartValue() {
            return this.start;
        }

        public Long getIncrementValue() {
            return this.increment;
        }

        public BigDecimal getMaxValue() {
            return this.max;
        }

        public BigDecimal getMinValue() {
            return this.min;
        }

        public Long getCacheValue() {
            return this.cache;
        }

        public boolean getCycle() {
            return this.cycle;
        }

        public String toString() {
            return "start: " + this.getStartValue() + " increment: " + this.getIncrementValue() + " max: " + this.getMaxValue() + " min: " + this.getMinValue() + " cache: " + this.getCacheValue() + " cycle: " + this.getCycle();
        }
    }

    public static class SGAttrsAndValues
    implements FastExternalizable {
        private SGAttributes attributes = null;
        private SGValues<?> values = null;

        public SGAttrsAndValues() {
        }

        public SGAttrsAndValues(DataInput in, short serialVersion) throws IOException {
            if (in.readByte() != 0) {
                this.attributes = SGAttributes.createSGAttributes(in, serialVersion);
            }
            if (in.readByte() != 0) {
                this.values = SGValues.readFastExternal(in, serialVersion);
            }
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            SerializationUtil.writeFastExternalOrNull(out, serialVersion, this.attributes);
            SerializationUtil.writeFastExternalOrNull(out, serialVersion, this.values);
        }

        public void setAttributes(SGAttributes attributes) {
            this.attributes = attributes;
        }

        public void setValueCache(SGValues<?> values) {
            this.values = values;
        }

        public SGAttributes getAttributes() {
            return this.attributes;
        }

        public SGValues<?> getValues() {
            return this.values;
        }

        public boolean containsAttributes() {
            return this.attributes != null;
        }

        public boolean containsValues() {
            return this.values != null;
        }
    }

    public static abstract class SGValues<T>
    implements FastExternalizable {
        private final FieldDef.Type dataType;
        public long increment;
        public long attrVersion;
        public T currentValue;
        public T lastValue;

        public static SGValues<?> newInstance(FieldDef.Type dataType, long increment) {
            if (dataType == null) {
                throw new IllegalArgumentException("Data-type is required.");
            }
            switch (dataType) {
                case INTEGER: {
                    return new SGIntegerValues(dataType, increment);
                }
                case LONG: {
                    return new SGLongValues(dataType, increment);
                }
                case NUMBER: {
                    return new SGNumberValues(dataType, increment);
                }
            }
            throw new IllegalArgumentException("Sequence number must be one of the following numeric data types: INTEGER, LONG or NUMBER: " + dataType);
        }

        protected SGValues(FieldDef.Type dataType, long increment) {
            this.dataType = dataType;
            this.increment = increment;
        }

        protected SGValues(FieldDef.Type dataType, DataInput in, short serialVersion) throws IOException {
            this.dataType = dataType;
            this.increment = in.readLong();
            this.attrVersion = in.readLong();
        }

        public abstract void update(BigDecimal var1, BigDecimal var2);

        private static SGValues<?> readFastExternal(DataInput in, short serialVersion) throws IOException {
            FieldDef.Type dataType = FieldDef.Type.readFastExternal(in, serialVersion);
            switch (dataType) {
                case INTEGER: {
                    return new SGIntegerValues(in, serialVersion);
                }
                case LONG: {
                    return new SGLongValues(in, serialVersion);
                }
                case NUMBER: {
                    return new SGNumberValues(in, serialVersion);
                }
            }
            throw new IllegalStateException("Sequence number must be one of the following numeric data types: INTEGER, LONG or NUMBER: " + dataType);
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            this.dataType.writeFastExternal(out, serialVersion);
            out.writeLong(this.increment);
            out.writeLong(this.attrVersion);
        }

        public FieldDef.Type getType() {
            return this.dataType;
        }
    }

    public static class SGNumberValues
    extends SGValues<BigDecimal> {
        private SGNumberValues(FieldDef.Type dataType, long increment) {
            super(dataType, increment);
        }

        private SGNumberValues(DataInput in, short serialVersion) throws IOException {
            super(FieldDef.Type.NUMBER, in, serialVersion);
            if (in.readByte() != 0) {
                this.currentValue = new BigDecimal(SerializationUtil.readString(in, serialVersion));
                this.lastValue = new BigDecimal(SerializationUtil.readString(in, serialVersion));
            }
        }

        @Override
        public void update(BigDecimal newCurrentValue, BigDecimal newLastValue) {
            this.currentValue = newCurrentValue;
            this.lastValue = newLastValue;
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            if (this.currentValue != null && this.lastValue != null) {
                out.writeBoolean(true);
                SerializationUtil.writeString(out, serialVersion, ((BigDecimal)this.currentValue).toString());
                SerializationUtil.writeString(out, serialVersion, ((BigDecimal)this.lastValue).toString());
            } else {
                out.writeBoolean(false);
            }
        }
    }

    public static class SGLongValues
    extends SGValues<Long> {
        private SGLongValues(FieldDef.Type dataType, long increment) {
            super(dataType, increment);
        }

        private SGLongValues(DataInput in, short serialVersion) throws IOException {
            super(FieldDef.Type.LONG, in, serialVersion);
            if (in.readByte() != 0) {
                this.currentValue = in.readLong();
                this.lastValue = in.readLong();
            }
        }

        @Override
        public void update(BigDecimal newCurrentValue, BigDecimal newLastValue) {
            this.currentValue = newCurrentValue.longValue();
            this.lastValue = newLastValue.longValue();
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            if (this.currentValue != null && this.lastValue != null) {
                out.writeBoolean(true);
                out.writeLong((Long)this.currentValue);
                out.writeLong((Long)this.lastValue);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    public static class SGIntegerValues
    extends SGValues<Integer> {
        private SGIntegerValues(FieldDef.Type dataType, long increment) {
            super(dataType, increment);
        }

        private SGIntegerValues(DataInput in, short serialVersion) throws IOException {
            super(FieldDef.Type.INTEGER, in, serialVersion);
            if (in.readByte() != 0) {
                this.currentValue = in.readInt();
                this.lastValue = in.readInt();
            }
        }

        @Override
        public void update(BigDecimal newCurrentValue, BigDecimal newLastValue) {
            this.currentValue = newCurrentValue.intValue();
            this.lastValue = newLastValue.intValue();
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            if (this.currentValue != null && this.lastValue != null) {
                out.writeBoolean(true);
                out.writeInt((Integer)this.currentValue);
                out.writeInt((Integer)this.lastValue);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    public static class SGKey {
        public final SGAttributesTableDesc.SGType sgType;
        public final String sgName;
        public long tableId;

        public SGKey(SGAttributesTableDesc.SGType type, String name, long id) {
            this.sgType = type;
            this.sgName = name;
            this.tableId = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SGKey)) {
                return false;
            }
            SGKey that = (SGKey)o;
            if (this.sgType != that.sgType) {
                return false;
            }
            if (this.tableId != that.tableId) {
                return false;
            }
            return this.sgName.equals(that.sgName);
        }

        public int hashCode() {
            int result = this.sgType.hashCode();
            result = 31 * result + this.sgName.hashCode();
            result = 31 * result + (int)(this.tableId ^ this.tableId >>> 32);
            return result;
        }

        public String toString() {
            return "SequenceKey{sgType=" + (Object)((Object)this.sgType) + ", sgName=" + this.sgName + ", tableId='" + this.tableId + '\'' + '}';
        }
    }
}

