/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.readonly;

import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.testing.models.readonly.Address;

public class Studio {
    public String name;
    public String owner;
    public Address address;

    public static RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Studio.class);
        descriptor.setTableName("RO_MOVIE");
        descriptor.descriptorIsAggregate();
        descriptor.addDirectMapping("name", "STD_NAME");
        descriptor.addDirectMapping("owner", "STD_OWN");
        OneToOneMapping addressMapping = new OneToOneMapping();
        addressMapping.setAttributeName("address");
        addressMapping.setReferenceClass(Address.class);
        addressMapping.setForeignKeyFieldName("STD_ADD");
        addressMapping.privateOwnedRelationship();
        addressMapping.dontUseIndirection();
        descriptor.addMapping((DatabaseMapping)addressMapping);
        return descriptor;
    }

    public static Studio example1() {
        Studio example = new Studio();
        example.setName("Lucasfilm, Ltd.");
        example.setOwner("George Lucas");
        example.setAddress(Address.example1());
        return example;
    }

    public static Studio example2() {
        Studio example = new Studio();
        example.setName("Columbia Pictures Corporation");
        example.setOwner("Christopher Columbus");
        example.setAddress(Address.example2());
        return example;
    }

    public static Studio example3() {
        Studio example = new Studio();
        example.setName("DreamWorks SKG");
        example.setOwner("Steven Speilberg");
        example.setAddress(Address.example3());
        return example;
    }

    public static Studio example4() {
        Studio example = new Studio();
        example.setName("Tall &amp; Short Studio");
        example.setOwner("Mutt &amp; Jeff");
        example.setAddress(Address.example4());
        return example;
    }

    public static Studio example5() {
        Studio example = new Studio();
        example.setName("FFC Productions");
        example.setOwner("Francis Ford Coppola");
        example.setAddress(Address.example5());
        return example;
    }

    public Address getAddress() {
        return this.address;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String toString() {
        return new String("Studio: " + this.getName());
    }
}

