/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.TupleValue;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;

public class FuncExpirationTimeMillisIter
extends PlanIter {
    private final PlanIter theInput;

    public FuncExpirationTimeMillisIter(Expr e, int resultReg, PlanIter input) {
        super(e, resultReg);
        this.theInput = input;
    }

    FuncExpirationTimeMillisIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theInput = FuncExpirationTimeMillisIter.deserializeIter(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        FuncExpirationTimeMillisIter.serializeIter(this.theInput, out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.FUNC_EXPIRATION_TIME_MILLIS;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new PlanIterState());
        this.theInput.open(rcb);
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        long expTime;
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        boolean more = this.theInput.next(rcb);
        assert (more);
        FieldValueImpl row = rcb.getRegVal(this.theInput.getResultReg());
        if (row == NullValueImpl.getInstance()) {
            rcb.setRegVal(this.theResultReg, row);
            state.done();
            return true;
        }
        if (row.isTuple()) {
            expTime = ((TupleValue)row).getExpirationTime();
        } else if (row.isRecord()) {
            expTime = ((RowImpl)row).getExpirationTime();
        } else {
            throw new QueryException("Input to the expiration_time() function is not a row", this.getLocation());
        }
        rcb.setRegVal(this.theResultReg, FieldDefImpl.longDef.createLong(expTime));
        state.done();
        return true;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInput.reset(rcb);
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInput.close(rcb);
        state.close();
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInput.display(sb, formatter);
    }
}

