/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.util.ArrayList;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTest;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestResult;
import org.eclipse.persistence.testing.framework.PerformanceRegressionTestCase;
import org.eclipse.persistence.testing.framework.TestCase;

public abstract class MemoryRegressionTestCase
extends PerformanceRegressionTestCase {
    public MemoryRegressionTestCase() {
        this.testRunTime = 10000L;
        this.allowableDecrease = -5.0;
        this.tests = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeTest() throws Throwable {
        PerformanceComparisonTestResult result = new PerformanceComparisonTestResult(this, "Passed");
        this.setTestResult(result);
        try {
            for (int index = 0; index < 5; ++index) {
                long endMemory;
                long startMemory;
                try {
                    this.startTest();
                    this.forceGC();
                    startMemory = Runtime.getRuntime().freeMemory();
                    this.test();
                    this.forceGC();
                    endMemory = Runtime.getRuntime().freeMemory();
                }
                finally {
                    this.endTest();
                }
                result.addTestCount(startMemory - endMemory, 0);
                for (int testIndex = 0; testIndex < this.getTests().size(); ++testIndex) {
                    PerformanceComparisonTest test = (PerformanceComparisonTest)((Object)this.getTests().get(testIndex));
                    ((TestCase)((Object)test)).setExecutor(this.getExecutor());
                    try {
                        test.startTest();
                        this.forceGC();
                        endMemory = startMemory = Runtime.getRuntime().freeMemory();
                        ((TestCase)((Object)test)).test();
                        this.forceGC();
                        endMemory = Runtime.getRuntime().freeMemory();
                    }
                    finally {
                        test.endTest();
                    }
                    result.addTestCount(startMemory - endMemory, testIndex + 1);
                }
            }
        }
        finally {
            result.computeResults();
        }
    }
}

