/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.codegen.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.pfl.dynamic.codegen.impl.AssignmentStatement;
import org.glassfish.pfl.dynamic.codegen.impl.BreakStatement;
import org.glassfish.pfl.dynamic.codegen.impl.DefinitionStatement;
import org.glassfish.pfl.dynamic.codegen.impl.ExpressionFactory;
import org.glassfish.pfl.dynamic.codegen.impl.ExpressionInternal;
import org.glassfish.pfl.dynamic.codegen.impl.IfStatement;
import org.glassfish.pfl.dynamic.codegen.impl.Node;
import org.glassfish.pfl.dynamic.codegen.impl.ReturnStatement;
import org.glassfish.pfl.dynamic.codegen.impl.Statement;
import org.glassfish.pfl.dynamic.codegen.impl.StatementBase;
import org.glassfish.pfl.dynamic.codegen.impl.SwitchStatement;
import org.glassfish.pfl.dynamic.codegen.impl.ThrowStatement;
import org.glassfish.pfl.dynamic.codegen.impl.TryStatement;
import org.glassfish.pfl.dynamic.codegen.impl.Visitor;
import org.glassfish.pfl.dynamic.codegen.impl.WhileStatement;
import org.glassfish.pfl.dynamic.codegen.spi.Expression;
import org.glassfish.pfl.dynamic.codegen.spi.Type;
import org.glassfish.pfl.dynamic.codegen.spi.Variable;

public class BlockStatement
extends StatementBase {
    private List<Statement> body = new ArrayList<Statement>();
    private ExpressionFactory efactory = new ExpressionFactory(this);
    private Map<String, DefinitionStatement> definitions = new HashMap<String, DefinitionStatement>();

    BlockStatement(Node parent) {
        super(parent);
    }

    public Variable getVar(String ident) {
        Variable result = null;
        DefinitionStatement ds = this.definitions.get(ident);
        if (ds != null) {
            result = ds.var();
        }
        return result;
    }

    public boolean isEmpty() {
        return this.body.isEmpty();
    }

    public List<Statement> body() {
        return this.body;
    }

    public ExpressionFactory exprFactory() {
        return this.efactory;
    }

    public void addBreak() {
        this.body.add(new BreakStatement(this));
    }

    public void addReturn() {
        this.body.add(new ReturnStatement(this));
    }

    public void addReturn(Expression expr) {
        this.body.add(new ReturnStatement(this, ((ExpressionInternal)expr).copy(this, ExpressionInternal.class)));
    }

    public IfStatement addIf(Expression cond) {
        IfStatement result = new IfStatement(this, ((ExpressionInternal)cond).copy(this, ExpressionInternal.class));
        this.body.add(result);
        return result;
    }

    public TryStatement addTry() {
        TryStatement result = new TryStatement(this);
        this.body.add(result);
        return result;
    }

    public void addThrow(Expression expr) {
        this.body.add(new ThrowStatement(this, ((ExpressionInternal)expr).copy(this, ExpressionInternal.class)));
    }

    private void checkSwitchExpressionType(Type type) {
        if (type.size() != 1 || type.equals(Type._boolean())) {
            throw new IllegalArgumentException("A switch expression must have type char, byte, short, or int");
        }
    }

    public SwitchStatement addSwitch(Expression value) {
        this.checkSwitchExpressionType(((ExpressionInternal)value).type());
        SwitchStatement result = new SwitchStatement(this, ((ExpressionInternal)value).copy(this, ExpressionInternal.class));
        this.body.add(result);
        return result;
    }

    public WhileStatement addWhile(Expression expr) {
        WhileStatement result = new WhileStatement(this, ((ExpressionInternal)expr).copy(this, ExpressionInternal.class));
        this.body.add(result);
        return result;
    }

    public void addExpression(Expression expr) {
        this.body.add(((ExpressionInternal)expr).copy(this, ExpressionInternal.class));
    }

    public void addAssign(Expression left, Expression right) {
        this.body.add(new AssignmentStatement(this, ((ExpressionInternal)left).copy(this, ExpressionInternal.class), ((ExpressionInternal)right).copy(this, ExpressionInternal.class)));
    }

    public Expression addDefinition(Type type, String ident, Expression value) {
        if (this.definitions.containsKey(ident)) {
            throw new IllegalArgumentException("This scope already contains a variable named " + ident);
        }
        Variable var = this.efactory.variable(type, ident);
        DefinitionStatement ds = new DefinitionStatement(this, var, ((ExpressionInternal)value).copy(this, ExpressionInternal.class));
        this.body.add(ds);
        this.definitions.put(ident, ds);
        return var;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitBlockStatement(this);
    }
}

