/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.sessionconsole;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DefaultConnector;
import org.eclipse.persistence.tools.beans.MessageDialog;

public class LoginEditorPanel
extends JPanel
implements CaretListener {
    public static String password;
    public static String bridge;
    private DatabaseLogin fieldLogin = new DatabaseLogin();
    private JPanel ivjBindingPage = null;
    private JCheckBox ivjBlobBindingCheckbox = null;
    private JCheckBox ivjBlobStreamBinding = null;
    private JComboBox<String> ivjBridgeChoice = null;
    private JCheckBox ivjCacheStatementsCheckbox = null;
    private boolean ivjConnPtoP1Aligning = false;
    private JLabel ivjCreatorLabel = null;
    private JTextField ivjCreatorText = null;
    private JLabel ivjDatabasePlatformLabel = null;
    private JLabel ivjDatabaseURLLabel = null;
    private JTextField ivjDatabaseURLText = null;
    private JComboBox<String> ivjDriverChoice = null;
    private JLabel ivjDriverClassNameLabel = null;
    private JTextField ivjDriverURLText = null;
    private JPanel ivjFillerPanel1 = null;
    private JPanel ivjFillerPanel11 = null;
    private JPanel ivjFillerPanel2 = null;
    private DatabaseLogin ivjLoginBean = null;
    private JCheckBox ivjNativeSequencingCheckbox = null;
    private JCheckBox ivjNativeSQLCheckbox = null;
    private JCheckBox ivjOptimizeDataConversionCheckbox = null;
    private JPanel ivjOtherPage = null;
    private JCheckBox ivjParameterizedSQLCheckbox = null;
    private JLabel ivjPasswordLabel = null;
    private JPasswordField ivjPasswordText = null;
    private JComboBox<String> ivjPlatformChoice = null;
    private JLabel ivjPreallocationSizeLabel = null;
    private JTabbedPane ivjPropertiesBook = null;
    private JLabel ivjSequenceCounterNameLabel = null;
    private JTextField ivjSequenceCounterNameText = null;
    private JLabel ivjSequenceFieldNameLabel = null;
    private JTextField ivjSequenceFieldNameText = null;
    private JTextField ivjSequencePreallocationSizeText = null;
    private JLabel ivjSequenceTableNameLabel = null;
    private JTextField ivjSequenceTableNameText = null;
    private JPanel ivjSequencingPage = null;
    private JLabel ivjStatementCacheSizeLabel = null;
    private JTextField ivjStatementCacheSizeText = null;
    private JCheckBox ivjStringBindingCheckbox = null;
    private JLabel ivjStringBindSizeLable = null;
    private JTextField ivjStringBindSizeText = null;
    private JCheckBox ivjTrimStringsCheckbox = null;
    private JLabel ivjUserNameLabel = null;
    private JTextField ivjUserText = null;
    private JCheckBox ivjBatchWritingCheckBox = null;
    private JCheckBox ivjDirectConnectCheckBox = null;
    private JCheckBox ivjForceCaseCheckBox = null;
    private JCheckBox ivjJTSCheckBox = null;
    private JCheckBox ivjPoolingCheckBox = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JPanel ivjDriverPage = null;
    private JPanel ivjFillerPanel = null;
    private JLabel ivjDriverLabel = null;

    public LoginEditorPanel() {
        this.initialize();
    }

    public LoginEditorPanel(LayoutManager layout) {
        super(layout);
    }

    public LoginEditorPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public LoginEditorPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public void bridgeChanged() {
        if (this.getBridgeChoice().getItemCount() > 1) {
            bridge = String.valueOf(this.getBridgeChoice().getSelectedItem());
        }
        String driver = String.valueOf(this.getBridgeChoice().getSelectedItem());
        DatabaseLogin login = (DatabaseLogin)this.getLogin().clone();
        switch (driver) {
            case "Sun JDBC-ODBC": {
                login.useJDBCODBCBridge();
                break;
            }
            case "Oracle thin": {
                login.useOracle();
                login.useOracleThinJDBCDriver();
                break;
            }
            case "Oracle 8 OCI": {
                login.useOracle();
                login.useOracleJDBCDriver();
                break;
            }
            case "DB2 (App)": {
                login.useDB2();
                login.useDB2JDBCDriver();
                break;
            }
            case "DB2 (Net)": {
                login.useDB2();
                login.setDriverClassName("COM.ibm.db2.jdbc.net.DB2Driver");
                break;
            }
            case "DB2 (Universal Driver)": {
                login.useDB2();
                login.setDriverClassName("com.ibm.db2.jcc.DB2Driver");
                login.setDriverURLHeader("jdbc:db2://");
                break;
            }
            case "DataDirect for DB2": {
                login.useDB2();
                login.setDriverClassName("com.oracle.ias.jdbc.db2.DB2Driver");
                login.setDriverURLHeader("jdbc:oracle:db2://");
                break;
            }
            case "Sybase JConnect": {
                login.useSybase();
                login.useJConnect50Driver();
                break;
            }
            case "DataDirect for Sybase": {
                login.useSybase();
                login.setDriverClassName("com.oracle.ias.jdbc.sybase.SybaseDriver");
                login.setDriverURLHeader("jdbc:oracle:sybase://");
                break;
            }
            case "Weblogic Thin": {
                login.useSQLServer();
                login.useWebLogicSQLServerDriver();
                break;
            }
            case "DataDirect for SQLServer": {
                login.useSQLServer();
                login.setDriverClassName("com.oracle.ias.jdbc.sqlserver.SQLServerDriver");
                login.setDriverURLHeader("jdbc:oracle:sqlserver://");
                break;
            }
            case "MS JDBC": {
                login.useSQLServer();
                login.setDriverClassName("com.microsoft.jdbc.sqlserver.SQLServerDriver");
                login.setDriverURLHeader("jdbc:microsoft:sqlserver://");
                break;
            }
            case "Symfoware (RDB2_TCP)": {
                login.useSymfoware();
                login.setDriverClassName("com.fujitsu.symfoware.jdbc.SYMDriver");
                login.setDriverURLHeader("jdbc:symford://");
            }
        }
        login.setDatabaseURL("");
        login.setUserName("");
        login.setPassword("");
        this.setLogin(login);
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (e.getSource() == this.getPasswordText()) {
            this.connEtoC7(e);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.resetSequenceButtons();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ItemEvent arg1) {
        try {
            this.bridgeChanged();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(ActionEvent arg1) {
        try {
            this.resetStringButtons();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC5(ActionEvent arg1) {
        try {
            this.resetStringButtons();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC7(CaretEvent arg1) {
        try {
            this.passwordChanged();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP10SetSource() {
        try {
            if (this.getLoginBean() != null) {
                this.getLoginBean().setUsesByteArrayBinding(this.getBlobBindingCheckbox().isSelected());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP10SetTarget() {
    }

    private void connPtoP11SetSource() {
        try {
            if (this.getLoginBean() != null) {
                if (this.getNativeSequencingCheckbox().isSelected() && !this.getLoginBean().shouldUseNativeSequencing()) {
                    this.getLoginBean().setDefaultSequence((Sequence)new NativeSequence());
                } else if (!this.getNativeSequencingCheckbox().isSelected() && this.getLoginBean().shouldUseNativeSequencing()) {
                    this.getLoginBean().setDefaultSequence((Sequence)new TableSequence());
                }
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP11SetTarget() {
        try {
            if (this.getLoginBean() != null) {
                this.getNativeSequencingCheckbox().setSelected(this.getLoginBean().getUsesNativeSequencing());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP12SetSource() {
        try {
            if (this.getLoginBean() != null) {
                this.getLoginBean().getDefaultSequence().setPreallocationSize(Integer.parseInt(this.getSequencePreallocationSizeText().getText()));
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP12SetTarget() {
        try {
            if (this.getLoginBean() != null) {
                this.getSequencePreallocationSizeText().setText(String.valueOf(this.getLoginBean().getDefaultSequence().getPreallocationSize()));
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP13SetSource() {
        try {
            if (this.getLoginBean() != null) {
                this.getLoginBean().setShouldOptimizeDataConversion(this.getOptimizeDataConversionCheckbox().isSelected());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP13SetTarget() {
        try {
            if (this.getLoginBean() != null) {
                this.getOptimizeDataConversionCheckbox().setSelected(this.getLoginBean().getShouldOptimizeDataConversion());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP14SetSource() {
        try {
            if (this.getLoginBean() != null && !this.getLoginBean().shouldUseNativeSequencing()) {
                ((TableSequence)this.getLoginBean().getDefaultSequence()).setCounterFieldName(this.getSequenceCounterNameText().getText());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP14SetTarget() {
        try {
            if (this.getLoginBean() != null && !this.getLoginBean().shouldUseNativeSequencing()) {
                this.getSequenceCounterNameText().setText(((TableSequence)this.getLoginBean().getDefaultSequence()).getCounterFieldName());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP15SetSource() {
        try {
            if (this.getLoginBean() != null && !this.getLoginBean().shouldUseNativeSequencing()) {
                ((TableSequence)this.getLoginBean().getDefaultSequence()).setNameFieldName(this.getSequenceFieldNameText().getText());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP15SetTarget() {
        try {
            if (this.getLoginBean() != null && !this.getLoginBean().shouldUseNativeSequencing()) {
                this.getSequenceFieldNameText().setText(((TableSequence)this.getLoginBean().getDefaultSequence()).getNameFieldName());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP16SetSource() {
        try {
            if (this.getLoginBean() != null && !this.getLoginBean().shouldUseNativeSequencing()) {
                ((TableSequence)this.getLoginBean().getDefaultSequence()).setTableName(this.getSequenceTableNameText().getText());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP16SetTarget() {
        try {
            if (this.getLoginBean() != null && !this.getLoginBean().shouldUseNativeSequencing()) {
                this.getSequenceTableNameText().setText(((TableSequence)this.getLoginBean().getDefaultSequence()).getTableName());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP17SetSource() {
        try {
            if (this.getLoginBean() != null) {
                this.getLoginBean().setShouldBindAllParameters(this.getParameterizedSQLCheckbox().isSelected());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP17SetTarget() {
        try {
            if (this.getLoginBean() != null) {
                this.getParameterizedSQLCheckbox().setSelected(this.getLoginBean().getShouldBindAllParameters());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP18SetSource() {
        try {
            if (this.getLoginBean() != null) {
                this.getLoginBean().setTableQualifier(this.getCreatorText().getText());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP18SetTarget() {
        try {
            if (this.getLoginBean() != null) {
                this.getCreatorText().setText(this.getLoginBean().getTableQualifier());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP19SetSource() {
        try {
            if (this.getLoginBean() != null) {
                this.getLoginBean().setShouldCacheAllStatements(this.getCacheStatementsCheckbox().isSelected());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP19SetTarget() {
        try {
            if (this.getLoginBean() != null) {
                this.getCacheStatementsCheckbox().setSelected(this.getLoginBean().getShouldCacheAllStatements());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP1SetSource() {
        try {
            if (!this.ivjConnPtoP1Aligning) {
                this.ivjConnPtoP1Aligning = true;
                if (this.getLoginBean() != null) {
                    this.setLogin(this.getLoginBean());
                }
                this.ivjConnPtoP1Aligning = false;
            }
        }
        catch (Throwable ivjExc) {
            this.ivjConnPtoP1Aligning = false;
            this.handleException(ivjExc);
        }
    }

    private void connPtoP1SetTarget() {
        try {
            if (!this.ivjConnPtoP1Aligning) {
                this.ivjConnPtoP1Aligning = true;
                this.setLoginBean(this.getLogin());
                this.ivjConnPtoP1Aligning = false;
            }
        }
        catch (Throwable ivjExc) {
            this.ivjConnPtoP1Aligning = false;
            this.handleException(ivjExc);
        }
    }

    private void connPtoP20SetSource() {
        try {
            if (this.getLoginBean() != null) {
                this.getLoginBean().setStatementCacheSize(Integer.parseInt(this.getStatementCacheSizeText().getText()));
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP20SetTarget() {
        try {
            if (this.getLoginBean() != null) {
                this.getStatementCacheSizeText().setText(String.valueOf(this.getLoginBean().getStatementCacheSize()));
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP21SetSource() {
        try {
            if (this.getLoginBean() != null) {
                this.getLoginBean().setStringBindingSize(Integer.parseInt(this.getStringBindSizeText().getText()));
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP21SetTarget() {
        try {
            if (this.getLoginBean() != null) {
                this.getStringBindSizeText().setText(String.valueOf(this.getLoginBean().getStringBindingSize()));
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP22SetSource() {
        try {
            if (this.getLoginBean() != null) {
                this.getLoginBean().setUsesStringBinding(this.getStringBindingCheckbox().isSelected());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP22SetTarget() {
        try {
            if (this.getLoginBean() != null) {
                this.getStringBindingCheckbox().setSelected(this.getLoginBean().getUsesStringBinding());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP23SetSource() {
        try {
            if (this.getLoginBean() != null) {
                this.getLoginBean().setShouldTrimStrings(this.getTrimStringsCheckbox().isSelected());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP23SetTarget() {
        try {
            if (this.getLoginBean() != null) {
                this.getTrimStringsCheckbox().setSelected(this.getLoginBean().getShouldTrimStrings());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP24SetSource() {
        try {
            if (this.getLoginBean() != null) {
                if (this.getDirectConnectCheckBox().isSelected()) {
                    this.getLoginBean().useDirectDriverConnect();
                } else {
                    this.getLoginBean().useDefaultDriverConnect();
                }
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP24SetTarget() {
    }

    private void connPtoP25SetSource() {
        try {
            if (this.getLoginBean() != null) {
                this.getLoginBean().setShouldForceFieldNamesToUpperCase(this.getForceCaseCheckBox().isSelected());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP25SetTarget() {
    }

    private void connPtoP2SetSource() {
        try {
            if (this.getLoginBean() != null && this.getLoginBean().getConnector() instanceof DefaultConnector) {
                this.getLoginBean().setDriverClassName((String)this.getDriverChoice().getSelectedItem());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP2SetTarget() {
        try {
            if (this.getLoginBean() != null) {
                this.getDriverChoice().setSelectedItem(this.getLoginBean().getDriverClassName());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP3SetSource() {
        try {
            if (this.getLoginBean() != null && this.getLoginBean().getConnector() instanceof DefaultConnector) {
                this.getLoginBean().setDriverURLHeader(this.getDriverURLText().getText());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP3SetTarget() {
        try {
            if (this.getLoginBean() != null) {
                this.getDriverURLText().setText(this.getLoginBean().getDriverURLHeader());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP4SetSource() {
        try {
            if (this.getLoginBean() != null) {
                this.getLoginBean().setUsesBatchWriting(this.getBatchWritingCheckBox().isSelected());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP4SetTarget() {
    }

    private void connPtoP5SetSource() {
        try {
            if (this.getLoginBean() != null && this.getLoginBean().getConnector() instanceof DefaultConnector) {
                this.getLoginBean().setDatabaseURL(this.getDatabaseURLText().getText());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP5SetTarget() {
        try {
            if (this.getLoginBean() != null) {
                this.getDatabaseURLText().setText(this.getLoginBean().getDatabaseURL());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP6SetSource() {
        try {
            if (this.getLoginBean() != null && this.getPlatformChoice().getSelectedItem() != null) {
                this.getLoginBean().setPlatformClassName((String)this.getPlatformChoice().getSelectedItem());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP6SetTarget() {
        try {
            if (this.getLoginBean() != null) {
                this.getPlatformChoice().setSelectedItem(this.getLoginBean().getPlatformClassName());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP7SetSource() {
        try {
            if (this.getLoginBean() != null) {
                this.getLoginBean().setUserName(this.getUserText().getText());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP7SetTarget() {
        try {
            if (this.getLoginBean() != null) {
                this.getUserText().setText(this.getLoginBean().getUserName());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP8SetSource() {
        try {
            if (this.getLoginBean() != null) {
                this.getLoginBean().setUsesStreamsForBinding(this.getBlobStreamBinding().isSelected());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP8SetTarget() {
        try {
            if (this.getLoginBean() != null) {
                this.getBlobStreamBinding().setSelected(this.getLoginBean().getUsesStreamsForBinding());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP9SetSource() {
        try {
            if (this.getLoginBean() != null) {
                this.getLoginBean().setUsesNativeSQL(this.getNativeSQLCheckbox().isSelected());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP9SetTarget() {
        try {
            if (this.getLoginBean() != null) {
                this.getNativeSQLCheckbox().setSelected(this.getLoginBean().getUsesNativeSQL());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JCheckBox getBatchWritingCheckBox() {
        if (this.ivjBatchWritingCheckBox == null) {
            try {
                this.ivjBatchWritingCheckBox = new JCheckBox();
                this.ivjBatchWritingCheckBox.setName("BatchWritingCheckBox");
                this.ivjBatchWritingCheckBox.setText("Batch Writing");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBatchWritingCheckBox;
    }

    private JPanel getBindingPage() {
        if (this.ivjBindingPage == null) {
            try {
                this.ivjBindingPage = new JPanel();
                this.ivjBindingPage.setName("BindingPage");
                this.ivjBindingPage.setLayout(new GridBagLayout());
                this.ivjBindingPage.setBackground(SystemColor.control);
                GridBagConstraints constraintsStringBindSizeLable = new GridBagConstraints();
                constraintsStringBindSizeLable.gridx = 0;
                constraintsStringBindSizeLable.gridy = 2;
                constraintsStringBindSizeLable.anchor = 17;
                constraintsStringBindSizeLable.insets = new Insets(2, 2, 2, 2);
                this.getBindingPage().add((Component)this.getStringBindSizeLable(), constraintsStringBindSizeLable);
                GridBagConstraints constraintsStringBindingCheckbox = new GridBagConstraints();
                constraintsStringBindingCheckbox.gridx = 0;
                constraintsStringBindingCheckbox.gridy = 1;
                constraintsStringBindingCheckbox.anchor = 18;
                constraintsStringBindingCheckbox.insets = new Insets(2, 2, 2, 2);
                this.getBindingPage().add((Component)this.getStringBindingCheckbox(), constraintsStringBindingCheckbox);
                GridBagConstraints constraintsBlobBindingCheckbox = new GridBagConstraints();
                constraintsBlobBindingCheckbox.gridx = 0;
                constraintsBlobBindingCheckbox.gridy = 0;
                constraintsBlobBindingCheckbox.anchor = 18;
                constraintsBlobBindingCheckbox.insets = new Insets(2, 2, 2, 2);
                this.getBindingPage().add((Component)this.getBlobBindingCheckbox(), constraintsBlobBindingCheckbox);
                GridBagConstraints constraintsBlobStreamBinding = new GridBagConstraints();
                constraintsBlobStreamBinding.gridx = 1;
                constraintsBlobStreamBinding.gridy = 0;
                constraintsBlobStreamBinding.anchor = 18;
                constraintsBlobStreamBinding.insets = new Insets(2, 2, 2, 2);
                this.getBindingPage().add((Component)this.getBlobStreamBinding(), constraintsBlobStreamBinding);
                GridBagConstraints constraintsStringBindSizeText = new GridBagConstraints();
                constraintsStringBindSizeText.gridx = 1;
                constraintsStringBindSizeText.gridy = 2;
                constraintsStringBindSizeText.fill = 2;
                constraintsStringBindSizeText.weightx = 1.0;
                constraintsStringBindSizeText.insets = new Insets(2, 2, 2, 2);
                this.getBindingPage().add((Component)this.getStringBindSizeText(), constraintsStringBindSizeText);
                GridBagConstraints constraintsFillerPanel2 = new GridBagConstraints();
                constraintsFillerPanel2.gridx = 0;
                constraintsFillerPanel2.gridy = 5;
                constraintsFillerPanel2.gridwidth = 2;
                constraintsFillerPanel2.gridheight = 2;
                constraintsFillerPanel2.fill = 1;
                constraintsFillerPanel2.weightx = 1.0;
                constraintsFillerPanel2.weighty = 1.0;
                this.getBindingPage().add((Component)this.getFillerPanel2(), constraintsFillerPanel2);
                GridBagConstraints constraintsParameterizedSQLCheckbox = new GridBagConstraints();
                constraintsParameterizedSQLCheckbox.gridx = 0;
                constraintsParameterizedSQLCheckbox.gridy = 3;
                constraintsParameterizedSQLCheckbox.anchor = 18;
                constraintsParameterizedSQLCheckbox.insets = new Insets(2, 2, 2, 2);
                this.getBindingPage().add((Component)this.getParameterizedSQLCheckbox(), constraintsParameterizedSQLCheckbox);
                GridBagConstraints constraintsStatementCacheSizeText = new GridBagConstraints();
                constraintsStatementCacheSizeText.gridx = 1;
                constraintsStatementCacheSizeText.gridy = 4;
                constraintsStatementCacheSizeText.fill = 2;
                constraintsStatementCacheSizeText.weightx = 1.0;
                constraintsStatementCacheSizeText.insets = new Insets(2, 2, 2, 2);
                this.getBindingPage().add((Component)this.getStatementCacheSizeText(), constraintsStatementCacheSizeText);
                GridBagConstraints constraintsStatementCacheSizeLabel = new GridBagConstraints();
                constraintsStatementCacheSizeLabel.gridx = 0;
                constraintsStatementCacheSizeLabel.gridy = 4;
                constraintsStatementCacheSizeLabel.anchor = 17;
                constraintsStatementCacheSizeLabel.insets = new Insets(2, 2, 2, 2);
                this.getBindingPage().add((Component)this.getStatementCacheSizeLabel(), constraintsStatementCacheSizeLabel);
                GridBagConstraints constraintsCacheStatementsCheckbox = new GridBagConstraints();
                constraintsCacheStatementsCheckbox.gridx = 1;
                constraintsCacheStatementsCheckbox.gridy = 3;
                constraintsCacheStatementsCheckbox.anchor = 18;
                constraintsCacheStatementsCheckbox.insets = new Insets(2, 2, 2, 2);
                this.getBindingPage().add((Component)this.getCacheStatementsCheckbox(), constraintsCacheStatementsCheckbox);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBindingPage;
    }

    private JCheckBox getBlobBindingCheckbox() {
        if (this.ivjBlobBindingCheckbox == null) {
            try {
                this.ivjBlobBindingCheckbox = new JCheckBox();
                this.ivjBlobBindingCheckbox.setName("BlobBindingCheckbox");
                this.ivjBlobBindingCheckbox.setText("Byte Array Binding");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBlobBindingCheckbox;
    }

    private JCheckBox getBlobStreamBinding() {
        if (this.ivjBlobStreamBinding == null) {
            try {
                this.ivjBlobStreamBinding = new JCheckBox();
                this.ivjBlobStreamBinding.setName("BlobStreamBinding");
                this.ivjBlobStreamBinding.setText("Byte Array Stream Binding");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBlobStreamBinding;
    }

    private JComboBox<String> getBridgeChoice() {
        if (this.ivjBridgeChoice == null) {
            try {
                this.ivjBridgeChoice = new JComboBox();
                this.ivjBridgeChoice.setName("BridgeChoice");
                this.ivjBridgeChoice.setBackground(SystemColor.window);
                this.ivjBridgeChoice.setEditable(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBridgeChoice;
    }

    private JCheckBox getCacheStatementsCheckbox() {
        if (this.ivjCacheStatementsCheckbox == null) {
            try {
                this.ivjCacheStatementsCheckbox = new JCheckBox();
                this.ivjCacheStatementsCheckbox.setName("CacheStatementsCheckbox");
                this.ivjCacheStatementsCheckbox.setText("Cache All Statements");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCacheStatementsCheckbox;
    }

    private JLabel getCreatorLabel() {
        if (this.ivjCreatorLabel == null) {
            try {
                this.ivjCreatorLabel = new JLabel();
                this.ivjCreatorLabel.setName("CreatorLabel");
                this.ivjCreatorLabel.setText("Creator/Table Qualifier:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCreatorLabel;
    }

    private JTextField getCreatorText() {
        if (this.ivjCreatorText == null) {
            try {
                this.ivjCreatorText = new JTextField();
                this.ivjCreatorText.setName("CreatorText");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCreatorText;
    }

    private JLabel getDatabasePlatformLabel() {
        if (this.ivjDatabasePlatformLabel == null) {
            try {
                this.ivjDatabasePlatformLabel = new JLabel();
                this.ivjDatabasePlatformLabel.setName("DatabasePlatformLabel");
                this.ivjDatabasePlatformLabel.setText("Database Platform:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDatabasePlatformLabel;
    }

    private JLabel getDatabaseURLLabel() {
        if (this.ivjDatabaseURLLabel == null) {
            try {
                this.ivjDatabaseURLLabel = new JLabel();
                this.ivjDatabaseURLLabel.setName("DatabaseURLLabel");
                this.ivjDatabaseURLLabel.setText("Database URL:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDatabaseURLLabel;
    }

    private JTextField getDatabaseURLText() {
        if (this.ivjDatabaseURLText == null) {
            try {
                this.ivjDatabaseURLText = new JTextField();
                this.ivjDatabaseURLText.setName("DatabaseURLText");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDatabaseURLText;
    }

    private JCheckBox getDirectConnectCheckBox() {
        if (this.ivjDirectConnectCheckBox == null) {
            try {
                this.ivjDirectConnectCheckBox = new JCheckBox();
                this.ivjDirectConnectCheckBox.setName("DirectConnectCheckBox");
                this.ivjDirectConnectCheckBox.setText("Direct Driver Connection");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDirectConnectCheckBox;
    }

    private JComboBox<String> getDriverChoice() {
        if (this.ivjDriverChoice == null) {
            try {
                this.ivjDriverChoice = new JComboBox();
                this.ivjDriverChoice.setName("DriverChoice");
                this.ivjDriverChoice.setBackground(SystemColor.window);
                this.ivjDriverChoice.setEditable(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDriverChoice;
    }

    private JLabel getDriverClassNameLabel() {
        if (this.ivjDriverClassNameLabel == null) {
            try {
                this.ivjDriverClassNameLabel = new JLabel();
                this.ivjDriverClassNameLabel.setName("DriverClassNameLabel");
                this.ivjDriverClassNameLabel.setText("Driver Class Name:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDriverClassNameLabel;
    }

    private JLabel getDriverLabel() {
        if (this.ivjDriverLabel == null) {
            try {
                this.ivjDriverLabel = new JLabel();
                this.ivjDriverLabel.setName("DriverLabel");
                this.ivjDriverLabel.setText("Driver:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDriverLabel;
    }

    private JPanel getDriverPage() {
        if (this.ivjDriverPage == null) {
            try {
                this.ivjDriverPage = new JPanel();
                this.ivjDriverPage.setName("DriverPage");
                this.ivjDriverPage.setLayout(new GridBagLayout());
                this.ivjDriverPage.setBackground(SystemColor.control);
                GridBagConstraints constraintsDriverLabel = new GridBagConstraints();
                constraintsDriverLabel.gridx = 0;
                constraintsDriverLabel.gridy = 0;
                constraintsDriverLabel.anchor = 17;
                constraintsDriverLabel.insets = new Insets(4, 4, 4, 4);
                this.getDriverPage().add((Component)this.getDriverLabel(), constraintsDriverLabel);
                GridBagConstraints constraintsBridgeChoice = new GridBagConstraints();
                constraintsBridgeChoice.gridx = 1;
                constraintsBridgeChoice.gridy = 0;
                constraintsBridgeChoice.gridwidth = 2;
                constraintsBridgeChoice.fill = 2;
                constraintsBridgeChoice.weightx = 1.0;
                constraintsBridgeChoice.insets = new Insets(4, 4, 4, 4);
                this.getDriverPage().add(this.getBridgeChoice(), constraintsBridgeChoice);
                GridBagConstraints constraintsDatabasePlatformLabel = new GridBagConstraints();
                constraintsDatabasePlatformLabel.gridx = 0;
                constraintsDatabasePlatformLabel.gridy = 1;
                constraintsDatabasePlatformLabel.anchor = 17;
                constraintsDatabasePlatformLabel.insets = new Insets(4, 4, 4, 4);
                this.getDriverPage().add((Component)this.getDatabasePlatformLabel(), constraintsDatabasePlatformLabel);
                GridBagConstraints constraintsPlatformChoice = new GridBagConstraints();
                constraintsPlatformChoice.gridx = 1;
                constraintsPlatformChoice.gridy = 1;
                constraintsPlatformChoice.gridwidth = 2;
                constraintsPlatformChoice.fill = 2;
                constraintsPlatformChoice.weightx = 1.0;
                constraintsPlatformChoice.insets = new Insets(4, 4, 4, 4);
                this.getDriverPage().add(this.getPlatformChoice(), constraintsPlatformChoice);
                GridBagConstraints constraintsDriverClassNameLabel = new GridBagConstraints();
                constraintsDriverClassNameLabel.gridx = 0;
                constraintsDriverClassNameLabel.gridy = 2;
                constraintsDriverClassNameLabel.anchor = 17;
                constraintsDriverClassNameLabel.insets = new Insets(4, 4, 4, 4);
                this.getDriverPage().add((Component)this.getDriverClassNameLabel(), constraintsDriverClassNameLabel);
                GridBagConstraints constraintsDriverChoice = new GridBagConstraints();
                constraintsDriverChoice.gridx = 1;
                constraintsDriverChoice.gridy = 2;
                constraintsDriverChoice.gridwidth = 2;
                constraintsDriverChoice.fill = 2;
                constraintsDriverChoice.weightx = 1.0;
                constraintsDriverChoice.insets = new Insets(4, 4, 4, 4);
                this.getDriverPage().add(this.getDriverChoice(), constraintsDriverChoice);
                GridBagConstraints constraintsDatabaseURLLabel = new GridBagConstraints();
                constraintsDatabaseURLLabel.gridx = 0;
                constraintsDatabaseURLLabel.gridy = 3;
                constraintsDatabaseURLLabel.anchor = 17;
                constraintsDatabaseURLLabel.insets = new Insets(4, 4, 4, 4);
                this.getDriverPage().add((Component)this.getDatabaseURLLabel(), constraintsDatabaseURLLabel);
                GridBagConstraints constraintsDriverURLText = new GridBagConstraints();
                constraintsDriverURLText.gridx = 1;
                constraintsDriverURLText.gridy = 3;
                constraintsDriverURLText.fill = 2;
                constraintsDriverURLText.weightx = 1.0;
                constraintsDriverURLText.insets = new Insets(4, 4, 4, 4);
                this.getDriverPage().add((Component)this.getDriverURLText(), constraintsDriverURLText);
                GridBagConstraints constraintsDatabaseURLText = new GridBagConstraints();
                constraintsDatabaseURLText.gridx = 2;
                constraintsDatabaseURLText.gridy = 3;
                constraintsDatabaseURLText.fill = 2;
                constraintsDatabaseURLText.weightx = 1.0;
                constraintsDatabaseURLText.insets = new Insets(4, 4, 4, 4);
                this.getDriverPage().add((Component)this.getDatabaseURLText(), constraintsDatabaseURLText);
                GridBagConstraints constraintsUserText = new GridBagConstraints();
                constraintsUserText.gridx = 1;
                constraintsUserText.gridy = 4;
                constraintsUserText.gridwidth = 2;
                constraintsUserText.fill = 2;
                constraintsUserText.weightx = 1.0;
                constraintsUserText.insets = new Insets(4, 4, 4, 4);
                this.getDriverPage().add((Component)this.getUserText(), constraintsUserText);
                GridBagConstraints constraintsUserNameLabel = new GridBagConstraints();
                constraintsUserNameLabel.gridx = 0;
                constraintsUserNameLabel.gridy = 4;
                constraintsUserNameLabel.anchor = 17;
                constraintsUserNameLabel.insets = new Insets(4, 4, 4, 4);
                this.getDriverPage().add((Component)this.getUserNameLabel(), constraintsUserNameLabel);
                GridBagConstraints constraintsPasswordText = new GridBagConstraints();
                constraintsPasswordText.gridx = 1;
                constraintsPasswordText.gridy = 5;
                constraintsPasswordText.gridwidth = 2;
                constraintsPasswordText.fill = 2;
                constraintsPasswordText.weightx = 1.0;
                constraintsPasswordText.insets = new Insets(4, 4, 4, 4);
                this.getDriverPage().add((Component)this.getPasswordText(), constraintsPasswordText);
                GridBagConstraints constraintsPasswordLabel = new GridBagConstraints();
                constraintsPasswordLabel.gridx = 0;
                constraintsPasswordLabel.gridy = 5;
                constraintsPasswordLabel.anchor = 17;
                constraintsPasswordLabel.insets = new Insets(4, 4, 4, 4);
                this.getDriverPage().add((Component)this.getPasswordLabel(), constraintsPasswordLabel);
                GridBagConstraints constraintsFillerPanel = new GridBagConstraints();
                constraintsFillerPanel.gridx = 0;
                constraintsFillerPanel.gridy = 7;
                constraintsFillerPanel.gridwidth = 3;
                constraintsFillerPanel.fill = 1;
                constraintsFillerPanel.weightx = 1.0;
                constraintsFillerPanel.weighty = 1.0;
                this.getDriverPage().add((Component)this.getFillerPanel(), constraintsFillerPanel);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDriverPage;
    }

    private JTextField getDriverURLText() {
        if (this.ivjDriverURLText == null) {
            try {
                this.ivjDriverURLText = new JTextField();
                this.ivjDriverURLText.setName("DriverURLText");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDriverURLText;
    }

    private JPanel getFillerPanel() {
        if (this.ivjFillerPanel == null) {
            try {
                this.ivjFillerPanel = new JPanel();
                this.ivjFillerPanel.setName("FillerPanel");
                this.ivjFillerPanel.setLayout(null);
                this.ivjFillerPanel.setBackground(SystemColor.control);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFillerPanel;
    }

    private JPanel getFillerPanel1() {
        if (this.ivjFillerPanel1 == null) {
            try {
                this.ivjFillerPanel1 = new JPanel();
                this.ivjFillerPanel1.setName("FillerPanel1");
                this.ivjFillerPanel1.setLayout(null);
                this.ivjFillerPanel1.setBackground(SystemColor.control);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFillerPanel1;
    }

    private JPanel getFillerPanel11() {
        if (this.ivjFillerPanel11 == null) {
            try {
                this.ivjFillerPanel11 = new JPanel();
                this.ivjFillerPanel11.setName("FillerPanel11");
                this.ivjFillerPanel11.setLayout(null);
                this.ivjFillerPanel11.setBackground(SystemColor.control);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFillerPanel11;
    }

    private JPanel getFillerPanel2() {
        if (this.ivjFillerPanel2 == null) {
            try {
                this.ivjFillerPanel2 = new JPanel();
                this.ivjFillerPanel2.setName("FillerPanel2");
                this.ivjFillerPanel2.setLayout(null);
                this.ivjFillerPanel2.setBackground(SystemColor.control);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFillerPanel2;
    }

    private JCheckBox getForceCaseCheckBox() {
        if (this.ivjForceCaseCheckBox == null) {
            try {
                this.ivjForceCaseCheckBox = new JCheckBox();
                this.ivjForceCaseCheckBox.setName("ForceCaseCheckBox");
                this.ivjForceCaseCheckBox.setText("Force Field Names to Upper Case");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjForceCaseCheckBox;
    }

    private JCheckBox getJTSCheckBox() {
        if (this.ivjJTSCheckBox == null) {
            try {
                this.ivjJTSCheckBox = new JCheckBox();
                this.ivjJTSCheckBox.setName("JTSCheckBox");
                this.ivjJTSCheckBox.setText("External Transaction Control");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTSCheckBox;
    }

    public DatabaseLogin getLogin() {
        return this.fieldLogin;
    }

    private DatabaseLogin getLoginBean() {
        return this.ivjLoginBean;
    }

    private JCheckBox getNativeSequencingCheckbox() {
        if (this.ivjNativeSequencingCheckbox == null) {
            try {
                this.ivjNativeSequencingCheckbox = new JCheckBox();
                this.ivjNativeSequencingCheckbox.setName("NativeSequencingCheckbox");
                this.ivjNativeSequencingCheckbox.setText("Native Sequencing");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjNativeSequencingCheckbox;
    }

    private JCheckBox getNativeSQLCheckbox() {
        if (this.ivjNativeSQLCheckbox == null) {
            try {
                this.ivjNativeSQLCheckbox = new JCheckBox();
                this.ivjNativeSQLCheckbox.setName("NativeSQLCheckbox");
                this.ivjNativeSQLCheckbox.setText("Native SQL");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjNativeSQLCheckbox;
    }

    private JCheckBox getOptimizeDataConversionCheckbox() {
        if (this.ivjOptimizeDataConversionCheckbox == null) {
            try {
                this.ivjOptimizeDataConversionCheckbox = new JCheckBox();
                this.ivjOptimizeDataConversionCheckbox.setName("OptimizeDataConversionCheckbox");
                this.ivjOptimizeDataConversionCheckbox.setText("Optimize Data Conversion");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOptimizeDataConversionCheckbox;
    }

    private JPanel getOtherPage() {
        if (this.ivjOtherPage == null) {
            try {
                this.ivjOtherPage = new JPanel();
                this.ivjOtherPage.setName("OtherPage");
                this.ivjOtherPage.setLayout(new GridBagLayout());
                this.ivjOtherPage.setBackground(SystemColor.control);
                GridBagConstraints constraintsOptimizeDataConversionCheckbox = new GridBagConstraints();
                constraintsOptimizeDataConversionCheckbox.gridx = 1;
                constraintsOptimizeDataConversionCheckbox.gridy = 3;
                constraintsOptimizeDataConversionCheckbox.anchor = 18;
                constraintsOptimizeDataConversionCheckbox.insets = new Insets(2, 2, 2, 2);
                this.getOtherPage().add((Component)this.getOptimizeDataConversionCheckbox(), constraintsOptimizeDataConversionCheckbox);
                GridBagConstraints constraintsCreatorText = new GridBagConstraints();
                constraintsCreatorText.gridx = 1;
                constraintsCreatorText.gridy = 2;
                constraintsCreatorText.fill = 2;
                constraintsCreatorText.weightx = 1.0;
                constraintsCreatorText.insets = new Insets(2, 2, 2, 2);
                this.getOtherPage().add((Component)this.getCreatorText(), constraintsCreatorText);
                GridBagConstraints constraintsCreatorLabel = new GridBagConstraints();
                constraintsCreatorLabel.gridx = 0;
                constraintsCreatorLabel.gridy = 2;
                constraintsCreatorLabel.anchor = 17;
                constraintsCreatorLabel.insets = new Insets(2, 2, 2, 2);
                this.getOtherPage().add((Component)this.getCreatorLabel(), constraintsCreatorLabel);
                GridBagConstraints constraintsFillerPanel11 = new GridBagConstraints();
                constraintsFillerPanel11.gridx = 0;
                constraintsFillerPanel11.gridy = 5;
                constraintsFillerPanel11.gridwidth = 2;
                constraintsFillerPanel11.gridheight = 2;
                constraintsFillerPanel11.fill = 1;
                constraintsFillerPanel11.weightx = 1.0;
                constraintsFillerPanel11.weighty = 1.0;
                this.getOtherPage().add((Component)this.getFillerPanel11(), constraintsFillerPanel11);
                GridBagConstraints constraintsNativeSQLCheckbox = new GridBagConstraints();
                constraintsNativeSQLCheckbox.gridx = 1;
                constraintsNativeSQLCheckbox.gridy = 1;
                constraintsNativeSQLCheckbox.anchor = 17;
                constraintsNativeSQLCheckbox.insets = new Insets(2, 2, 2, 2);
                this.getOtherPage().add((Component)this.getNativeSQLCheckbox(), constraintsNativeSQLCheckbox);
                GridBagConstraints constraintsTrimStringsCheckbox = new GridBagConstraints();
                constraintsTrimStringsCheckbox.gridx = 1;
                constraintsTrimStringsCheckbox.gridy = 4;
                constraintsTrimStringsCheckbox.anchor = 17;
                constraintsTrimStringsCheckbox.insets = new Insets(2, 2, 2, 2);
                this.getOtherPage().add((Component)this.getTrimStringsCheckbox(), constraintsTrimStringsCheckbox);
                GridBagConstraints constraintsBatchWritingCheckBox = new GridBagConstraints();
                constraintsBatchWritingCheckBox.gridx = 0;
                constraintsBatchWritingCheckBox.gridy = 1;
                constraintsBatchWritingCheckBox.anchor = 18;
                constraintsBatchWritingCheckBox.insets = new Insets(2, 2, 2, 2);
                this.getOtherPage().add((Component)this.getBatchWritingCheckBox(), constraintsBatchWritingCheckBox);
                GridBagConstraints constraintsDirectConnectCheckBox = new GridBagConstraints();
                constraintsDirectConnectCheckBox.gridx = 0;
                constraintsDirectConnectCheckBox.gridy = 3;
                constraintsDirectConnectCheckBox.anchor = 18;
                constraintsDirectConnectCheckBox.insets = new Insets(2, 2, 2, 2);
                this.getOtherPage().add((Component)this.getDirectConnectCheckBox(), constraintsDirectConnectCheckBox);
                GridBagConstraints constraintsForceCaseCheckBox = new GridBagConstraints();
                constraintsForceCaseCheckBox.gridx = 0;
                constraintsForceCaseCheckBox.gridy = 4;
                constraintsForceCaseCheckBox.anchor = 17;
                constraintsForceCaseCheckBox.insets = new Insets(2, 2, 2, 2);
                this.getOtherPage().add((Component)this.getForceCaseCheckBox(), constraintsForceCaseCheckBox);
                GridBagConstraints constraintsJTSCheckBox = new GridBagConstraints();
                constraintsJTSCheckBox.gridx = 0;
                constraintsJTSCheckBox.gridy = 0;
                constraintsJTSCheckBox.anchor = 18;
                constraintsJTSCheckBox.insets = new Insets(2, 2, 2, 2);
                this.getOtherPage().add((Component)this.getJTSCheckBox(), constraintsJTSCheckBox);
                GridBagConstraints constraintsPoolingCheckBox = new GridBagConstraints();
                constraintsPoolingCheckBox.gridx = 1;
                constraintsPoolingCheckBox.gridy = 0;
                constraintsPoolingCheckBox.anchor = 18;
                constraintsPoolingCheckBox.insets = new Insets(2, 2, 2, 2);
                this.getOtherPage().add((Component)this.getPoolingCheckBox(), constraintsPoolingCheckBox);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOtherPage;
    }

    private JCheckBox getParameterizedSQLCheckbox() {
        if (this.ivjParameterizedSQLCheckbox == null) {
            try {
                this.ivjParameterizedSQLCheckbox = new JCheckBox();
                this.ivjParameterizedSQLCheckbox.setName("ParameterizedSQLCheckbox");
                this.ivjParameterizedSQLCheckbox.setText("Parameterize All SQL");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjParameterizedSQLCheckbox;
    }

    private JLabel getPasswordLabel() {
        if (this.ivjPasswordLabel == null) {
            try {
                this.ivjPasswordLabel = new JLabel();
                this.ivjPasswordLabel.setName("PasswordLabel");
                this.ivjPasswordLabel.setText("Password:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPasswordLabel;
    }

    private JPasswordField getPasswordText() {
        if (this.ivjPasswordText == null) {
            try {
                this.ivjPasswordText = new JPasswordField();
                this.ivjPasswordText.setName("PasswordText");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPasswordText;
    }

    private JComboBox<String> getPlatformChoice() {
        if (this.ivjPlatformChoice == null) {
            try {
                this.ivjPlatformChoice = new JComboBox();
                this.ivjPlatformChoice.setName("PlatformChoice");
                this.ivjPlatformChoice.setBackground(SystemColor.window);
                this.ivjPlatformChoice.setEditable(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPlatformChoice;
    }

    private JCheckBox getPoolingCheckBox() {
        if (this.ivjPoolingCheckBox == null) {
            try {
                this.ivjPoolingCheckBox = new JCheckBox();
                this.ivjPoolingCheckBox.setName("PoolingCheckBox");
                this.ivjPoolingCheckBox.setText("External Connection Pooling");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPoolingCheckBox;
    }

    private JLabel getPreallocationSizeLabel() {
        if (this.ivjPreallocationSizeLabel == null) {
            try {
                this.ivjPreallocationSizeLabel = new JLabel();
                this.ivjPreallocationSizeLabel.setName("PreallocationSizeLabel");
                this.ivjPreallocationSizeLabel.setText("Sequence Preallocation Size:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPreallocationSizeLabel;
    }

    private JTabbedPane getPropertiesBook() {
        if (this.ivjPropertiesBook == null) {
            try {
                this.ivjPropertiesBook = new JTabbedPane();
                this.ivjPropertiesBook.setName("PropertiesBook");
                this.ivjPropertiesBook.setTabPlacement(4);
                this.ivjPropertiesBook.setBackground(SystemColor.control);
                this.ivjPropertiesBook.insertTab("Driver", null, this.getDriverPage(), null, 0);
                this.ivjPropertiesBook.insertTab("Binding", null, this.getBindingPage(), null, 1);
                this.ivjPropertiesBook.insertTab("Sequencing", null, this.getSequencingPage(), null, 2);
                this.ivjPropertiesBook.insertTab("Other", null, this.getOtherPage(), null, 3);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPropertiesBook;
    }

    private JLabel getSequenceCounterNameLabel() {
        if (this.ivjSequenceCounterNameLabel == null) {
            try {
                this.ivjSequenceCounterNameLabel = new JLabel();
                this.ivjSequenceCounterNameLabel.setName("SequenceCounterNameLabel");
                this.ivjSequenceCounterNameLabel.setText("Sequence Counter Name:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSequenceCounterNameLabel;
    }

    private JTextField getSequenceCounterNameText() {
        if (this.ivjSequenceCounterNameText == null) {
            try {
                this.ivjSequenceCounterNameText = new JTextField();
                this.ivjSequenceCounterNameText.setName("SequenceCounterNameText");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSequenceCounterNameText;
    }

    private JLabel getSequenceFieldNameLabel() {
        if (this.ivjSequenceFieldNameLabel == null) {
            try {
                this.ivjSequenceFieldNameLabel = new JLabel();
                this.ivjSequenceFieldNameLabel.setName("SequenceFieldNameLabel");
                this.ivjSequenceFieldNameLabel.setText("Sequence Field Name:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSequenceFieldNameLabel;
    }

    private JTextField getSequenceFieldNameText() {
        if (this.ivjSequenceFieldNameText == null) {
            try {
                this.ivjSequenceFieldNameText = new JTextField();
                this.ivjSequenceFieldNameText.setName("SequenceFieldNameText");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSequenceFieldNameText;
    }

    private JTextField getSequencePreallocationSizeText() {
        if (this.ivjSequencePreallocationSizeText == null) {
            try {
                this.ivjSequencePreallocationSizeText = new JTextField();
                this.ivjSequencePreallocationSizeText.setName("SequencePreallocationSizeText");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSequencePreallocationSizeText;
    }

    private JLabel getSequenceTableNameLabel() {
        if (this.ivjSequenceTableNameLabel == null) {
            try {
                this.ivjSequenceTableNameLabel = new JLabel();
                this.ivjSequenceTableNameLabel.setName("SequenceTableNameLabel");
                this.ivjSequenceTableNameLabel.setText("Sequence Table Name:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSequenceTableNameLabel;
    }

    private JTextField getSequenceTableNameText() {
        if (this.ivjSequenceTableNameText == null) {
            try {
                this.ivjSequenceTableNameText = new JTextField();
                this.ivjSequenceTableNameText.setName("SequenceTableNameText");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSequenceTableNameText;
    }

    private JPanel getSequencingPage() {
        if (this.ivjSequencingPage == null) {
            try {
                this.ivjSequencingPage = new JPanel();
                this.ivjSequencingPage.setName("SequencingPage");
                this.ivjSequencingPage.setLayout(new GridBagLayout());
                this.ivjSequencingPage.setBackground(SystemColor.control);
                GridBagConstraints constraintsNativeSequencingCheckbox = new GridBagConstraints();
                constraintsNativeSequencingCheckbox.gridx = 0;
                constraintsNativeSequencingCheckbox.gridy = 0;
                constraintsNativeSequencingCheckbox.anchor = 18;
                constraintsNativeSequencingCheckbox.insets = new Insets(2, 2, 2, 2);
                this.getSequencingPage().add((Component)this.getNativeSequencingCheckbox(), constraintsNativeSequencingCheckbox);
                GridBagConstraints constraintsSequencePreallocationSizeText = new GridBagConstraints();
                constraintsSequencePreallocationSizeText.gridx = 1;
                constraintsSequencePreallocationSizeText.gridy = 1;
                constraintsSequencePreallocationSizeText.fill = 2;
                constraintsSequencePreallocationSizeText.weightx = 1.0;
                constraintsSequencePreallocationSizeText.insets = new Insets(2, 2, 2, 2);
                this.getSequencingPage().add((Component)this.getSequencePreallocationSizeText(), constraintsSequencePreallocationSizeText);
                GridBagConstraints constraintsPreallocationSizeLabel = new GridBagConstraints();
                constraintsPreallocationSizeLabel.gridx = 0;
                constraintsPreallocationSizeLabel.gridy = 1;
                constraintsPreallocationSizeLabel.anchor = 17;
                constraintsPreallocationSizeLabel.insets = new Insets(2, 2, 2, 2);
                this.getSequencingPage().add((Component)this.getPreallocationSizeLabel(), constraintsPreallocationSizeLabel);
                GridBagConstraints constraintsFillerPanel1 = new GridBagConstraints();
                constraintsFillerPanel1.gridx = 0;
                constraintsFillerPanel1.gridy = 5;
                constraintsFillerPanel1.gridwidth = 2;
                constraintsFillerPanel1.gridheight = 2;
                constraintsFillerPanel1.fill = 1;
                constraintsFillerPanel1.weightx = 1.0;
                constraintsFillerPanel1.weighty = 1.0;
                this.getSequencingPage().add((Component)this.getFillerPanel1(), constraintsFillerPanel1);
                GridBagConstraints constraintsSequenceTableNameText = new GridBagConstraints();
                constraintsSequenceTableNameText.gridx = 1;
                constraintsSequenceTableNameText.gridy = 2;
                constraintsSequenceTableNameText.fill = 2;
                constraintsSequenceTableNameText.weightx = 1.0;
                constraintsSequenceTableNameText.insets = new Insets(2, 2, 2, 2);
                this.getSequencingPage().add((Component)this.getSequenceTableNameText(), constraintsSequenceTableNameText);
                GridBagConstraints constraintsSequenceTableNameLabel = new GridBagConstraints();
                constraintsSequenceTableNameLabel.gridx = 0;
                constraintsSequenceTableNameLabel.gridy = 2;
                constraintsSequenceTableNameLabel.anchor = 17;
                constraintsSequenceTableNameLabel.insets = new Insets(2, 2, 2, 2);
                this.getSequencingPage().add((Component)this.getSequenceTableNameLabel(), constraintsSequenceTableNameLabel);
                GridBagConstraints constraintsSequenceCounterNameText = new GridBagConstraints();
                constraintsSequenceCounterNameText.gridx = 1;
                constraintsSequenceCounterNameText.gridy = 4;
                constraintsSequenceCounterNameText.fill = 2;
                constraintsSequenceCounterNameText.weightx = 1.0;
                constraintsSequenceCounterNameText.insets = new Insets(2, 2, 2, 2);
                this.getSequencingPage().add((Component)this.getSequenceCounterNameText(), constraintsSequenceCounterNameText);
                GridBagConstraints constraintsSequenceFieldNameLabel = new GridBagConstraints();
                constraintsSequenceFieldNameLabel.gridx = 0;
                constraintsSequenceFieldNameLabel.gridy = 3;
                constraintsSequenceFieldNameLabel.anchor = 17;
                constraintsSequenceFieldNameLabel.insets = new Insets(2, 2, 2, 2);
                this.getSequencingPage().add((Component)this.getSequenceFieldNameLabel(), constraintsSequenceFieldNameLabel);
                GridBagConstraints constraintsSequenceCounterNameLabel = new GridBagConstraints();
                constraintsSequenceCounterNameLabel.gridx = 0;
                constraintsSequenceCounterNameLabel.gridy = 4;
                constraintsSequenceCounterNameLabel.anchor = 17;
                constraintsSequenceCounterNameLabel.insets = new Insets(2, 2, 2, 2);
                this.getSequencingPage().add((Component)this.getSequenceCounterNameLabel(), constraintsSequenceCounterNameLabel);
                GridBagConstraints constraintsSequenceFieldNameText = new GridBagConstraints();
                constraintsSequenceFieldNameText.gridx = 1;
                constraintsSequenceFieldNameText.gridy = 3;
                constraintsSequenceFieldNameText.fill = 2;
                constraintsSequenceFieldNameText.weightx = 1.0;
                constraintsSequenceFieldNameText.insets = new Insets(2, 2, 2, 2);
                this.getSequencingPage().add((Component)this.getSequenceFieldNameText(), constraintsSequenceFieldNameText);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSequencingPage;
    }

    private JLabel getStatementCacheSizeLabel() {
        if (this.ivjStatementCacheSizeLabel == null) {
            try {
                this.ivjStatementCacheSizeLabel = new JLabel();
                this.ivjStatementCacheSizeLabel.setName("StatementCacheSizeLabel");
                this.ivjStatementCacheSizeLabel.setText("Statement Cache Size:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStatementCacheSizeLabel;
    }

    private JTextField getStatementCacheSizeText() {
        if (this.ivjStatementCacheSizeText == null) {
            try {
                this.ivjStatementCacheSizeText = new JTextField();
                this.ivjStatementCacheSizeText.setName("StatementCacheSizeText");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStatementCacheSizeText;
    }

    private JCheckBox getStringBindingCheckbox() {
        if (this.ivjStringBindingCheckbox == null) {
            try {
                this.ivjStringBindingCheckbox = new JCheckBox();
                this.ivjStringBindingCheckbox.setName("StringBindingCheckbox");
                this.ivjStringBindingCheckbox.setText("String Binding");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStringBindingCheckbox;
    }

    private JLabel getStringBindSizeLable() {
        if (this.ivjStringBindSizeLable == null) {
            try {
                this.ivjStringBindSizeLable = new JLabel();
                this.ivjStringBindSizeLable.setName("StringBindSizeLable");
                this.ivjStringBindSizeLable.setText("String Bind Size:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStringBindSizeLable;
    }

    private JTextField getStringBindSizeText() {
        if (this.ivjStringBindSizeText == null) {
            try {
                this.ivjStringBindSizeText = new JTextField();
                this.ivjStringBindSizeText.setName("StringBindSizeText");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStringBindSizeText;
    }

    private JCheckBox getTrimStringsCheckbox() {
        if (this.ivjTrimStringsCheckbox == null) {
            try {
                this.ivjTrimStringsCheckbox = new JCheckBox();
                this.ivjTrimStringsCheckbox.setName("TrimStringsCheckbox");
                this.ivjTrimStringsCheckbox.setText("Trim Strings");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTrimStringsCheckbox;
    }

    private JLabel getUserNameLabel() {
        if (this.ivjUserNameLabel == null) {
            try {
                this.ivjUserNameLabel = new JLabel();
                this.ivjUserNameLabel.setName("UserNameLabel");
                this.ivjUserNameLabel.setText("User Name:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjUserNameLabel;
    }

    private JTextField getUserText() {
        if (this.ivjUserText == null) {
            try {
                this.ivjUserText = new JTextField();
                this.ivjUserText.setName("UserText");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjUserText;
    }

    private void handleException(Throwable exception) {
        System.out.println("--------- UNCAUGHT EXCEPTION ---------");
        exception.printStackTrace(System.out);
        MessageDialog.displayException(exception, this);
    }

    private void initConnections() {
        this.addPropertyChangeListener(this.ivjEventHandler);
        this.getDriverURLText().addKeyListener(this.ivjEventHandler);
        this.getDatabaseURLText().addKeyListener(this.ivjEventHandler);
        this.getUserText().addKeyListener(this.ivjEventHandler);
        this.getSequencePreallocationSizeText().addKeyListener(this.ivjEventHandler);
        this.getBridgeChoice().addItemListener(this.ivjEventHandler);
        this.getDriverChoice().addItemListener(this.ivjEventHandler);
        this.getPlatformChoice().addItemListener(this.ivjEventHandler);
        this.getSequenceCounterNameText().addKeyListener(this.ivjEventHandler);
        this.getSequenceFieldNameText().addKeyListener(this.ivjEventHandler);
        this.getSequenceTableNameText().addKeyListener(this.ivjEventHandler);
        this.getCreatorText().addKeyListener(this.ivjEventHandler);
        this.getNativeSQLCheckbox().addActionListener(this.ivjEventHandler);
        this.getNativeSequencingCheckbox().addActionListener(this.ivjEventHandler);
        this.getBlobStreamBinding().addActionListener(this.ivjEventHandler);
        this.getBlobBindingCheckbox().addActionListener(this.ivjEventHandler);
        this.getParameterizedSQLCheckbox().addActionListener(this.ivjEventHandler);
        this.getOptimizeDataConversionCheckbox().addActionListener(this.ivjEventHandler);
        this.getCacheStatementsCheckbox().addActionListener(this.ivjEventHandler);
        this.getStringBindSizeText().addKeyListener(this.ivjEventHandler);
        this.getStringBindingCheckbox().addActionListener(this.ivjEventHandler);
        this.getStatementCacheSizeText().addKeyListener(this.ivjEventHandler);
        this.getTrimStringsCheckbox().addActionListener(this.ivjEventHandler);
        this.getPasswordText().addCaretListener(this.ivjEventHandler);
        this.getBatchWritingCheckBox().addActionListener(this.ivjEventHandler);
        this.getDirectConnectCheckBox().addActionListener(this.ivjEventHandler);
        this.getForceCaseCheckBox().addActionListener(this.ivjEventHandler);
        this.connPtoP1SetTarget();
        this.connPtoP3SetTarget();
        this.connPtoP5SetTarget();
        this.connPtoP7SetTarget();
        this.connPtoP12SetTarget();
        this.connPtoP2SetTarget();
        this.connPtoP6SetTarget();
        this.connPtoP14SetTarget();
        this.connPtoP15SetTarget();
        this.connPtoP16SetTarget();
        this.connPtoP18SetTarget();
        this.connPtoP9SetTarget();
        this.connPtoP11SetTarget();
        this.connPtoP8SetTarget();
        this.connPtoP10SetTarget();
        this.connPtoP17SetTarget();
        this.connPtoP13SetTarget();
        this.connPtoP19SetTarget();
        this.connPtoP21SetTarget();
        this.connPtoP22SetTarget();
        this.connPtoP20SetTarget();
        this.connPtoP23SetTarget();
        this.connPtoP4SetTarget();
        this.connPtoP24SetTarget();
        this.connPtoP25SetTarget();
    }

    private void initialize() {
        try {
            this.setName("LoginEditorPanel");
            this.setLayout(new GridBagLayout());
            this.setBackground(SystemColor.control);
            this.setSize(590, 428);
            GridBagConstraints constraintsPropertiesBook = new GridBagConstraints();
            constraintsPropertiesBook.gridx = 0;
            constraintsPropertiesBook.gridy = 0;
            constraintsPropertiesBook.gridwidth = 3;
            constraintsPropertiesBook.fill = 1;
            constraintsPropertiesBook.weightx = 1.0;
            constraintsPropertiesBook.weighty = 1.0;
            constraintsPropertiesBook.insets = new Insets(0, 2, 2, 2);
            this.add((Component)this.getPropertiesBook(), constraintsPropertiesBook);
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.reset();
    }

    public void passwordChanged() {
        password = new String(this.getPasswordText().getPassword());
        this.getLogin().setEncryptedPassword(password);
    }

    public void reset() {
        this.resetLogin();
        this.resetSequenceButtons();
        this.resetStringButtons();
    }

    public void resetLogin() {
        this.getDriverChoice().removeAllItems();
        this.getDriverChoice().addItem("oracle.jdbc.OracleDriver");
        this.getDriverChoice().addItem("COM.ibm.db2.jdbc.app.DB2Driver");
        this.getDriverChoice().addItem("COM.ibm.db2.jdbc.net.DB2Driver");
        this.getDriverChoice().addItem("com.ibm.db2.jcc.DB2Driver");
        this.getDriverChoice().addItem("com.sybase.jdbc2.jdbc.SybDriver");
        this.getDriverChoice().addItem("com.oracle.ias.jdbc.db2.DB2Driver");
        this.getDriverChoice().addItem("org.apache.derby.EmbeddedDriver");
        this.getDriverChoice().addItem("com.oracle.ias.jdbc.sybase.SybaseDriver");
        this.getDriverChoice().addItem("com.oracle.ias.jdbc.sqlserver.SQLServerDriver");
        this.getDriverChoice().addItem("com.microsoft.jdbc.sqlserver.SQLServerDriver");
        this.getDriverChoice().addItem("weblogic.jdbc.mssqlserver4.Driver");
        this.getDriverChoice().addItem("com.mysql.jdbc.Driver");
        this.getDriverChoice().addItem("sun.jdbc.odbc.JdbcOdbcDriver");
        this.getDriverChoice().addItem("com.fujitsu.symfoware.jdbc.SYMDriver");
        this.getPlatformChoice().removeAllItems();
        this.getPlatformChoice().addItem("org.eclipse.persistence.platform.database.OraclePlatform");
        this.getPlatformChoice().addItem("org.eclipse.persistence.platform.database.oracle.Oracle8Platform");
        this.getPlatformChoice().addItem("org.eclipse.persistence.platform.database.oracle.Oracle9Platform");
        this.getPlatformChoice().addItem("org.eclipse.persistence.platform.database.DB2Platform");
        this.getPlatformChoice().addItem("org.eclipse.persistence.platform.database.InformixPlatform");
        this.getPlatformChoice().addItem("org.eclipse.persistence.platform.database.DerbyPlatform");
        this.getPlatformChoice().addItem("org.eclipse.persistence.platform.database.JavaDBPlatform");
        this.getPlatformChoice().addItem("org.eclipse.persistence.platform.database.HSQLPlatform");
        this.getPlatformChoice().addItem("org.eclipse.persistence.platform.database.PostgreSQLPlatform");
        this.getPlatformChoice().addItem("org.eclipse.persistence.platform.database.SybasePlatform");
        this.getPlatformChoice().addItem("org.eclipse.persistence.platform.database.SQLAnywherePlatform");
        this.getPlatformChoice().addItem("org.eclipse.persistence.platform.database.SQLServerPlatform");
        this.getPlatformChoice().addItem("org.eclipse.persistence.platform.database.TimesTenPlatform");
        this.getPlatformChoice().addItem("org.eclipse.persistence.platform.database.TimesTen7Platform");
        this.getPlatformChoice().addItem("org.eclipse.persistence.platform.database.AccessPlatform");
        this.getPlatformChoice().addItem("org.eclipse.persistence.platform.database.MySQLPlatform");
        this.getPlatformChoice().addItem("org.eclipse.persistence.platform.database.DatabasePlatform");
        this.getPlatformChoice().addItem("org.eclipse.persistence.platform.database.SymfowarePlatform");
        this.getBridgeChoice().removeAllItems();
        this.getBridgeChoice().addItem("Oracle thin");
        this.getBridgeChoice().addItem("Oracle 8 OCI");
        this.getBridgeChoice().addItem("DB2 (App)");
        this.getBridgeChoice().addItem("DB2 (Net)");
        this.getBridgeChoice().addItem("DB2 (Universal Driver)");
        this.getBridgeChoice().addItem("Sybase JConnect");
        this.getBridgeChoice().addItem("DataDirect for DB2");
        this.getBridgeChoice().addItem("DataDirect for Sybase");
        this.getBridgeChoice().addItem("DataDirect for SQLServer");
        this.getBridgeChoice().addItem("MS JDBC");
        this.getBridgeChoice().addItem("Weblogic Thin for SQLServer");
        this.getBridgeChoice().addItem("Sun JDBC-ODBC");
        this.getBridgeChoice().addItem("Symfoware (RDB2_TCP)");
        this.getBridgeChoice().setSelectedItem(bridge);
        this.getPasswordText().setText(password);
    }

    public void resetSequenceButtons() {
        this.getSequenceCounterNameText().setEnabled(!this.getNativeSequencingCheckbox().isSelected());
        this.getSequenceFieldNameText().setEnabled(!this.getNativeSequencingCheckbox().isSelected());
        this.getSequenceTableNameText().setEnabled(!this.getNativeSequencingCheckbox().isSelected());
        this.getSequencePreallocationSizeText().setText(Integer.valueOf(this.getLogin().getDefaultSequence().getPreallocationSize()).toString());
    }

    public void resetStringButtons() {
        this.getBlobStreamBinding().setEnabled(this.getBlobBindingCheckbox().isSelected());
        this.getStringBindSizeText().setEnabled(this.getStringBindingCheckbox().isSelected());
    }

    public void setLogin(DatabaseLogin login) {
        DatabaseLogin oldValue = this.fieldLogin;
        this.fieldLogin = login;
        this.firePropertyChange("login", oldValue, login);
    }

    private void setLoginBean(DatabaseLogin newValue) {
        if (this.ivjLoginBean != newValue) {
            try {
                DatabaseLogin oldValue = this.getLoginBean();
                this.ivjLoginBean = newValue;
                this.connPtoP1SetSource();
                this.connPtoP3SetTarget();
                this.connPtoP5SetTarget();
                this.connPtoP7SetTarget();
                this.connPtoP12SetTarget();
                this.connPtoP2SetTarget();
                this.connPtoP6SetTarget();
                this.connPtoP14SetTarget();
                this.connPtoP15SetTarget();
                this.connPtoP16SetTarget();
                this.connPtoP18SetTarget();
                this.connPtoP9SetTarget();
                this.connPtoP11SetTarget();
                this.connPtoP8SetTarget();
                this.connPtoP10SetTarget();
                this.connPtoP17SetTarget();
                this.connPtoP13SetTarget();
                this.connPtoP19SetTarget();
                this.connPtoP21SetTarget();
                this.connPtoP22SetTarget();
                this.connPtoP20SetTarget();
                this.connPtoP23SetTarget();
                this.connPtoP4SetTarget();
                this.connPtoP24SetTarget();
                this.connPtoP25SetTarget();
                this.firePropertyChange("login", oldValue, newValue);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
    }

    static {
        bridge = null;
    }

    class IvjEventHandler
    implements ActionListener,
    ItemListener,
    KeyListener,
    PropertyChangeListener,
    CaretListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == LoginEditorPanel.this.getNativeSQLCheckbox()) {
                LoginEditorPanel.this.connPtoP9SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getNativeSequencingCheckbox()) {
                LoginEditorPanel.this.connPtoP11SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getBlobStreamBinding()) {
                LoginEditorPanel.this.connPtoP8SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getBlobBindingCheckbox()) {
                LoginEditorPanel.this.connPtoP10SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getParameterizedSQLCheckbox()) {
                LoginEditorPanel.this.connPtoP17SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getOptimizeDataConversionCheckbox()) {
                LoginEditorPanel.this.connPtoP13SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getCacheStatementsCheckbox()) {
                LoginEditorPanel.this.connPtoP19SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getStringBindingCheckbox()) {
                LoginEditorPanel.this.connPtoP22SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getNativeSequencingCheckbox()) {
                LoginEditorPanel.this.connEtoC2(e);
            }
            if (e.getSource() == LoginEditorPanel.this.getStringBindingCheckbox()) {
                LoginEditorPanel.this.connEtoC4(e);
            }
            if (e.getSource() == LoginEditorPanel.this.getTrimStringsCheckbox()) {
                LoginEditorPanel.this.connPtoP23SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getBlobBindingCheckbox()) {
                LoginEditorPanel.this.connEtoC5(e);
            }
            if (e.getSource() == LoginEditorPanel.this.getBatchWritingCheckBox()) {
                LoginEditorPanel.this.connPtoP4SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getDirectConnectCheckBox()) {
                LoginEditorPanel.this.connPtoP24SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getForceCaseCheckBox()) {
                LoginEditorPanel.this.connPtoP25SetSource();
            }
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            if (e.getSource() == LoginEditorPanel.this.getPasswordText()) {
                LoginEditorPanel.this.connEtoC7(e);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == LoginEditorPanel.this.getBridgeChoice()) {
                LoginEditorPanel.this.connEtoC3(e);
            }
            if (e.getSource() == LoginEditorPanel.this.getDriverChoice()) {
                LoginEditorPanel.this.connPtoP2SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getPlatformChoice()) {
                LoginEditorPanel.this.connPtoP6SetSource();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getSource() == LoginEditorPanel.this.getDriverURLText()) {
                LoginEditorPanel.this.connPtoP3SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getDatabaseURLText()) {
                LoginEditorPanel.this.connPtoP5SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getUserText()) {
                LoginEditorPanel.this.connPtoP7SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getSequencePreallocationSizeText()) {
                LoginEditorPanel.this.connPtoP12SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getSequenceCounterNameText()) {
                LoginEditorPanel.this.connPtoP14SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getSequenceFieldNameText()) {
                LoginEditorPanel.this.connPtoP15SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getSequenceTableNameText()) {
                LoginEditorPanel.this.connPtoP16SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getCreatorText()) {
                LoginEditorPanel.this.connPtoP18SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getStringBindSizeText()) {
                LoginEditorPanel.this.connPtoP21SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getStatementCacheSizeText()) {
                LoginEditorPanel.this.connPtoP20SetSource();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getSource() == LoginEditorPanel.this.getDriverURLText()) {
                LoginEditorPanel.this.connPtoP3SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getDatabaseURLText()) {
                LoginEditorPanel.this.connPtoP5SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getUserText()) {
                LoginEditorPanel.this.connPtoP7SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getSequencePreallocationSizeText()) {
                LoginEditorPanel.this.connPtoP12SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getSequenceCounterNameText()) {
                LoginEditorPanel.this.connPtoP14SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getSequenceFieldNameText()) {
                LoginEditorPanel.this.connPtoP15SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getSequenceTableNameText()) {
                LoginEditorPanel.this.connPtoP16SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getCreatorText()) {
                LoginEditorPanel.this.connPtoP18SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getStringBindSizeText()) {
                LoginEditorPanel.this.connPtoP21SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getStatementCacheSizeText()) {
                LoginEditorPanel.this.connPtoP20SetSource();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getSource() == LoginEditorPanel.this.getDriverURLText()) {
                LoginEditorPanel.this.connPtoP3SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getDatabaseURLText()) {
                LoginEditorPanel.this.connPtoP5SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getUserText()) {
                LoginEditorPanel.this.connPtoP7SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getSequencePreallocationSizeText()) {
                LoginEditorPanel.this.connPtoP12SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getSequenceCounterNameText()) {
                LoginEditorPanel.this.connPtoP14SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getSequenceFieldNameText()) {
                LoginEditorPanel.this.connPtoP15SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getSequenceTableNameText()) {
                LoginEditorPanel.this.connPtoP16SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getCreatorText()) {
                LoginEditorPanel.this.connPtoP18SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getStringBindSizeText()) {
                LoginEditorPanel.this.connPtoP21SetSource();
            }
            if (e.getSource() == LoginEditorPanel.this.getStatementCacheSizeText()) {
                LoginEditorPanel.this.connPtoP20SetSource();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == LoginEditorPanel.this && evt.getPropertyName().equals("login")) {
                LoginEditorPanel.this.connPtoP1SetTarget();
            }
        }
    }
}

