/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.modelgen;

import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.MappedSuperclass;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.PrimitiveType;
import javax.tools.JavaFileObject;
import org.eclipse.persistence.Version;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappedKeyMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.modelgen.CanonicalModelProperties;
import org.eclipse.persistence.internal.jpa.modelgen.MessagerLog;
import org.eclipse.persistence.internal.jpa.modelgen.MetadataMirrorFactory;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceUnit;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceUnitReader;
import org.eclipse.persistence.internal.jpa.modelgen.visitors.TypeVisitor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.server.ServerSession;

public class CanonicalModelProcessor
extends AbstractProcessor {
    protected MetadataMirrorFactory nonStaticFactory;
    protected static MetadataMirrorFactory staticFactory;
    private SessionLog log;
    private boolean useStaticFactory;
    private boolean generateComments;
    private boolean generateTimestamp;
    private boolean generateGenerated;
    private static final Set<String> SUPPORTED_ANNOTATIONS;
    private static final Set<String> SUPPORTED_OPTIONS;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return SUPPORTED_ANNOTATIONS;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        Map<String, String> options = processingEnv.getOptions();
        this.log = new MessagerLog(processingEnv.getMessager(), options);
        if (Boolean.parseBoolean(options.get("verbose")) && this.log.getLevel() > 2) {
            this.log.setLevel(2);
        }
        AbstractSessionLog.setLog((SessionLog)this.log);
        for (Map.Entry<String, String> option : options.entrySet()) {
            this.log(4, "Found Option: {0}, with value: {1}", option.getKey(), option.getValue());
        }
        this.useStaticFactory = Boolean.parseBoolean(CanonicalModelProperties.getOption("eclipselink.canonicalmodel.use_static_factory", "true", options));
        this.generateGenerated = Boolean.parseBoolean(CanonicalModelProperties.getOption("eclipselink.canonicalmodel.use_generated", "true", options));
        if (this.generateGenerated) {
            this.generateTimestamp = Boolean.parseBoolean(CanonicalModelProperties.getOption("eclipselink.canonicalmodel.generate_timestamp", "true", options));
            this.generateComments = Boolean.parseBoolean(CanonicalModelProperties.getOption("eclipselink.canonicalmodel.generate_comments", "true", options));
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver() && !roundEnv.errorRaised()) {
            MetadataMirrorFactory factory = null;
            try {
                MetadataLogger logger;
                ServerSession session;
                if (this.useStaticFactory) {
                    if (staticFactory == null) {
                        session = new ServerSession(new Project(new DatabaseLogin()));
                        session.setSessionLog(this.log);
                        logger = new MetadataLogger((AbstractSession)session);
                        staticFactory = new MetadataMirrorFactory(logger, Thread.currentThread().getContextClassLoader());
                        this.log(5, "Creating static metadata factory ...", new Object[0]);
                    }
                    factory = staticFactory;
                } else {
                    if (this.nonStaticFactory == null) {
                        session = new ServerSession(new Project(new DatabaseLogin()));
                        session.setSessionLog(this.log);
                        logger = new MetadataLogger((AbstractSession)session);
                        this.nonStaticFactory = new MetadataMirrorFactory(logger, Thread.currentThread().getContextClassLoader());
                        this.log(5, "Creating non-static metadata factory ...", new Object[0]);
                    }
                    factory = this.nonStaticFactory;
                }
                MetadataLogger logger2 = factory.getLogger();
                factory.setEnvironments(this.processingEnv, roundEnv);
                PersistenceUnitReader puReader = new PersistenceUnitReader(logger2, this.processingEnv);
                puReader.initPersistenceUnits(factory);
                for (PersistenceUnit persistenceUnit : factory.getPersistenceUnits()) {
                    for (Element element : roundEnv.getElementsAnnotatedWith(Entity.class)) {
                        persistenceUnit.addEntityAccessor(element);
                    }
                    for (Element element : roundEnv.getElementsAnnotatedWith(Embeddable.class)) {
                        persistenceUnit.addEmbeddableAccessor(element);
                    }
                    for (Element element : roundEnv.getElementsAnnotatedWith(MappedSuperclass.class)) {
                        persistenceUnit.addMappedSuperclassAccessor(element);
                    }
                    persistenceUnit.preProcessForCanonicalModel();
                    this.generateCanonicalModelClasses(factory, persistenceUnit);
                }
            }
            catch (Exception e) {
                this.log.logThrowable(7, "processor", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateCanonicalModelClass(MetadataClass metadataClass, Element element, PersistenceUnit persistenceUnit) throws IOException {
        Writer writer = null;
        try {
            ClassAccessor accessor = persistenceUnit.getClassAccessor(metadataClass);
            String qualifiedName = accessor.getAccessibleObjectName();
            String className = this.getName(qualifiedName);
            String classPackage = this.getPackage(qualifiedName);
            String qualifiedCanonicalName = persistenceUnit.getQualifiedCanonicalName(qualifiedName);
            String canonicalName = this.getName(qualifiedCanonicalName);
            String canonicalpackage = this.getPackage(qualifiedCanonicalName);
            boolean isNewJava = SourceVersion.RELEASE_8.compareTo(this.processingEnv.getSourceVersion()) < 0;
            JavaFileObject file = this.processingEnv.getFiler().createSourceFile(qualifiedCanonicalName, element);
            writer = file.openWriter();
            if (!canonicalpackage.equals("")) {
                writer.append("package ").append(canonicalpackage).append(";\n\n");
            }
            ArrayList<CallSite> attributes = new ArrayList<CallSite>();
            HashMap<String, String> imports = new HashMap<String, String>();
            if (this.generateGenerated) {
                if (isNewJava) {
                    imports.put("Generated", "javax.annotation.processing.Generated");
                } else {
                    imports.put("Generated", "jakarta.annotation.Generated");
                }
            }
            if (!classPackage.equals(canonicalpackage)) {
                imports.put(className, qualifiedName);
            }
            for (MappingAccessor mappingAccessor : accessor.getDescriptor().getMappingAccessors()) {
                String attributeType;
                if (mappingAccessor.isTransient()) continue;
                MetadataAnnotatedElement annotatedElement = mappingAccessor.getAnnotatedElement();
                MetadataClass metadataClass2 = mappingAccessor.getRawClass();
                Object types = className;
                if (mappingAccessor.isBasic()) {
                    types = (String)types + ", " + this.getUnqualifiedType(this.getBoxedType(annotatedElement, metadataClass2), imports);
                    attributeType = AttributeType.SingularAttribute.name();
                    imports.put(attributeType, "jakarta.persistence.metamodel.SingularAttribute");
                } else {
                    if (metadataClass2.isList()) {
                        attributeType = AttributeType.ListAttribute.name();
                        imports.put(attributeType, "jakarta.persistence.metamodel.ListAttribute");
                    } else if (metadataClass2.isSet()) {
                        attributeType = AttributeType.SetAttribute.name();
                        imports.put(attributeType, "jakarta.persistence.metamodel.SetAttribute");
                    } else if (metadataClass2.isMap()) {
                        attributeType = AttributeType.MapAttribute.name();
                        imports.put(attributeType, "jakarta.persistence.metamodel.MapAttribute");
                    } else if (metadataClass2.isCollection()) {
                        attributeType = AttributeType.CollectionAttribute.name();
                        imports.put(attributeType, "jakarta.persistence.metamodel.CollectionAttribute");
                    } else {
                        attributeType = AttributeType.SingularAttribute.name();
                        imports.put(attributeType, "jakarta.persistence.metamodel.SingularAttribute");
                    }
                    if (mappingAccessor.isMapAccessor()) {
                        if (mappingAccessor.isMappedKeyMapAccessor()) {
                            MetadataClass mapKeyClass = ((MappedKeyMapAccessor)mappingAccessor).getMapKeyClass();
                            types = (String)types + ", " + this.getUnqualifiedType(mapKeyClass.getName(), imports) + ", " + this.getUnqualifiedType(mappingAccessor.getReferenceClassName(), imports);
                        } else {
                            String mapKeyType;
                            if (annotatedElement.isGenericCollectionType()) {
                                mapKeyType = (String)annotatedElement.getGenericType().get(1);
                            } else if (mappingAccessor.getReferenceDescriptor().hasIdAccessor()) {
                                MappingAccessor idAccessor = (MappingAccessor)mappingAccessor.getReferenceDescriptor().getIdAccessors().values().iterator().next();
                                mapKeyType = idAccessor.getReferenceClassName();
                            } else {
                                mapKeyType = TypeVisitor.GENERIC_TYPE;
                            }
                            types = (String)types + ", " + this.getUnqualifiedType(mapKeyType, imports) + ", " + this.getUnqualifiedType(mappingAccessor.getReferenceClassName(), imports);
                        }
                    } else {
                        types = (String)types + ", " + this.getUnqualifiedType(mappingAccessor.getReferenceClassName(), imports);
                    }
                }
                attributes.add((CallSite)((Object)("    public static volatile " + attributeType + "<" + (String)types + "> " + annotatedElement.getAttributeName() + ";\n")));
            }
            String parent = this.writeImportStatements(imports, accessor, writer, persistenceUnit, canonicalpackage);
            if (this.generateGenerated) {
                String elVersion = "EclipseLink-" + Version.getVersion() + ".v" + Version.getBuildDate() + "-r" + Version.getBuildRevision();
                writer.append("@Generated(value=\"");
                if (isNewJava) {
                    writer.append(CanonicalModelProcessor.class.getName());
                } else {
                    writer.append(elVersion);
                }
                writer.append("\"");
                if (this.generateTimestamp) {
                    Date date = new Date();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    writer.append(", date=\"").append(simpleDateFormat.format(date)).append("\"");
                }
                if (isNewJava && this.generateComments) {
                    writer.append(", comments=\"");
                    writer.append(elVersion);
                    writer.append("\"");
                }
                writer.append(")\n");
            }
            writer.append("@StaticMetamodel(").append(className).append(".class)\n");
            writer.append("@SuppressWarnings({\"rawtypes\", \"deprecation\"})\n");
            int modifier = accessor.getAccessibleObject().getModifiers();
            writer.append(Modifier.toString(modifier)).append(" class ").append(canonicalName);
            if (parent == null) {
                writer.append(" { \n\n");
            } else {
                writer.append(" extends ").append(parent).append(" {\n\n");
            }
            for (String string : attributes) {
                writer.append(string);
            }
            writer.append("\n}");
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
                writer = null;
            }
        }
    }

    protected void generateCanonicalModelClasses(MetadataMirrorFactory factory, PersistenceUnit persistenceUnit) throws IOException {
        Map<Element, MetadataClass> roundElements = factory.getRoundElements();
        for (Element roundElement : roundElements.keySet()) {
            MetadataClass roundClass = roundElements.get(roundElement);
            if (!persistenceUnit.containsClass(roundClass) || factory.isProcessed(roundElement)) continue;
            this.log(1, "Generating class: {0}", roundClass.getName());
            this.generateCanonicalModelClass(roundClass, roundElement, persistenceUnit);
            factory.addProcessed(roundElement);
        }
    }

    protected String getBoxedType(MetadataAnnotatedElement annotatedElement, MetadataClass rawClass) {
        PrimitiveType primitiveType = (PrimitiveType)annotatedElement.getPrimitiveType();
        if (primitiveType != null) {
            return this.processingEnv.getTypeUtils().boxedClass(primitiveType).toString();
        }
        String type = annotatedElement.getType();
        return type == null ? rawClass.getType() : type;
    }

    protected String getName(String qualifiedName) {
        if (qualifiedName.indexOf(46) > -1) {
            return qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
        }
        return qualifiedName;
    }

    protected String getPackage(String qualifiedName) {
        if (qualifiedName.indexOf(46) > -1) {
            return qualifiedName.substring(0, qualifiedName.lastIndexOf(46));
        }
        return "";
    }

    protected String getUnqualifiedType(String type, HashMap<String, String> imports) {
        type = type.trim();
        if ((type = type.replace("$", ".")).contains("void")) {
            return TypeVisitor.GENERIC_TYPE;
        }
        if (type.startsWith("java.lang")) {
            return type.substring(type.lastIndexOf(46) + 1);
        }
        if (type.indexOf(60) > -1) {
            String raw = type.substring(0, type.indexOf(62));
            String generic = type.substring(type.indexOf(60) + 1, type.length() - 1);
            if (raw.contains("Map")) {
                String key = generic.substring(0, generic.indexOf(44));
                String value = generic.substring(generic.indexOf(44) + 1);
                return this.getUnqualifiedType(raw, imports) + "<" + this.getUnqualifiedType(key, imports) + ", " + this.getUnqualifiedType(value, imports) + ">";
            }
            return this.getUnqualifiedType(raw, imports) + "<" + this.getUnqualifiedType(generic, imports) + ">";
        }
        if (type.indexOf(46) > -1) {
            String shortClassName = type.substring(type.lastIndexOf(46) + 1);
            if (imports.containsKey(shortClassName)) {
                if (imports.get(shortClassName).equals(type)) {
                    return type.substring(type.lastIndexOf(46) + 1);
                }
                return type;
            }
            if (shortClassName.indexOf(91) > 1) {
                imports.put(shortClassName, type.substring(0, type.indexOf(91)));
            } else {
                imports.put(shortClassName, type);
            }
            return shortClassName;
        }
        return type;
    }

    protected String writeImportStatements(HashMap<String, String> typeImports, ClassAccessor accessor, Writer writer, PersistenceUnit persistenceUnit, String childCanonicalpackage) throws IOException {
        String parentCanonicalName = null;
        ArrayList<String> imps = new ArrayList<String>(typeImports.values());
        imps.add("jakarta.persistence.metamodel.StaticMetamodel");
        MetadataClass parentCls = accessor.getJavaClass().getSuperclass();
        MetadataProject project = accessor.getProject();
        if (project.hasEntity(parentCls) || project.hasEmbeddable(parentCls) || project.hasMappedSuperclass(parentCls)) {
            String qualifiedParentCanonicalName = persistenceUnit.getQualifiedCanonicalName(parentCls.getName());
            parentCanonicalName = this.getName(qualifiedParentCanonicalName);
            String parentCanonicalPackage = this.getPackage(qualifiedParentCanonicalName);
            if (!parentCanonicalPackage.equals(childCanonicalpackage)) {
                imps.add(qualifiedParentCanonicalName);
            }
        }
        Collections.sort(imps);
        for (String typeImport : imps) {
            writer.append("import ").append(typeImport).append(";\n");
        }
        writer.append("\n");
        return parentCanonicalName;
    }

    private void log(int level, String msg, Object ... args) {
        this.log.log(level, "processor", msg, args, false);
    }

    static {
        SUPPORTED_ANNOTATIONS = Collections.unmodifiableSet(new HashSet<String>(){
            {
                if (SourceVersion.latest().compareTo(SourceVersion.RELEASE_8) > 0) {
                    this.add("java.persistence/jakarta.persistence.*");
                    this.add("jakarta.persistence/jakarta.persistence.*");
                }
                this.add("jakarta.persistence.*");
                this.add("org.eclipse.persistence.annotations.*");
            }
        });
        SUPPORTED_OPTIONS = Collections.unmodifiableSet(new HashSet<String>(){
            {
                this.add("eclipselink.canonicalmodel.prefix");
                this.add("eclipselink.canonicalmodel.suffix");
                this.add("eclipselink.canonicalmodel.subpackage");
                this.add("eclipselink.canonicalmodel.load_xml");
                this.add("eclipselink.canonicalmodel.use_static_factory");
                this.add("eclipselink.canonicalmodel.use_generated");
                this.add("eclipselink.canonicalmodel.generate_timestamp");
                this.add("eclipselink.canonicalmodel.generate_comments");
                this.add("eclipselink.logging.level.processor");
                this.add("eclipselink.logging.level");
                this.add("eclipselink.persistencexml");
                this.add("verbose");
            }
        });
    }

    protected static enum AttributeType {
        CollectionAttribute,
        ListAttribute,
        MapAttribute,
        SetAttribute,
        SingularAttribute;

    }
}

