/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.rmi.RemoteException;
import java.util.Timer;
import java.util.TimerTask;
import oracle.kv.AuthenticationRequiredException;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.login.LoginHandle;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.login.LoginToken;
import oracle.kv.impl.security.login.UserLoginAPI;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.HostPort;

public abstract class UserLoginManager
implements LoginManager {
    private final String username;
    private final boolean autoRenew;
    private long acquireTime;
    private long renewTime;
    private Timer timer;
    private volatile LoginHandle loginHandle = null;

    public UserLoginManager(String username, boolean autoRenew) {
        this.username = username;
        this.autoRenew = autoRenew;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public LoginHandle getHandle(ResourceId target) {
        if (this.loginHandle == null) {
            this.initializeLoginHandle();
            if (this.loginHandle == null) {
                throw new IllegalStateException("LoginManager is not initialized");
            }
            if (!this.loginHandle.isUsable(target.getType())) {
                throw new UnsupportedOperationException("Unable to use the login handle for accessing a resouce  of type " + target.getType());
            }
        }
        return this.loginHandle;
    }

    @Override
    public LoginHandle getHandle(HostPort target, ResourceId.ResourceType rtype) {
        if (this.loginHandle == null) {
            this.initializeLoginHandle();
            if (this.loginHandle == null) {
                throw new IllegalStateException("LoginManager is not initialized");
            }
            if (!this.loginHandle.isUsable(rtype)) {
                throw new UnsupportedOperationException("Unable to use the login handle for accessing a resouce  of type " + rtype);
            }
        }
        return this.loginHandle;
    }

    @Override
    public void logout() throws SessionAccessException {
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.loginHandle != null) {
            this.loginHandle.logoutToken();
        }
    }

    protected void initializeLoginHandle() {
    }

    protected LoginHandle getLoginHandle() {
        return this.loginHandle;
    }

    protected void init(LoginHandle loginHndl) {
        this.loginHandle = loginHndl;
        if (this.autoRenew) {
            this.autoRenewToken();
        }
    }

    private void autoRenewToken() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.acquireTime = System.currentTimeMillis();
        LoginToken token = this.loginHandle.getLoginToken();
        if (token == null) {
            return;
        }
        long expireTime = token.getExpireTime();
        if (expireTime > this.acquireTime) {
            this.renewTime = this.acquireTime + (expireTime - this.acquireTime) / 2L;
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)new RenewTask(), this.renewTime - this.acquireTime);
        } else {
            this.renewTime = 0L;
        }
    }

    private class RenewTask
    extends TimerTask {
        private RenewTask() {
        }

        @Override
        public void run() {
            try {
                LoginToken lt = UserLoginManager.this.loginHandle.getLoginToken();
                UserLoginManager.this.loginHandle.renewToken(lt);
                UserLoginManager.this.autoRenewToken();
            }
            catch (SessionAccessException sae) {
                long delay = 60000L;
                UserLoginManager.this.timer.schedule((TimerTask)this, 60000L);
                UserLoginManager.this.autoRenewToken();
            }
            catch (AuthenticationRequiredException are) {
                UserLoginManager.this.timer.cancel();
                UserLoginManager.this.timer = null;
            }
        }
    }

    static abstract class AbstractUserLoginHandle
    extends LoginHandle {
        private boolean extendFailed = false;

        AbstractUserLoginHandle(LoginToken loginToken) {
            super(loginToken);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LoginToken renewToken(LoginToken prevToken) throws SessionAccessException {
            LoginToken currToken = this.getLoginToken();
            if (currToken != prevToken) {
                return currToken;
            }
            try {
                UserLoginAPI ulAPI = this.getLoginAPI();
                if (ulAPI == null) {
                    return null;
                }
                AbstractUserLoginHandle abstractUserLoginHandle = this;
                synchronized (abstractUserLoginHandle) {
                    if (currToken == this.getLoginToken() && !this.extendFailed) {
                        LoginToken newToken = ulAPI.requestSessionExtension(currToken);
                        if (newToken == null) {
                            this.extendFailed = true;
                        } else {
                            this.updateLoginToken(currToken, newToken);
                        }
                    }
                }
                return this.getLoginToken();
            }
            catch (RemoteException re) {
                throw new SessionAccessException(re, false);
            }
        }

        @Override
        public void logoutToken() throws SessionAccessException {
            LoginToken currToken = this.getLoginToken();
            if (currToken == null) {
                return;
            }
            try {
                UserLoginAPI ulAPI = this.getLoginAPI();
                ulAPI.logout(currToken);
                this.updateLoginToken(currToken, null);
            }
            catch (RemoteException re) {
                throw new SessionAccessException(re, false);
            }
            catch (AuthenticationRequiredException are) {
                this.updateLoginToken(currToken, null);
            }
        }

        protected abstract UserLoginAPI getLoginAPI() throws RemoteException;
    }
}

