/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.registry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.kv.impl.async.AsyncVersionedRemote;
import oracle.kv.impl.async.AsyncVersionedRemoteDialogInitiator;
import oracle.kv.impl.async.AsyncVersionedRemoteInitiator;
import oracle.kv.impl.async.CreatorEndpoint;
import oracle.kv.impl.async.MessageInput;
import oracle.kv.impl.async.MessageOutput;
import oracle.kv.impl.async.ResultHandler;
import oracle.kv.impl.async.StandardDialogTypeFamily;
import oracle.kv.impl.async.registry.ServiceEndpoint;
import oracle.kv.impl.async.registry.ServiceRegistry;
import oracle.kv.impl.util.SerializationUtil;

class ServiceRegistryInitiator
extends AsyncVersionedRemoteInitiator
implements ServiceRegistry {
    ServiceRegistryInitiator(CreatorEndpoint endpoint, Logger logger) {
        super(endpoint, StandardDialogTypeFamily.SERVICE_REGISTRY_DIALOG_TYPE, logger);
    }

    @Override
    public void getSerialVersion(short serialVersion, long timeoutMillis, ResultHandler<Short> handler) {
        this.getSerialVersion(serialVersion, ServiceRegistry.RegistryMethodOp.GET_SERIAL_VERSION, timeoutMillis, handler);
    }

    @Override
    public void lookup(short serialVersion, final String name, long timeout, ResultHandler<ServiceEndpoint> handler) {
        MessageOutput request = this.startRequest(ServiceRegistry.RegistryMethodOp.LOOKUP, serialVersion);
        try {
            SerializationUtil.writeString(request, serialVersion, name);
            SerializationUtil.writePackedLong(request, timeout);
        }
        catch (IOException e) {
            handler.onResult(null, new RuntimeException("Unexpected problem writing request: " + e, e));
            return;
        }
        this.startDialog(new Handler<ServiceEndpoint>(request, handler, (AsyncVersionedRemote.MethodOp)ServiceRegistry.RegistryMethodOp.LOOKUP){

            @Override
            String getMethodArgs() {
                return " name=" + name;
            }

            @Override
            public ServiceEndpoint readResult(MessageInput in, short serialVersionRead) throws IOException {
                ServiceEndpoint result = in.readBoolean() ? new ServiceEndpoint(in, serialVersionRead) : null;
                return result;
            }
        }, timeout);
    }

    @Override
    public void bind(short serialVersion, final String name, final ServiceEndpoint endpoint, long timeout, ResultHandler<Void> handler) {
        MessageOutput request = this.startRequest(ServiceRegistry.RegistryMethodOp.BIND, serialVersion);
        try {
            SerializationUtil.writeString(request, serialVersion, name);
            endpoint.writeFastExternal(request, serialVersion);
            SerializationUtil.writePackedLong(request, timeout);
        }
        catch (IOException e) {
            handler.onResult(null, new RuntimeException("Unexpected problem writing request: " + e, e));
            return;
        }
        this.startDialog(new Handler<Void>(request, handler, (AsyncVersionedRemote.MethodOp)ServiceRegistry.RegistryMethodOp.BIND){

            @Override
            String getMethodArgs() {
                return " name=" + name + " endpoint=" + endpoint;
            }

            @Override
            public Void readResult(MessageInput in, short serialVersionRead) {
                return null;
            }
        }, timeout);
    }

    @Override
    public void unbind(short serialVersion, final String name, long timeout, ResultHandler<Void> handler) {
        MessageOutput request = this.startRequest(ServiceRegistry.RegistryMethodOp.UNBIND, serialVersion);
        try {
            SerializationUtil.writeString(request, serialVersion, name);
            SerializationUtil.writePackedLong(request, timeout);
        }
        catch (IOException e) {
            handler.onResult(null, new RuntimeException("Unexpected problem writing request: " + e, e));
            return;
        }
        this.startDialog(new Handler<Void>(request, handler, (AsyncVersionedRemote.MethodOp)ServiceRegistry.RegistryMethodOp.UNBIND){

            @Override
            String getMethodArgs() {
                return " name=" + name;
            }

            @Override
            public Void readResult(MessageInput in, short serialVersionRead) {
                return null;
            }
        }, timeout);
    }

    @Override
    public void list(short serialVersion, long timeout, ResultHandler<List<String>> handler) {
        MessageOutput request = this.startRequest(ServiceRegistry.RegistryMethodOp.LIST, serialVersion);
        try {
            SerializationUtil.writePackedLong(request, timeout);
        }
        catch (IOException e) {
            handler.onResult(null, new RuntimeException("Unexpected problem writing request: " + e, e));
            return;
        }
        this.startDialog(new Handler<List<String>>(request, handler, (AsyncVersionedRemote.MethodOp)ServiceRegistry.RegistryMethodOp.LIST){

            @Override
            public List<String> readResult(MessageInput in, short serialVersionRead) throws IOException {
                int count = SerializationUtil.readNonNullSequenceLength(in);
                ArrayList<String> result = new ArrayList<String>(count);
                for (int i = 0; i < count; ++i) {
                    result.add(SerializationUtil.readString(in, serialVersionRead));
                }
                return result;
            }
        }, timeout);
    }

    private abstract class Handler<V>
    extends AsyncVersionedRemoteDialogInitiator<V> {
        private final AsyncVersionedRemote.MethodOp methodOp;

        Handler(MessageOutput request, ResultHandler<V> handler, AsyncVersionedRemote.MethodOp methodOp) {
            super(request, ServiceRegistryInitiator.this.logger, handler);
            this.methodOp = methodOp;
        }

        String getMethodArgs() {
            return "";
        }

        public String toString() {
            return "Handler[dialogType=" + ServiceRegistryInitiator.this.dialogType + " methodOp=" + this.methodOp + this.getMethodArgs() + "]";
        }
    }
}

