/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;

public class DeleteObjectTest
extends TransactionalTestCase {
    protected ReadObjectQuery query;
    protected Object originalObject;
    protected Object objectFromDatabase;

    public DeleteObjectTest() {
    }

    public DeleteObjectTest(Object originalObject) {
        this.setOriginalObject(originalObject);
        this.setName("DeleteObjectTest(" + originalObject.getClass() + ")");
        this.setDescription("The test deletion of the intended object, '" + originalObject + "', from the database and checks if it was deleted properly");
    }

    public Object getOriginalObject() {
        return this.originalObject;
    }

    public void setOriginalObject(Object originalObject) {
        this.originalObject = originalObject;
    }

    @Override
    protected void setup() {
        super.setup();
        this.query = new ReadObjectQuery();
        this.query.setSelectionObject(this.getOriginalObject());
        this.objectFromDatabase = this.getSession().executeQuery((DatabaseQuery)this.query);
        if (this.objectFromDatabase == null) {
            this.objectFromDatabase = this.getOriginalObject();
        }
    }

    @Override
    protected void test() {
        this.getDatabaseSession().deleteObject(this.objectFromDatabase);
    }

    @Override
    protected void verify() {
        if (!this.verifyDelete(this.objectFromDatabase)) {
            throw new TestErrorException("The object '" + this.originalObject + "' was not completely deleted from the database.");
        }
    }
}

