/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.xml.inherited;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.xml.inherited.Accredidation;
import org.eclipse.persistence.testing.models.jpa.xml.inherited.Alpine;
import org.eclipse.persistence.testing.models.jpa.xml.inherited.Becks;
import org.eclipse.persistence.testing.models.jpa.xml.inherited.BecksTag;
import org.eclipse.persistence.testing.models.jpa.xml.inherited.BeerConsumer;
import org.eclipse.persistence.testing.models.jpa.xml.inherited.Birthday;
import org.eclipse.persistence.testing.models.jpa.xml.inherited.Canadian;
import org.eclipse.persistence.testing.models.jpa.xml.inherited.Certification;
import org.eclipse.persistence.testing.models.jpa.xml.inherited.Committee;
import org.eclipse.persistence.testing.models.jpa.xml.inherited.Corona;
import org.eclipse.persistence.testing.models.jpa.xml.inherited.CoronaTag;
import org.eclipse.persistence.testing.models.jpa.xml.inherited.ExpertBeerConsumer;
import org.eclipse.persistence.testing.models.jpa.xml.inherited.Heineken;
import org.eclipse.persistence.testing.models.jpa.xml.inherited.InheritedTableManager;
import org.eclipse.persistence.testing.models.jpa.xml.inherited.Location;
import org.eclipse.persistence.testing.models.jpa.xml.inherited.NoviceBeerConsumer;
import org.eclipse.persistence.testing.models.jpa.xml.inherited.Official;
import org.eclipse.persistence.testing.models.jpa.xml.inherited.Record;
import org.eclipse.persistence.testing.models.jpa.xml.inherited.ServiceTime;
import org.eclipse.persistence.testing.models.jpa.xml.inherited.TelephoneNumber;
import org.eclipse.persistence.testing.models.jpa.xml.inherited.Witness;

public class EntityMappingsInheritedJUnitTestCase
extends JUnitTestCase {
    private static Integer beerConsumerId;
    private static Integer m_noviceBeerConsumerId;
    private static Integer m_expertBeerConsumerId;
    private static Timestamp m_quote1Stamp;
    private static final String QUOTE_ONE = "Beer is blood";
    private static Timestamp m_quote2Stamp;
    private static final String QUOTE_TWO = "My first wife was a beer";

    public EntityMappingsInheritedJUnitTestCase() {
    }

    public EntityMappingsInheritedJUnitTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("EntityMappingsInheritedJUnitTestCase");
        suite.addTest((Test)new EntityMappingsInheritedJUnitTestCase("testSetup"));
        suite.addTest((Test)new EntityMappingsInheritedJUnitTestCase("testOneToManyRelationships"));
        suite.addTest((Test)new EntityMappingsInheritedJUnitTestCase("testVerifyOneToManyRelationships"));
        suite.addTest((Test)new EntityMappingsInheritedJUnitTestCase("testCreateBeerConsumer"));
        suite.addTest((Test)new EntityMappingsInheritedJUnitTestCase("testReadBeerConsumer"));
        suite.addTest((Test)new EntityMappingsInheritedJUnitTestCase("testCreateNoviceBeerConsumer"));
        suite.addTest((Test)new EntityMappingsInheritedJUnitTestCase("testReadNoviceBeerConsumer"));
        suite.addTest((Test)new EntityMappingsInheritedJUnitTestCase("testOrderColumnNoviceBeerConsumerDesignations"));
        suite.addTest((Test)new EntityMappingsInheritedJUnitTestCase("testCreateExpertBeerConsumer"));
        suite.addTest((Test)new EntityMappingsInheritedJUnitTestCase("testReadExpertBeerConsumer"));
        suite.addTest((Test)new EntityMappingsInheritedJUnitTestCase("testNamedNativeQueryBeerConsumers"));
        suite.addTest((Test)new EntityMappingsInheritedJUnitTestCase("testNamedNativeQueryCertifications"));
        suite.addTest((Test)new EntityMappingsInheritedJUnitTestCase("testUpdateBeerConsumer"));
        suite.addTest((Test)new EntityMappingsInheritedJUnitTestCase("testDeleteBeerConsumer"));
        suite.addTest((Test)new EntityMappingsInheritedJUnitTestCase("testHeinekenBeerConsumer"));
        suite.addTest((Test)new EntityMappingsInheritedJUnitTestCase("testBecksBeerConsumer"));
        suite.addTest((Test)new EntityMappingsInheritedJUnitTestCase("testCoronaBeerConsumer"));
        suite.addTest((Test)new EntityMappingsInheritedJUnitTestCase("testColumnUpdatableAndInsertable"));
        suite.addTest((Test)new EntityMappingsInheritedJUnitTestCase("testColumnUpdatableAndInsertableThroughQuery"));
        return suite;
    }

    public void testSetup() {
        ServerSession session = JUnitTestCase.getServerSession();
        new InheritedTableManager().replaceTables((DatabaseSession)session);
        this.clearCache();
    }

    public void testBecksBeerConsumer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        BeerConsumer initialBC = new BeerConsumer();
        int beerConsumerId = 0;
        try {
            Becks becks1 = new Becks();
            becks1.setAlcoholContent(5.1);
            BecksTag becksTag1 = new BecksTag();
            becksTag1.setCallNumber("0A.789");
            em.persist((Object)becksTag1);
            Becks becks2 = new Becks();
            becks2.setAlcoholContent(5.1);
            BecksTag becksTag2 = new BecksTag();
            becksTag2.setCallNumber("BX.521");
            em.persist((Object)becksTag2);
            Becks becks3 = new Becks();
            becks3.setAlcoholContent(5.1);
            BecksTag becksTag3 = new BecksTag();
            becksTag3.setCallNumber("UY.429");
            em.persist((Object)becksTag3);
            initialBC.setName("Becks Consumer");
            initialBC.addBecksBeerToConsume(becks1, becksTag1);
            initialBC.addBecksBeerToConsume(becks2, becksTag2);
            initialBC.addBecksBeerToConsume(becks3, becksTag3);
            em.persist((Object)initialBC);
            beerConsumerId = initialBC.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            EntityMappingsInheritedJUnitTestCase.fail((String)("An exception was caught during create operation: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        BeerConsumer refreshedBC = (BeerConsumer)em.find(BeerConsumer.class, (Object)beerConsumerId);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"The beer consumer read back did not match the original", (boolean)EntityMappingsInheritedJUnitTestCase.getServerSession().compareObjects((Object)initialBC, (Object)refreshedBC));
    }

    public void testCoronaBeerConsumer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        BeerConsumer initialBC = new BeerConsumer();
        int beerConsumerId = 0;
        try {
            Corona corona1 = new Corona();
            corona1.setAlcoholContent(5.3);
            CoronaTag coronaTag1 = new CoronaTag();
            coronaTag1.setCode("0A");
            coronaTag1.setNumber(Integer.valueOf(789));
            Corona corona2 = new Corona();
            corona2.setAlcoholContent(5.3);
            CoronaTag coronaTag2 = new CoronaTag();
            coronaTag2.setCode("BX");
            coronaTag2.setNumber(Integer.valueOf(521));
            Corona corona3 = new Corona();
            corona3.setAlcoholContent(5.3);
            CoronaTag coronaTag3 = new CoronaTag();
            coronaTag3.setCode("UY");
            coronaTag3.setNumber(Integer.valueOf(429));
            initialBC.setName("Corona Consumer");
            initialBC.addCoronaBeerToConsume(corona1, coronaTag1);
            initialBC.addCoronaBeerToConsume(corona2, coronaTag2);
            initialBC.addCoronaBeerToConsume(corona3, coronaTag3);
            em.persist((Object)initialBC);
            beerConsumerId = initialBC.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            EntityMappingsInheritedJUnitTestCase.fail((String)("An exception was caught during create operation: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        BeerConsumer refreshedBC = (BeerConsumer)em.find(BeerConsumer.class, (Object)beerConsumerId);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"The beer consumer read back did not match the original", (boolean)EntityMappingsInheritedJUnitTestCase.getServerSession().compareObjects((Object)initialBC, (Object)refreshedBC));
    }

    public void verifyCalled(int countBefore, int countAfter, String callback) {
        EntityMappingsInheritedJUnitTestCase.assertFalse((String)("The callback method [" + callback + "] was not called"), (countBefore == countAfter ? 1 : 0) != 0);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)("The callback method [" + callback + "] was called more than once"), (countAfter == countBefore + 1 ? 1 : 0) != 0);
    }

    public void verifyNotCalled(int countBefore, int countAfter, String callback) {
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)("The callback method [" + callback + "] was called."), (countBefore == countAfter ? 1 : 0) != 0);
    }

    public void testCreateBeerConsumer() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            BeerConsumer consumer = new BeerConsumer();
            consumer.setName("Joe Black");
            int beerPrePersistCountBefore = consumer.pre_persist_count;
            em.persist((Object)consumer);
            int beerPrePersistCountAfter = consumer.pre_persist_count;
            this.verifyCalled(beerPrePersistCountBefore, beerPrePersistCountAfter, "pre-persist");
            beerConsumerId = consumer.getId();
            Alpine alpine1 = new Alpine();
            alpine1.setAlcoholContent(5.0);
            alpine1.setBeerConsumer(consumer);
            alpine1.setBestBeforeDate((java.util.Date)new Date(System.currentTimeMillis() + 10000000L));
            em.persist((Object)alpine1);
            Canadian canadian1 = new Canadian();
            canadian1.setAlcoholContent(5.5);
            canadian1.setBeerConsumer(consumer);
            canadian1.setBornOnDate((java.util.Date)new Date(System.currentTimeMillis() - 30000000L));
            em.persist((Object)canadian1);
            Canadian canadian2 = new Canadian();
            canadian2.setAlcoholContent(5.0);
            canadian2.setBeerConsumer(consumer);
            canadian2.setBornOnDate((java.util.Date)new Date(System.currentTimeMillis() - 23000000L));
            em.persist((Object)canadian2);
            Certification cert1 = new Certification();
            cert1.setDescription("Value brand beer consumption certified");
            cert1.setBeerConsumer(consumer);
            em.persist((Object)cert1);
            Certification cert2 = new Certification();
            cert2.setDescription("Premium brand beer consumption certified");
            cert2.setBeerConsumer(consumer);
            em.persist((Object)cert2);
            em.persist((Object)consumer);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
    }

    public void testCreateExpertBeerConsumer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        ExpertBeerConsumer beerConsumer = new ExpertBeerConsumer();
        try {
            beerConsumer.setName("Expert Beer Consumer");
            beerConsumer.setIQ(110);
            beerConsumer.getAcclaims().add("A");
            beerConsumer.getAcclaims().add("B");
            beerConsumer.getAcclaims().add("C");
            beerConsumer.getAwards().put("A", "A");
            beerConsumer.getAwards().put("B", "B");
            beerConsumer.getAwards().put("C", "C");
            beerConsumer.getDesignations().add("A");
            beerConsumer.getDesignations().add("B");
            m_quote1Stamp = Helper.timestampFromDate((java.util.Date)Helper.dateFromYearMonthDate((int)2009, (int)1, (int)1));
            beerConsumer.getQuotes().put(m_quote1Stamp, QUOTE_ONE);
            m_quote2Stamp = Helper.timestampFromDate((java.util.Date)Helper.dateFromYearMonthDate((int)2005, (int)7, (int)9));
            beerConsumer.getQuotes().put(m_quote2Stamp, QUOTE_TWO);
            Record record1 = new Record();
            record1.setDescription("Fastest beer ever consumed - 10 ms");
            record1.setDate(Helper.dateFromYearMonthDate((int)2009, (int)10, (int)10));
            record1.setLocation(new Location("Ottawa", "Canada"));
            beerConsumer.getRecords().add(record1);
            Record record2 = new Record();
            record2.setDescription("Most beers consumed in a second - 5");
            record2.setDate(Helper.dateFromYearMonthDate((int)2005, (int)12, (int)12));
            record2.setLocation(new Location("Miami", "USA"));
            beerConsumer.getRecords().add(record2);
            Accredidation accredidation = new Accredidation();
            accredidation.setDetails("Elite, absolutely elite!");
            Witness witness1 = new Witness();
            witness1.setName("Big Bobby");
            accredidation.addWitness(witness1);
            Witness witness2 = new Witness();
            witness2.setName("Little Bobby");
            accredidation.addWitness(witness2);
            Official official = new Official();
            official.setName("Authority Joe");
            accredidation.addOfficial(official);
            beerConsumer.setAccredidation(accredidation);
            Birthday birthday1 = new Birthday();
            birthday1.setDay(Integer.valueOf(9));
            birthday1.setMonth(Integer.valueOf(7));
            birthday1.setYear(Integer.valueOf(2005));
            beerConsumer.addCelebration(birthday1, "Drank a 24 of Heineken");
            Birthday birthday2 = new Birthday();
            birthday2.setDay(Integer.valueOf(10));
            birthday2.setMonth(Integer.valueOf(7));
            birthday2.setYear(Integer.valueOf(2006));
            beerConsumer.addCelebration(birthday2, "Drank a 24 of Becks");
            Committee committee1 = new Committee();
            committee1.setDescription("New beer committee");
            beerConsumer.addCommittee(committee1);
            Committee committee2 = new Committee();
            committee2.setDescription("Alcohol content regulation");
            beerConsumer.addCommittee(committee2);
            em.persist((Object)beerConsumer);
            m_expertBeerConsumerId = beerConsumer.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            EntityMappingsInheritedJUnitTestCase.fail((String)("An exception was caught during create operation for an expert beer consumer: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        BeerConsumer refreshedBC = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_expertBeerConsumerId);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"The expert beer consumer read back did not match the original", (boolean)EntityMappingsInheritedJUnitTestCase.getServerSession().compareObjects((Object)beerConsumer, (Object)refreshedBC));
    }

    public void testCreateNoviceBeerConsumer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        NoviceBeerConsumer beerConsumer = new NoviceBeerConsumer();
        try {
            beerConsumer.setName("Novice Beer Consumer");
            beerConsumer.setIQ(100);
            beerConsumer.getAcclaims().add(1);
            beerConsumer.getAcclaims().add(2);
            beerConsumer.getAcclaims().add(3);
            beerConsumer.getAwards().put(1, 1);
            beerConsumer.getAwards().put(2, 2);
            beerConsumer.getAwards().put(3, 3);
            beerConsumer.getDesignations().add("5");
            beerConsumer.getDesignations().add("4");
            beerConsumer.getDesignations().add("2");
            beerConsumer.getDesignations().add("3");
            beerConsumer.getDesignations().add("1");
            Record record1 = new Record();
            record1.setDescription("Slowest beer ever consumed - 10 hours");
            record1.setDate(Helper.dateFromYearMonthDate((int)2008, (int)1, (int)1));
            record1.setLocation(new Location("Paris", "France"));
            beerConsumer.getRecords().add(record1);
            Accredidation accredidation = new Accredidation();
            accredidation.setDetails("Superb, just superb!");
            Witness witness1 = new Witness();
            witness1.setName("Mickey Blue Eyes");
            accredidation.addWitness(witness1);
            Witness witness2 = new Witness();
            witness2.setName("Donny Trafalgo");
            accredidation.addWitness(witness2);
            beerConsumer.setAccredidation(accredidation);
            Committee committee1 = new Committee();
            committee1.setDescription("Moral labelling");
            beerConsumer.addCommittee(committee1);
            Committee committee2 = new Committee();
            committee2.setDescription("Crimes against beer");
            beerConsumer.addCommittee(committee2);
            Committee committee3 = new Committee();
            committee3.setDescription("BADD - Beers against drunk dorks");
            beerConsumer.addCommittee(committee3);
            em.persist((Object)beerConsumer);
            m_noviceBeerConsumerId = beerConsumer.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            EntityMappingsInheritedJUnitTestCase.fail((String)("An exception was caught during create operation for a novice beer consumer: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        BeerConsumer refreshedBC = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_noviceBeerConsumerId);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"The novice beer consumer read back did not match the original", (boolean)EntityMappingsInheritedJUnitTestCase.getServerSession().compareObjects((Object)beerConsumer, (Object)refreshedBC));
    }

    public void testReadNoviceBeerConsumer() {
        NoviceBeerConsumer consumer = (NoviceBeerConsumer)this.createEntityManager().find(NoviceBeerConsumer.class, (Object)m_noviceBeerConsumerId);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Error on reading back a NoviceBeerConsumer", (consumer != null ? 1 : 0) != 0);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"IQ Level was not persisted.", (consumer.getIQ() == 100 ? 1 : 0) != 0);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Incorrect number of acclaims returned.", (consumer.getAcclaims().size() == 3 ? 1 : 0) != 0);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Missing acclaim - 1", (boolean)consumer.getAcclaims().contains(1));
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Missing acclaim - 2", (boolean)consumer.getAcclaims().contains(2));
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Missing acclaim - 3", (boolean)consumer.getAcclaims().contains(3));
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Incorrect number of awards returned.", (consumer.getAwards().size() == 3 ? 1 : 0) != 0);
        Integer awardCode = (Integer)consumer.getAwards().get(1);
        EntityMappingsInheritedJUnitTestCase.assertFalse((String)"Missing award code - 1", (awardCode == null ? 1 : 0) != 0);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Award code 1 is incorrect", (boolean)awardCode.equals(1));
        awardCode = (Integer)consumer.getAwards().get(2);
        EntityMappingsInheritedJUnitTestCase.assertFalse((String)"Missing award code - 2", (awardCode == null ? 1 : 0) != 0);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Award code 2 is incorrect", (boolean)awardCode.equals(2));
        awardCode = (Integer)consumer.getAwards().get(3);
        EntityMappingsInheritedJUnitTestCase.assertFalse((String)"Missing award code - 3", (awardCode == null ? 1 : 0) != 0);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Award code 3 is incorrect", (boolean)awardCode.equals(3));
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Incorrect number of designations returned.", (consumer.getDesignations().size() == 5 ? 1 : 0) != 0);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Missing designation - 5 at index 0", (boolean)((String)consumer.getDesignations().get(0)).equals("5"));
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Missing designation - 4 at index 1", (boolean)((String)consumer.getDesignations().get(1)).equals("4"));
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Missing designation - 2 at index 2", (boolean)((String)consumer.getDesignations().get(2)).equals("2"));
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Missing designation - 3 at index 3", (boolean)((String)consumer.getDesignations().get(3)).equals("3"));
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Missing designation - 1 at index 4", (boolean)((String)consumer.getDesignations().get(4)).equals("1"));
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Incorrect number of records returned.", (consumer.getRecords().size() == 1 ? 1 : 0) != 0);
    }

    public void testReadExpertBeerConsumer() {
        ExpertBeerConsumer consumer = (ExpertBeerConsumer)this.createEntityManager().find(ExpertBeerConsumer.class, (Object)m_expertBeerConsumerId);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Error on reading back an ExpertBeerConsumer", (consumer != null ? 1 : 0) != 0);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"IQ Level was not persisted.", (consumer.getIQ() == 110 ? 1 : 0) != 0);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Incorrect number of acclaims returned.", (consumer.getAcclaims().size() == 3 ? 1 : 0) != 0);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Missing acclaim - A", (boolean)consumer.getAcclaims().contains("A"));
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Missing acclaim - B", (boolean)consumer.getAcclaims().contains("B"));
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Missing acclaim - C", (boolean)consumer.getAcclaims().contains("C"));
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Incorrect number of awards returned.", (consumer.getAwards().size() == 3 ? 1 : 0) != 0);
        String awardCode = (String)consumer.getAwards().get("A");
        EntityMappingsInheritedJUnitTestCase.assertFalse((String)"Missing award code - A", (awardCode == null ? 1 : 0) != 0);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Award code A is incorrect", (boolean)awardCode.equals("A"));
        awardCode = (String)consumer.getAwards().get("B");
        EntityMappingsInheritedJUnitTestCase.assertFalse((String)"Missing award code - B", (awardCode == null ? 1 : 0) != 0);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Award code B is incorrect", (boolean)awardCode.equals("B"));
        awardCode = (String)consumer.getAwards().get("C");
        EntityMappingsInheritedJUnitTestCase.assertFalse((String)"Missing award code - C", (awardCode == null ? 1 : 0) != 0);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Award code C is incorrect", (boolean)awardCode.equals("C"));
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Incorrect number of designations returned.", (consumer.getDesignations().size() == 2 ? 1 : 0) != 0);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Missing designation - A", (boolean)consumer.getDesignations().contains("A"));
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Missing designation - B", (boolean)consumer.getDesignations().contains("B"));
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Incorrect number of quotes returned.", (consumer.getQuotes().size() == 2 ? 1 : 0) != 0);
        String quote = (String)consumer.getQuotes().get(m_quote1Stamp);
        EntityMappingsInheritedJUnitTestCase.assertFalse((String)"Missing quote from Jan 1, 2009", (quote == null ? 1 : 0) != 0);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Quote from Jan 1, 2009 was incorrect", (boolean)quote.equals(QUOTE_ONE));
        quote = (String)consumer.getQuotes().get(m_quote2Stamp);
        EntityMappingsInheritedJUnitTestCase.assertFalse((String)"Missing quote from Jul 9, 2005", (quote == null ? 1 : 0) != 0);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Quote from Jul 9, 2005 was incorrect", (boolean)quote.equals(QUOTE_TWO));
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Incorrect number of records returned.", (consumer.getRecords().size() == 2 ? 1 : 0) != 0);
    }

    public void testHeinekenBeerConsumer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        BeerConsumer initialBC = new BeerConsumer();
        int beerConsumerId = 0;
        try {
            Heineken heineken1 = new Heineken();
            heineken1.setAlcoholContent(5.0);
            Heineken heineken2 = new Heineken();
            heineken2.setAlcoholContent(5.0);
            Heineken heineken3 = new Heineken();
            heineken3.setAlcoholContent(5.0);
            initialBC.setName("Heineken Consumer");
            Calendar cal = Calendar.getInstance();
            cal.set(2008, 12, 12);
            initialBC.addHeinekenBeerToConsume(heineken1, cal.getTime());
            cal.set(2009, 1, 1);
            initialBC.addHeinekenBeerToConsume(heineken2, cal.getTime());
            cal.set(2009, 2, 2);
            initialBC.addHeinekenBeerToConsume(heineken3, cal.getTime());
            em.persist((Object)initialBC);
            beerConsumerId = initialBC.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            EntityMappingsInheritedJUnitTestCase.fail((String)("An exception was caught during create operation: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        BeerConsumer refreshedBC = (BeerConsumer)em.find(BeerConsumer.class, (Object)beerConsumerId);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"The beer consumer read back did not match the original", (boolean)EntityMappingsInheritedJUnitTestCase.getServerSession().compareObjects((Object)initialBC, (Object)refreshedBC));
    }

    public void testNamedNativeQueryBeerConsumers() {
        List consumers = this.createEntityManager().createNamedQuery("findAnySQLBeerConsumer").getResultList();
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Error executing native query 'findAnySQLBeerConsumer'", (consumers != null ? 1 : 0) != 0);
    }

    public void testNamedNativeQueryCertifications() {
        List certifications = this.createEntityManager().createNamedQuery("findAllSQLCertifications").getResultList();
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Error executing native query 'findAllSQLCertifications'", (certifications != null ? 1 : 0) != 0);
    }

    public void testDeleteBeerConsumer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.remove(em.find(BeerConsumer.class, (Object)beerConsumerId));
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Error deleting BeerConsumer", (em.find(BeerConsumer.class, (Object)beerConsumerId) == null ? 1 : 0) != 0);
    }

    public void testReadBeerConsumer() {
        BeerConsumer consumer = (BeerConsumer)this.createEntityManager().find(BeerConsumer.class, (Object)beerConsumerId);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Error reading BeerConsumer", (consumer.getId() == beerConsumerId ? 1 : 0) != 0);
    }

    public void testUpdateBeerConsumer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)beerConsumerId);
            beerConsumer.setName("Joe White");
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        this.clearCache();
        BeerConsumer newBeerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)beerConsumerId);
        this.closeEntityManager(em);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Error updating BeerConsumer name", (boolean)newBeerConsumer.getName().equals("Joe White"));
    }

    public void testOneToManyRelationships() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            BeerConsumer consumer = new BeerConsumer();
            consumer.setName("Joe Black");
            TelephoneNumber homeNumber = new TelephoneNumber();
            homeNumber.setAreaCode("555");
            homeNumber.setType("Home");
            homeNumber.setNumber("123-1234");
            TelephoneNumber workNumber = new TelephoneNumber();
            workNumber.setAreaCode("555");
            workNumber.setType("Work");
            workNumber.setNumber("987-9876");
            consumer.addTelephoneNumber(homeNumber);
            consumer.addTelephoneNumber(workNumber);
            em.persist((Object)consumer);
            beerConsumerId = consumer.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
    }

    public void testOrderColumnNoviceBeerConsumerDesignations() {
        NoviceBeerConsumer beerConsumer;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            beerConsumer = (NoviceBeerConsumer)em.find(NoviceBeerConsumer.class, (Object)m_noviceBeerConsumerId);
            String stringFour = (String)beerConsumer.getDesignations().remove(1);
            String stringTwo = (String)beerConsumer.getDesignations().remove(1);
            beerConsumer.getDesignations().add(stringTwo);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        BeerConsumer refreshedBC = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_noviceBeerConsumerId);
        EntityMappingsInheritedJUnitTestCase.assertTrue((String)"The novice beer consumer read back did not match the original", (boolean)EntityMappingsInheritedJUnitTestCase.getServerSession().compareObjects((Object)beerConsumer, (Object)refreshedBC));
    }

    public void testVerifyOneToManyRelationships() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            BeerConsumer cm = (BeerConsumer)em.find(BeerConsumer.class, (Object)beerConsumerId);
            Collection phones = cm.getTelephoneNumbers().values();
            EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Wrong phonenumbers associated with BeerConsumer", (phones.size() == 2 ? 1 : 0) != 0);
            for (TelephoneNumber phone : phones) {
                EntityMappingsInheritedJUnitTestCase.assertTrue((String)"Wrong owner of the telephone", (phone.getBeerConsumer().getId() == beerConsumerId ? 1 : 0) != 0);
            }
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testColumnUpdatableAndInsertable() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Official initialOfficial = new Official();
            initialOfficial.setName("Gui Pelletier");
            initialOfficial.setAge(Integer.valueOf(25));
            initialOfficial.setSalary(Integer.valueOf(50000));
            initialOfficial.setBonus(Integer.valueOf(10000));
            ServiceTime service = new ServiceTime();
            service.setStartDate("Jan 1, 2008");
            service.setEndDate("Jul 1, 2010");
            initialOfficial.setServiceTime(service);
            em.persist((Object)initialOfficial);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            Official official = (Official)em.find(Official.class, (Object)initialOfficial.getId());
            EntityMappingsInheritedJUnitTestCase.assertTrue((String)"The name was not inserted", (boolean)official.getName().equals("Gui Pelletier"));
            EntityMappingsInheritedJUnitTestCase.assertTrue((String)"The age was inserted", (official.getAge() == null ? 1 : 0) != 0);
            EntityMappingsInheritedJUnitTestCase.assertTrue((String)"The salary was not inserted", (official.getSalary() == 50000 ? 1 : 0) != 0);
            EntityMappingsInheritedJUnitTestCase.assertTrue((String)"The bonus was inserted", (official.getBonus() == null ? 1 : 0) != 0);
            EntityMappingsInheritedJUnitTestCase.assertTrue((String)"The embeddable start date was not inserted", (boolean)official.getServiceTime().getStartDate().equals("Jan 1, 2008"));
            EntityMappingsInheritedJUnitTestCase.assertTrue((String)"The embeddable end date was inserted", (official.getServiceTime().getEndDate() == null ? 1 : 0) != 0);
            official.setName("Guy Pelletier");
            official.setSalary(Integer.valueOf(100000));
            official.getServiceTime().setStartDate("Jan 30, 2008");
            official.setAge(Integer.valueOf(25));
            official.setBonus(Integer.valueOf(10000));
            official.getServiceTime().setEndDate("Jul 1, 2010");
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            Official refreshedOfficial = (Official)em.find(Official.class, (Object)initialOfficial.getId());
            EntityMappingsInheritedJUnitTestCase.assertTrue((String)"The refreshedOfficial did not match the original", (boolean)EntityMappingsInheritedJUnitTestCase.getServerSession().compareObjects((Object)initialOfficial, (Object)refreshedOfficial));
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            EntityMappingsInheritedJUnitTestCase.fail((String)("An exception was caught during create operation: [" + e.getMessage() + "]"));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testColumnUpdatableAndInsertableThroughQuery() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityMappingsInheritedJUnitTestCase.getServerSession().logMessage("Test testColumnUpdatableAndInsertableThroughQuery skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Official initialOfficial = new Official();
            initialOfficial.setName("Gui Pelletier");
            em.persist((Object)initialOfficial);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            Query query = em.createNamedQuery("UpdateXMLOfficalName");
            query.setParameter("name", (Object)"Guy");
            query.setParameter("id", (Object)initialOfficial.getId());
            query.executeUpdate();
            Official modifiedOfficial = (Official)em.find(Official.class, (Object)initialOfficial.getId());
            EntityMappingsInheritedJUnitTestCase.assertTrue((String)"The name was not updated after executing the named query", (boolean)modifiedOfficial.getName().equals("Guy"));
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            Official refreshedOfficial = (Official)em.find(Official.class, (Object)modifiedOfficial.getId());
            EntityMappingsInheritedJUnitTestCase.assertTrue((String)"The refreshedOfficial did not match the modified", (boolean)EntityMappingsInheritedJUnitTestCase.getServerSession().compareObjects((Object)modifiedOfficial, (Object)refreshedOfficial));
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            EntityMappingsInheritedJUnitTestCase.fail((String)("Update query failed: " + e.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
    }
}

