/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.relationships;

import jakarta.persistence.EntityManager;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.relationships.Customer;
import org.eclipse.persistence.testing.models.jpa.relationships.Item;
import org.eclipse.persistence.testing.models.jpa.relationships.RelationshipsExamples;
import org.eclipse.persistence.testing.models.jpa.relationships.RelationshipsTableManager;

public class ExpressionJUnitTestSuite
extends JUnitTestCase {
    public ExpressionJUnitTestSuite() {
    }

    public ExpressionJUnitTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("ExpressionJUnitTestSuite");
        suite.addTest((Test)new ExpressionJUnitTestSuite("testSetup"));
        suite.addTest((Test)new ExpressionJUnitTestSuite("testLeftTrimWithTrimChar"));
        suite.addTest((Test)new ExpressionJUnitTestSuite("testLeftTrimWithoutTrimChar"));
        suite.addTest((Test)new ExpressionJUnitTestSuite("testRightTrimWithTrimChar"));
        suite.addTest((Test)new ExpressionJUnitTestSuite("testRightTrimWithoutTrimChar"));
        suite.addTest((Test)new ExpressionJUnitTestSuite("testTrimWithTrimChar"));
        suite.addTest((Test)new ExpressionJUnitTestSuite("testTrimWithoutTrimChar"));
        suite.addTest((Test)new ExpressionJUnitTestSuite("testLocateWithSingleArgument"));
        suite.addTest((Test)new ExpressionJUnitTestSuite("testLocateWithDoubleArgument"));
        suite.addTest((Test)new ExpressionJUnitTestSuite("testLocateWithDoubleArgument_Neg"));
        return suite;
    }

    public void testSetup() {
        this.clearCache();
        new RelationshipsTableManager().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
    }

    public void testLeftTrimWithTrimChar() throws Exception {
        Platform dbPlatform = this.getPlatform();
        if (!(dbPlatform.isOracle() || dbPlatform.isMySQL() || dbPlatform.isPostgreSQL() || dbPlatform.isSymfoware())) {
            ExpressionJUnitTestSuite.getServerSession().logMessage("Test testLeftTrimWithTrimChar skipped for this platform");
            return;
        }
        Customer c = RelationshipsExamples.customerExample4();
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.persist((Object)c);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        this.closeEntityManager(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("city").leftTrim((Object)"M").equal((Object)"anotick");
            ReadAllQuery r = new ReadAllQuery();
            r.setReferenceClass(Customer.class);
            r.setSelectionCriteria(expression);
            Vector v = (Vector)ExpressionJUnitTestSuite.getServerSession().executeQuery((DatabaseQuery)r);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Customers found", (v.size() != 0 ? 1 : 0) != 0);
            Customer returned = (Customer)v.firstElement();
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Customers found", (boolean)"Manotick".equals(returned.getCity()));
        }
        catch (Exception e) {
            block8: {
                em = this.createEntityManager();
                this.beginTransaction(em);
                c = (Customer)em.find(Customer.class, (Object)c.getCustomerId());
                em.remove((Object)c);
                try {
                    this.commitTransaction(em);
                }
                catch (Throwable t) {
                    if (!this.isTransactionActive(em)) break block8;
                    this.rollbackTransaction(em);
                }
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testLeftTrimWithoutTrimChar() throws Exception {
        Customer c = RelationshipsExamples.customerExample4();
        c.setCity(" anotick");
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.persist((Object)c);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        this.closeEntityManager(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("city").leftTrim().equal((Object)"anotick");
            ReadAllQuery r = new ReadAllQuery();
            r.setReferenceClass(Customer.class);
            r.setSelectionCriteria(expression);
            Vector v = (Vector)ExpressionJUnitTestSuite.getServerSession().executeQuery((DatabaseQuery)r);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Customers found", (v.size() != 0 ? 1 : 0) != 0);
            Customer returned = (Customer)v.firstElement();
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Customers found", (boolean)" anotick".equals(returned.getCity()));
        }
        catch (Exception e) {
            block7: {
                em = this.createEntityManager();
                this.beginTransaction(em);
                c = (Customer)em.find(Customer.class, (Object)c.getCustomerId());
                em.remove((Object)c);
                try {
                    this.commitTransaction(em);
                }
                catch (Throwable t) {
                    if (!this.isTransactionActive(em)) break block7;
                    this.rollbackTransaction(em);
                }
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testRightTrimWithTrimChar() throws Exception {
        Platform dbPlatform = this.getPlatform();
        if (!(dbPlatform.isOracle() || dbPlatform.isMySQL() || dbPlatform.isPostgreSQL() || dbPlatform.isSymfoware())) {
            ExpressionJUnitTestSuite.getServerSession().logMessage("Test testRightTrimWithTrimChar skipped for this platform");
            return;
        }
        Customer c = RelationshipsExamples.customerExample4();
        c.setCity("ManotickM");
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.persist((Object)c);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        this.closeEntityManager(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("city").rightTrim((Object)"M").equal((Object)"Manotick");
            ReadAllQuery r = new ReadAllQuery();
            r.setReferenceClass(Customer.class);
            r.setSelectionCriteria(expression);
            Vector v = (Vector)ExpressionJUnitTestSuite.getServerSession().executeQuery((DatabaseQuery)r);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Customers found", (v.size() != 0 ? 1 : 0) != 0);
            Customer returned = (Customer)v.firstElement();
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Customers found", ("ManotickM".equals(returned.getCity()) || "Manotick".equals(returned.getCity()) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            block8: {
                em = this.createEntityManager();
                this.beginTransaction(em);
                c = (Customer)em.find(Customer.class, (Object)c.getCustomerId());
                em.remove((Object)c);
                try {
                    this.commitTransaction(em);
                }
                catch (Throwable t) {
                    if (!this.isTransactionActive(em)) break block8;
                    this.rollbackTransaction(em);
                }
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testRightTrimWithoutTrimChar() throws Exception {
        Customer c = RelationshipsExamples.customerExample4();
        c.setCity("Manotic ");
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.persist((Object)c);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        this.closeEntityManager(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("city").rightTrim().equal((Object)"Manotic");
            ReadAllQuery r = new ReadAllQuery();
            r.setReferenceClass(Customer.class);
            r.setSelectionCriteria(expression);
            Vector v = (Vector)ExpressionJUnitTestSuite.getServerSession().executeQuery((DatabaseQuery)r);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Customers found", (v.size() != 0 ? 1 : 0) != 0);
            Customer returned = (Customer)v.firstElement();
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Customers found", (boolean)"Manotic ".equals(returned.getCity()));
        }
        catch (Exception e) {
            block7: {
                em = this.createEntityManager();
                this.beginTransaction(em);
                c = (Customer)em.find(Customer.class, (Object)c.getCustomerId());
                em.remove((Object)c);
                try {
                    this.commitTransaction(em);
                }
                catch (Throwable t) {
                    if (!this.isTransactionActive(em)) break block7;
                    this.rollbackTransaction(em);
                }
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testTrimWithTrimChar() throws Exception {
        Platform dbPlatform = this.getPlatform();
        if (!(dbPlatform.isOracle() || dbPlatform.isMySQL() || dbPlatform.isPostgreSQL() || dbPlatform.isSymfoware())) {
            ExpressionJUnitTestSuite.getServerSession().logMessage("Test testTrimWithTrimChar skipped for this platform");
            return;
        }
        Item i = new Item();
        i.setName("itemi");
        i.setDescription("itemi description");
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.persist((Object)i);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        this.closeEntityManager(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("name").trim((Object)"i").equal((Object)"tem");
            ReadAllQuery r = new ReadAllQuery();
            r.setReferenceClass(Item.class);
            r.setSelectionCriteria(expression);
            Vector v = (Vector)ExpressionJUnitTestSuite.getServerSession().executeQuery((DatabaseQuery)r);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Items found", (v.size() != 0 ? 1 : 0) != 0);
            Item returned = (Item)v.firstElement();
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Items found", (boolean)"itemi".equals(returned.getName()));
        }
        catch (Exception e) {
            block8: {
                em = this.createEntityManager();
                try {
                    this.beginTransaction(em);
                    i = (Item)em.find(Item.class, (Object)i.getItemId());
                    em.remove((Object)i);
                    this.commitTransaction(em);
                }
                catch (Throwable t) {
                    if (!this.isTransactionActive(em)) break block8;
                    this.rollbackTransaction(em);
                }
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testTrimWithoutTrimChar() throws Exception {
        Platform dbPlatform = this.getPlatform();
        if (!(dbPlatform.isOracle() || dbPlatform.isMySQL() || dbPlatform.isPostgreSQL() || dbPlatform.isInformix() || dbPlatform.isSQLAnywhere() || dbPlatform.isHSQL() || dbPlatform.isSymfoware())) {
            ExpressionJUnitTestSuite.getServerSession().logMessage("Test testTrimWithoutTrimChar skipped for this platform");
            return;
        }
        Item i = new Item();
        i.setName(" tem ");
        i.setDescription("itemi description");
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.persist((Object)i);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        this.closeEntityManager(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("name").trim().equal((Object)"tem");
            ReadAllQuery r = new ReadAllQuery();
            r.setReferenceClass(Item.class);
            r.setSelectionCriteria(expression);
            Vector v = (Vector)ExpressionJUnitTestSuite.getServerSession().executeQuery((DatabaseQuery)r);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Items found", (v.size() != 0 ? 1 : 0) != 0);
            Item returned = (Item)v.firstElement();
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Items found", (boolean)" tem ".equals(returned.getName()));
        }
        catch (Exception e) {
            block8: {
                em = this.createEntityManager();
                try {
                    this.beginTransaction(em);
                    i = (Item)em.find(Item.class, (Object)i.getItemId());
                    em.remove((Object)i);
                    this.commitTransaction(em);
                }
                catch (Throwable t) {
                    if (!this.isTransactionActive(em)) break block8;
                    this.rollbackTransaction(em);
                }
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testLocateWithSingleArgument() throws Exception {
        Item i = new Item();
        i.setName("itemi");
        i.setDescription("itemi description");
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.persist((Object)i);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        this.closeEntityManager(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("name").locate((Object)"t").equal((Object)2);
            ReadAllQuery r = new ReadAllQuery();
            r.setReferenceClass(Item.class);
            r.setSelectionCriteria(expression);
            Vector v = (Vector)ExpressionJUnitTestSuite.getServerSession().executeQuery((DatabaseQuery)r);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Items found", (v.size() != 0 ? 1 : 0) != 0);
            Item returned = (Item)v.firstElement();
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: IncorrectItem found", (boolean)"itemi".equals(returned.getName()));
        }
        catch (Exception e) {
            block7: {
                em = this.createEntityManager();
                try {
                    this.beginTransaction(em);
                    i = (Item)em.find(Item.class, (Object)i.getItemId());
                    em.remove((Object)i);
                    this.commitTransaction(em);
                }
                catch (Throwable t) {
                    if (!this.isTransactionActive(em)) break block7;
                    this.rollbackTransaction(em);
                }
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testLocateWithDoubleArgument() throws Exception {
        Item i = new Item();
        i.setName("itemi");
        i.setDescription("itemi description");
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.persist((Object)i);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        this.closeEntityManager(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("name").locate("i", 2).equal((Object)5);
            ReadAllQuery r = new ReadAllQuery();
            r.setReferenceClass(Item.class);
            r.setSelectionCriteria(expression);
            Vector v = (Vector)ExpressionJUnitTestSuite.getServerSession().executeQuery((DatabaseQuery)r);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Items found", (v.size() != 0 ? 1 : 0) != 0);
            Item returned = (Item)v.firstElement();
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: IncorrectItem found", (boolean)"itemi".equals(returned.getName()));
        }
        catch (Exception e) {
            block7: {
                em = this.createEntityManager();
                try {
                    this.beginTransaction(em);
                    i = (Item)em.find(Item.class, (Object)i.getItemId());
                    em.remove((Object)i);
                    this.commitTransaction(em);
                }
                catch (Throwable t) {
                    if (!this.isTransactionActive(em)) break block7;
                    this.rollbackTransaction(em);
                }
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testLocateWithDoubleArgument_Neg() throws Exception {
        Item i = new Item();
        i.setName("itemi");
        i.setDescription("itemi description");
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.persist((Object)i);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        this.closeEntityManager(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("name").locate("t", 4).equal((Object)0);
            ReadAllQuery r = new ReadAllQuery();
            r.setReferenceClass(Item.class);
            r.setSelectionCriteria(expression);
            Vector v = (Vector)ExpressionJUnitTestSuite.getServerSession().executeQuery((DatabaseQuery)r);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Items found", (v.size() != 0 ? 1 : 0) != 0);
            Item returned = (Item)v.firstElement();
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: IncorrectItem found", (boolean)"itemi".equals(returned.getName()));
        }
        catch (Exception e) {
            block7: {
                em = this.createEntityManager();
                try {
                    this.beginTransaction(em);
                    i = (Item)em.find(Item.class, (Object)i.getItemId());
                    em.remove((Object)i);
                    this.commitTransaction(em);
                }
                catch (Throwable t) {
                    if (!this.isTransactionActive(em)) break block7;
                    this.rollbackTransaction(em);
                }
            }
            this.closeEntityManager(em);
            throw e;
        }
    }
}

