/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.complexaggregate;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.Query;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.descriptors.changetracking.AttributeChangeListener;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.JoinedAttributeTestHelper;
import org.eclipse.persistence.testing.framework.QuerySQLTracker;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.Body;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.CitySlicker;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.CoachVitals;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.ComplexAggregateTableCreator;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.CountryDweller;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.Heart;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.HockeyCoach;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.HockeyPlayer;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.HockeyPuck;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.HockeyRink;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.HockeySponsor;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.HockeyTeam;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.Location;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.Name;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.PersonalVitals;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.Place;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.Role;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.TeamVitals;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.Torso;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.Vitals;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.World;

public class ComplexAggregateTestSuite
extends JUnitTestCase {
    public ComplexAggregateTestSuite() {
    }

    public ComplexAggregateTestSuite(String name) {
        super(name);
    }

    public void testSetup() {
        new ComplexAggregateTableCreator().replaceTables((DatabaseSession)this.getDatabaseSession());
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = (TestSuite)ComplexAggregateTestSuite.suiteSpring();
        suite.addTest((Test)new ComplexAggregateTestSuite("testInvalidateAndRefreshEmbeddableParent"));
        return suite;
    }

    public static Test suiteSpring() {
        TestSuite suite = new TestSuite();
        suite.setName("ComplexAggregateTestSuite");
        suite.addTest((Test)new ComplexAggregateTestSuite("testSetup"));
        suite.addTest((Test)new ComplexAggregateTestSuite("testMapKeyColumnMerge"));
        suite.addTest((Test)new ComplexAggregateTestSuite("testAggregatePrimaryKey"));
        suite.addTest((Test)new ComplexAggregateTestSuite("testAggregatePrimaryKeyOrderBy"));
        suite.addTest((Test)new ComplexAggregateTestSuite("testNestedAggregate"));
        suite.addTest((Test)new ComplexAggregateTestSuite("testNestedAggregatePrimaryKey"));
        suite.addTest((Test)new ComplexAggregateTestSuite("testAggregateReadOnlyMapKey"));
        suite.addTest((Test)new ComplexAggregateTestSuite("testComplexAggregateJoin"));
        suite.addTest((Test)new ComplexAggregateTestSuite("testComplexAggregateBatch"));
        suite.addTest((Test)new ComplexAggregateTestSuite("testAggregateFieldAttributeOverrides"));
        return suite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMapKeyColumnMerge() {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        try {
            HockeyPlayer player = new HockeyPlayer();
            player.setFirstName("Guy");
            player.setLastName("Flower");
            Vitals vitals = new Vitals();
            vitals.setTeamVitals(new TeamVitals());
            player.setVitals(vitals);
            HockeyPlayer player2 = new HockeyPlayer();
            player2.setFirstName("Power");
            player2.setLastName("Flower");
            Vitals vitals2 = new Vitals();
            vitals2.setTeamVitals(new TeamVitals());
            player2.setVitals(vitals2);
            HockeyCoach coach = new HockeyCoach();
            coach.setFirstName("Scott");
            coach.setLastName("Arrowman");
            CoachVitals cVitals = new CoachVitals();
            PersonalVitals pVitals = new PersonalVitals();
            pVitals.setAge(45);
            pVitals.setHeight(3.3);
            pVitals.setWeight(333.0);
            cVitals.setPersonalVitals(pVitals);
            coach.setVitals(cVitals);
            this.beginTransaction(em);
            em.persist((Object)player);
            em.persist((Object)player2);
            em.persist((Object)coach);
            Integer playerId = player.getPlayerId();
            Integer player2Id = player2.getPlayerId();
            Integer coachId = coach.getId();
            coach.addFavouritePlayer(player);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            em = this.createEntityManager();
            this.beginTransaction(em);
            coach.addFavouritePlayer(player2);
            em.merge((Object)coach);
            this.commitTransaction(em);
            this.beginTransaction(em);
            player = (HockeyPlayer)em.find(HockeyPlayer.class, (Object)playerId);
            player2 = (HockeyPlayer)em.find(HockeyPlayer.class, (Object)player2Id);
            coach = (HockeyCoach)em.find(HockeyCoach.class, (Object)coachId);
            if (player != null) {
                em.remove((Object)player);
            }
            if (player2 != null) {
                em.remove((Object)player2);
            }
            if (coach != null) {
                em.remove((Object)coach);
            }
            this.commitTransaction(em);
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
    }

    public void testAggregatePrimaryKey() {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        try {
            Name name1 = new Name();
            name1.setFirstName("Tom");
            name1.setLastName("Ware");
            CountryDweller countryDweller = new CountryDweller();
            countryDweller.setAge(30);
            countryDweller.setName(name1);
            CitySlicker citySlicker = new CitySlicker();
            citySlicker.setAge(53);
            Name name1Clone = (Name)name1.clone();
            citySlicker.setName(name1Clone);
            Name name2 = new Name();
            name2.setFirstName("Guy");
            name2.setLastName("Pelletier");
            CountryDweller countryDweller2 = new CountryDweller();
            countryDweller2.setAge(65);
            countryDweller2.setName(name2);
            this.beginTransaction(em);
            em.persist((Object)countryDweller);
            em.persist((Object)countryDweller2);
            em.persist((Object)citySlicker);
            this.commitTransaction(em);
            this.clearCache();
            em.clear();
            this.beginTransaction(em);
            CitySlicker cs = (CitySlicker)em.find(CitySlicker.class, (Object)name1Clone);
            CountryDweller cd = (CountryDweller)em.merge((Object)countryDweller);
            CountryDweller cd2 = (CountryDweller)em.merge((Object)countryDweller2);
            em.remove((Object)cs);
            em.remove((Object)cd);
            em.remove((Object)cd2);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            this.closeEntityManagerAndTransaction(em);
            throw e;
        }
    }

    public void testAggregatePrimaryKeyOrderBy() {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            World world = new World();
            Name name1 = new Name();
            name1.setFirstName("Guy");
            name1.setLastName("Pelletier");
            CountryDweller countryDweller1 = new CountryDweller();
            countryDweller1.setAge(30);
            countryDweller1.setName(name1);
            countryDweller1.setGender("Male");
            em.persist((Object)countryDweller1);
            world.addCountryDweller(countryDweller1);
            CitySlicker citySlicker1 = new CitySlicker();
            citySlicker1.setAge(53);
            Name name1Clone = (Name)name1.clone();
            citySlicker1.setName(name1Clone);
            citySlicker1.setGender("Male");
            em.persist((Object)citySlicker1);
            world.addCitySlicker(citySlicker1);
            Name name2 = new Name();
            name2.setFirstName("Steve");
            name2.setLastName("Harp");
            CountryDweller countryDweller2 = new CountryDweller();
            countryDweller2.setAge(28);
            countryDweller2.setName(name2);
            countryDweller2.setGender("Male");
            em.persist((Object)countryDweller2);
            world.addCountryDweller(countryDweller2);
            CitySlicker citySlicker2 = new CitySlicker();
            citySlicker2.setAge(41);
            Name name2Clone = (Name)name2.clone();
            citySlicker2.setName(name2Clone);
            citySlicker2.setGender("Male");
            em.persist((Object)citySlicker2);
            world.addCitySlicker(citySlicker2);
            Name name3 = new Name();
            name3.setFirstName("Jesse");
            name3.setLastName("Petoncle");
            CountryDweller countryDweller3 = new CountryDweller();
            countryDweller3.setAge(48);
            countryDweller3.setName(name3);
            countryDweller3.setGender("Male");
            em.persist((Object)countryDweller3);
            world.addCountryDweller(countryDweller3);
            CitySlicker citySlicker3 = new CitySlicker();
            citySlicker3.setAge(76);
            Name name3Clone = (Name)name3.clone();
            citySlicker3.setName(name3Clone);
            citySlicker3.setGender("Female");
            em.persist((Object)citySlicker3);
            world.addCitySlicker(citySlicker3);
            em.persist((Object)world);
            this.commitTransaction(em);
            this.clearCache();
            em.clear();
            this.beginTransaction(em);
            World w = (World)em.find(World.class, (Object)world.getId());
            Collection css = w.getCitySlickers();
            css.toString();
            Collection cds = w.getCountryDwellers();
            cds.toString();
            CitySlicker cs1 = (CitySlicker)em.find(CitySlicker.class, (Object)name1Clone);
            em.remove((Object)cs1);
            CitySlicker cs2 = (CitySlicker)em.find(CitySlicker.class, (Object)name2Clone);
            em.remove((Object)cs2);
            CitySlicker cs3 = (CitySlicker)em.find(CitySlicker.class, (Object)name3Clone);
            em.remove((Object)cs3);
            CountryDweller cd1 = (CountryDweller)em.merge((Object)countryDweller1);
            em.remove((Object)cd1);
            CountryDweller cd2 = (CountryDweller)em.merge((Object)countryDweller2);
            em.remove((Object)cd2);
            CountryDweller cd3 = (CountryDweller)em.merge((Object)countryDweller3);
            em.remove((Object)cd3);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            this.closeEntityManagerAndTransaction(em);
            throw e;
        }
    }

    public void testNestedAggregate() {
        int[] teamIDs = new int[3];
        this.clearCache();
        HockeyTeam team1 = new HockeyTeam();
        team1.setName("Axemen");
        team1.setAwayColor("Red");
        team1.setHomeColor("White");
        team1.setLevel("Division 5");
        HockeyTeam team2 = new HockeyTeam();
        team2.setName("Cartier Partners");
        team2.setAwayColor("Black");
        team2.setHomeColor("White");
        team2.setLevel("Division 2");
        HockeyTeam team3 = new HockeyTeam();
        team3.setName("Dead Last");
        team3.setAwayColor("Blue");
        team3.setHomeColor("White");
        team3.setLevel("Division 4");
        HockeyPlayer player1 = new HockeyPlayer();
        player1.setFirstName("Guy");
        player1.setLastName("Pelletier");
        PersonalVitals personalVitals1 = new PersonalVitals();
        personalVitals1.setAge(29);
        personalVitals1.setHeight(1.8);
        personalVitals1.setWeight(180.0);
        TeamVitals teamVitals1 = new TeamVitals();
        teamVitals1.setHockeyTeam(team2);
        team2.getPlayers().add(player1);
        teamVitals1.setJerseyNumber(20);
        teamVitals1.setPosition("Goalie");
        teamVitals1.getRoles().add(new Role("Stop pucks!"));
        Vitals vitals1 = new Vitals();
        vitals1.setPersonalVitals(personalVitals1);
        vitals1.setTeamVitals(teamVitals1);
        player1.setVitals(vitals1);
        HockeyPlayer player2 = new HockeyPlayer();
        player2.setFirstName("Dave");
        player2.setLastName("McCann");
        PersonalVitals personalVitals2 = new PersonalVitals();
        personalVitals2.setAge(35);
        personalVitals2.setHeight(1.77);
        personalVitals2.setWeight(165.0);
        TeamVitals teamVitals2 = new TeamVitals();
        teamVitals2.setHockeyTeam(team1);
        team1.getPlayers().add(player2);
        teamVitals2.setJerseyNumber(70);
        teamVitals2.setPosition("Left wing");
        teamVitals2.getRoles().add(new Role("Power play unit"));
        teamVitals2.getRoles().add(new Role("Face-off specialist"));
        Vitals vitals2 = new Vitals();
        vitals2.setPersonalVitals(personalVitals2);
        vitals2.setTeamVitals(teamVitals2);
        player2.setVitals(vitals2);
        HockeyPlayer player3 = new HockeyPlayer();
        player3.setFirstName("Tom");
        player3.setLastName("Ware");
        PersonalVitals personalVitals3 = new PersonalVitals();
        personalVitals3.setAge(30);
        personalVitals3.setHeight(1.83);
        personalVitals3.setWeight(200.0);
        TeamVitals teamVitals3 = new TeamVitals();
        teamVitals3.setHockeyTeam(team1);
        team1.getPlayers().add(player3);
        teamVitals3.setJerseyNumber(12);
        teamVitals3.setPosition("Defence");
        teamVitals3.getRoles().add(new Role("Penalty kill unit"));
        Vitals vitals3 = new Vitals();
        vitals3.setPersonalVitals(personalVitals3);
        vitals3.setTeamVitals(teamVitals3);
        player3.setVitals(vitals3);
        HockeyPlayer player4 = new HockeyPlayer();
        player4.setFirstName("George");
        player4.setLastName("Robinson");
        PersonalVitals personalVitals4 = new PersonalVitals();
        personalVitals4.setAge(32);
        personalVitals4.setHeight(1.86);
        personalVitals4.setWeight(210.0);
        TeamVitals teamVitals4 = new TeamVitals();
        teamVitals4.setHockeyTeam(team3);
        team3.getPlayers().add(player4);
        teamVitals4.setJerseyNumber(6);
        teamVitals4.setPosition("Center");
        teamVitals4.getRoles().add(new Role("Power play unit"));
        teamVitals4.getRoles().add(new Role("Goon"));
        Vitals vitals4 = new Vitals();
        vitals4.setPersonalVitals(personalVitals4);
        vitals4.setTeamVitals(teamVitals4);
        player4.setVitals(vitals4);
        HockeyPlayer player5 = new HockeyPlayer();
        player5.setFirstName("Andrew");
        player5.setLastName("Glennie");
        PersonalVitals personalVitals5 = new PersonalVitals();
        personalVitals5.setAge(31);
        personalVitals5.setHeight(1.8);
        personalVitals5.setWeight(205.0);
        TeamVitals teamVitals5 = new TeamVitals();
        teamVitals5.setHockeyTeam(team3);
        team3.getPlayers().add(player5);
        teamVitals5.setJerseyNumber(7);
        teamVitals5.setPosition("Right wing");
        Vitals vitals5 = new Vitals();
        vitals5.setPersonalVitals(personalVitals5);
        vitals5.setTeamVitals(teamVitals5);
        player5.setVitals(vitals5);
        HockeyPlayer player6 = new HockeyPlayer();
        player6.setFirstName("David");
        player6.setLastName("Whittaker");
        PersonalVitals personalVitals6 = new PersonalVitals();
        personalVitals6.setAge(32);
        personalVitals6.setHeight(1.83);
        personalVitals6.setWeight(190.0);
        TeamVitals teamVitals6 = new TeamVitals();
        teamVitals6.setHockeyTeam(team2);
        team2.getPlayers().add(player6);
        teamVitals6.setJerseyNumber(17);
        teamVitals6.setPosition("Defence");
        Vitals vitals6 = new Vitals();
        vitals6.setPersonalVitals(personalVitals6);
        vitals6.setTeamVitals(teamVitals6);
        player6.setVitals(vitals6);
        HockeyCoach coach1 = new HockeyCoach();
        coach1.setFirstName("Don");
        coach1.setLastName("Hyslop");
        PersonalVitals coachPersonalVitals1 = new PersonalVitals();
        coachPersonalVitals1.setAge(55);
        coachPersonalVitals1.setHeight(1.85);
        coachPersonalVitals1.setWeight(200.0);
        CoachVitals coachVitals1 = new CoachVitals();
        coachVitals1.setPersonalVitals(coachPersonalVitals1);
        coachVitals1.setHockeyTeam(team1);
        team1.getCoaches().add(coach1);
        coach1.setVitals(coachVitals1);
        HockeyCoach coach2 = new HockeyCoach();
        coach2.setFirstName("Al");
        coach2.setLastName("Montoya");
        PersonalVitals coachPersonalVitals2 = new PersonalVitals();
        coachPersonalVitals2.setAge(63);
        coachPersonalVitals2.setHeight(1.86);
        coachPersonalVitals2.setWeight(213.0);
        CoachVitals coachVitals2 = new CoachVitals();
        coachVitals2.setPersonalVitals(coachPersonalVitals2);
        coachVitals2.setHockeyTeam(team2);
        team2.getCoaches().add(coach2);
        coach2.setVitals(coachVitals2);
        HockeyCoach coach3 = new HockeyCoach();
        coach3.setFirstName("Guy");
        coach3.setLastName("Carbonneau");
        PersonalVitals coachPersonalVitals3 = new PersonalVitals();
        coachPersonalVitals3.setAge(47);
        coachPersonalVitals3.setHeight(1.91);
        coachPersonalVitals3.setWeight(191.0);
        CoachVitals coachVitals3 = new CoachVitals();
        coachVitals3.setPersonalVitals(coachPersonalVitals3);
        coachVitals3.setHockeyTeam(team3);
        team3.getCoaches().add(coach3);
        coach3.setVitals(coachVitals3);
        HockeyCoach coach4 = new HockeyCoach();
        coach4.setFirstName("Walter");
        coach4.setLastName("Mullen");
        PersonalVitals coachPersonalVitals4 = new PersonalVitals();
        coachPersonalVitals4.setAge(67);
        coachPersonalVitals4.setHeight(1.94);
        coachPersonalVitals4.setWeight(187.0);
        CoachVitals coachVitals4 = new CoachVitals();
        coachVitals4.setPersonalVitals(coachPersonalVitals4);
        coachVitals4.setHockeyTeam(team1);
        team1.getCoaches().add(coach4);
        coach4.setVitals(coachVitals4);
        HockeyCoach coach5 = new HockeyCoach();
        coach5.setFirstName("Ben");
        coach5.setLastName("Gasket");
        PersonalVitals coachPersonalVitals5 = new PersonalVitals();
        coachPersonalVitals5.setAge(33);
        coachPersonalVitals5.setHeight(1.67);
        coachPersonalVitals5.setWeight(155.0);
        CoachVitals coachVitals5 = new CoachVitals();
        coachVitals5.setPersonalVitals(coachPersonalVitals5);
        coachVitals5.setHockeyTeam(team2);
        team2.getCoaches().add(coach5);
        coach5.setVitals(coachVitals5);
        HockeyCoach coach6 = new HockeyCoach();
        coach6.setFirstName("Jim");
        coach6.setLastName("Balogna");
        PersonalVitals coachPersonalVitals6 = new PersonalVitals();
        coachPersonalVitals6.setAge(37);
        coachPersonalVitals6.setHeight(1.77);
        coachPersonalVitals6.setWeight(179.0);
        CoachVitals coachVitals6 = new CoachVitals();
        coachVitals6.setPersonalVitals(coachPersonalVitals5);
        coachVitals6.setHockeyTeam(team3);
        team3.getCoaches().add(coach6);
        coach6.setVitals(coachVitals6);
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.persist((Object)team1);
            teamIDs[0] = team1.getId();
            em.persist((Object)team2);
            teamIDs[1] = team2.getId();
            em.persist((Object)team3);
            teamIDs[2] = team3.getId();
            em.persist((Object)player1);
            em.persist((Object)player2);
            em.persist((Object)player3);
            em.persist((Object)player4);
            em.persist((Object)player5);
            em.persist((Object)player6);
            em.persist((Object)coach1);
            em.persist((Object)coach2);
            em.persist((Object)coach3);
            em.persist((Object)coach4);
            em.persist((Object)coach5);
            em.persist((Object)coach6);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            this.closeEntityManagerAndTransaction(em);
            throw ex;
        }
        em = this.createEntityManager();
        this.checkTeam(teamIDs[0], em);
        this.checkTeam(teamIDs[1], em);
        this.checkTeam(teamIDs[2], em);
        this.clearCache();
        em = this.createEntityManager();
        em.clear();
        this.checkTeam(teamIDs[0], em);
        this.checkTeam(teamIDs[1], em);
        this.checkTeam(teamIDs[2], em);
        HockeyTeam team = (HockeyTeam)em.find(HockeyTeam.class, (Object)teamIDs[0]);
        if (((HockeyCoach)team.getCoaches().get(0)).getVitals().getPersonalVitals().getAge() != 67) {
            throw new TestErrorException("The order by specification on age for hockey coaches was not observed: " + team.getCoaches());
        }
    }

    private void checkTeam(int id, EntityManager em) {
        HockeyTeam team = (HockeyTeam)em.find(HockeyTeam.class, (Object)id);
        if (team == null) {
            throw new TestErrorException("Hockey team with ID: " + id + ", was not created.");
        }
        if (team.getPlayers().size() != 2) {
            throw new TestErrorException("Hockey team with ID: " + id + ", did not have 2 players, had: " + team.getPlayers().size());
        }
        if (team.getCoaches().size() != 2) {
            throw new TestErrorException("Hockey team with ID: " + id + ", did not have 2 coach, had: " + team.getCoaches().size());
        }
    }

    public void testNestedAggregatePrimaryKey() {
        Torso torso;
        this.clearCache();
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = this.createEntityManager();
        try {
            Body body = new Body();
            torso = new Torso();
            Heart heart = new Heart();
            heart.setSize(8);
            torso.setHeart(heart);
            body.setTorso(torso);
            this.beginTransaction(em);
            em.persist((Object)body);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            throw new TestErrorException("Exception caught when persisting the new body: " + e.getMessage());
        }
        finally {
            this.closeEntityManager(em);
        }
        em = this.createEntityManager();
        Exception m_testException = null;
        DatabaseSessionImpl m_session = this.getDatabaseSession();
        Body m_refreshedBody = null;
        try {
            em.clear();
            m_session.getIdentityMapAccessor().initializeAllIdentityMaps();
            m_refreshedBody = (Body)em.find(Body.class, (Object)torso);
        }
        catch (Exception e) {
            m_testException = e;
        }
        if (m_testException != null) {
            throw new TestErrorException("Exception caught reading back the persisted body: " + m_testException);
        }
        if (m_refreshedBody == null) {
            throw new TestErrorException("Unable to read back the persisted body");
        }
        ClassDescriptor descriptor = this.getDatabaseSession().getClassDescriptor(Body.class);
        Object pks = descriptor.getObjectBuilder().extractPrimaryKeyFromObject((Object)m_refreshedBody, (AbstractSession)m_session);
        Torso createdTorso = (Torso)descriptor.getCMPPolicy().createPrimaryKeyInstanceFromId(pks, (AbstractSession)m_session);
        ComplexAggregateTestSuite.assertTrue((String)"PK's do not match.", (boolean)m_refreshedBody.getTorso().equals((Object)createdTorso));
        PersistenceUnitUtil util = emf.getPersistenceUnitUtil();
        ComplexAggregateTestSuite.assertTrue((String)"PersistenceUnitUtil returned incorrect identifier", (boolean)torso.equals(util.getIdentifier((Object)m_refreshedBody)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAggregateReadOnlyMapKey() {
        this.clearCache();
        HockeyPlayer player = new HockeyPlayer();
        player.setFirstName("Guy");
        player.setLastName("Flower");
        PersonalVitals personalVitals2 = new PersonalVitals();
        personalVitals2.setAge(45);
        personalVitals2.setHeight(1.8);
        personalVitals2.setWeight(185.0);
        TeamVitals teamVitals2 = new TeamVitals();
        teamVitals2.setJerseyNumber(70);
        teamVitals2.setPosition("Right wing");
        Vitals vitals2 = new Vitals();
        vitals2.setPersonalVitals(personalVitals2);
        vitals2.setTeamVitals(teamVitals2);
        player.setVitals(vitals2);
        HockeyCoach coach = new HockeyCoach();
        coach.setFirstName("Scott");
        coach.setLastName("Arrowman");
        PersonalVitals coachPersonalVitals1 = new PersonalVitals();
        coachPersonalVitals1.setAge(65);
        coachPersonalVitals1.setHeight(1.85);
        coachPersonalVitals1.setWeight(200.0);
        CoachVitals coachVitals1 = new CoachVitals();
        coachVitals1.setPersonalVitals(coachPersonalVitals1);
        coach.setVitals(coachVitals1);
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.persist((Object)player);
            em.persist((Object)coach);
            this.commitTransaction(em);
            Integer playerId = player.getPlayerId();
            Integer coachId = coach.getId();
            this.clearCache();
            em.clear();
            this.beginTransaction(em);
            player = (HockeyPlayer)em.find(HockeyPlayer.class, (Object)player.getPlayerId());
            coach = (HockeyCoach)em.find(HockeyCoach.class, (Object)coach.getId());
            coach.addFavouritePlayer(player);
            this.commitTransaction(em);
            this.beginTransaction(em);
            player = (HockeyPlayer)em.find(HockeyPlayer.class, (Object)playerId);
            coach = (HockeyCoach)em.find(HockeyCoach.class, (Object)coachId);
            if (player != null) {
                em.remove((Object)player);
            }
            if (coach != null) {
                em.remove((Object)coach);
            }
            this.commitTransaction(em);
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComplexAggregateJoin() {
        this.clearCache();
        HockeyTeam team1 = new HockeyTeam();
        team1.setName("Axemen");
        team1.setAwayColor("Red");
        team1.setHomeColor("White");
        team1.setLevel("Division 5");
        HockeyPlayer player1 = new HockeyPlayer();
        player1.setFirstName("Guy");
        player1.setLastName("Pelletier");
        PersonalVitals personalVitals1 = new PersonalVitals();
        personalVitals1.setAge(29);
        personalVitals1.setHeight(1.8);
        personalVitals1.setWeight(180.0);
        TeamVitals teamVitals1 = new TeamVitals();
        teamVitals1.setJerseyNumber(20);
        teamVitals1.setPosition("Goalie");
        teamVitals1.getRoles().add(new Role("Stop pucks!"));
        Vitals vitals1 = new Vitals();
        vitals1.setPersonalVitals(personalVitals1);
        vitals1.setTeamVitals(teamVitals1);
        player1.setVitals(vitals1);
        HockeyCoach coach1 = new HockeyCoach();
        coach1.setFirstName("Don");
        coach1.setLastName("Hyslop");
        PersonalVitals coachPersonalVitals1 = new PersonalVitals();
        coachPersonalVitals1.setAge(55);
        coachPersonalVitals1.setHeight(1.85);
        coachPersonalVitals1.setWeight(200.0);
        CoachVitals coachVitals1 = new CoachVitals();
        coachVitals1.setPersonalVitals(coachPersonalVitals1);
        coach1.setVitals(coachVitals1);
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        em.persist((Object)team1);
        em.persist((Object)player1);
        em.persist((Object)coach1);
        teamVitals1.setHockeyTeam(team1);
        team1.getPlayers().add(player1);
        team1.getCoaches().add(coach1);
        coachVitals1.setHockeyTeam(team1);
        em.flush();
        DatabaseSessionImpl m_session = this.getDatabaseSession();
        List hockeyCoachResults = null;
        ArrayList<HockeyCoach> controledCoachList = null;
        ArrayList<HockeyPlayer> controledPlayerList = null;
        List hockeyPlayerResults = null;
        try {
            em.clear();
            m_session.getIdentityMapAccessor().initializeAllIdentityMaps();
            Query query1 = em.createQuery("Select a from HockeyCoach a where a.id = " + coach1.getId());
            query1.setHint("eclipselink.left-join-fetch", (Object)"a.vitals.hockeyTeam");
            hockeyCoachResults = query1.getResultList();
            em.clear();
            m_session.getIdentityMapAccessor().initializeAllIdentityMaps();
            Query query2 = em.createQuery("Select z from HockeyPlayer z where z.playerId = " + player1.getPlayerId());
            query2.setHint("eclipselink.left-join-fetch", (Object)"z.vitals.teamVitals.hockeyTeam.coaches");
            hockeyPlayerResults = query2.getResultList();
            em.clear();
            m_session.getIdentityMapAccessor().initializeAllIdentityMaps();
            HockeyCoach expectedCoach = (HockeyCoach)em.find(HockeyCoach.class, (Object)coach1.getId());
            expectedCoach.getVitals().getHockeyTeam();
            controledCoachList = new ArrayList<HockeyCoach>(1);
            controledCoachList.add(expectedCoach);
            em.clear();
            m_session.getIdentityMapAccessor().initializeAllIdentityMaps();
            HockeyPlayer expectedPlayer = (HockeyPlayer)em.find(HockeyPlayer.class, (Object)player1.getPlayerId());
            expectedPlayer.getVitals().getTeamVitals().getHockeyTeam().getCoaches().size();
            controledPlayerList = new ArrayList<HockeyPlayer>(1);
            controledPlayerList.add(expectedPlayer);
            em.clear();
            m_session.getIdentityMapAccessor().initializeAllIdentityMaps();
        }
        finally {
            try {
                this.closeEntityManagerAndTransaction(em);
            }
            catch (RuntimeException query1) {}
        }
        String errorMsg = JoinedAttributeTestHelper.compareCollections(controledCoachList, (Collection)hockeyCoachResults, (ClassDescriptor)m_session.getClassDescriptor(HockeyCoach.class), (AbstractSession)m_session);
        if (errorMsg.length() > 0) {
            throw new TestErrorException(errorMsg);
        }
        errorMsg = JoinedAttributeTestHelper.compareCollections(controledPlayerList, (Collection)hockeyPlayerResults, (ClassDescriptor)m_session.getClassDescriptor(HockeyPlayer.class), (AbstractSession)m_session);
        if (errorMsg.length() > 0) {
            throw new TestErrorException(errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComplexAggregateBatch() {
        this.clearCache();
        HockeyTeam team1 = new HockeyTeam();
        team1.setName("Axemen");
        team1.setAwayColor("Red");
        team1.setHomeColor("White");
        team1.setLevel("Division 5");
        HockeyTeam team2 = new HockeyTeam();
        team2.setName("Ducks");
        team2.setAwayColor("Black");
        team2.setHomeColor("Red");
        team2.setLevel("Division 4");
        HockeyPlayer player1 = new HockeyPlayer();
        player1.setFirstName("Guy");
        player1.setLastName("Pelletier");
        PersonalVitals personalVitals1 = new PersonalVitals();
        personalVitals1.setAge(29);
        personalVitals1.setHeight(1.8);
        personalVitals1.setWeight(180.0);
        TeamVitals teamVitals1 = new TeamVitals();
        teamVitals1.setJerseyNumber(20);
        teamVitals1.setPosition("Goalie");
        teamVitals1.getRoles().add(new Role("Stop pucks!"));
        Vitals vitals1 = new Vitals();
        vitals1.setPersonalVitals(personalVitals1);
        vitals1.setTeamVitals(teamVitals1);
        player1.setVitals(vitals1);
        HockeyCoach coach1 = new HockeyCoach();
        coach1.setFirstName("Don");
        coach1.setLastName("Hyslop");
        PersonalVitals coachPersonalVitals1 = new PersonalVitals();
        coachPersonalVitals1.setAge(55);
        coachPersonalVitals1.setHeight(1.85);
        coachPersonalVitals1.setWeight(200.0);
        CoachVitals coachVitals1 = new CoachVitals();
        coachVitals1.setPersonalVitals(coachPersonalVitals1);
        coach1.setVitals(coachVitals1);
        HockeyCoach coach2 = new HockeyCoach();
        coach2.setFirstName("Bob");
        coach2.setLastName("Jones");
        PersonalVitals coachPersonalVitals2 = new PersonalVitals();
        coachPersonalVitals2.setAge(44);
        coachPersonalVitals2.setHeight(1.95);
        coachPersonalVitals2.setWeight(250.0);
        CoachVitals coachVitals2 = new CoachVitals();
        coachVitals2.setPersonalVitals(coachPersonalVitals2);
        coach2.setVitals(coachVitals2);
        DatabaseSessionImpl m_session = this.getDatabaseSession();
        QuerySQLTracker counter = new QuerySQLTracker((Session)m_session);
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        em.persist((Object)team1);
        em.persist((Object)team2);
        em.persist((Object)player1);
        em.persist((Object)coach1);
        em.persist((Object)coach2);
        teamVitals1.setHockeyTeam(team1);
        team1.getPlayers().add(player1);
        team1.getCoaches().add(coach1);
        team2.getCoaches().add(coach2);
        coachVitals1.setHockeyTeam(team1);
        coachVitals2.setHockeyTeam(team2);
        em.flush();
        try {
            counter.getSqlStatements().clear();
            em.clear();
            m_session.getIdentityMapAccessor().initializeAllIdentityMaps();
            Query query1 = em.createQuery("Select a from HockeyCoach a");
            query1.setHint("eclipselink.batch", (Object)"a.vitals.hockeyTeam");
            List hockeyCoachResults = query1.getResultList();
            for (HockeyCoach coach : hockeyCoachResults) {
                coach.getVitals().getHockeyTeam();
            }
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() != 2) {
                ComplexAggregateTestSuite.fail((String)("Should have been 2 queries but was: " + counter.getSqlStatements().size()));
            }
            counter.getSqlStatements().clear();
            em.clear();
            m_session.getIdentityMapAccessor().initializeAllIdentityMaps();
            query1 = em.createQuery("Select a from HockeyCoach a");
            query1.setHint("eclipselink.batch", (Object)"a.vitals.hockeyTeam");
            query1.setHint("eclipselink.batch.type", (Object)BatchFetchType.IN);
            hockeyCoachResults = query1.getResultList();
            for (HockeyCoach coach : hockeyCoachResults) {
                coach.getVitals().getHockeyTeam();
            }
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() != 2) {
                ComplexAggregateTestSuite.fail((String)("Should have been 2 queries but was: " + counter.getSqlStatements().size()));
            }
            em.clear();
            m_session.getIdentityMapAccessor().initializeAllIdentityMaps();
            counter.getSqlStatements().clear();
            query1 = em.createQuery("Select a from HockeyCoach a");
            query1.setHint("eclipselink.batch", (Object)"a.vitals.hockeyTeam");
            query1.setHint("eclipselink.batch.type", (Object)BatchFetchType.EXISTS);
            hockeyCoachResults = query1.getResultList();
            for (HockeyCoach coach : hockeyCoachResults) {
                coach.getVitals().getHockeyTeam();
            }
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() != 2) {
                ComplexAggregateTestSuite.fail((String)("Should have been 2 queries but was: " + counter.getSqlStatements().size()));
            }
            em.clear();
            m_session.getIdentityMapAccessor().initializeAllIdentityMaps();
            Query query2 = em.createQuery("Select z from HockeyPlayer z where z.playerId <> 0");
            query2.setHint("eclipselink.batch", (Object)"z.vitals.teamVitals.hockeyTeam.coaches");
            List hockeyPlayerResults = query2.getResultList();
            for (HockeyPlayer player : hockeyPlayerResults) {
                player.getVitals().getTeamVitals().getHockeyTeam().getCoaches();
            }
            em.clear();
            m_session.getIdentityMapAccessor().initializeAllIdentityMaps();
            query2 = em.createQuery("Select z from HockeyPlayer z where z.playerId <> 0");
            query2.setHint("eclipselink.batch", (Object)"z.vitals.teamVitals.hockeyTeam.coaches");
            query2.setHint("eclipselink.batch.type", (Object)BatchFetchType.IN);
            hockeyPlayerResults = query2.getResultList();
            for (HockeyPlayer player : hockeyPlayerResults) {
                player.getVitals().getTeamVitals().getHockeyTeam().getCoaches();
            }
            em.clear();
            m_session.getIdentityMapAccessor().initializeAllIdentityMaps();
            query2 = em.createQuery("Select z from HockeyPlayer z where z.playerId <> 0");
            query2.setHint("eclipselink.batch", (Object)"z.vitals.teamVitals.hockeyTeam.coaches");
            query2.setHint("eclipselink.batch.type", (Object)BatchFetchType.EXISTS);
            hockeyPlayerResults = query2.getResultList();
            for (HockeyPlayer player : hockeyPlayerResults) {
                player.getVitals().getTeamVitals().getHockeyTeam().getCoaches();
            }
            em.clear();
            m_session.getIdentityMapAccessor().initializeAllIdentityMaps();
        }
        finally {
            try {
                this.closeEntityManagerAndTransaction(em);
            }
            catch (RuntimeException runtimeException) {}
            if (counter != null) {
                counter.remove();
            }
        }
    }

    public void testAggregateFieldAttributeOverrides() {
        this.clearCache();
        DatabaseSessionImpl m_session = this.getDatabaseSession();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Place place = new Place();
        place.setCountryCode("US");
        place.setName("Nowhere");
        place.setAddress1(new Location("12 Main Street", "US"));
        place.setAddress2(new Location("34 Easy Street", "US"));
        em.persist((Object)place);
        em.flush();
        this.rollbackTransaction(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidateAndRefreshEmbeddableParent() {
        if (!this.isWeavingEnabled()) {
            ComplexAggregateTestSuite.warning((String)"Test depends on weaving and change tracking");
            return;
        }
        HockeyPuck puck = null;
        HockeyRink rink = null;
        this.clearCache();
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            puck = new HockeyPuck();
            puck.setId(1);
            puck.setName("MrWraparound");
            puck.getSponsor().setName("ACME Cloud Computing Company, Inc.");
            puck.getSponsor().setSponsorshipValue(1000000);
            em.persist((Object)puck);
            this.commitTransaction(em);
        }
        finally {
            this.closeEntityManager(em);
        }
        em = this.createEntityManager();
        try {
            JpaHelper.getDatabaseSession((EntityManagerFactory)this.getEntityManagerFactory()).getIdentityMapAccessor().invalidateObject((Object)puck.getId(), HockeyPuck.class);
            ComplexAggregateTestSuite.assertFalse((String)"Existing cached HockeyPuck should not be valid", (boolean)JpaHelper.getDatabaseSession((EntityManagerFactory)this.getEntityManagerFactory()).getIdentityMapAccessor().isValid((Object)puck.getId(), HockeyPuck.class));
            this.beginTransaction(em);
            rink = new HockeyRink();
            rink.setId(1);
            em.persist((Object)rink);
            puck = (HockeyPuck)em.createQuery("select object(p) from HockeyPuck p where p.id = " + puck.getId(), HockeyPuck.class).getSingleResult();
            ComplexAggregateTestSuite.assertNotNull((String)"HockeyPuck loaded should not be null", (Object)puck);
            rink.setPuck(puck);
            this.commitTransaction(em);
        }
        finally {
            this.closeEntityManager(em);
        }
        try {
            HockeyPuck cachedPuck = (HockeyPuck)JpaHelper.getDatabaseSession((EntityManagerFactory)this.getEntityManagerFactory()).getIdentityMapAccessor().getFromIdentityMap((Object)puck.getId(), HockeyPuck.class);
            HockeySponsor sponsor = cachedPuck.getSponsor();
            if (sponsor instanceof ChangeTracker) {
                PropertyChangeListener listener = ((ChangeTracker)sponsor)._persistence_getPropertyChangeListener();
                if (listener != null && listener instanceof AttributeChangeListener) {
                    ComplexAggregateTestSuite.assertNull((String)"UnitOfWork referenced in Embeddable referenced by an object in the shared cache", (Object)((AttributeChangeListener)listener).getUnitOfWork());
                }
            } else {
                ComplexAggregateTestSuite.fail((String)"Config error: HockeyPuck/HockeySponsor is not change tracked");
            }
        }
        finally {
            em = this.createEntityManager();
            this.beginTransaction(em);
            if (puck != null && (puck = (HockeyPuck)em.find(HockeyPuck.class, (Object)puck.getId())) != null) {
                em.remove((Object)puck);
            }
            if (rink != null && (rink = (HockeyRink)em.find(HockeyRink.class, (Object)rink.getId())) != null) {
                em.remove((Object)rink);
            }
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
    }
}

