/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa;

import jakarta.persistence.EntityManager;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCaseHelper;

public class CMP3TestModel
extends TestModel {
    public static EntityManager entityManager;
    public static boolean shouldLogoutOnReset;
    protected static Map originalProperties;

    public void setup() {
        CMP3TestModel.setup(this.getSession());
    }

    public static void setup(Session originalSession) {
        DatabaseLogin systemLogin = (DatabaseLogin)originalSession.getDatasourceLogin();
        HashMap<String, Object> currentMap = new HashMap<String, Object>();
        currentMap.put("jakarta.persistence.jdbc.driver", systemLogin.getDriverClassName());
        currentMap.put("jakarta.persistence.jdbc.url", systemLogin.getConnectionString());
        currentMap.put("jakarta.persistence.jdbc.user", systemLogin.getUserName());
        currentMap.put("jakarta.persistence.jdbc.password", systemLogin.getPassword());
        currentMap.put("eclipselink.logging.level", AbstractSessionLog.translateLoggingLevelToString((int)originalSession.getSessionLog().getLevel()));
        currentMap.put("eclipselink.classloader", systemLogin.getClass().getClassLoader());
        currentMap.putAll(JUnitTestCaseHelper.persistencePropertiesTestMap);
        if (!currentMap.equals(JUnitTestCaseHelper.propertiesMap)) {
            originalProperties = JUnitTestCaseHelper.propertiesMap;
            JUnitTestCaseHelper.propertiesMap = currentMap;
            JUnitTestCase.closeEntityManagerFactory((String)"default");
            entityManager = null;
        }
    }

    public void reset() {
        CMP3TestModel.reset(this.getSession());
    }

    public static void reset(Session originalSession) {
        if (shouldLogoutOnReset) {
            JUnitTestCase.closeEntityManagerFactory((String)"default");
            entityManager = null;
        }
        if (originalProperties != null) {
            JUnitTestCaseHelper.propertiesMap = originalProperties;
        }
    }

    public static EntityManager getEntityManager() {
        if (entityManager == null || !entityManager.isOpen()) {
            entityManager = CMP3TestModel.createEntityManager();
        }
        return entityManager;
    }

    public static void closeAndRemoveEntityManager() {
        if (entityManager != null) {
            if (entityManager.isOpen()) {
                entityManager.close();
            }
            entityManager = null;
        }
    }

    public static EntityManager createEntityManager() {
        entityManager = JUnitTestCase.createEntityManager((String)"default");
        return entityManager;
    }

    public static ServerSession getServerSession() {
        return ((EntityManagerImpl)CMP3TestModel.getEntityManager()).getServerSession();
    }

    static {
        shouldLogoutOnReset = true;
    }
}

