/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import jakarta.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.jaxb.WrappedValue;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.sessions.Session;

public class JAXBElementRootConverter
implements XMLConverter {
    private Class declaredType;
    private XMLConverter nestedConverter;

    public JAXBElementRootConverter(Class declaredType) {
        this.declaredType = declaredType;
    }

    public Converter getNestedConverter() {
        return this.nestedConverter;
    }

    public void setNestedConverter(XMLConverter nestedConverter) {
        this.nestedConverter = nestedConverter;
    }

    public void initialize(DatabaseMapping mapping, Session session) {
        if (null != this.nestedConverter) {
            this.nestedConverter.initialize(mapping, session);
        }
    }

    public Object convertDataValueToObjectValue(Object dataValue, Session session) {
        return this.convertDataValueToObjectValue(dataValue, session, null);
    }

    public Object convertDataValueToObjectValue(Object dataValue, Session session, XMLUnmarshaller unmarshaller) {
        if (null != this.nestedConverter) {
            dataValue = this.nestedConverter.convertDataValueToObjectValue(dataValue, session, unmarshaller);
        }
        if (dataValue instanceof JAXBElement) {
            return dataValue;
        }
        if (dataValue instanceof Root) {
            Root root = (Root)dataValue;
            QName name = new QName(root.getNamespaceURI(), root.getLocalName());
            dataValue = root.getObject();
            if (null == dataValue) {
                return this.createJAXBElement(name, Object.class, null);
            }
            return this.createJAXBElement(name, this.declaredType, dataValue);
        }
        return dataValue;
    }

    public Object convertObjectValueToDataValue(Object objectValue, Session session) {
        return this.convertObjectValueToDataValue(objectValue, session, null);
    }

    public Object convertObjectValueToDataValue(Object objectValue, Session session, XMLMarshaller marshaller) {
        ClassDescriptor desc;
        if (null != this.nestedConverter) {
            objectValue = this.nestedConverter.convertObjectValueToDataValue(objectValue, session, marshaller);
        }
        if (objectValue instanceof JAXBElement && ((desc = session.getDescriptor(objectValue)) == null || objectValue instanceof WrappedValue)) {
            JAXBElement element = (JAXBElement)objectValue;
            XMLRoot root = new XMLRoot();
            root.setLocalName(element.getName().getLocalPart());
            root.setNamespaceURI(element.getName().getNamespaceURI());
            root.setObject(element.getValue());
            root.setDeclaredType(element.getDeclaredType());
            root.setNil(element.isNil());
            return root;
        }
        return objectValue;
    }

    public boolean isMutable() {
        return false;
    }

    private JAXBElement createJAXBElement(QName qname, Class theClass, Object value) {
        if (value != null && value instanceof JAXBElement) {
            return (JAXBElement)value;
        }
        if (CoreClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(theClass)) {
            theClass = CoreClassConstants.XML_GREGORIAN_CALENDAR;
        } else if (CoreClassConstants.DURATION.isAssignableFrom(theClass)) {
            theClass = CoreClassConstants.DURATION;
        }
        return new JAXBElement(qname, theClass, value);
    }
}

