/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.utils.rename;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.persistence.utils.rename.PackageRenamer;

public class MigrateTopLinkToEclipseLink {
    private static final String PROPERTIES_FILE = "package-rename.properties";

    public static void main(String[] args) {
        if (args.length < 2 || args.length > 3) {
            System.out.println("Usage: MigrateTopLinkToEclipseLink sourceDir targetDir (propertiesFile)");
        }
        String source = args[0];
        String target = args[1];
        String propertiesFile = PROPERTIES_FILE;
        if (args.length == 3) {
            propertiesFile = args[2];
        }
        new MigrateTopLinkToEclipseLink().migrate(source, target, propertiesFile);
    }

    public void migrate(String source, String target, String propertiesFile) {
        Properties props = this.readProperties(propertiesFile);
        this.clearTargetFolder(target);
        PackageRenamer renamer = new PackageRenamer(source, target, props);
        renamer.run();
    }

    private void clearTargetFolder(String targetFolder) {
        File folder = new File(targetFolder);
        if (folder.exists()) {
            this.removeAllJavaFiles(folder);
        }
    }

    private void removeAllJavaFiles(File folder) {
        File[] contents = folder.listFiles();
        for (int index = 0; contents != null && index < contents.length; ++index) {
            File file = contents[index];
            if (file.isDirectory()) {
                this.removeAllJavaFiles(file);
                continue;
            }
            if (!file.getName().endsWith(".java")) continue;
            file.delete();
        }
    }

    private Properties readProperties(String filename) {
        Properties props = new Properties();
        try {
            FileInputStream in = new FileInputStream(filename);
            props.load(in);
            ((InputStream)in).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Properties file was not found: " + filename);
        }
        catch (IOException ioException) {
            throw new RuntimeException("IO error occurred while reading the properties file:'" + filename + "'" + ioException.getMessage());
        }
        return props;
    }
}

