/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import oracle.kv.impl.param.DurationParameter;

public class ScheduleStart {
    public static long calculateDelay(long configuredIntervalMs, long nowMs) {
        if (configuredIntervalMs < 1000L) {
            return 0L;
        }
        long configuredIntervalSec = configuredIntervalMs / 1000L;
        long time = nowMs / (configuredIntervalSec * 1000L);
        if (nowMs % (configuredIntervalSec * 1000L) > 0L) {
            ++time;
        }
        long nextMs = time * configuredIntervalSec * 1000L;
        return nextMs - nowMs;
    }

    public static Future<?> scheduleAtFixedRate(ScheduledExecutorService executor, DurationParameter configuredDuration, Runnable task, Logger logger) {
        long configuredIntervalMs = configuredDuration.toMillis();
        long nowMs = System.currentTimeMillis();
        long delayMs = ScheduleStart.calculateDelay(configuredIntervalMs, nowMs);
        logger.info("Starting task: interval is " + configuredDuration.asString() + ", delay is " + delayMs + "(ms)");
        return executor.scheduleAtFixedRate(task, delayMs, configuredIntervalMs, TimeUnit.MILLISECONDS);
    }
}

