/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.systables;

import oracle.kv.impl.api.table.TableBuilder;
import oracle.kv.impl.api.table.TableEvolver;
import oracle.kv.impl.systables.SysTableDescriptor;

public class TableStatsPartitionDesc
extends SysTableDescriptor {
    public static final String TABLE_NAME = TableStatsPartitionDesc.makeSystemTableName("TableStatsPartition");
    public static final String COL_NAME_TABLE_NAME = "tableName";
    public static final String COL_NAME_PARTITION_ID = "partitionId";
    public static final String COL_NAME_SHARD_ID = "shardId";
    public static final String COL_NAME_COUNT = "count";
    public static final String COL_NAME_AVG_KEY_SIZE = "avgKeySize";
    public static final String COL_NAME_TABLE_SIZE = "tableSize";
    private static final int TABLE_SIZE_VERSION = 2;
    private static final int TABLE_VERSION = 2;

    TableStatsPartitionDesc() {
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    protected int getCurrentSchemaVersion() {
        return 2;
    }

    @Override
    protected void buildTable(TableBuilder builder) {
        builder.addString(COL_NAME_TABLE_NAME);
        builder.addInteger(COL_NAME_PARTITION_ID);
        builder.addInteger(COL_NAME_SHARD_ID);
        builder.addLong(COL_NAME_COUNT);
        builder.addInteger(COL_NAME_AVG_KEY_SIZE);
        builder.addLong(COL_NAME_TABLE_SIZE);
        builder.primaryKey(COL_NAME_TABLE_NAME, COL_NAME_PARTITION_ID);
        builder.shardKey(COL_NAME_TABLE_NAME, COL_NAME_PARTITION_ID);
    }

    @Override
    protected int evolveTable(TableEvolver ev, int schemaVersion) {
        if (schemaVersion < 2) {
            ev.addLong(COL_NAME_TABLE_SIZE);
            schemaVersion = 2;
        }
        return schemaVersion;
    }
}

