/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.FastExternalizableException;

public class SessionAccessException
extends FastExternalizableException {
    private static final long serialVersionUID = 1L;
    private final boolean isReturnSignal;

    public SessionAccessException(String message) {
        super(message);
        this.isReturnSignal = true;
    }

    public SessionAccessException(Throwable cause, boolean isReturnSignal) {
        super(cause);
        this.isReturnSignal = isReturnSignal;
    }

    public SessionAccessException(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.isReturnSignal = in.readBoolean();
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeBoolean(this.isReturnSignal);
    }

    public boolean getIsReturnSignal() {
        return this.isReturnSignal;
    }
}

