/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep;

import com.sleepycat.je.rep.ReplicatedEnvironmentStats;
import java.io.Serializable;
import java.util.SortedMap;

public class MasterRepNodeStats
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final SortedMap<String, Long> replicaDelayMillisMap;
    private final SortedMap<String, Long> replicaLastCommitTimestampMap;
    private final SortedMap<String, Long> replicaLastCommitVLSNMap;
    private final SortedMap<String, Long> replicaVLSNLagMap;
    private final SortedMap<String, Long> replicaVLSNRateMinuteMap;
    private final long masterLastCommitVLSN;
    private final long masterLastCommitTimestamp;
    private final long masterVLSNRateMinute;

    public static MasterRepNodeStats create(ReplicatedEnvironmentStats stats) {
        return stats != null ? new MasterRepNodeStats(stats) : null;
    }

    private MasterRepNodeStats(ReplicatedEnvironmentStats stats) {
        this.replicaDelayMillisMap = stats.getReplicaDelayMap();
        this.replicaLastCommitTimestampMap = stats.getReplicaLastCommitTimestampMap();
        this.replicaLastCommitVLSNMap = stats.getReplicaLastCommitVLSNMap();
        this.replicaVLSNLagMap = stats.getReplicaVLSNLagMap();
        this.replicaVLSNRateMinuteMap = stats.getReplicaVLSNRateMap();
        this.masterLastCommitVLSN = stats.getLastCommitVLSN();
        this.masterLastCommitTimestamp = stats.getLastCommitTimestamp();
        this.masterVLSNRateMinute = stats.getVLSNRate();
    }

    public SortedMap<String, Long> getReplicaDelayMillisMap() {
        return this.replicaDelayMillisMap;
    }

    public SortedMap<String, Long> getReplicaLastCommitTimestampMap() {
        return this.replicaLastCommitTimestampMap;
    }

    public SortedMap<String, Long> getReplicaLastCommitVLSNMap() {
        return this.replicaLastCommitVLSNMap;
    }

    public SortedMap<String, Long> getReplicaVLSNLagMap() {
        return this.replicaVLSNLagMap;
    }

    public SortedMap<String, Long> getReplicaVLSNRateMinuteMap() {
        return this.replicaVLSNRateMinuteMap;
    }

    public long getMasterLastCommitVLSN() {
        return this.masterLastCommitVLSN;
    }

    public long getMasterLastCommitTimestamp() {
        return this.masterLastCommitTimestamp;
    }

    public double getMasterVLSNRateMinute() {
        return this.masterVLSNRateMinute;
    }

    public Long getReplicaCatchupRate(String replicaName) {
        Long replicaVLSNLag = (Long)this.replicaVLSNLagMap.get(replicaName);
        if (replicaVLSNLag == null) {
            return null;
        }
        if (replicaVLSNLag <= 0L) {
            return 0L;
        }
        Long replicaDelayMillis = (Long)this.replicaDelayMillisMap.get(replicaName);
        if (replicaDelayMillis == null) {
            return null;
        }
        Long replicaVLSNPerMinute = (Long)this.replicaVLSNRateMinuteMap.get(replicaName);
        if (replicaVLSNPerMinute == null) {
            return null;
        }
        double replicaVLSNCatchupPerMinute = replicaVLSNPerMinute - this.masterVLSNRateMinute;
        double replicaCatchupRatioPerMinute = replicaVLSNCatchupPerMinute / (double)replicaVLSNLag.longValue();
        return (long)Math.ceil((double)replicaDelayMillis.longValue() * replicaCatchupRatioPerMinute);
    }

    public Long getReplicaCatchupTimeSecs(String replicaName) {
        Long replicaVLSNLag = (Long)this.replicaVLSNLagMap.get(replicaName);
        if (replicaVLSNLag == null) {
            return null;
        }
        if (replicaVLSNLag <= 0L) {
            return 0L;
        }
        Long replicaDelayMillis = (Long)this.replicaDelayMillisMap.get(replicaName);
        if (replicaDelayMillis == null) {
            return null;
        }
        Long replicaVLSNPerMinute = (Long)this.replicaVLSNRateMinuteMap.get(replicaName);
        if (replicaVLSNPerMinute == null) {
            return null;
        }
        long replicaVLSNCatchupPerMinute = replicaVLSNPerMinute - this.masterVLSNRateMinute;
        if (replicaVLSNCatchupPerMinute == 0L) {
            return Long.MAX_VALUE;
        }
        return (long)Math.ceil(60.0 * (double)replicaVLSNLag.longValue() / (double)replicaVLSNCatchupPerMinute);
    }
}

