/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.collections;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Vector;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.models.collections.MenuItem;
import org.eclipse.persistence.testing.models.collections.Restaurant;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class Menu
implements ChangeTracker {
    private String type;
    public ValueHolderInterface<Collection<MenuItem>> items = new ValueHolder(new Vector());
    private BigDecimal id;
    private ValueHolderInterface<Restaurant> owner = new ValueHolder();
    public PropertyChangeListener listener;

    public Menu() {
    }

    public Menu(String menuType) {
        this();
        this.type = menuType;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this.listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener listener) {
        this.listener = listener;
    }

    public void propertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.listener != null && oldValue != newValue) {
            this.listener.propertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
        }
    }

    public void collectionChange(String propertyName, Collection changedCollection, Object newObject, int changeType, boolean isChangeApplied) {
        if (this.listener != null) {
            this.listener.propertyChange((PropertyChangeEvent)new CollectionChangeEvent((Object)this, propertyName, (Object)changedCollection, newObject, changeType, isChangeApplied));
        }
    }

    protected static Menu example1(Restaurant aRestaurant) {
        Menu instance = new Menu();
        instance.setOwner(aRestaurant);
        instance.setType("dinner");
        LinkedList<MenuItem> items = new LinkedList<MenuItem>();
        items.add(MenuItem.example1(instance));
        items.add(MenuItem.example2(instance));
        items.add(MenuItem.example3(instance));
        instance.setItems(items);
        return instance;
    }

    protected static Menu example2(Restaurant aRestaurant) {
        Menu instance = new Menu();
        instance.setOwner(aRestaurant);
        instance.setType("lunch");
        LinkedList<MenuItem> items = new LinkedList<MenuItem>();
        items.add(MenuItem.example4(instance));
        items.add(MenuItem.example5(instance));
        items.add(MenuItem.example6(instance));
        instance.setItems(items);
        return instance;
    }

    protected static Menu example3(Restaurant aRestaurant) {
        Menu instance = new Menu();
        instance.setOwner(aRestaurant);
        instance.setType("dessert");
        LinkedList<MenuItem> items = new LinkedList<MenuItem>();
        items.add(MenuItem.example7(instance));
        items.add(MenuItem.example8(instance));
        items.add(MenuItem.example9(instance));
        instance.setItems(items);
        return instance;
    }

    protected static Menu example4(Restaurant aRestaurant) {
        Menu instance = new Menu();
        instance.setOwner(aRestaurant);
        instance.setType("dinner");
        LinkedList<MenuItem> items = new LinkedList<MenuItem>();
        items.add(MenuItem.example10(instance));
        items.add(MenuItem.example11(instance));
        items.add(MenuItem.example12(instance));
        instance.setItems(items);
        return instance;
    }

    protected static Menu example5(Restaurant aRestaurant) {
        Menu instance = new Menu();
        instance.setOwner(aRestaurant);
        instance.setType("lunch");
        LinkedList<MenuItem> items = new LinkedList<MenuItem>();
        items.add(MenuItem.example13(instance));
        items.add(MenuItem.example14(instance));
        items.add(MenuItem.example15(instance));
        instance.setItems(items);
        return instance;
    }

    protected static Menu example6(Restaurant aRestaurant) {
        Menu instance = new Menu();
        instance.setOwner(aRestaurant);
        instance.setType("brkf/lnch/dinner");
        LinkedList<MenuItem> items = new LinkedList<MenuItem>();
        items.add(MenuItem.example16(instance));
        instance.setItems(items);
        return instance;
    }

    public BigDecimal getId() {
        return this.id;
    }

    public Collection getItems() {
        return (Collection)this.getItemsHolder().getValue();
    }

    public ValueHolderInterface<Collection<MenuItem>> getItemsHolder() {
        return this.items;
    }

    public String getKey() {
        return new String(this.getType());
    }

    public Restaurant getOwner() {
        return (Restaurant)this.getOwnerHolder().getValue();
    }

    public ValueHolderInterface<Restaurant> getOwnerHolder() {
        return this.owner;
    }

    public String getType() {
        return this.type;
    }

    public void setId(BigDecimal newValue) {
        this.id = newValue;
    }

    public void setItems(Collection<MenuItem> value) {
        this.propertyChange("items", this.getItemsHolder().getValue(), value);
        this.getItemsHolder().setValue(value);
    }

    public void setItemsHolder(ValueHolderInterface<Collection<MenuItem>> newValue) {
        this.items = newValue;
    }

    public void setOwner(ValueHolderInterface<Restaurant> newValue) {
        this.owner = newValue;
    }

    public void setOwner(Restaurant newValue) {
        this.propertyChange("owner", this.getOwnerHolder().getValue(), newValue);
        this.getOwnerHolder().setValue((Object)newValue);
    }

    public void setOwnerHolder(ValueHolderInterface<Restaurant> newValue) {
        this.owner = newValue;
    }

    public void setType(String newValue) {
        this.propertyChange("type", this.type, newValue);
        this.type = newValue;
    }

    public static TableDefinition tableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("COL_MENU");
        definition.addIdentityField("ID", BigDecimal.class, 15);
        definition.addField("TYPE", String.class, 20);
        definition.addField("REST_ID", BigDecimal.class, 15);
        return definition;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(Helper.getShortClassName(this.getClass()) + ": " + this.getType());
        buf.append(Helper.cr());
        if (this.getItems() != null) {
            buf.append("MenuItems: " + Helper.getShortClassName(this.getItems().getClass()));
            buf.append(this.getItems().toString());
            buf.append(Helper.cr());
        }
        return buf.toString();
    }
}

