/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.beanvalidation.dynamic;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.HashMap;
import junit.framework.Test;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.internal.jpa.config.metadata.ReflectiveDynamicClassLoader;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.junit.Assert;

public class BeanValidationDynamicEntityJunitTest
extends JUnitTestCase {
    public BeanValidationDynamicEntityJunitTest() {
    }

    public BeanValidationDynamicEntityJunitTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("BeanValidationDynamicEntityJunitTest");
        if (!JUnitTestCase.isJPA10()) {
            suite.addTest((Test)new BeanValidationDynamicEntityJunitTest("testPersistDynamicEntityWithInvalidData"));
        }
        return suite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPersistDynamicEntityWithInvalidData() {
        ReflectiveDynamicClassLoader dcl = new ReflectiveDynamicClassLoader(Thread.currentThread().getContextClassLoader());
        HashMap<String, ReflectiveDynamicClassLoader> properties = new HashMap<String, ReflectiveDynamicClassLoader>(this.getPersistenceProperties());
        properties.put("eclipselink.classloader", dcl);
        EntityManager em = BeanValidationDynamicEntityJunitTest.createEntityManager((String)"beanvalidation-dynamic", properties);
        EntityManagerFactory entityManagerFactory = em.getEntityManagerFactory();
        JPADynamicHelper helper = new JPADynamicHelper(entityManagerFactory);
        DynamicType empType = helper.getType("DynamicEmployee");
        ClassDescriptor empTypeDescriptor = empType.getDescriptor();
        DynamicEntity employee = (DynamicEntity)empTypeDescriptor.getInstantiationPolicy().buildNewInstance();
        employee.set("name", (Object)"Bob");
        employee.set("surname", (Object)"Smith");
        try {
            this.beginTransaction(em);
            em.persist((Object)employee);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            Assert.fail((String)e.getMessage());
        }
        Integer employeeId = (Integer)employee.get("id");
        BeanValidationDynamicEntityJunitTest.assertTrue((String)"Employee id not set!", (employeeId > 0 ? 1 : 0) != 0);
        DynamicEntity emp = (DynamicEntity)em.find(empType.getJavaClass(), (Object)employeeId);
        emp.set("name", null);
        emp.set("surname", null);
        try {
            this.beginTransaction(em);
            em.flush();
        }
        catch (ConstraintViolationException e) {
            System.out.println("ConstraintException: " + e.getMessage());
            for (ConstraintViolation cv : e.getConstraintViolations()) {
                System.out.println("\t>> " + cv.getPropertyPath() + "::" + cv.getMessage());
            }
            return;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        Assert.fail((String)"ConstraintViolationException not thrown");
    }
}

