/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security;

import java.io.IOException;
import java.util.Collection;

public interface PasswordStore {
    public boolean exists() throws IOException;

    public boolean requiresPassphrase() throws IOException;

    public boolean isValidPassphrase(char[] var1) throws IOException;

    public boolean open(char[] var1) throws IOException;

    public boolean create(char[] var1) throws IOException;

    public Collection<String> getSecretAliases() throws IOException;

    public boolean setSecret(String var1, char[] var2) throws IOException;

    public char[] getSecret(String var1) throws IOException;

    public boolean deleteSecret(String var1) throws IOException;

    public Collection<LoginId> getLogins() throws IOException;

    public boolean setLogin(LoginId var1, char[] var2) throws IOException;

    public LoginId getLoginId(String var1) throws IOException;

    public char[] getLoginSecret(String var1) throws IOException;

    public boolean deleteLogin(String var1) throws IOException;

    public boolean setPassphrase(char[] var1) throws IOException;

    public void save() throws IOException;

    public void discard();

    public static class LoginId {
        private final String database;
        private final String user;

        public LoginId(String database, String user) {
            this.database = database;
            this.user = user;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getUser() {
            return this.user;
        }

        public int hashCode() {
            return this.user.hashCode() + this.database.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != LoginId.class) {
                return false;
            }
            LoginId oLid = (LoginId)o;
            return this.user.equals(oLid.user) && this.database.equals(oLid.database);
        }
    }
}

