/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.util.Vector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;

public class NestedUnitOfWorkMultipleCommitTest
extends WriteObjectTest {
    public Employee unitOfWorkWorkingCopy;
    public Employee nestedUnitOfWorkWorkingCopy;
    public UnitOfWork unitOfWork;
    public UnitOfWork nestedUnitOfWork;

    public NestedUnitOfWorkMultipleCommitTest(Employee originalObject) {
        super((Object)originalObject);
    }

    protected void changeNestedUnitOfWork() {
        this.nestedUnitOfWorkWorkingCopy.setProjects(new Vector());
        this.nestedUnitOfWorkWorkingCopy.addProject((Project)this.nestedUnitOfWork.readObject(SmallProject.class));
        this.nestedUnitOfWorkWorkingCopy.addProject((Project)this.nestedUnitOfWork.readObject(LargeProject.class));
        this.nestedUnitOfWorkWorkingCopy.setResponsibilitiesList(new Vector());
        this.nestedUnitOfWorkWorkingCopy.addResponsibility("does not make cafee");
        this.nestedUnitOfWorkWorkingCopy.addResponsibility("does not buy donuts");
        this.nestedUnitOfWorkWorkingCopy.setAddress(new Address());
        this.nestedUnitOfWorkWorkingCopy.setManager((Employee)this.nestedUnitOfWork.readObject(Employee.class));
    }

    protected void changeNestedUnitOfWorkAgain() {
        this.nestedUnitOfWorkWorkingCopy.setProjects(new Vector());
        this.nestedUnitOfWorkWorkingCopy.addResponsibility("eat not buy donuts");
        this.nestedUnitOfWorkWorkingCopy.setAddress(new Address());
        this.nestedUnitOfWorkWorkingCopy.setManager(null);
    }

    protected void setup() {
        super.setup();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
        this.nestedUnitOfWork = this.unitOfWork.acquireUnitOfWork();
        this.unitOfWorkWorkingCopy = (Employee)this.unitOfWork.registerObject(this.objectToBeWritten);
        this.nestedUnitOfWorkWorkingCopy = (Employee)this.nestedUnitOfWork.registerObject((Object)this.unitOfWorkWorkingCopy);
    }

    protected void test() {
        this.changeNestedUnitOfWork();
        if (!((AbstractSession)this.getSession()).compareObjects(this.originalObject, this.objectToBeWritten)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
        this.nestedUnitOfWork.commitAndResume();
        if (!((AbstractSession)this.getSession()).compareObjects((Object)this.unitOfWorkWorkingCopy, (Object)this.nestedUnitOfWorkWorkingCopy)) {
            throw new TestErrorException("The object in the nested unit of work has not been commited properly to its parent");
        }
        this.changeNestedUnitOfWorkAgain();
        if (!((AbstractSession)this.getSession()).compareObjectsDontMatch((Object)this.unitOfWorkWorkingCopy, (Object)this.nestedUnitOfWorkWorkingCopy)) {
            throw new TestErrorException("The parent session was changed through changing the nested UOW.");
        }
        this.nestedUnitOfWork.commitAndResume();
        if (!((AbstractSession)this.getSession()).compareObjects((Object)this.unitOfWorkWorkingCopy, (Object)this.nestedUnitOfWorkWorkingCopy)) {
            throw new TestErrorException("The object in the nested unit of work has not been commited properly to its parent");
        }
        this.nestedUnitOfWork.release();
    }
}

