/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.inmemory;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;

public class UnitOfWorkConformWithOrderTest
extends AutoVerifyTestCase {
    public UnitOfWorkConformWithOrderTest() {
        this.setDescription("Test that the query maintains order for non changed objects.");
    }

    public void test() {
        ExpressionBuilder phone = new ExpressionBuilder();
        Expression exp = phone.get("areaCode").equal(613);
        ReadAllQuery query = new ReadAllQuery(PhoneNumber.class);
        query.setSelectionCriteria(exp);
        query.conformResultsInUnitOfWork();
        query.addOrdering(phone.get("owner").get("id").descending());
        query.addOrdering(phone.get("type").descending());
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Vector v = (Vector)uow.executeQuery((DatabaseQuery)query);
        Vector v2 = (Vector)uow.executeQuery((DatabaseQuery)query);
        if (!v.equals(v2)) {
            throw new TestErrorException("Order not maintained when conforming:" + v + " != " + v2);
        }
    }
}

