/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.fault;

import oracle.kv.KVVersion;

public class UnknownVersionException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final KVVersion kvVersion = KVVersion.CURRENT_VERSION;
    private final int supportedVersion;
    private final int unknownVersion;
    private final String className;

    public UnknownVersionException(String message, String className, int supportedVersion, int unknownVersion) {
        super(message);
        this.supportedVersion = supportedVersion;
        this.unknownVersion = unknownVersion;
        this.className = className;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + " Class: " + this.className + " KVVersion: " + this.kvVersion.toString() + " Supported version:" + this.supportedVersion + " Unknown version:" + this.unknownVersion;
    }

    public KVVersion getKVVersion() {
        return this.kvVersion;
    }

    public int getUnknownVersion() {
        return this.unknownVersion;
    }

    public int getSupportedVersion() {
        return this.supportedVersion;
    }

    public String getClassName() {
        return this.className;
    }
}

