/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps;

import java.util.Vector;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.employee.EmployeeDeleteTest;
import org.eclipse.persistence.testing.tests.identitymaps.RegisterInIdentityMapTest;

public class DeleteFromIdentityMapTest
extends RegisterInIdentityMapTest {
    protected Object deletionResult;
    protected Object retrievalAttempt;
    protected OptimisticLockingPolicy lockingPolicy;

    public DeleteFromIdentityMapTest(Class mapClass) {
        super(mapClass);
    }

    @Override
    public String getDescription() {
        return "This test verifies an object was properly retrieved from the identity map";
    }

    @Override
    public void setup() {
        super.setup();
        this.beginTransaction();
        this.lockingPolicy = this.getSession().getDescriptor(Employee.class).getOptimisticLockingPolicy();
        this.getSession().getDescriptor(Employee.class).setOptimisticLockingPolicy(null);
        this.getSession().getDescriptor(Employee.class).getQueryManager().setDeleteQuery(null);
        this.getSession().getDescriptor(Employee.class).getQueryManager().setUpdateQuery(null);
    }

    @Override
    public void reset() {
        super.reset();
        this.getSession().getDescriptor(Employee.class).setOptimisticLockingPolicy(this.lockingPolicy);
        this.getSession().getDescriptor(Employee.class).getQueryManager().setDeleteQuery(null);
        this.getSession().getDescriptor(Employee.class).getQueryManager().setUpdateQuery(null);
        this.rollbackTransaction();
    }

    @Override
    public void test() {
        block2: {
            super.test();
            try {
                EmployeeDeleteTest.deleteDependencies(this.getSession(), (Employee)this.employees.lastElement());
                this.getDatabaseSession().deleteObject(this.employees.lastElement());
            }
            catch (OptimisticLockException exception) {
                if (!this.isNoIdentityMap()) break block2;
                throw new TestWarningException("Violated optimistic locking, Should not use Optimistic locking with NoIdentityMap");
            }
        }
    }

    @Override
    public void verifyCacheIdentityMap() {
        Vector cache = (Vector)this.employees.clone();
        cache.setSize(11);
        cache.removeElementAt(0);
        cache.removeElementAt(0);
        this.checkIdentityMap(cache);
    }

    @Override
    public void verifyFullIdentityMap() {
        Vector cache = (Vector)this.employees.clone();
        cache.setSize(this.employees.size() - 1);
        this.checkIdentityMap(cache);
    }
}

