/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionbroker;

import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.remote.rmi.RMIRemoteSessionController;
import org.eclipse.persistence.sessions.remote.rmi.RMIRemoteSessionControllerDispatcher;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.tests.sessionbroker.RMISessionBrokerServerManager;

public class RMIServerManagerController
extends UnicastRemoteObject
implements RMISessionBrokerServerManager {
    protected Session session;
    public Session broker;

    public RMIServerManagerController(Session session) throws RemoteException {
        this.session = session;
    }

    @Override
    public RMIRemoteSessionController createRemoteSessionController() {
        RMIRemoteSessionControllerDispatcher controller = null;
        try {
            controller = new RMIRemoteSessionControllerDispatcher(this.session);
        }
        catch (RemoteException exception) {
            System.out.println("Error in invocation " + exception.toString());
        }
        return controller;
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    public static void start(Session session) {
        RMIServerManagerController manager = null;
        try {
            System.setSecurityManager(new RMISecurityManager());
        }
        catch (Exception exception) {
            System.out.println("Security violation " + exception.toString());
        }
        try {
            LocateRegistry.createRegistry(1099);
        }
        catch (Exception exception) {
            System.out.println("Security violation " + exception.toString());
        }
        try {
            manager = new RMIServerManagerController(session);
        }
        catch (RemoteException exception) {
            throw new TestProblemException(exception.toString());
        }
        try {
            Naming.rebind("SERVER-BROKER-MANAGER", manager);
        }
        catch (Exception exception) {
            throw new TestProblemException(exception.toString());
        }
    }
}

