/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Vector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;

public class RowFetchTest
extends PerformanceComparisonTestCase {
    protected Connection connection;
    protected Number id;
    protected String sql;

    public RowFetchTest() {
        this.setName("Default row fetch vs set row fetch (2, 1 object) PerformanceComparisonTest");
        this.setDescription("Compares the performance between using default and set row fetch, query 1 row, row fetch set to 2.");
        this.addSetRowFetch();
    }

    public void setup() throws Exception {
        this.connection = (Connection)((AbstractSession)this.getSession()).getAccessor().getDatasourceConnection();
        PreparedStatement statement = this.connection.prepareStatement("SELECT EMP_ID FROM EMPLOYEE");
        ResultSet result = statement.executeQuery();
        int size = result.getMetaData().getColumnCount();
        result.next();
        this.id = (Number)result.getObject(1);
        result.close();
        statement.close();
        this.sql = "SELECT * FROM EMPLOYEE where emp_id = " + this.id;
    }

    public void test() throws Exception {
        PreparedStatement statement = this.connection.prepareStatement(this.sql);
        ResultSet result = statement.executeQuery();
        int size = result.getMetaData().getColumnCount();
        Vector rows = new Vector();
        while (result.next()) {
            Vector<Object> row = new Vector<Object>(size);
            for (int column = 1; column <= size; ++column) {
                row.add(result.getObject(column));
            }
            rows.add(row);
        }
        result.close();
        statement.close();
    }

    public void addSetRowFetch() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() throws Exception {
                PreparedStatement statement = RowFetchTest.this.connection.prepareStatement(RowFetchTest.this.sql);
                statement.setFetchSize(2);
                ResultSet result = statement.executeQuery();
                int size = result.getMetaData().getColumnCount();
                Vector rows = new Vector();
                while (result.next()) {
                    Vector<Object> row = new Vector<Object>(size);
                    for (int column = 1; column <= size; ++column) {
                        row.add(result.getObject(column));
                    }
                    rows.add(row);
                }
                result.close();
                statement.close();
            }
        };
        test.setName("SetRowFetchTest");
        this.addTest((TestCase)test);
    }
}

