/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.dynamic;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.sessions.SessionEventListener;

public class QuerySQLTracker
extends SessionEventAdapter {
    private List<QueryResult> queries;

    private QuerySQLTracker(Session session) {
        session.getEventManager().addListener((SessionEventListener)this);
        session.setSessionLog((SessionLog)new SQLTrackingSessionLog(session, this));
        this.reset();
    }

    public static QuerySQLTracker install(Session session) {
        if (session.getSessionLog() instanceof SQLTrackingSessionLog) {
            return ((SQLTrackingSessionLog)session.getSessionLog()).getTracker();
        }
        return new QuerySQLTracker(session);
    }

    public static QuerySQLTracker getTracker(Session session) {
        if (session == null) {
            return null;
        }
        SessionLog sessionLog = session.getSessionLog();
        if (sessionLog instanceof SQLTrackingSessionLog) {
            return ((SQLTrackingSessionLog)sessionLog).getTracker();
        }
        throw new RuntimeException("Could not retireve QuerySQLTracke from session: " + session);
    }

    public void reset() {
        this.queries = new ArrayList<QueryResult>();
    }

    public List<QueryResult> getQueries() {
        return this.queries;
    }

    protected QueryResult getCurrentResult() {
        if (this.getQueries().size() == 0) {
            this.getQueries().add(new QueryResult(null));
        }
        return this.getQueries().get(this.getQueries().size() - 1);
    }

    public int getTotalSQLCalls() {
        int totalSQLCalls = 0;
        for (QueryResult result : this.getQueries()) {
            totalSQLCalls += result.sqlStatements.size();
        }
        return totalSQLCalls;
    }

    public int getTotalSQLCalls(String startsWith) {
        int sqlCalls = 0;
        for (QueryResult result : this.getQueries()) {
            for (String sql : result.sqlStatements) {
                String sub = sql.substring(0, startsWith.length());
                if (!sub.equalsIgnoreCase(startsWith)) continue;
                ++sqlCalls;
            }
        }
        return sqlCalls;
    }

    public int getTotalSQLSELECTCalls() {
        return this.getTotalSQLCalls("SELECT");
    }

    public int getTotalSQLINSERTCalls() {
        return this.getTotalSQLCalls("INSERT");
    }

    public int getTotalSQLUPDATECalls() {
        return this.getTotalSQLCalls("UPDATE");
    }

    public int getTotalSQLDELETECalls() {
        return this.getTotalSQLCalls("DELETE");
    }

    public void preExecuteQuery(SessionEvent event) {
        QueryResult result = new QueryResult(event.getQuery());
        this.getQueries().add(result);
    }

    public void postExecuteQuery(SessionEvent event) {
        if (this.getCurrentResult().query == null) {
            this.getCurrentResult().setQuery(event.getQuery());
        }
        this.getCurrentResult().setResult(event.getResult());
    }

    public void printResults(String prefix) {
        System.out.println(prefix + "-QuerySQLTracker-Queries:");
        int sql = 0;
        for (int index = 0; index < this.getQueries().size(); ++index) {
            QueryResult result = this.getQueries().get(index);
            System.out.println("\t" + (index + 1) + "> " + result);
            for (int sqlNum = 0; sqlNum < result.sqlStatements.size(); ++sqlNum) {
                System.out.println("\t\t" + (index + 1) + "." + (sqlNum + 1) + "-" + ++sql + "> " + (String)result.sqlStatements.get(sqlNum));
            }
        }
        System.out.println(prefix + "-QuerySQLTracker-Queries: " + this.getQueries().size());
        System.out.println(prefix + "-QuerySQLTracker-INSERT: " + this.getTotalSQLINSERTCalls());
        System.out.println(prefix + "-QuerySQLTracker-SELECT: " + this.getTotalSQLSELECTCalls());
        System.out.println(prefix + "-QuerySQLTracker-UPDATE: " + this.getTotalSQLUPDATECalls());
        System.out.println(prefix + "-QuerySQLTracker-DELETE: " + this.getTotalSQLDELETECalls());
    }

    public class SQLTrackingSessionLog
    extends DefaultSessionLog {
        private QuerySQLTracker tracker;
        private SessionLog originalLog;

        protected SQLTrackingSessionLog(Session session, QuerySQLTracker aTracker) {
            this.tracker = aTracker;
            this.originalLog = session.getSessionLog();
            this.setSession(session);
            this.setWriter(this.originalLog.getWriter());
        }

        public QuerySQLTracker getTracker() {
            return this.tracker;
        }

        public synchronized void log(SessionLogEntry entry) {
            if (entry.getNameSpace() != null && entry.getNameSpace().equalsIgnoreCase("sql")) {
                this.getTracker().getCurrentResult().addSQL(entry.getMessage());
            }
            super.log(entry);
        }

        public int getLevel(String category) {
            return this.originalLog.getLevel(category);
        }

        public void setLevel(int level, String category) {
            this.originalLog.setLevel(level, category);
        }

        public int getLevel() {
            return this.originalLog.getLevel();
        }

        public void setLevel(int level) {
            this.originalLog.setLevel(level);
        }

        public boolean shouldPrintConnection() {
            return this.originalLog.shouldPrintConnection();
        }

        public boolean shouldPrintDate() {
            return this.originalLog.shouldPrintDate();
        }

        public boolean shouldPrintSession() {
            return this.originalLog.shouldPrintSession();
        }

        public boolean shouldPrintThread() {
            return this.originalLog.shouldPrintThread();
        }
    }

    protected class QueryResult {
        private DatabaseQuery query;
        private String resultString = null;
        private List<String> sqlStatements = new ArrayList<String>();

        QueryResult(DatabaseQuery q) {
            this.query = q;
        }

        protected void setQuery(DatabaseQuery query) {
            this.query = query;
        }

        protected void setResult(Object queryResult) {
            StringWriter writer = new StringWriter();
            writer.write(Helper.getShortClassName((Object)this.query));
            writer.write("[" + System.identityHashCode(this.query) + "]");
            writer.write(" result = ");
            Object[] result = queryResult;
            if (queryResult instanceof Collection) {
                result = ((Collection)queryResult).toArray();
            }
            if (result == null) {
                writer.write("NONE");
            } else if (result instanceof Object[]) {
                Object[] results = result;
                writer.write("<" + results.length + "> [");
                for (int index = 0; index < results.length; ++index) {
                    if (index > 0) {
                        writer.write(", ");
                    }
                    writer.write(results[index] + "");
                }
                writer.write("]");
                this.resultString = writer.toString();
            } else {
                writer.write(result.toString());
            }
            this.resultString = writer.toString();
        }

        public void addSQL(String sql) {
            this.sqlStatements.add(sql);
        }

        public String toString() {
            if (this.resultString == null) {
                this.setResult(null);
            }
            return this.resultString;
        }
    }
}

