/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.ConformResultsInUnitOfWorkTest;

public class NestedUnitOfWorkQuery
extends ConformResultsInUnitOfWorkTest {
    public UnitOfWork nestedUnitOfWork;
    public Employee employee;

    @Override
    public void buildConformQuery() {
        this.conformedQuery = new ReadAllQuery();
        this.conformedQuery.setReferenceClass(Employee.class);
        this.conformedQuery.conformResultsInUnitOfWork();
    }

    @Override
    public void prepareTest() {
        this.employee = (Employee)this.getSession().readObject(Employee.class);
        this.unitOfWork.registerObject((Object)this.employee);
        this.nestedUnitOfWork = this.unitOfWork.acquireUnitOfWork();
    }

    @Override
    public void test() {
        this.result = this.nestedUnitOfWork.executeQuery((DatabaseQuery)this.conformedQuery);
        this.unitOfWork.release();
    }

    @Override
    public void verify() {
        boolean error = true;
        Enumeration enumtr = ((Vector)this.result).elements();
        while (enumtr.hasMoreElements()) {
            if (((Employee)enumtr.nextElement()).getId() != this.employee.getId()) continue;
            error = false;
        }
        if (error) {
            throw new TestErrorException("The object deleted from unit of work shows up in ReadAllQuery using conformResultsInUnitOfWork().");
        }
    }
}

