/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.exceptions.IntegrityException;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.feature.EmployeeProjectForDatabaseChecking;

public class ShouldCheckDatabaseTest
extends AutoVerifyTestCase {
    public ShouldCheckDatabaseTest() {
        this.setDescription("Test for checking the database tables and fields");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        EmployeeProjectForDatabaseChecking project = new EmployeeProjectForDatabaseChecking();
        project.setDatasourceLogin(this.getSession().getDatasourceLogin());
        DatabaseSessionImpl session = (DatabaseSessionImpl)new Project(this.getSession().getDatasourceLogin()).createDatabaseSession();
        boolean caughtError = false;
        try {
            session.setSessionLog(this.getSession().getSessionLog());
            session.login();
            session.setIntegrityChecker(new IntegrityChecker());
            session.getIntegrityChecker().checkDatabase();
            session.addDescriptors((Project)project);
        }
        catch (IntegrityException integrityException) {
            if (integrityException.getIntegrityChecker().getCaughtExceptions().size() != 5) {
                throw new TestErrorException("" + integrityException.getIntegrityChecker().getCaughtExceptions().size() + "  Not equal to the Number of Exceptions to the expected 5.");
            }
            caughtError = true;
        }
        finally {
            session.logout();
        }
        if (!caughtError) {
            throw new TestErrorException("Test is Failed, no database error ");
        }
    }
}

