/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.environment.deployment.WeldBeanDeploymentArchive;
import org.jboss.weld.environment.deployment.discovery.AbstractDiscoveryStrategy;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveBuilder;
import org.jboss.weld.environment.deployment.discovery.FileSystemBeanArchiveHandler;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.environment.util.Reflections;
import org.jboss.weld.resources.spi.ResourceLoader;

public class ReflectionDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private final AtomicBoolean annotatedDiscoveryProcessed = new AtomicBoolean(false);

    public ReflectionDiscoveryStrategy(ResourceLoader resourceLoader, Bootstrap bootstrap, Set<Class<? extends Annotation>> initialBeanDefiningAnnotations) {
        super(resourceLoader, bootstrap, initialBeanDefiningAnnotations);
        this.registerHandler(new FileSystemBeanArchiveHandler());
    }

    @Override
    protected WeldBeanDeploymentArchive processAnnotatedDiscovery(BeanArchiveBuilder builder) {
        if (this.annotatedDiscoveryProcessed.compareAndSet(false, true)) {
            CommonLogger.LOG.reflectionFallback();
        }
        Iterator<String> classIterator = builder.getClassIterator();
        while (classIterator.hasNext()) {
            String className = classIterator.next();
            Class clazz = Reflections.loadClass(this.resourceLoader, className);
            if (clazz != null && Reflections.hasBeanDefiningAnnotation(clazz, this.initialBeanDefiningAnnotations)) continue;
            classIterator.remove();
        }
        return builder.build();
    }
}

