/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.report.ReportQueryTestCase;

public class ReportQueryAndExistsSubQuery
extends ReportQueryTestCase {
    public ReportQueryAndExistsSubQuery() {
        this.setDescription("ReportQuery and exists subQuery");
    }

    @Override
    protected void buildExpectedResults() {
        Vector employees = this.getSession().readAllObjects(Employee.class);
        Enumeration e = employees.elements();
        while (e.hasMoreElements()) {
            Employee emp = (Employee)e.nextElement();
            Object[] result = new Object[]{emp};
            this.addResult(result, null);
        }
    }

    @Override
    protected void setup() throws Exception {
        if (this.getSession().isRemoteSession()) {
            this.throwWarning("Report queries with objects are not supported on remote session.");
        }
        if (this.getSession().getPlatform().isDerby() || this.getSession().getPlatform().isSybase()) {
            this.throwWarning("Exists with multiple values not supported on " + this.getSession().getPlatform());
        }
        super.setup();
        this.reportQuery = new ReportQuery(Employee.class, new ExpressionBuilder());
        ExpressionBuilder builder = this.reportQuery.getExpressionBuilder();
        this.reportQuery.addAttribute("employee", (Expression)builder);
        ReportQuery innerQuery = new ReportQuery(Employee.class, new ExpressionBuilder());
        innerQuery.addAttribute("phoneNumbers", builder.anyOf("phoneNumbers"));
        Expression exists = builder.exists(innerQuery);
        this.reportQuery.setSelectionCriteria(exists);
    }
}

