/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.threadpool.Work;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.Connection;
import com.sun.corba.ee.spi.transport.ReaderThread;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;

@Transport
public class ReaderThreadImpl
implements ReaderThread,
Work {
    private ORB orb;
    private Connection connection;
    private boolean keepRunning;
    private long enqueueTime;
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;

    public ReaderThreadImpl(ORB orb, Connection connection) {
        this.orb = orb;
        this.connection = connection;
        this.keepRunning = true;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    @Transport
    public synchronized void close() {
        this.keepRunning = false;
    }

    private synchronized boolean isRunning() {
        return this.keepRunning;
    }

    @InfoMethod
    private void display(String msg) {
    }

    @InfoMethod
    private void display(String msg, Object value) {
    }

    @Transport
    public void doWork() {
        while (this.isRunning()) {
            try {
                this.display("Start readerThread cycle", this.connection);
                if (this.connection.read()) {
                    return;
                }
                this.display("End readerThread cycle");
            }
            catch (Throwable t) {
                wrapper.exceptionInReaderThread(t);
                this.display("Exception in read", t);
                this.orb.getTransportManager().getSelector(0).unregisterForEvent(this.getConnection().getEventHandler());
                try {
                    if (!this.isRunning()) continue;
                    this.getConnection().close();
                }
                catch (Exception exc) {
                    wrapper.ioExceptionOnClose(exc);
                }
            }
        }
    }

    public void setEnqueueTime(long timeInMillis) {
        this.enqueueTime = timeInMillis;
    }

    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    public String getName() {
        return "ReaderThread";
    }
}

