/*******************************************************************************
 * Copyright (c) 1998, 2015 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
 ******************************************************************************/
package org.eclipse.persistence.testing.tests.isolatedsession;

import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.*;
import org.eclipse.persistence.descriptors.*;
import org.eclipse.persistence.mappings.*;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;

/**
 * This class was generated by the TopLink project class generator.
 * It stores the meta-data (descriptors) that define the TopLink mappings.
 * @see org.eclipse.persistence.sessions.factories.ProjectClassGenerator
 */
public class IsolatedEmployeeProject extends Project {
    public IsolatedEmployeeProject() {
        setName("IsolatedEmployee");
        applyLogin();

        addDescriptor(buildAddressDescriptor());
        addDescriptor(buildEmployeeDescriptor());
        addDescriptor(buildEmploymentPeriodDescriptor());
        addDescriptor(buildPhoneNumberDescriptor());
        addDescriptor(buildIsolatedChildDescriptor());
        addDescriptor(buildIsolatedParentDescriptor());
        addDescriptor(buildIsolatedBoneClassDescriptor());
        addDescriptor(buildIsolatedDogClassDescriptor());
    }

    public void applyLogin() {
        DatabaseLogin login = new DatabaseLogin();
        setLogin(login);
    }

    public RelationalDescriptor buildAddressDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(org.eclipse.persistence.testing.tests.isolatedsession.IsolatedAddress.class);
        descriptor.addTableName("ISOLATED_ADDRESS");
        descriptor.addPrimaryKeyFieldName("ISOLATED_ADDRESS.ADDRESS_ID");

        // Descriptor properties.
        descriptor.setSequenceNumberFieldName("ADDRESS_ID");
        descriptor.setSequenceNumberName("ADDRESS_SEQ");

        // Query manager.
        descriptor.getQueryManager().checkCacheForDoesExist();

        // Event manager.
        // Mappings.
        DirectToFieldMapping cityMapping = new DirectToFieldMapping();
        cityMapping.setAttributeName("city");
        cityMapping.setFieldName("ISOLATED_ADDRESS.CITY");
        descriptor.addMapping(cityMapping);

        DirectToFieldMapping countryMapping = new DirectToFieldMapping();
        countryMapping.setAttributeName("country");
        countryMapping.setFieldName("ISOLATED_ADDRESS.COUNTRY");
        descriptor.addMapping(countryMapping);

        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("ISOLATED_ADDRESS.ADDRESS_ID");
        descriptor.addMapping(idMapping);

        DirectToFieldMapping postalCodeMapping = new DirectToFieldMapping();
        postalCodeMapping.setAttributeName("postalCode");
        postalCodeMapping.setFieldName("ISOLATED_ADDRESS.P_CODE");
        descriptor.addMapping(postalCodeMapping);

        DirectToFieldMapping provinceMapping = new DirectToFieldMapping();
        provinceMapping.setAttributeName("province");
        provinceMapping.setFieldName("ISOLATED_ADDRESS.PROVINCE");
        descriptor.addMapping(provinceMapping);

        DirectToFieldMapping streetMapping = new DirectToFieldMapping();
        streetMapping.setAttributeName("street");
        streetMapping.setFieldName("ISOLATED_ADDRESS.STREET");
        descriptor.addMapping(streetMapping);

        return descriptor;
    }

    public RelationalDescriptor buildEmployeeDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(org.eclipse.persistence.testing.tests.isolatedsession.IsolatedEmployee.class);
        descriptor.addTableName("ISOLATED_EMPLOYEE");
        descriptor.addTableName("ISOLATED_SALARY");
        descriptor.addPrimaryKeyFieldName("ISOLATED_EMPLOYEE.EMP_ID");

        // Descriptor properties.
        descriptor.setSequenceNumberFieldName("EMP_ID");
        descriptor.setSequenceNumberName("EMP_SEQ");
        VersionLockingPolicy lockingPolicy = new VersionLockingPolicy();
        lockingPolicy.setWriteLockFieldName("VERSION");
        descriptor.setOptimisticLockingPolicy(lockingPolicy);
        descriptor.setIsIsolated(true);
        // Tests depend on uow merge.
        descriptor.setUnitOfWorkCacheIsolationLevel(RelationalDescriptor.ISOLATE_NEW_DATA_AFTER_TRANSACTION);

        // Query manager.
        descriptor.getQueryManager().checkCacheForDoesExist();

        // Event manager.
        // Mappings.
        DirectToFieldMapping firstNameMapping = new DirectToFieldMapping();
        firstNameMapping.setAttributeName("firstName");
        firstNameMapping.setFieldName("ISOLATED_EMPLOYEE.F_NAME");
        firstNameMapping.setNullValue("");
        descriptor.addMapping(firstNameMapping);

        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("ISOLATED_EMPLOYEE.EMP_ID");
        descriptor.addMapping(idMapping);

        DirectToFieldMapping lastNameMapping = new DirectToFieldMapping();
        lastNameMapping.setAttributeName("lastName");
        lastNameMapping.setFieldName("ISOLATED_EMPLOYEE.L_NAME");
        lastNameMapping.setNullValue("");
        descriptor.addMapping(lastNameMapping);

        DirectToFieldMapping salaryMapping = new DirectToFieldMapping();
        salaryMapping.setAttributeName("salary");
        salaryMapping.setFieldName("ISOLATED_SALARY.SALARY");
        descriptor.addMapping(salaryMapping);

        DirectToFieldMapping genderMapping = new DirectToFieldMapping();
        ObjectTypeConverter genderConverter = new ObjectTypeConverter();
        genderMapping.setAttributeName("gender");
        genderMapping.setFieldName("ISOLATED_EMPLOYEE.GENDER");
        genderConverter.addConversionValue("M", "Male");
        genderConverter.addConversionValue("F", "Female");
        genderMapping.setConverter(genderConverter);
        descriptor.addMapping(genderMapping);

        TransformationMapping normalHoursMapping = new TransformationMapping();
        normalHoursMapping.setAttributeName("normalHours");
        normalHoursMapping.setAttributeTransformation("buildNormalHours");
        normalHoursMapping.addFieldTransformation("ISOLATED_EMPLOYEE.START_TIME", "getStartTime");
        normalHoursMapping.addFieldTransformation("ISOLATED_EMPLOYEE.END_TIME", "getEndTime");
        descriptor.addMapping(normalHoursMapping);

        AggregateObjectMapping periodMapping = new AggregateObjectMapping();
        periodMapping.setAttributeName("period");
        periodMapping.setReferenceClass(org.eclipse.persistence.testing.tests.isolatedsession.IsolatedEmploymentPeriod.class);
        periodMapping.setIsNullAllowed(true);
        descriptor.addMapping(periodMapping);

        DirectCollectionMapping responsibilitiesListMapping = new DirectCollectionMapping();
        responsibilitiesListMapping.setAttributeName("responsibilitiesList");
        responsibilitiesListMapping.useBasicIndirection();
        responsibilitiesListMapping.setReferenceTableName("ISOLATED_RESPONS");
        responsibilitiesListMapping.setDirectFieldName("ISOLATED_RESPONS.DESCRIP");
        responsibilitiesListMapping.addReferenceKeyFieldName("ISOLATED_RESPONS.EMP_ID", "ISOLATED_EMPLOYEE.EMP_ID");
        descriptor.addMapping(responsibilitiesListMapping);

        OneToOneMapping addressMapping = new OneToOneMapping();
        addressMapping.setAttributeName("address");
        addressMapping.setReferenceClass(org.eclipse.persistence.testing.tests.isolatedsession.IsolatedAddress.class);
        addressMapping.useBasicIndirection();
        addressMapping.privateOwnedRelationship();
        addressMapping.addForeignKeyFieldName("ISOLATED_EMPLOYEE.ADDR_ID", "ISOLATED_ADDRESS.ADDRESS_ID");
        descriptor.addMapping(addressMapping);

        OneToOneMapping managerMapping = new OneToOneMapping();
        managerMapping.setAttributeName("manager");
        managerMapping.setReferenceClass(IsolatedEmployee.class);
        managerMapping.useBasicIndirection();
        managerMapping.addForeignKeyFieldName("ISOLATED_EMPLOYEE.MANAGER_ID", "ISOLATED_EMPLOYEE.EMP_ID");
        descriptor.addMapping(managerMapping);

        OneToManyMapping managedEmployeesMapping = new OneToManyMapping();
        managedEmployeesMapping.setAttributeName("managedEmployees");
        managedEmployeesMapping.setReferenceClass(IsolatedEmployee.class);
        managedEmployeesMapping.useBasicIndirection();
        managedEmployeesMapping.addTargetForeignKeyFieldName("ISOLATED_EMPLOYEE.MANAGER_ID", "ISOLATED_EMPLOYEE.EMP_ID");
        descriptor.addMapping(managedEmployeesMapping);

        OneToManyMapping phoneNumbersMapping = new OneToManyMapping();
        phoneNumbersMapping.setAttributeName("phoneNumbers");
        phoneNumbersMapping.setReferenceClass(IsolatedPhoneNumber.class);
        phoneNumbersMapping.useBasicIndirection();
        phoneNumbersMapping.privateOwnedRelationship();
        phoneNumbersMapping.addTargetForeignKeyFieldName("ISOLATED_PHONE.EMP_ID", "ISOLATED_EMPLOYEE.EMP_ID");
        descriptor.addMapping(phoneNumbersMapping);

        return descriptor;
    }

    public RelationalDescriptor buildEmploymentPeriodDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.descriptorIsAggregate();
        descriptor.setJavaClass(org.eclipse.persistence.testing.tests.isolatedsession.IsolatedEmploymentPeriod.class);

        // Descriptor properties.
        // Query manager.
        // Event manager.
        // Mappings.
        DirectToFieldMapping endDateMapping = new DirectToFieldMapping();
        endDateMapping.setAttributeName("endDate");
        endDateMapping.setFieldName("END_DATE");
        descriptor.addMapping(endDateMapping);

        DirectToFieldMapping startDateMapping = new DirectToFieldMapping();
        startDateMapping.setAttributeName("startDate");
        startDateMapping.setFieldName("START_DATE");
        descriptor.addMapping(startDateMapping);

        return descriptor;
    }

    public RelationalDescriptor buildPhoneNumberDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(org.eclipse.persistence.testing.tests.isolatedsession.IsolatedPhoneNumber.class);
        descriptor.addTableName("ISOLATED_PHONE");
        descriptor.addPrimaryKeyFieldName("ISOLATED_PHONE.EMP_ID");
        descriptor.addPrimaryKeyFieldName("ISOLATED_PHONE.TYPE");

        // Descriptor properties.
        descriptor.setIsIsolated(true);
        // Tests depend on uow merge.
        descriptor.setUnitOfWorkCacheIsolationLevel(RelationalDescriptor.ISOLATE_NEW_DATA_AFTER_TRANSACTION);

        // Query manager.
        descriptor.getQueryManager().checkCacheForDoesExist();

        // Event manager.
        // Query keys.
        descriptor.addDirectQueryKey("id", "EMP_ID");

        // Mappings.
        DirectToFieldMapping areaCodeMapping = new DirectToFieldMapping();
        areaCodeMapping.setAttributeName("areaCode");
        areaCodeMapping.setFieldName("ISOLATED_PHONE.AREA_CODE");
        descriptor.addMapping(areaCodeMapping);

        DirectToFieldMapping numberMapping = new DirectToFieldMapping();
        numberMapping.setAttributeName("number");
        numberMapping.setFieldName("ISOLATED_PHONE.P_NUMBER");
        descriptor.addMapping(numberMapping);

        DirectToFieldMapping typeMapping = new DirectToFieldMapping();
        typeMapping.setAttributeName("type");
        typeMapping.setFieldName("ISOLATED_PHONE.TYPE");
        descriptor.addMapping(typeMapping);

        OneToOneMapping ownerMapping = new OneToOneMapping();
        ownerMapping.setAttributeName("owner");
        ownerMapping.setReferenceClass(org.eclipse.persistence.testing.tests.isolatedsession.IsolatedEmployee.class);
        ownerMapping.useBasicIndirection();
        ownerMapping.addForeignKeyFieldName("ISOLATED_PHONE.EMP_ID", "ISOLATED_EMPLOYEE.EMP_ID");
        descriptor.addMapping(ownerMapping);

        descriptor.applyAmendmentMethod();
        return descriptor;
    }

    public RelationalDescriptor buildIsolatedParentDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(IsolatedParent.class);
        descriptor.addTableName("ISOLATED_PARENT");
        descriptor.addPrimaryKeyFieldName("ISOLATED_PARENT.ID");

        // ClassDescriptor Properties.
        descriptor.useFullIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteFullIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("ISOLATED_PARENT.ID");
        descriptor.setSequenceNumberName("PARENT_SEQ");
        descriptor.alwaysConformResultsInUnitOfWork(); // IMPORTANT!
        descriptor.setIsIsolated(true);
        descriptor.setAlias("IsolatedParent");
        descriptor.setCacheSynchronizationType(ClassDescriptor.DO_NOT_SEND_CHANGES);

        descriptor.setAmendmentClass(IsolatedParent.class);
        descriptor.setAmendmentMethodName("afterLoad");

        // Query Manager.
        descriptor.getQueryManager().checkCacheForDoesExist();
        // Named Queries.
        // Named Query -- findParentBySerial
        ReadObjectQuery namedQuery0 = new ReadObjectQuery(IsolatedParent.class);
        namedQuery0.setName("findParentBySerial");
        namedQuery0.setShouldBindAllParameters(true);
        ExpressionBuilder expBuilder0 = namedQuery0.getExpressionBuilder();
        namedQuery0.setSelectionCriteria(expBuilder0.get("serial").equal(expBuilder0.getParameter("serial_p")));
        namedQuery0.addArgument("serial_p", java.lang.String.class);
        descriptor.getQueryManager().addQuery("findParentBySerial", namedQuery0);



        // Event Manager.

        // Mappings.
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("ISOLATED_PARENT.ID");
        descriptor.addMapping(idMapping);

        DirectToFieldMapping serialMapping = new DirectToFieldMapping();
        serialMapping.setAttributeName("serial");
        serialMapping.setFieldName("ISOLATED_PARENT.SERIAL");
        descriptor.addMapping(serialMapping);

        OneToManyMapping childrenMapping = new OneToManyMapping();
        childrenMapping.setAttributeName("children");
        childrenMapping.setReferenceClass(IsolatedChild.class);
        childrenMapping.useTransparentCollection();
        childrenMapping.useCollectionClass(org.eclipse.persistence.indirection.IndirectList.class);
        childrenMapping.addTargetForeignKeyFieldName("ISOLATED_CHILD.PARENT_ID", "ISOLATED_PARENT.ID");
        childrenMapping.privateOwnedRelationship();

        descriptor.addMapping(childrenMapping);

        return descriptor;
    }

    public RelationalDescriptor buildIsolatedChildDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(IsolatedChild.class);
        descriptor.addTableName("ISOLATED_CHILD");
        descriptor.addPrimaryKeyFieldName("ISOLATED_CHILD.ID");

        // ClassDescriptor Properties.
        descriptor.useFullIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteFullIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("ISOLATED_CHILD.ID");
        descriptor.setSequenceNumberName("CHILD_SEQ");
        descriptor.alwaysConformResultsInUnitOfWork(); // IMPORTANT!
        descriptor.setIsIsolated(true);
        descriptor.setAlias("IsolatedChild");
        descriptor.setCacheSynchronizationType(ClassDescriptor.DO_NOT_SEND_CHANGES);


        // Query Manager.
        descriptor.getQueryManager().checkCacheForDoesExist();


        // Event Manager.

        // Mappings.
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("ISOLATED_CHILD.ID");
        descriptor.addMapping(idMapping);

        DirectToFieldMapping serialMapping = new DirectToFieldMapping();
        serialMapping.setAttributeName("serial");
        serialMapping.setFieldName("ISOLATED_CHILD.SERIAL");
        descriptor.addMapping(serialMapping);

        DirectToFieldMapping deletedMapping = new DirectToFieldMapping();
        deletedMapping.setAttributeName("deleted");
        deletedMapping.setFieldName("ISOLATED_CHILD.DELETED");
        descriptor.addMapping(deletedMapping);

        OneToOneMapping parentMapping = new OneToOneMapping();
        parentMapping.setAttributeName("parent");
        parentMapping.setReferenceClass(IsolatedParent.class);
        parentMapping.useBasicIndirection();
        parentMapping.addForeignKeyFieldName("ISOLATED_CHILD.PARENT_ID", "ISOLATED_PARENT.ID");
        descriptor.addMapping(parentMapping);

        return descriptor;
    }

    public ClassDescriptor buildIsolatedBoneClassDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(IsolatedBone.class);
        descriptor.addTableName("ISOLATED_BONE");
        descriptor.addPrimaryKeyFieldName("ISOLATED_BONE.ID");

        // ClassDescriptor Properties.
        descriptor.useFullIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteFullIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.alwaysConformResultsInUnitOfWork();
        descriptor.setIsIsolated(true);
        descriptor.setAlias("IsolatedBone");
        descriptor.setCacheSynchronizationType(ClassDescriptor.DO_NOT_SEND_CHANGES);


        // Query Manager.
        descriptor.getQueryManager().checkCacheForDoesExist();


        // Event Manager.

        // Mappings.
        DirectToFieldMapping colorMapping = new DirectToFieldMapping();
        colorMapping.setAttributeName("color");
        colorMapping.setFieldName("ISOLATED_BONE.COLOR");
        descriptor.addMapping(colorMapping);

        DirectToFieldMapping deletedMapping = new DirectToFieldMapping();
        deletedMapping.setAttributeName("deleted");
        deletedMapping.setFieldName("ISOLATED_BONE.DELETED");
        descriptor.addMapping(deletedMapping);

        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("ISOLATED_BONE.ID");
        descriptor.addMapping(idMapping);

        OneToOneMapping ownerMapping = new OneToOneMapping();
        ownerMapping.setAttributeName("owner");
        ownerMapping.setReferenceClass(IsolatedDog.class);
        ownerMapping.useBasicIndirection();
        ownerMapping.addForeignKeyFieldName("ISOLATED_BONE.DOG_ID", "ISOLATED_DOG.ID");
        descriptor.addMapping(ownerMapping);

        return descriptor;
    }

    public ClassDescriptor buildIsolatedDogClassDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(IsolatedDog.class);
        descriptor.addTableName("ISOLATED_DOG");
        descriptor.addPrimaryKeyFieldName("ISOLATED_DOG.ID");

        // ClassDescriptor Properties.
        descriptor.useFullIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteFullIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.alwaysConformResultsInUnitOfWork();
        descriptor.setIsIsolated(true);
        descriptor.setAlias("IsolatedDog");
        descriptor.setAmendmentClass(IsolatedDog.class);
        descriptor.setAmendmentMethodName("afterLoad");
        descriptor.setCacheSynchronizationType(ClassDescriptor.DO_NOT_SEND_CHANGES);


        // Query Manager.
        descriptor.getQueryManager().checkCacheForDoesExist();
        // Named Queries.
        // Named Query -- findIsolatedDogByName
        ReadObjectQuery namedQuery0 = new ReadObjectQuery(IsolatedDog.class);
        namedQuery0.setName("findIsolatedDogByName");
        namedQuery0.setShouldBindAllParameters(true);
        ExpressionBuilder expBuilder0 = namedQuery0.getExpressionBuilder();
        namedQuery0.setSelectionCriteria(expBuilder0.get("name").equal(expBuilder0.getParameter("dogName")));
        namedQuery0.addArgument("dogName", java.lang.String.class);
        descriptor.getQueryManager().addQuery("findIsolatedDogByName", namedQuery0);



        // Event Manager.

        // Mappings.
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("ISOLATED_DOG.ID");
        descriptor.addMapping(idMapping);

        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("ISOLATED_DOG.NAME");
        descriptor.addMapping(nameMapping);

        OneToOneMapping boneMapping = new OneToOneMapping();
        boneMapping.setAttributeName("bone");
        boneMapping.setReferenceClass(IsolatedBone.class);
        boneMapping.useBasicIndirection();
        boneMapping.privateOwnedRelationship();
        boneMapping.addTargetForeignKeyFieldName("ISOLATED_BONE.DOG_ID", "ISOLATED_DOG.ID");
        descriptor.addMapping(boneMapping);

        descriptor.applyAmendmentMethod();
        return descriptor;
    }

}
