/*******************************************************************************
 * Copyright (c) 1998, 2015 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
 ******************************************************************************/
 package org.eclipse.persistence.testing.tests.failover.emulateddriver;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Executor;

public class EmulatedConnection implements Connection {
    protected EmulatedDriver driver;

    protected boolean inFailureState = false;

    public void causeCommError() {
        this.inFailureState = true;
    }

    public boolean isInFailureState() {
        return this.inFailureState;
    }

    public EmulatedConnection(EmulatedDriver driver) {
        this.driver = driver;
    }

    public Statement createStatement() {
        return new EmulatedStatement(this);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) {
        return new EmulatedStatement(this);
    }

    public PreparedStatement prepareStatement(String sql) {
        return new EmulatedStatement(sql, this);
    }

    public Statement createStatement(int resultSetType,
            int resultSetConcurrency, int resultSetHoldability) {
        return new EmulatedStatement(this);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) {
        return new EmulatedStatement(sql, this);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType,
            int resultSetConcurrency) {
        return new EmulatedStatement(sql, this);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType,
            int resultSetConcurrency, int resultSetHoldability) {
        return new EmulatedStatement(sql, this);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) {
        return new EmulatedStatement(sql, this);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) {
        return new EmulatedStatement(sql, this);
    }

    /**
     * Return the rows for the sql.
     */
    public Vector getRows(String sql) {
        Vector rows = (Vector) this.driver.getRows().get(sql);
        if (rows == null) {
            rows = new Vector(0);
        }
        return rows;
    }

    /**
     * Return the rows for the sql.
     */
    public void putRows(String sql, Vector rows) {
        this.driver.getRows().put(sql, rows);
    }

    public CallableStatement prepareCall(String sql) {
        return null;
    }

    public String nativeSQL(String sql) {
        return sql;
    }

    public void setAutoCommit(boolean autoCommit) {
    }

    public boolean getAutoCommit() {
        return false;
    }

    public void commit() {
    }

    public void rollback() {
    }

    public void close() {
    }

    public boolean isClosed() {
        return false;
    }

    public DatabaseMetaData getMetaData() {
        return null;
    }

    public void setReadOnly(boolean readOnly) {
    }

    public boolean isReadOnly() {
        return false;
    }

    public void setCatalog(String catalog) {
    }

    public String getCatalog() {
        return null;
    }

    public void setTransactionIsolation(int level) {
    }

    public int getTransactionIsolation() {
        return 0;
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void clearWarnings() {
    }

    public CallableStatement prepareCall(String sql, int resultSetType,
            int resultSetConcurrency) {
        return null;
    }

    public java.util.Map getTypeMap() {
        return null;
    }

    public void setTypeMap(java.util.Map map) {
    }

    public void setHoldability(int holdability) {
    }

    public int getHoldability() {
        return 0;
    }

    public Savepoint setSavepoint() {
        return null;
    }

    public Savepoint setSavepoint(String name) {
        return null;
    }

    public void rollback(Savepoint savepoint) {
        return;
    }

    public void releaseSavepoint(Savepoint savepoint) {
        return;
    }

    public CallableStatement prepareCall(String sql, int resultSetType,
            int resultSetConcurrency, int resultSetHoldability) {
        return null;
    }

    // 236070: Methods introduced in JDK 1.6
    public Array createArrayOf(String typeName, Object[] elements)  throws SQLException {
        return null;
    }

    public Blob createBlob() throws SQLException {
        return null;
    }

    public Clob createClob() throws SQLException {
        return null;
    }

    public NClob createNClob()  throws SQLException {
        return null;
    }

    public SQLXML createSQLXML()  throws SQLException {
        return null;
    }

    public Struct createStruct(String typeName, Object[] attributes)  throws SQLException {
        return null;
    }

    public Properties getClientInfo()  throws SQLException {
        return null;
    }

    public String getClientInfo(String name)  throws SQLException {
        return null;
    }

    public boolean isValid(int timeout)  throws SQLException {
        return false;
    }

    public void setClientInfo(String name, String value) {
    }

    public void setClientInfo(Properties properties) {
    }

    // From java.sql.Wrapper

    public boolean isWrapperFor(Class<?> iFace) throws SQLException {
        return false;
    }

    public <T> T unwrap(Class<T> iFace) throws SQLException {
        return iFace.cast(this);
    }

    public int getNetworkTimeout(){return 0;}

    public void setNetworkTimeout(Executor executor, int milliseconds){}

    public void abort(Executor executor){}

    public String getSchema(){return null;}

    public void setSchema(String schema){}
}
