/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;

public class MergeDeadIndirectionTest
extends AutoVerifyTestCase {
    public MergeDeadIndirectionTest() {
        this.setDescription("Test the the correct exception is thrown when encountering a dead indirection object in a merge.");
    }

    public void test() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        PhoneNumber detachedPhone = (PhoneNumber)uow.readObject(PhoneNumber.class);
        ((DatabaseValueHolder)detachedPhone.owner).setSession(null);
        uow.release();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        uow = this.getSession().acquireUnitOfWork();
        DescriptorException caughtException = null;
        try {
            uow.deepMergeClone((Object)detachedPhone);
        }
        catch (DescriptorException exception) {
            caughtException = exception;
        }
        if (caughtException == null || caughtException.getErrorCode() != 200) {
            this.throwError("Incorrect exception thrown. " + (Object)((Object)caughtException));
        }
        uow.release();
    }
}

