/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.customsqlstoredprocedures;

import java.util.Vector;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.StoredFunctionCall;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;

public class StoredProcedureTest_Inout_Out_In
extends TestCase {
    DatabaseRecord row;
    int mode;
    boolean useCustomSQL;
    boolean useArgumentNames;
    boolean shouldBindAllParameters;
    Integer in = new Integer(1);
    Integer inout = new Integer(2);
    static final int PROC = 0;
    static final int FUNC = 1;

    public static StoredProcedureTest_Inout_Out_In proc(boolean useArgumentNames, boolean shouldBindAllParameters) {
        return new StoredProcedureTest_Inout_Out_In(0, false, useArgumentNames, shouldBindAllParameters);
    }

    public static StoredProcedureTest_Inout_Out_In procUseCustomSQL(boolean shouldBindAllParameters) {
        return new StoredProcedureTest_Inout_Out_In(0, true, false, shouldBindAllParameters);
    }

    public static StoredProcedureTest_Inout_Out_In func(boolean useArgumentNames, boolean shouldBindAllParameters) {
        return new StoredProcedureTest_Inout_Out_In(1, false, useArgumentNames, shouldBindAllParameters);
    }

    public static StoredProcedureTest_Inout_Out_In funcUseCustomSQL(boolean shouldBindAllParameters) {
        return new StoredProcedureTest_Inout_Out_In(1, true, false, shouldBindAllParameters);
    }

    public StoredProcedureTest_Inout_Out_In(int mode, boolean useCustomSQL, boolean useArgumentNames, boolean shouldBindAllParameters) {
        this.useCustomSQL = useCustomSQL;
        this.useArgumentNames = useArgumentNames;
        this.shouldBindAllParameters = shouldBindAllParameters;
        this.mode = mode;
        if (mode == 0) {
            this.setName(this.getName() + " proc");
        } else if (mode == 1) {
            this.setName(this.getName() + " func");
        }
        if (useCustomSQL) {
            this.setName(this.getName() + " custom");
        } else {
            this.setName(this.getName() + " stored");
            if (mode == 0) {
                this.setName(this.getName() + "Proc ");
            } else if (mode == 1) {
                this.setName(this.getName() + "Func ");
            }
            if (useArgumentNames) {
                this.setName(this.getName() + " named");
            }
        }
        if (shouldBindAllParameters) {
            this.setName(this.getName() + " Bind");
        } else {
            this.setName(this.getName() + " don'tBind");
        }
    }

    public void setup() {
        if (!this.getSession().getPlatform().isOracle()) {
            throw new TestWarningException("This test can only be run in Oracle");
        }
    }

    public void test() {
        SQLCall call = null;
        if (this.useCustomSQL) {
            String str;
            SQLCall sqlCall = null;
            if (this.mode == 0) {
                str = "BEGIN StoredProcedure_InOut_Out_In(####P_INOUT, ###P_OUT, #P_IN); END;";
                sqlCall = new SQLCall(str);
            } else if (this.mode == 1) {
                str = "BEGIN ###RESULT := StoredFunction_InOut_Out_In(####P_INOUT, ###P_OUT, #P_IN); END;";
                sqlCall = new SQLCall(str);
                sqlCall.setCustomSQLArgumentType("RESULT", Integer.class);
            }
            sqlCall.setCustomSQLArgumentType("P_OUT", Integer.class);
            call = sqlCall;
        } else {
            StoredProcedureCall spCall = null;
            if (this.mode == 0) {
                spCall = new StoredProcedureCall();
                spCall.setProcedureName("StoredProcedure_InOut_Out_In");
            } else if (this.mode == 1) {
                StoredFunctionCall sfCall = new StoredFunctionCall();
                sfCall.setProcedureName("StoredFunction_InOut_Out_In");
                sfCall.setResult("RESULT", Integer.class);
                spCall = sfCall;
            }
            if (this.useArgumentNames) {
                spCall.addNamedInOutputArgument("P_INOUT");
                spCall.addNamedOutputArgument("P_OUT", "P_OUT", Integer.class);
                spCall.addNamedArgument("P_IN");
            } else {
                spCall.addUnamedInOutputArgument("P_INOUT");
                spCall.addUnamedOutputArgument("P_OUT", Integer.class);
                spCall.addUnamedArgument("P_IN");
            }
            call = spCall;
        }
        DataReadQuery query = new DataReadQuery();
        query.setShouldBindAllParameters(this.shouldBindAllParameters);
        query.setCall((Call)call);
        query.addArgument("P_IN");
        query.addArgument("P_INOUT");
        Vector<Integer> args = new Vector<Integer>(2);
        args.addElement(this.in);
        args.addElement(this.inout);
        this.row = (DatabaseRecord)((Vector)this.getSession().executeQuery((DatabaseQuery)query, args)).firstElement();
    }

    public void verify() {
        Integer result;
        Integer inoutExpected = this.in;
        Integer outExpected = this.inout;
        Integer inoutReturned = new Integer(((Number)this.row.get("P_INOUT")).intValue());
        Integer outReturned = new Integer(((Number)this.row.get("P_OUT")).intValue());
        if (!((Object)inoutExpected).equals(inoutReturned)) {
            throw new TestErrorException("Invalid value P_INOUT = " + inoutReturned + "; should be " + inoutExpected);
        }
        if (!((Object)outExpected).equals(outReturned)) {
            throw new TestErrorException("Invalid value P_OUT = " + outReturned + "; should be " + outExpected);
        }
        if (this.mode == 1 && !(result = new Integer(((Number)this.row.get("RESULT")).intValue())).equals(outReturned)) {
            throw new TestErrorException("Invalid value RESULT = " + result + "; should be " + outReturned);
        }
    }
}

