/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.relationships;

import javax.persistence.EntityManager;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.virtualattribute.OneToOneVirtualAttributeHolder;
import org.eclipse.persistence.testing.models.jpa.virtualattribute.VirtualAttribute;
import org.eclipse.persistence.testing.models.jpa.virtualattribute.VirtualAttributeTableCreator;

public class VirtualAttributeTestSuite
extends JUnitTestCase {
    protected static int id;

    public VirtualAttributeTestSuite() {
    }

    public VirtualAttributeTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("VirtualAttributeTestSuite");
        suite.addTest((Test)new VirtualAttributeTestSuite("testSetup"));
        suite.addTest((Test)new VirtualAttributeTestSuite("testInsertVirtualAttribute"));
        suite.addTest((Test)new VirtualAttributeTestSuite("testReadVirtualAttribute"));
        suite.addTest((Test)new VirtualAttributeTestSuite("testUpdateVirtualAttribute"));
        suite.addTest((Test)new VirtualAttributeTestSuite("testDeleteVirtualAttribute"));
        return suite;
    }

    public void testSetup() {
        new VirtualAttributeTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    public void testInsertVirtualAttribute() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            OneToOneVirtualAttributeHolder holder = new OneToOneVirtualAttributeHolder();
            VirtualAttribute attribute = new VirtualAttribute();
            attribute.setDescription("virtualAttribute");
            holder.setVirtualAttribute(attribute);
            em.persist((Object)holder);
            em.flush();
            id = holder.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
    }

    public void testReadVirtualAttribute() {
        OneToOneVirtualAttributeHolder holder = (OneToOneVirtualAttributeHolder)this.createEntityManager().find(OneToOneVirtualAttributeHolder.class, (Object)id);
        VirtualAttributeTestSuite.assertNotNull((String)"Object with virtual attributes could not be read.", (Object)holder);
        VirtualAttributeTestSuite.assertNotNull((String)"Object held as a virtual attribute was not read with it's owner", (Object)holder.getVirtualAttribute());
    }

    public void testUpdateVirtualAttribute() {
        OneToOneVirtualAttributeHolder holder = null;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            holder = (OneToOneVirtualAttributeHolder)em.find(OneToOneVirtualAttributeHolder.class, (Object)id);
            VirtualAttribute attribute = new VirtualAttribute();
            attribute.setDescription("virtualAttribute2");
            holder.setVirtualAttribute(attribute);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.clearCache();
        holder = (OneToOneVirtualAttributeHolder)em.find(OneToOneVirtualAttributeHolder.class, (Object)id);
        this.closeEntityManager(em);
        VirtualAttributeTestSuite.assertNotNull((String)"Updated object with virtual attributes could not be read.", (Object)holder);
        VirtualAttributeTestSuite.assertNotNull((String)"Updated object held as a virtual attribute was not read with it's owner", (Object)holder.getVirtualAttribute());
        VirtualAttributeTestSuite.assertTrue((String)"Virtual Attribute Object was not updated.", (boolean)holder.getVirtualAttribute().getDescription().equals("virtualAttribute2"));
    }

    public void testDeleteVirtualAttribute() {
        OneToOneVirtualAttributeHolder holder = null;
        VirtualAttribute attribute = null;
        int attributeId = 0;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            holder = (OneToOneVirtualAttributeHolder)em.find(OneToOneVirtualAttributeHolder.class, (Object)id);
            attribute = holder.getVirtualAttribute();
            attributeId = attribute.getId();
            holder.setVirtualAttribute(null);
            em.remove((Object)attribute);
            em.remove((Object)holder);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        holder = (OneToOneVirtualAttributeHolder)em.find(OneToOneVirtualAttributeHolder.class, (Object)id);
        VirtualAttributeTestSuite.assertNull((String)"Object holding virtual attribute was not properly deleted", (Object)holder);
        attribute = (VirtualAttribute)em.find(VirtualAttribute.class, (Object)attributeId);
        VirtualAttributeTestSuite.assertNull((String)"Virtual Attribute Object was not properly removed.", (Object)attribute);
    }
}

