/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;

public class ReadAllCallWithOrderingTest
extends AutoVerifyTestCase {
    protected int originalObjectsSize;
    protected Object objectsFromDatabase;
    protected Class referenceClass;
    protected Call call;
    protected Expression orderBy;

    public ReadAllCallWithOrderingTest(Class referenceClass, int originalObjectsSize, Call aCall, Expression orderBy) {
        this.setOriginalObjectsSize(originalObjectsSize);
        this.setReferenceClass(referenceClass);
        this.setCall(aCall);
        this.setName("ReadAllCallWithOrderingTest(" + referenceClass.getName() + ")");
        this.setOrderBy(orderBy);
        this.setDescription("The test reads the intended objects from the database through the call, and checks if it was read properly.");
    }

    public Call getCall() {
        return this.call;
    }

    public void setCall(Call aCall) {
        this.call = aCall;
    }

    public Expression getOrderBy() {
        return this.orderBy;
    }

    public int getOriginalObjectsSize() {
        return this.originalObjectsSize;
    }

    public Class getReferenceClass() {
        return this.referenceClass;
    }

    public void setOrderBy(Expression orderBy) {
        this.orderBy = orderBy;
    }

    public void setOriginalObjectsSize(int size) {
        this.originalObjectsSize = size;
    }

    public void setReferenceClass(Class aClass) {
        this.referenceClass = aClass;
    }

    @Override
    protected void setup() {
        if (this.getSession().getLogin().getTableQualifier() != "") {
            throw new TestWarningException("this test can't work with table qualifier set");
        }
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    @Override
    protected void test() {
        ReadAllQuery query = new ReadAllQuery(this.getReferenceClass(), this.getCall());
        query.addOrdering(this.getOrderBy());
        this.objectsFromDatabase = this.getSession().executeQuery((DatabaseQuery)query);
    }

    @Override
    protected void verify() throws Exception {
        if (this.getOriginalObjectsSize() != ((Vector)this.objectsFromDatabase).size()) {
            throw new TestErrorException(((Vector)this.objectsFromDatabase).size() + " objects were read from the database, but originially there were, " + this.getOriginalObjectsSize() + ".");
        }
    }
}

