/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpql;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeTableCreator;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class JPQLSystem
extends TestSystem {
    public JPQLSystem() {
        this.project = this.buildProject();
    }

    public EmployeeProject buildProject() {
        EmployeeProject employeeProject = new EmployeeProject();
        DirectToFieldMapping addressIdMapping = new DirectToFieldMapping();
        addressIdMapping.setAttributeName("addressId");
        addressIdMapping.setFieldName("EMPLOYEE.ADDR_ID");
        addressIdMapping.setGetMethodName("getAddressId");
        addressIdMapping.setSetMethodName("setAddressId");
        addressIdMapping.setIsReadOnly(true);
        employeeProject.getDescriptor(Employee.class).addMapping((DatabaseMapping)addressIdMapping);
        return employeeProject;
    }

    public void addDescriptors(DatabaseSession session) {
        if (this.project == null) {
            this.project = this.buildProject();
        }
        session.addDescriptors(this.project);
    }

    public void createTables(DatabaseSession session) {
        new EmployeeTableCreator().replaceTables(session);
    }

    public DatabaseSession login() {
        DatabaseSession session = this.project.createDatabaseSession();
        session.login();
        return session;
    }

    public static void modifyPhoneDescriptor(ClassDescriptor descriptor) {
        descriptor.addDirectQueryKey("id", "EMP_ID");
        ReadAllQuery query = new ReadAllQuery();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp = builder.get("id").equal(builder.getParameter("ID"));
        query.setReferenceClass(PhoneNumber.class);
        query.setSelectionCriteria(exp.and(builder.get("areaCode").equal((Object)"613")));
        query.addArgument("ID");
        descriptor.getQueryManager().removeQuery("localNumbers");
        descriptor.getQueryManager().addQuery("localNumbers", (DatabaseQuery)query);
    }

    public void populate(DatabaseSession session) {
        EmployeePopulator system = new EmployeePopulator();
        UnitOfWork unitOfWork = session.acquireUnitOfWork();
        system.buildExamples();
        Vector allObjects = new Vector();
        PopulationManager.getDefaultManager().addAllObjectsForClass(Employee.class, allObjects);
        PopulationManager.getDefaultManager().addAllObjectsForAbstractClass(Project.class, (Session)session, allObjects);
        unitOfWork.registerAllObjects(allObjects);
        unitOfWork.commit();
    }
}

