/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.persistence.CacheStoreMode;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.OptimisticLockException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.ProviderUtil;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventAdapter;
import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryDelegate;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MapAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.SingularAttributeImpl;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.PersistenceProvider;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.UnidirectionalOneToManyMapping;
import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.JoinedAttributeTestHelper;
import org.eclipse.persistence.testing.framework.QuerySQLTracker;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Bag;
import org.eclipse.persistence.testing.models.jpa.advanced.BarCode;
import org.eclipse.persistence.testing.models.jpa.advanced.Bill;
import org.eclipse.persistence.testing.models.jpa.advanced.BillAction;
import org.eclipse.persistence.testing.models.jpa.advanced.BillLine;
import org.eclipse.persistence.testing.models.jpa.advanced.BillLineItem;
import org.eclipse.persistence.testing.models.jpa.advanced.Buyer;
import org.eclipse.persistence.testing.models.jpa.advanced.Cost;
import org.eclipse.persistence.testing.models.jpa.advanced.Customer;
import org.eclipse.persistence.testing.models.jpa.advanced.Dealer;
import org.eclipse.persistence.testing.models.jpa.advanced.Department;
import org.eclipse.persistence.testing.models.jpa.advanced.Door;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.advanced.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.advanced.Equipment;
import org.eclipse.persistence.testing.models.jpa.advanced.EquipmentCode;
import org.eclipse.persistence.testing.models.jpa.advanced.GoldBuyer;
import org.eclipse.persistence.testing.models.jpa.advanced.HugeProject;
import org.eclipse.persistence.testing.models.jpa.advanced.Jigsaw;
import org.eclipse.persistence.testing.models.jpa.advanced.JigsawPiece;
import org.eclipse.persistence.testing.models.jpa.advanced.LargeProject;
import org.eclipse.persistence.testing.models.jpa.advanced.Loot;
import org.eclipse.persistence.testing.models.jpa.advanced.OrderedEntityA;
import org.eclipse.persistence.testing.models.jpa.advanced.OrderedEntityZ;
import org.eclipse.persistence.testing.models.jpa.advanced.Oyster;
import org.eclipse.persistence.testing.models.jpa.advanced.Pearl;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.advanced.Product;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.models.jpa.advanced.Quantity;
import org.eclipse.persistence.testing.models.jpa.advanced.Room;
import org.eclipse.persistence.testing.models.jpa.advanced.SmallProject;
import org.eclipse.persistence.testing.models.jpa.advanced.ToDoList;
import org.eclipse.persistence.testing.models.jpa.advanced.Violation;
import org.eclipse.persistence.testing.models.jpa.advanced.ViolationCode;
import org.eclipse.persistence.testing.models.jpa.advanced.additionalcriteria.Bolt;
import org.eclipse.persistence.testing.models.jpa.advanced.additionalcriteria.Eater;
import org.eclipse.persistence.testing.models.jpa.advanced.additionalcriteria.Nut;
import org.eclipse.persistence.testing.models.jpa.advanced.additionalcriteria.Rabbit;
import org.eclipse.persistence.testing.models.jpa.advanced.additionalcriteria.RabbitFoot;
import org.eclipse.persistence.testing.models.jpa.advanced.additionalcriteria.Sandwich;
import org.eclipse.persistence.testing.models.jpa.advanced.additionalcriteria.School;
import org.eclipse.persistence.testing.models.jpa.advanced.additionalcriteria.Student;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.StoredFunctionDefinition;
import org.junit.Assert;

public class AdvancedJPAJunitTest
extends JUnitTestCase {
    private static int empId;
    private static int penelopeId;
    private static int deptId;
    private static int buyerId;
    private static long visa;
    private static long amex;
    private static long diners;
    private static long mastercard;
    private static long rbc;
    private static long scotia;
    private static long td;
    private static long cibc;
    private static String newResponsibility;

    public AdvancedJPAJunitTest() {
    }

    public AdvancedJPAJunitTest(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("AdvancedJPAJunitTest");
        suite.addTest((Test)new AdvancedJPAJunitTest("testSetup"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testRelationshipReadDuringClone"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testExistenceCheckingSetting"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testJoinColumnForeignKeyFieldLength"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testEmployeeFetchWithAlias"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testJoinFetchAnnotation"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testVerifyEmployeeCacheSettings"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testVerifyEmployeeCustomizerSettings"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testUpdateEmployee"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testVerifyUpdatedEmployee"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testCreateNewBuyer"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testVerifyNewBuyer"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testBuyerOptimisticLocking"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testOptimisticLockExceptionOnMerge"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testOptimisticLockExceptionOnMergeWithAssumeExists"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testVersionUpdateForOwnedMappings"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testGiveFredAnObjectTypeConverterChange"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testUpdatePenelopesPhoneNumberStatus"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testRemoveJillWithPrivateOwnedPhoneNumbers"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testCreateNewEquipment"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testAddNewEquipmentToDepartment"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testRemoveDepartmentWithPrivateOwnedEquipment"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testUpdateReadOnlyEquipmentCode"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testNamedStoredProcedureQuery"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testNamedStoredProcedureQueryByIndex"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testNamedStoredProcedureQueryInOut"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testNamedStoredProcedureQueryWithRawData"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testModifyNamedStoredProcedureQueryWithRawData"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testNamedStoredProcedureQueryWithResultSetMapping"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testNamedStoredProcedureQueryWithResultSetFieldMapping"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testNamedFunction"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testNonTriggerLazyForSProc"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testMethodBasedTransformationMapping"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testClassBasedTransformationMapping"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testTransformationMappingWithColumnAnnotation"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testCursorStream"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testProperty"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testBackpointerOnMerge"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testUnidirectionalPersist"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testUnidirectionalUpdate"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testUnidirectionalFetchJoin"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testUnidirectionalTargetLocking_AddRemoveTarget"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testUnidirectionalTargetLocking_DeleteSource"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testMapBuildReferencesPKList"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testListBuildReferencesPKList"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testValuePKListMissingElement"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testEnumeratedPrimaryKeys"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testAttributeOverrideToMultipleSameDefaultColumnName"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testJoinFetchWithRefreshOnRelatedEntity"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testSharedEmbeddedAttributeOverrides"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testTransparentIndirectionValueHolderSessionReset"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testTransparentIndirectionQuerySessionReset"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testEmployeeToProjectWithBatchFetchTypeInReverseIteration"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testEmployeeToProjectWithBatchFetchTypeInCustomIteration"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testEmployeeToProjectWithBatchFetchTypeInRandomIteration"));
        if (!AdvancedJPAJunitTest.isJPA10()) {
            suite.addTest((Test)new AdvancedJPAJunitTest("testQueryGetParameter"));
            suite.addTest((Test)new AdvancedJPAJunitTest("testAdditionalCriteriaModelPopulate"));
            suite.addTest((Test)new AdvancedJPAJunitTest("testAdditionalCriteria"));
            suite.addTest((Test)new AdvancedJPAJunitTest("testAdditionalCriteriaWithParameterFromEM1"));
            suite.addTest((Test)new AdvancedJPAJunitTest("testAdditionalCriteriaWithParameterFromEM2"));
            suite.addTest((Test)new AdvancedJPAJunitTest("testAdditionalCriteriaWithParameterFromEMF"));
            suite.addTest((Test)new AdvancedJPAJunitTest("testComplexAdditionalCriteria"));
            suite.addTest((Test)new AdvancedJPAJunitTest("testAdditionalCriteriaBetweenEntities"));
            suite.addTest((Test)new AdvancedJPAJunitTest("testAdditionalCriteriaWithSubQuery"));
            suite.addTest((Test)new AdvancedJPAJunitTest("testMetamodelMinimalSanityTest"));
            suite.addTest((Test)new AdvancedJPAJunitTest("testProjectToEmployeeWithBatchFetchJoinFetch"));
            suite.addTest((Test)new AdvancedJPAJunitTest("testEmployeeToPhoneNumberWithBatchFetchJoinFetch"));
            suite.addTest((Test)new AdvancedJPAJunitTest("testEmployeeToAddressWithBatchFetchJoinFetch"));
            suite.addTest((Test)new AdvancedJPAJunitTest("testHistoryRelationshipQueryInitialization"));
            suite.addTest((Test)new AdvancedJPAJunitTest("testQueryJoinBasicCollectionTableUsingQueryResultsCache"));
            suite.addTest((Test)new AdvancedJPAJunitTest("testNullValueInCollectionWithOrderColumn"));
            suite.addTest((Test)new AdvancedJPAJunitTest("testJoinWithOrderByOnElementCollectionList"));
            suite.addTest((Test)new AdvancedJPAJunitTest("testJoinWithOrderByOnElementCollectionMap"));
        }
        return suite;
    }

    public void testSetup() {
        ServerSession session = JUnitTestCase.getServerSession();
        new AdvancedTableCreator().replaceTables((DatabaseSession)session);
        ClassDescriptor descriptor = session.getDescriptor(EquipmentCode.class);
        boolean shouldBeReadOnly = descriptor.shouldBeReadOnly();
        descriptor.setShouldBeReadOnly(false);
        EmployeePopulator employeePopulator = new EmployeePopulator();
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)session);
        descriptor.setShouldBeReadOnly(shouldBeReadOnly);
        this.clearCache();
        if (this.supportsStoredFunctions()) {
            SchemaManager schema = new SchemaManager((DatabaseSessionImpl)session);
            schema.replaceObject((DatabaseObjectDefinition)this.buildStoredFunction());
        }
    }

    public StoredFunctionDefinition buildStoredFunction() {
        StoredFunctionDefinition func = new StoredFunctionDefinition();
        func.setName("StoredFunction_In");
        func.addArgument("P_IN", Long.class);
        func.setReturnType(Long.class);
        func.addStatement("RETURN P_IN * 1000");
        return func;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNamedFunction() {
        if (!this.supportsStoredFunctions()) {
            AdvancedJPAJunitTest.warning((String)"this test is not suitable for running on dbs that don't support stored function");
            return;
        }
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createNamedQuery("StoredFunction_In");
            query.setParameter("P_IN", (Object)1);
            int result = (Integer)query.getSingleResult();
            if (result != 1000) {
                AdvancedJPAJunitTest.fail((String)("Incorrect result returned:" + result));
            }
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testQueryGetParameter() {
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("select e from Employee e where e.salary = :sal").setParameter("sal", (Object)1000);
            query.getParameter("sal");
        }
        catch (Exception e) {
            AdvancedJPAJunitTest.fail((String)("Get parameter on test failed: " + e));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testAdditionalCriteriaModelPopulate() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            School school1 = new School();
            school1.setName("Ottawa Junior High");
            school1.addStudent(new Student("OttawaJRStud1"));
            school1.addStudent(new Student("OttawaJRStud2"));
            school1.addStudent(new Student("OttawaJRStud3"));
            em.persist((Object)school1);
            School school2 = new School();
            school2.setName("Ottawa Senior High");
            school2.addStudent(new Student("OttawaSRStud1"));
            school2.addStudent(new Student("OttawaSRStud2"));
            school2.addStudent(new Student("OttawaSRStud3"));
            school2.addStudent(new Student("OttawaSRStud4"));
            school2.addStudent(new Student("OttawaSRStud5"));
            em.persist((Object)school2);
            School school3 = new School();
            school3.setName("Toronto Junior High");
            school3.addStudent(new Student("TorontoJRStud1"));
            school3.addStudent(new Student("TorontoJRStud2"));
            school3.addStudent(new Student("TorontoJRStud3"));
            school3.addStudent(new Student("TorontoJRStud4"));
            school3.addStudent(new Student("TorontoJRStud5"));
            school3.addStudent(new Student("TorontoJRStud6"));
            school3.addStudent(new Student("TorontoJRStud7"));
            em.persist((Object)school3);
            School school4 = new School();
            school4.setName("Toronto Senior High");
            school4.addStudent(new Student("TorontoSRStud1"));
            school4.addStudent(new Student("TorontoSRStud2"));
            school4.addStudent(new Student("TorontoSRStud3"));
            school4.addStudent(new Student("TorontoSRStud4"));
            school4.addStudent(new Student("TorontoSRStud5"));
            school4.addStudent(new Student("TorontoSRStud6"));
            school4.addStudent(new Student("TorontoSRStud7"));
            school4.addStudent(new Student("TorontoSRStud8"));
            school4.addStudent(new Student("TorontoSRStud9"));
            school4.addStudent(new Student("TorontoSRStud10"));
            school4.addStudent(new Student("TorontoSRStud11"));
            em.persist((Object)school4);
            School school5 = new School();
            school5.setName("Montreal Senior High");
            school5.addStudent(new Student("MontrealSRStud1"));
            school5.addStudent(new Student("MontrealSRStud2"));
            school5.addStudent(new Student("MontrealSRStud3"));
            school5.addStudent(new Student("MontrealSRStud4"));
            school5.addStudent(new Student("MontrealSRStud5"));
            em.persist((Object)school5);
            Bolt bolt1 = new Bolt();
            Nut nut1 = new Nut();
            nut1.setColor("Grey");
            nut1.setSize(Integer.valueOf(8));
            bolt1.setNut(nut1);
            em.persist((Object)bolt1);
            Bolt bolt2 = new Bolt();
            Nut nut2 = new Nut();
            nut2.setColor("Black");
            nut2.setSize(Integer.valueOf(8));
            bolt2.setNut(nut2);
            em.persist((Object)bolt2);
            Bolt bolt3 = new Bolt();
            Nut nut3 = new Nut();
            nut3.setColor("Grey");
            nut3.setSize(Integer.valueOf(6));
            bolt3.setNut(nut3);
            em.persist((Object)bolt3);
            Bolt bolt4 = new Bolt();
            Nut nut4 = new Nut();
            nut4.setColor("Black");
            nut4.setSize(Integer.valueOf(6));
            bolt4.setNut(nut4);
            em.persist((Object)bolt4);
            Bolt bolt5 = new Bolt();
            Nut nut5 = new Nut();
            nut5.setColor("Grey");
            nut5.setSize(Integer.valueOf(2));
            bolt5.setNut(nut5);
            em.persist((Object)bolt5);
            Bolt bolt6 = new Bolt();
            Nut nut6 = new Nut();
            nut6.setColor("Grey");
            nut6.setSize(Integer.valueOf(8));
            bolt6.setNut(nut6);
            em.persist((Object)bolt6);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testAdditionalCriteria() {
        EntityManager em = this.createEntityManager();
        try {
            List schools = em.createNamedQuery("findJPQLSchools").getResultList();
            AdvancedJPAJunitTest.assertTrue((String)("Incorrect number of schools were returned [" + schools.size() + "], expected [2]"), (schools.size() == 2 ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testAdditionalCriteriaWithParameterFromEM1() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.setProperty("NAME", (Object)"Ottawa%");
            List students = em.createQuery("SELECT s from Student s").getResultList();
            AdvancedJPAJunitTest.assertTrue((String)("Incorrect number of students were returned [" + students.size() + "], expected [8]"), (students.size() == 8 ? 1 : 0) != 0);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testAdditionalCriteriaWithParameterFromEM2() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.setProperty("NAME", (Object)"Toronto%");
            List students = em.createQuery("SELECT s from Student s").getResultList();
            AdvancedJPAJunitTest.assertTrue((String)("Incorrect number of students were returned [" + students.size() + "], expected [18]"), (students.size() == 18 ? 1 : 0) != 0);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testMapBuildReferencesPKList() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        AbstractSession session = (AbstractSession)JpaHelper.getEntityManager((EntityManager)em).getActiveSession();
        ClassDescriptor descriptor = session.getDescriptorForAlias("ADV_DEPT");
        Department dept = (Department)em.createQuery("SELECT d FROM ADV_DEPT d WHERE d.equipment IS NOT EMPTY").getResultList().get(0);
        ForeignReferenceMapping mapping = (ForeignReferenceMapping)descriptor.getMappingForAttributeName("equipment");
        Object[] pks = mapping.buildReferencesPKList((Object)dept, mapping.getAttributeValueFromObject((Object)dept), session);
        AdvancedJPAJunitTest.assertTrue((String)("PK list is of incorrect size.  pks.size: " + pks.length + " expected: " + dept.getEquipment().size() * 2), (pks.length == dept.getEquipment().size() * 2 ? 1 : 0) != 0);
        Map equipments = (Map)mapping.valueFromPKList(pks, null, session);
        AdvancedJPAJunitTest.assertTrue((String)"ValueFromPKList returned list of different size from actual entity.", (equipments.size() == dept.getEquipment().size() ? 1 : 0) != 0);
        for (Equipment equip : dept.getEquipment().values()) {
            AdvancedJPAJunitTest.assertTrue((String)"Equipment not found in ValueFromPKList list", (boolean)equipments.containsKey(equip.getId()));
        }
        this.rollbackTransaction(em);
    }

    public void testListBuildReferencesPKList() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Jigsaw jigsaw = new Jigsaw();
        for (int i = 1; i < 11; ++i) {
            jigsaw.addPiece(new JigsawPiece(i));
        }
        em.persist((Object)jigsaw);
        em.flush();
        this.clearCache();
        AbstractSession session = (AbstractSession)JpaHelper.getEntityManager((EntityManager)em).getActiveSession();
        ClassDescriptor descriptor = session.getDescriptorForAlias("Jigsaw");
        Jigsaw foundJigsaw = (Jigsaw)em.find(Jigsaw.class, (Object)jigsaw.getId());
        int expectedNumber = foundJigsaw.getPieces().size();
        ForeignReferenceMapping mapping = (ForeignReferenceMapping)descriptor.getMappingForAttributeName("pieces");
        Object[] pks = mapping.buildReferencesPKList((Object)foundJigsaw, mapping.getAttributeValueFromObject((Object)foundJigsaw), session);
        AdvancedJPAJunitTest.assertEquals((String)"PK list is of incorrect size", (int)expectedNumber, (int)pks.length);
        List elements = (List)mapping.valueFromPKList(pks, null, session);
        AdvancedJPAJunitTest.assertEquals((String)"ValueFromPKList returned list of different size from actual entity.", (int)expectedNumber, (int)elements.size());
        for (JigsawPiece element : elements) {
            AdvancedJPAJunitTest.assertTrue((String)("Entity id " + element.getId() + " not found in ValueFromPKList list"), (boolean)foundJigsaw.getPieces().contains(element));
        }
        elements = (List)mapping.valueFromPKList(pks, null, session);
        AdvancedJPAJunitTest.assertEquals((String)"ValueFromPKList returned list of different size from actual entity.", (int)expectedNumber, (int)elements.size());
        for (JigsawPiece element : elements) {
            AdvancedJPAJunitTest.assertTrue((String)("Entity id " + element.getId() + " not found in ValueFromPKList list"), (boolean)foundJigsaw.getPieces().contains(element));
        }
        this.rollbackTransaction(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValuePKListMissingElement() {
        if (this.isOnServer()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Jigsaw jigsaw = new Jigsaw();
        for (int i = 1; i < 11; ++i) {
            jigsaw.addPiece(new JigsawPiece(i));
        }
        em.persist((Object)jigsaw);
        this.commitTransaction(em);
        try {
            AbstractSession session = (AbstractSession)JpaHelper.getEntityManager((EntityManager)em).getActiveSession();
            ClassDescriptor descriptor = session.getDescriptorForAlias("Jigsaw");
            Jigsaw foundJigsaw = (Jigsaw)em.find(Jigsaw.class, (Object)jigsaw.getId());
            int expectedNumber = foundJigsaw.getPieces().size();
            OneToManyMapping mapping = (OneToManyMapping)descriptor.getMappingForAttributeName("pieces");
            Object[] pks = mapping.buildReferencesPKList((Object)foundJigsaw, mapping.getAttributeValueFromObject((Object)foundJigsaw), session);
            AdvancedJPAJunitTest.assertEquals((String)"PK list is of incorrect size", (int)expectedNumber, (int)pks.length);
            session.getIdentityMapAccessor().invalidateObject(foundJigsaw.getPieces().get(2));
            DatabaseRecord fks = new DatabaseRecord();
            for (DatabaseField field : mapping.getSourceKeyFields()) {
                fks.add(field, descriptor.getObjectBuilder().extractValueFromObjectForField((Object)foundJigsaw, field, session));
            }
            mapping.writeFromObjectIntoRow((Object)foundJigsaw, (AbstractRecord)fks, session, DatabaseMapping.WriteType.UNDEFINED);
            List elements = (List)mapping.valueFromPKList(pks, (AbstractRecord)fks, session);
            AdvancedJPAJunitTest.assertEquals((String)"ValueFromPKList returned list of different size from actual entity.", (int)expectedNumber, (int)elements.size());
            AdvancedJPAJunitTest.assertFalse((String)"Collection contains unexpected null", (boolean)elements.contains(null));
            for (JigsawPiece element : elements) {
                AdvancedJPAJunitTest.assertTrue((String)("Entity id " + element.getId() + " not found in ValueFromPKList list"), (boolean)foundJigsaw.getPieces().contains(element));
            }
            em.refresh(foundJigsaw.getPieces().get(2));
            session.getIdentityMapAccessor().invalidateObject(foundJigsaw.getPieces().get(5));
            elements = (List)mapping.valueFromPKList(pks, (AbstractRecord)fks, session);
            AdvancedJPAJunitTest.assertEquals((String)"ValueFromPKList returned list of different size from actual entity.", (int)expectedNumber, (int)elements.size());
            AdvancedJPAJunitTest.assertFalse((String)"Collection contains unexpected null", (boolean)elements.contains(null));
            for (JigsawPiece element : elements) {
                AdvancedJPAJunitTest.assertTrue((String)("Entity id " + element.getId() + " not found in ValueFromPKList list"), (boolean)foundJigsaw.getPieces().contains(element));
            }
        }
        catch (Throwable throwable) {
            try {
                this.beginTransaction(em);
                em.remove((Object)jigsaw);
                this.commitTransaction(em);
            }
            catch (Exception exception) {
            }
            finally {
                this.closeEntityManager(em);
            }
            throw throwable;
        }
        try {
            this.beginTransaction(em);
            em.remove((Object)jigsaw);
            this.commitTransaction(em);
        }
        catch (Exception exception) {
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testAdditionalCriteriaWithParameterFromEMF() {
        EntityManager em = this.createEntityManager();
        try {
            List students = em.createQuery("SELECT s from Student s").getResultList();
            AdvancedJPAJunitTest.assertTrue((String)("Incorrect number of students were returned [" + students.size() + "], expected [5]"), (students.size() == 5 ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testComplexAdditionalCriteria() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.setProperty("NUT_SIZE", (Object)8);
            em.setProperty("NUT_COLOR", (Object)"Grey");
            List bolts = em.createQuery("SELECT b from Bolt b").getResultList();
            AdvancedJPAJunitTest.assertTrue((String)("Incorrect number of bolts were returned [" + bolts.size() + "], expected [2]"), (bolts.size() == 2 ? 1 : 0) != 0);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testAdditionalCriteriaBetweenEntities() {
        EntityManager em = AdvancedJPAJunitTest.createEntityManager((String)"additional-criteria");
        try {
            this.beginTransaction(em);
            em.setProperty("SANDWICH_DESCRIPTION", (Object)"%hot%");
            em.setProperty("EATER_NAME", (Object)"%Glutton%");
            Sandwich sandwich = new Sandwich();
            sandwich.setName("The Inferno");
            sandwich.setDescription("A hot and spicy crazy concoction");
            em.persist((Object)sandwich);
            Eater eater = new Eater();
            eater.setName("Glutton for spicy");
            eater.setSandwhich(sandwich);
            em.persist((Object)eater);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testAdditionalCriteriaWithSubQuery() {
        EntityManager em = AdvancedJPAJunitTest.createEntityManager((String)"additional-criteria");
        try {
            this.beginTransaction(em);
            Rabbit rabbit = new Rabbit();
            rabbit.setName("Bugs");
            em.persist((Object)rabbit);
            RabbitFoot rabbitFoot = new RabbitFoot();
            rabbitFoot.setCaption("Caption of Bugs");
            rabbitFoot.setRabbitId(rabbit.getId());
            em.persist((Object)rabbitFoot);
            this.commitTransaction(em);
            em.clear();
            AdvancedJPAJunitTest.clearCache((String)"additional-criteria");
            List list = em.createQuery("select this from Rabbit this").getResultList();
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testAttributeOverrideToMultipleSameDefaultColumnName() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Loot loot = new Loot();
            Bag bag = new Bag();
            Quantity quantity = new Quantity();
            quantity.value = 11;
            bag.quantity = quantity;
            Cost cost = new Cost();
            cost.value = 5.99;
            bag.cost = cost;
            loot.bag = bag;
            em.persist((Object)loot);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testMetamodelMinimalSanityTest() {
        Metamodel metamodel;
        EntityType entityLargeProject;
        Set declaredAttributes;
        EntityManager em = this.createEntityManager();
        if (!this.isOnServer()) {
            ((EntityManagerFactoryDelegate)((EntityManagerImpl)em).getEntityManagerFactory()).setMetamodel(null);
        }
        AdvancedJPAJunitTest.assertTrue(((declaredAttributes = (entityLargeProject = (metamodel = em.getMetamodel()).entity(LargeProject.class)).getDeclaredAttributes()).size() > 0 ? 1 : 0) != 0);
        Attribute budgetAttribute = entityLargeProject.getDeclaredAttribute("budget");
        AdvancedJPAJunitTest.assertNotNull((Object)budgetAttribute);
        SingularAttribute budgetSingularAttribute = entityLargeProject.getDeclaredSingularAttribute("budget");
        AdvancedJPAJunitTest.assertNotNull((Object)budgetSingularAttribute);
        AdvancedJPAJunitTest.assertEquals((Object)budgetSingularAttribute, (Object)budgetAttribute);
        AdvancedJPAJunitTest.assertTrue((boolean)declaredAttributes.contains(budgetSingularAttribute));
        Class budgetClass = budgetSingularAttribute.getJavaType();
        AdvancedJPAJunitTest.assertEquals(Double.TYPE, (Object)budgetClass);
        EntityType entityBuyer = metamodel.entity(Buyer.class);
        AdvancedJPAJunitTest.assertNotNull((Object)entityBuyer);
        AdvancedJPAJunitTest.assertEquals((Object)Type.PersistenceType.ENTITY, (Object)entityBuyer.getPersistenceType());
        AdvancedJPAJunitTest.assertEquals(Buyer.class, (Object)entityBuyer.getJavaType());
        Attribute buyingDaysAttribute = entityBuyer.getAttribute("buyingDays");
        AdvancedJPAJunitTest.assertNotNull((Object)buyingDaysAttribute);
        AdvancedJPAJunitTest.assertEquals((Object)Attribute.PersistentAttributeType.BASIC, (Object)buyingDaysAttribute.getPersistentAttributeType());
        AdvancedJPAJunitTest.assertFalse((boolean)((SingularAttributeImpl)buyingDaysAttribute).isPlural());
        Bindable.BindableType buyingDaysElementBindableType = ((SingularAttributeImpl)buyingDaysAttribute).getBindableType();
        AdvancedJPAJunitTest.assertEquals((Object)Bindable.BindableType.SINGULAR_ATTRIBUTE, (Object)buyingDaysElementBindableType);
        SingularAttribute buyingDaysSingularAttribute = entityBuyer.getSingularAttribute("buyingDays", EnumSet.class);
        AdvancedJPAJunitTest.assertNotNull((Object)buyingDaysSingularAttribute);
        AdvancedJPAJunitTest.assertFalse((boolean)buyingDaysSingularAttribute.isCollection());
        boolean expectedIAExceptionThrown = false;
        boolean hasSingleIdAttribute = false;
        try {
            hasSingleIdAttribute = entityBuyer.hasSingleIdAttribute();
        }
        catch (IllegalArgumentException iae) {
            expectedIAExceptionThrown = true;
        }
        AdvancedJPAJunitTest.assertFalse((boolean)expectedIAExceptionThrown);
        AdvancedJPAJunitTest.assertTrue((boolean)hasSingleIdAttribute);
        Attribute buyerCreditCards = entityBuyer.getAttribute("creditCards");
        AdvancedJPAJunitTest.assertNotNull((Object)buyerCreditCards);
        AdvancedJPAJunitTest.assertTrue((boolean)buyerCreditCards.isCollection());
        AdvancedJPAJunitTest.assertTrue((boolean)(buyerCreditCards instanceof MapAttributeImpl));
        MapAttribute buyerCreditCardsMap = entityBuyer.getMap("creditCards");
        AdvancedJPAJunitTest.assertNotNull((Object)buyerCreditCardsMap);
        AdvancedJPAJunitTest.assertEquals((Object)entityBuyer, (Object)buyerCreditCardsMap.getDeclaringType());
        AdvancedJPAJunitTest.assertEquals(String.class, (Object)buyerCreditCardsMap.getKeyJavaType());
        AdvancedJPAJunitTest.assertEquals(Long.class, (Object)buyerCreditCardsMap.getElementType().getJavaType());
    }

    public void testExistenceCheckingSetting() {
        ServerSession session = JUnitTestCase.getServerSession();
        ClassDescriptor employeeDescriptor = session.getDescriptor(Employee.class);
        AdvancedJPAJunitTest.assertTrue((String)"Employee existence checking was incorrect", (employeeDescriptor.getQueryManager().getDoesExistQuery().getExistencePolicy() == 4 ? 1 : 0) != 0);
        ClassDescriptor projectDescriptor = session.getDescriptor(Project.class);
        AdvancedJPAJunitTest.assertTrue((String)"Project existence checking was incorrect", (projectDescriptor.getQueryManager().getDoesExistQuery().getExistencePolicy() == 3 ? 1 : 0) != 0);
        ClassDescriptor smallProjectDescriptor = session.getDescriptor(SmallProject.class);
        AdvancedJPAJunitTest.assertTrue((String)"SmallProject existence checking was incorrect", (smallProjectDescriptor.getQueryManager().getDoesExistQuery().getExistencePolicy() == 2 ? 1 : 0) != 0);
        ClassDescriptor largeProjectDescriptor = session.getDescriptor(LargeProject.class);
        AdvancedJPAJunitTest.assertTrue((String)"LargeProject existence checking was incorrect", (largeProjectDescriptor.getQueryManager().getDoesExistQuery().getExistencePolicy() == 1 ? 1 : 0) != 0);
    }

    public void testJoinColumnForeignKeyFieldLength() {
        DatabaseField foreignKey;
        DatabaseField primaryKey;
        int i;
        DatabaseField pkField;
        ServerSession session = JUnitTestCase.getServerSession();
        ClassDescriptor employeeDescriptor = session.getDescriptor(Employee.class);
        ClassDescriptor buyerDescriptor = session.getDescriptor(Buyer.class);
        DatabaseTable secondaryTable = employeeDescriptor.getTable("CMP3_SALARY");
        Map keys = (Map)employeeDescriptor.getAdditionalTablePrimaryKeyFields().get(secondaryTable);
        for (Object pkField2 : keys.keySet()) {
            DatabaseField fkField = (DatabaseField)keys.get(pkField2);
            AdvancedJPAJunitTest.assertTrue((String)("The secondary table foreign field [" + fkField.getName() + "(" + fkField.getLength() + ")] did not have the same length as the primary key field [" + pkField2.getName() + "(" + pkField2.getLength() + ")]"), (fkField.getLength() == pkField2.getLength() ? 1 : 0) != 0);
        }
        DatabaseMapping mapping = employeeDescriptor.getMappingForAttributeName("address");
        AdvancedJPAJunitTest.assertNotNull((String)"The address mapping from Employee was not found", (Object)mapping);
        AdvancedJPAJunitTest.assertTrue((String)"The address mapping is no longer a one to one mapping", (boolean)mapping.isOneToOneMapping());
        keys = ((OneToOneMapping)mapping).getSourceToTargetKeyFields();
        for (DatabaseField fkField : keys.keySet()) {
            pkField = (DatabaseField)keys.get(fkField);
            AdvancedJPAJunitTest.assertTrue((String)("The address mapping foreign field [" + fkField.getName() + "(" + fkField.getLength() + ")] did not have the same length as the primary key field [" + pkField.getName() + "(" + pkField.getLength() + ")]"), (fkField.getLength() == pkField.getLength() ? 1 : 0) != 0);
        }
        mapping = employeeDescriptor.getMappingForAttributeName("dealers");
        AdvancedJPAJunitTest.assertNotNull((String)"The dealers mapping from Employee was not found", (Object)mapping);
        AdvancedJPAJunitTest.assertTrue((String)"The dealers mapping is no longer a unidirectional one to many mapping", (boolean)mapping.isUnidirectionalOneToManyMapping());
        keys = ((UnidirectionalOneToManyMapping)mapping).getTargetForeignKeysToSourceKeys();
        for (DatabaseField fkField : keys.keySet()) {
            pkField = (DatabaseField)keys.get(fkField);
            AdvancedJPAJunitTest.assertTrue((String)("The dealers mapping foreign key field [" + fkField.getName() + "(" + fkField.getLength() + ")] did not have the same length as the primary key field [" + pkField.getName() + "(" + pkField.getLength() + ")]"), (fkField.getLength() == pkField.getLength() ? 1 : 0) != 0);
        }
        mapping = employeeDescriptor.getMappingForAttributeName("projects");
        AdvancedJPAJunitTest.assertNotNull((String)"The projects mapping from Employee was not found", (Object)mapping);
        AdvancedJPAJunitTest.assertTrue((String)"The projects mapping is no longer a many to many mapping", (boolean)mapping.isManyToManyMapping());
        Vector sourceKeys = ((ManyToManyMapping)mapping).getSourceKeyFields();
        Vector sourceRelationKeys = ((ManyToManyMapping)mapping).getSourceRelationKeyFields();
        for (int i2 = 0; i2 < sourceKeys.size(); ++i2) {
            DatabaseField sourcePrimaryKey = (DatabaseField)sourceKeys.get(i2);
            DatabaseField sourceRelationForeignKey = (DatabaseField)sourceRelationKeys.get(i2);
            AdvancedJPAJunitTest.assertTrue((String)("The projects mapping source relation foreign key field [" + sourceRelationForeignKey.getName() + "(" + sourceRelationForeignKey.getLength() + ")] did not have the same length as the source primary key field [" + sourcePrimaryKey.getName() + "(" + sourcePrimaryKey.getLength() + ")]"), (sourcePrimaryKey.getLength() == sourceRelationForeignKey.getLength() ? 1 : 0) != 0);
        }
        Vector targetKeys = ((ManyToManyMapping)mapping).getSourceKeyFields();
        Vector targetRelationKeys = ((ManyToManyMapping)mapping).getSourceRelationKeyFields();
        for (int i3 = 0; i3 < targetKeys.size(); ++i3) {
            DatabaseField targetPrimaryKey = (DatabaseField)targetKeys.get(i3);
            DatabaseField targetRelationForeignKey = (DatabaseField)targetRelationKeys.get(i3);
            AdvancedJPAJunitTest.assertTrue((String)("The projects mapping target relation foreign key field [" + targetRelationForeignKey.getName() + "(" + targetRelationForeignKey.getLength() + ")] did not have the same length as the target primary key field [" + targetPrimaryKey.getName() + "(" + targetPrimaryKey.getLength() + ")]"), (targetPrimaryKey.getLength() == targetRelationForeignKey.getLength() ? 1 : 0) != 0);
        }
        mapping = employeeDescriptor.getMappingForAttributeName("responsibilities");
        AdvancedJPAJunitTest.assertNotNull((String)"The responsibilities mapping from Employee was not found", (Object)mapping);
        AdvancedJPAJunitTest.assertTrue((String)"The responsibilities mapping is no longer a direct collection mapping", (boolean)mapping.isDirectCollectionMapping());
        Vector primaryKeys = ((DirectCollectionMapping)mapping).getSourceKeyFields();
        Vector foreignKeys = ((DirectCollectionMapping)mapping).getReferenceKeyFields();
        for (i = 0; i < primaryKeys.size(); ++i) {
            primaryKey = (DatabaseField)primaryKeys.get(i);
            foreignKey = (DatabaseField)foreignKeys.get(i);
            AdvancedJPAJunitTest.assertTrue((String)("The responsibilities mapping foreign key field [" + foreignKey.getName() + "(" + foreignKey.getLength() + ")] did not have the same length as the source primary key field [" + primaryKey.getName() + "(" + primaryKey.getLength() + ")]"), (primaryKey.getLength() == foreignKey.getLength() ? 1 : 0) != 0);
        }
        mapping = buyerDescriptor.getMappingForAttributeName("creditLines");
        AdvancedJPAJunitTest.assertNotNull((String)"The creditLines mapping from Buyer was not found", (Object)mapping);
        AdvancedJPAJunitTest.assertTrue((String)"The creditLines mapping is no longer an element collection mapping", (boolean)mapping.isDirectCollectionMapping());
        primaryKeys = ((DirectCollectionMapping)mapping).getSourceKeyFields();
        foreignKeys = ((DirectCollectionMapping)mapping).getReferenceKeyFields();
        for (i = 0; i < primaryKeys.size(); ++i) {
            primaryKey = (DatabaseField)primaryKeys.get(i);
            foreignKey = (DatabaseField)foreignKeys.get(i);
            AdvancedJPAJunitTest.assertTrue((String)("The creditLines mapping foreign key field [" + foreignKey.getName() + "(" + foreignKey.getLength() + ")] did not have the same length as the source primary key field [" + primaryKey.getName() + "(" + primaryKey.getLength() + ")]"), (primaryKey.getLength() == foreignKey.getLength() ? 1 : 0) != 0);
        }
    }

    public void testVerifyEmployeeCacheSettings() {
        EntityManager em = AdvancedJPAJunitTest.createEntityManager((String)"default1");
        ClassDescriptor descriptor = AdvancedJPAJunitTest.isOnServer() ? AdvancedJPAJunitTest.getServerSession((String)"default1").getDescriptorForAlias("Employee") : ((EntityManagerImpl)em).getServerSession().getDescriptorForAlias("Employee");
        if (descriptor == null) {
            AdvancedJPAJunitTest.fail((String)"A descriptor for the Employee alias was not found in the default1 PU.");
        } else {
            AdvancedJPAJunitTest.assertTrue((String)"Incorrect cache type() setting.", (boolean)descriptor.getIdentityMapClass().equals(ClassConstants.SoftCacheWeakIdentityMap_Class));
            AdvancedJPAJunitTest.assertTrue((String)("Incorrect cache size() setting, was: " + descriptor.getIdentityMapSize() + " expected: 730."), (descriptor.getIdentityMapSize() == 730 ? 1 : 0) != 0);
            AdvancedJPAJunitTest.assertFalse((String)"Incorrect cache isolated() setting.", (boolean)descriptor.isIsolated());
            AdvancedJPAJunitTest.assertFalse((String)"Incorrect cache alwaysRefresh() setting.", (boolean)descriptor.shouldAlwaysRefreshCache());
            CacheInvalidationPolicy policy = descriptor.getCacheInvalidationPolicy();
            AdvancedJPAJunitTest.assertTrue((String)"Incorrect cache expiry() policy setting.", (boolean)(policy instanceof TimeToLiveCacheInvalidationPolicy));
            AdvancedJPAJunitTest.assertTrue((String)"Incorrect cache expiry() setting.", (((TimeToLiveCacheInvalidationPolicy)policy).getTimeToLive() == 1000000L ? 1 : 0) != 0);
            AdvancedJPAJunitTest.assertTrue((String)"Incorrect cache coordinationType() settting.", (descriptor.getCacheSynchronizationType() == 2 ? 1 : 0) != 0);
        }
        this.closeEntityManager(em);
    }

    public void testVerifyEmployeeCustomizerSettings() {
        EntityManager em = this.createEntityManager();
        ClassDescriptor descriptor = AdvancedJPAJunitTest.getServerSession().getDescriptorForAlias("Employee");
        if (descriptor == null) {
            AdvancedJPAJunitTest.fail((String)"A descriptor for the Employee alias was not found.");
        } else {
            AdvancedJPAJunitTest.assertFalse((String)"Disable cache hits was true. Customizer should have made it false.", (boolean)descriptor.shouldDisableCacheHits());
        }
        this.closeEntityManager(em);
    }

    public void testJoinFetchAnnotation() {
        ServerSession session = JUnitTestCase.getServerSession();
        ClassDescriptor descriptor = session.getDescriptor(Employee.class);
        if (((ForeignReferenceMapping)descriptor.getMappingForAttributeName("department")).getJoinFetch() != 2) {
            AdvancedJPAJunitTest.fail((String)"JoinFetch annotation not read correctly for Employee.department.");
        }
    }

    public void testUpdateEmployee() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            EJBQueryImpl query = (EJBQueryImpl)em.createNamedQuery("findAllSQLEmployees");
            Collection employees = query.getResultCollection();
            if (employees.isEmpty()) {
                AdvancedJPAJunitTest.fail((String)"No Employees were found. Test requires at least one Employee to be created in the EmployeePopulator.");
            } else {
                Employee emp = (Employee)employees.iterator().next();
                emp.addResponsibility(newResponsibility);
                emp.setMondayToFridayWorkWeek();
                empId = emp.getId();
                this.commitTransaction(em);
            }
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testVerifyUpdatedEmployee() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee emp = (Employee)em.find(Employee.class, (Object)empId);
            AdvancedJPAJunitTest.assertNotNull((String)"The updated employee was not found.", (Object)emp);
            boolean found = false;
            for (String responsibility : emp.getResponsibilities()) {
                if (!responsibility.equals(newResponsibility)) continue;
                found = true;
                break;
            }
            this.commitTransaction(em);
            AdvancedJPAJunitTest.assertTrue((String)"The new responsibility was not added.", (boolean)found);
            AdvancedJPAJunitTest.assertTrue((String)"The basic collection using enums was not persisted correctly.", (boolean)emp.worksMondayToFriday());
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testVersionUpdateForOwnedMappings() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee emp = (Employee)em.find(Employee.class, (Object)empId);
            int currentVersion = emp.getVersion();
            AdvancedJPAJunitTest.assertNotNull((String)"The employee was not found for Id.", (Object)empId);
            emp.getResponsibilities().add("UpdateVersionField");
            this.commitTransaction(em);
            AdvancedJPAJunitTest.assertTrue((String)"Did not increment version for change to direct collection", (emp.getVersion() == ++currentVersion ? 1 : 0) != 0);
            this.beginTransaction(em);
            emp = (Employee)em.find(Employee.class, (Object)empId);
            emp.getDealers().add(em.merge((Object)new Dealer("update", "version")));
            this.commitTransaction(em);
            AdvancedJPAJunitTest.assertTrue((String)"Did not increment version for change to uni-directional one to many with join table", (emp.getVersion() == ++currentVersion ? 1 : 0) != 0);
            this.beginTransaction(em);
            emp = (Employee)em.find(Employee.class, (Object)empId);
            emp.getProjects().add(em.merge((Object)new LargeProject("versionUpdate")));
            this.commitTransaction(em);
            AdvancedJPAJunitTest.assertTrue((String)"Did not increment version for change to owned ManyToMany", (emp.getVersion() == ++currentVersion ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testCreateNewBuyer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            GoldBuyer buyer = new GoldBuyer();
            buyer.setName("Guy Pelletier");
            buyer.setGender("Made of testosterone");
            buyer.setDescription("Loves to spend");
            buyer.addVisa(visa);
            buyer.addAmex(amex);
            buyer.addDinersClub(diners);
            buyer.addMastercard(mastercard);
            buyer.addRoyalBankCreditLine(rbc);
            buyer.addScotiabankCreditLine(scotia);
            buyer.addTorontoDominionCreditLine(td);
            buyer.addCanadianImperialCreditLine(cibc);
            buyer.setSaturdayToSundayBuyingDays();
            em.persist((Object)buyer);
            this.commitTransaction(em);
            buyerId = buyer.getId();
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testVerifyNewBuyer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            GoldBuyer buyer = (GoldBuyer)em.find(GoldBuyer.class, (Object)buyerId);
            AdvancedJPAJunitTest.assertNotNull((String)"The new buyer was not found", (Object)buyer);
            AdvancedJPAJunitTest.assertTrue((String)"Gender was not persisted correctly.", (boolean)buyer.isMale());
            AdvancedJPAJunitTest.assertTrue((String)"Visa card did not persist correctly.", (boolean)buyer.hasVisa(visa));
            AdvancedJPAJunitTest.assertTrue((String)"Amex card did not persist correctly.", (boolean)buyer.hasAmex(amex));
            AdvancedJPAJunitTest.assertTrue((String)"Diners Club card did not persist correctly.", (boolean)buyer.hasDinersClub(diners));
            AdvancedJPAJunitTest.assertTrue((String)"Mastercard card did not persist correctly.", (boolean)buyer.hasMastercard(mastercard));
            AdvancedJPAJunitTest.assertTrue((String)"RBC credit line did not persist correctly.", (boolean)buyer.hasRoyalBankCreditLine(rbc));
            AdvancedJPAJunitTest.assertTrue((String)"Scotia credit line did not persist correctly.", (boolean)buyer.hasScotiabankCreditLine(scotia));
            AdvancedJPAJunitTest.assertTrue((String)"TD credit line did not persist correctly.", (boolean)buyer.hasTorontoDominionCreditLine(td));
            AdvancedJPAJunitTest.assertTrue((String)"CIBC credit line did not persist correctly.", (boolean)buyer.hasCanadianImperialCreditLine(cibc));
            AdvancedJPAJunitTest.assertTrue((String)"The serialized enum set was not persisted correctly.", (boolean)buyer.buysSaturdayToSunday());
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testBuyerOptimisticLocking() {
        if (AdvancedJPAJunitTest.isOnServer()) {
            return;
        }
        EntityManager em1 = this.createEntityManager();
        EntityManager em2 = this.createEntityManager();
        em1.getTransaction().begin();
        em2.getTransaction().begin();
        RuntimeException caughtException = null;
        try {
            GoldBuyer buyer1 = (GoldBuyer)em1.find(GoldBuyer.class, (Object)buyerId);
            GoldBuyer buyer2 = (GoldBuyer)em2.find(GoldBuyer.class, (Object)buyerId);
            buyer1.setName("Geezer");
            buyer2.setName("Guyzer");
            buyer1.setVersion(buyer1.getVersion() + 1);
            buyer2.setVersion(buyer2.getVersion() + 1);
            em1.getTransaction().commit();
            em2.getTransaction().commit();
            em1.close();
            em2.close();
        }
        catch (RuntimeException e) {
            caughtException = e;
            if (em1.getTransaction().isActive()) {
                em1.getTransaction().rollback();
            }
            if (em2.getTransaction().isActive()) {
                em2.getTransaction().rollback();
            }
            em1.close();
            em2.close();
        }
        if (caughtException == null) {
            AdvancedJPAJunitTest.fail((String)"Optimistic lock exception was not thrown.");
        } else if (!(caughtException.getCause() instanceof OptimisticLockException)) {
            throw caughtException;
        }
    }

    public void testGiveFredAnObjectTypeConverterChange() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            EJBQueryImpl query = (EJBQueryImpl)em.createNamedQuery("findAllEmployeesByFirstName");
            query.setParameter("firstname", (Object)"Fred");
            Collection employees = query.getResultCollection();
            if (employees.isEmpty()) {
                AdvancedJPAJunitTest.fail((String)"No employees named Fred were found. Test requires at least one Fred to be created in the EmployeePopulator.");
            } else {
                Employee fred = (Employee)employees.iterator().next();
                fred.setFemale();
                fred.setFirstName("Penelope");
                penelopeId = fred.getId();
                this.commitTransaction(em);
                this.clearCache();
                em.clear();
                Employee penelope = (Employee)em.find(Employee.class, (Object)penelopeId);
                AdvancedJPAJunitTest.assertTrue((String)"Fred's ObjectTypeConverter change to Penelope didn't occur.", (boolean)penelope.isFemale());
            }
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testUpdatePenelopesPhoneNumberStatus() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee emp = (Employee)em.find(Employee.class, (Object)penelopeId);
            AdvancedJPAJunitTest.assertNotNull((String)("The employee with id: [" + penelopeId + "] was not found."), (Object)emp);
            for (PhoneNumber phoneNumber : emp.getPhoneNumbers()) {
                phoneNumber.addStatus(PhoneNumber.PhoneStatus.ACTIVE);
                phoneNumber.addStatus(PhoneNumber.PhoneStatus.ASSIGNED);
            }
            this.commitTransaction(em);
            this.clearCache();
            em.clear();
            Employee emp2 = (Employee)em.find(Employee.class, (Object)penelopeId);
            for (PhoneNumber phone : emp2.getPhoneNumbers()) {
                AdvancedJPAJunitTest.assertTrue((String)"", (boolean)phone.getStatus().contains(PhoneNumber.PhoneStatus.ACTIVE));
                AdvancedJPAJunitTest.assertTrue((String)"", (boolean)phone.getStatus().contains(PhoneNumber.PhoneStatus.ASSIGNED));
            }
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testSharedEmbeddedAttributeOverrides() {
        EntityManager em = this.createEntityManager();
        try {
            Product product = new Product();
            product.setName("Scottish Shortbread");
            product.setCountryCode("GBR");
            product.setBarCode1(new BarCode("123-456-789", "GBR"));
            product.setBarCode2(null);
            this.beginTransaction(em);
            em.persist((Object)product);
            this.commitTransaction(em);
            Product productReRead = (Product)em.find(Product.class, (Object)product.getId());
            productReRead.setName("Beef Jerky");
            productReRead.setCountryCode("USA");
            productReRead.setBarCode1(new BarCode("722-666-489", "USA"));
            productReRead.setBarCode2(null);
            this.beginTransaction(em);
            em.merge((Object)productReRead);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadingEntityGarbageCollectedFromSharedCache() {
        EntityManager em = this.createEntityManager();
        Employee emp = (Employee)em.createQuery("Select e from Employee e").getResultList().get(0);
        em.clear();
        this.clearCache();
        try {
            Query q = em.createQuery("Select f from Employee f where f.id =" + emp.getId());
            q.setHint("javax.persistence.cache.storeMode", (Object)CacheStoreMode.BYPASS);
            try {
                Employee clone = (Employee)q.getSingleResult();
                clone.toString();
            }
            catch (NullPointerException e) {
                AdvancedJPAJunitTest.fail((String)("NPE occured building an Entity whos reference in the shared cache was garbage collected: " + e));
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.getServerSession().getIdentityMapAccessorInstance().initializeAllIdentityMaps();
        }
    }

    public void testRemoveJillWithPrivateOwnedPhoneNumbers() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            EJBQueryImpl query = (EJBQueryImpl)em.createNamedQuery("findAllEmployeesByFirstName");
            query.setParameter("firstname", (Object)"Jill");
            Collection employees = query.getResultCollection();
            if (employees.isEmpty()) {
                AdvancedJPAJunitTest.fail((String)"No employees named Jill were found. Test requires at least one Jill to be created in the EmployeePopulator.");
            } else {
                Employee jill = (Employee)employees.iterator().next();
                Collection phoneNumbers = jill.getPhoneNumbers();
                if (phoneNumbers.isEmpty()) {
                    AdvancedJPAJunitTest.fail((String)"Jill does not have any phone numbers. Test requires that Jill have atleast one phone number created in the EmployeePopulator.");
                }
                for (Employee employee : jill.getManagedEmployees()) {
                    employee.setManager(jill.getManager());
                }
                jill.getManagedEmployees().clear();
                int jillId = jill.getId();
                em.remove((Object)jill);
                this.commitTransaction(em);
                AdvancedJPAJunitTest.assertNull((String)"Jill herself was not removed.", (Object)em.find(Employee.class, (Object)jillId));
                for (PhoneNumber phoneNumber : phoneNumbers) {
                    AdvancedJPAJunitTest.assertNull((String)"Jill's phone numbers were not deleted.", (Object)em.find(PhoneNumber.class, (Object)phoneNumber.buildPK()));
                }
            }
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testCreateNewEquipment() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Equipment equip1 = new Equipment();
            equip1.setDescription("Toaster");
            em.persist((Object)equip1);
            Equipment equip2 = new Equipment();
            equip1.setDescription("Bucket");
            em.persist((Object)equip2);
            Equipment equip3 = new Equipment();
            equip1.setDescription("Broom");
            em.persist((Object)equip3);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testAddNewEquipmentToDepartment() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            EJBQueryImpl query = (EJBQueryImpl)em.createNamedQuery("findAllSQLEquipment");
            Collection equipment = query.getResultCollection();
            if (equipment.isEmpty()) {
                AdvancedJPAJunitTest.fail((String)"No Equipment was found. testCreateNewEquipment should have created new equipment and should have run before this test.");
            } else {
                Department department = new Department();
                department.setName("Department with equipment");
                for (Equipment e : equipment) {
                    department.addEquipment(e);
                }
                em.persist((Object)department);
                deptId = department.getId();
                this.commitTransaction(em);
            }
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testBackpointerOnMerge() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Department department = new Department();
            department.setName("Football");
            em.persist((Object)department);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            em = this.createEntityManager();
            this.beginTransaction(em);
            Equipment equipment = new Equipment();
            equipment.setDescription("Shields & Dummies");
            department.addEquipment(equipment);
            em.merge((Object)department);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            AdvancedJPAJunitTest.assertTrue((department.getEquipment().get(0) == equipment ? 1 : 0) != 0);
            AdvancedJPAJunitTest.assertEquals((int)System.identityHashCode(department.getEquipment().get(0)), (int)System.identityHashCode(equipment));
            AdvancedJPAJunitTest.assertEquals((Object)department.getId(), (Object)equipment.getDepartment().getId());
            AdvancedJPAJunitTest.assertTrue((String)"The department instance (backpointer) from equipment was modified after merge.", (department == equipment.getDepartment() ? 1 : 0) != 0);
            AdvancedJPAJunitTest.assertEquals((String)"The department instance (backpointer) from equipment was modified after merge.", (int)System.identityHashCode(department), (int)System.identityHashCode(equipment.getDepartment()));
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testNamedStoredProcedureQuery() {
        if (!this.supportsStoredProcedures()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Address address1 = new Address();
            address1.setCity("Ottawa");
            address1.setPostalCode("K1G6P3");
            address1.setProvince("ON");
            address1.setStreet("123 Street");
            address1.setCountry("Canada");
            em.persist((Object)address1);
            this.commitTransaction(em);
            em.clear();
            Address address2 = (Address)em.createNamedQuery("SProcAddress").setParameter("ADDRESS_ID", (Object)address1.getID()).getSingleResult();
            AdvancedJPAJunitTest.assertNotNull((String)"Address returned from stored procedure is null", (Object)address2);
            AdvancedJPAJunitTest.assertFalse((String)"Address returned is the same cached instance that was persisted - the cache must be disabled for this test", (address1 == address2 ? 1 : 0) != 0);
            AdvancedJPAJunitTest.assertTrue((String)"Address build correctly using stored procedure", (address2.getID() == address1.getID() ? 1 : 0) != 0);
            AdvancedJPAJunitTest.assertTrue((String)"Address build correctly using stored procedure", (boolean)address2.getStreet().equals(address1.getStreet()));
            AdvancedJPAJunitTest.assertTrue((String)"Address build correctly using stored procedure", (boolean)address2.getCountry().equals(address1.getCountry()));
            AdvancedJPAJunitTest.assertTrue((String)"Address build correctly using stored procedure", (boolean)address2.getProvince().equals(address1.getProvince()));
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testNamedStoredProcedureQueryByIndex() {
        if (!this.supportsStoredProcedures()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Address address1 = new Address();
            address1.setCity("Ottawa");
            address1.setPostalCode("K1G6P3");
            address1.setProvince("ON");
            address1.setStreet("123 Street");
            address1.setCountry("Canada");
            em.persist((Object)address1);
            this.commitTransaction(em);
            em.clear();
            Address address2 = (Address)em.createNamedQuery("SProcAddressByIndex").setParameter("ADDRESS_ID", (Object)address1.getID()).getSingleResult();
            AdvancedJPAJunitTest.assertNotNull((String)"Address returned from stored procedure is null", (Object)address2);
            AdvancedJPAJunitTest.assertFalse((String)"Address returned is the same cached instance that was persisted - the cache must be disabled for this test", (address1 == address2 ? 1 : 0) != 0);
            AdvancedJPAJunitTest.assertTrue((String)"Address build correctly using stored procedure", (address2.getID() == address1.getID() ? 1 : 0) != 0);
            AdvancedJPAJunitTest.assertTrue((String)"Address build correctly using stored procedure", (boolean)address2.getStreet().equals(address1.getStreet()));
            AdvancedJPAJunitTest.assertTrue((String)"Address build correctly using stored procedure", (boolean)address2.getCountry().equals(address1.getCountry()));
            AdvancedJPAJunitTest.assertTrue((String)"Address build correctly using stored procedure", (boolean)address2.getProvince().equals(address1.getProvince()));
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testNamedStoredProcedureQueryWithResultSetMapping() {
        if (!this.supportsStoredProcedures()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Address address1 = new Address();
            address1.setCity("Ottawa");
            address1.setPostalCode("K1G6P3");
            address1.setProvince("ON");
            address1.setStreet("123 Street");
            address1.setCountry("Canada");
            em.persist((Object)address1);
            this.commitTransaction(em);
            em.clear();
            Address address2 = (Address)em.createNamedQuery("SProcAddressWithResultSetMapping").setParameter("address_id_v", (Object)address1.getID()).getSingleResult();
            AdvancedJPAJunitTest.assertNotNull((String)"Address returned from stored procedure is null", (Object)address2);
            AdvancedJPAJunitTest.assertFalse((String)"Address returned is the same cached instance that was persisted - the cache must be disabled for this test", (address1 == address2 ? 1 : 0) != 0);
            AdvancedJPAJunitTest.assertTrue((String)"Address not found using stored procedure", (address2.getID() == address1.getID() ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testNamedStoredProcedureQueryWithResultSetFieldMapping() {
        if (!this.supportsStoredProcedures()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Address address1 = new Address();
            address1.setCity("Ottawa");
            address1.setPostalCode("K1G6P3");
            address1.setProvince("ON");
            address1.setStreet("123 Street");
            address1.setCountry("Canada");
            em.persist((Object)address1);
            this.commitTransaction(em);
            Object[] values = (Object[])em.createNamedQuery("SProcAddressWithResultSetFieldMapping").setParameter("address_id_v", (Object)address1.getID()).getSingleResult();
            AdvancedJPAJunitTest.assertTrue((String)"Address data not found or returned using stored procedure", (values != null && values.length == 6 ? 1 : 0) != 0);
            AdvancedJPAJunitTest.assertNotNull((String)"No results returned from store procedure call", (Object)values[1]);
            AdvancedJPAJunitTest.assertTrue((String)"Address not found using stored procedure", (boolean)address1.getStreet().equals(values[1]));
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testNamedStoredProcedureQueryInOut() {
        if (!this.supportsStoredProcedures()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Address address1 = new Address();
            address1.setCity("Ottawa");
            address1.setPostalCode("K1G6P3");
            address1.setProvince("ON");
            address1.setStreet("123 Street");
            address1.setCountry("Canada");
            em.persist((Object)address1);
            this.commitTransaction(em);
            em.clear();
            Query aQuery = em.createNamedQuery("SProcInOut").setParameter("ADDRESS_ID", (Object)address1.getID());
            Address address2 = (Address)aQuery.getSingleResult();
            AdvancedJPAJunitTest.assertNotNull((String)"Address returned from stored procedure is null", (Object)address2);
            AdvancedJPAJunitTest.assertFalse((String)"Address returned is the same cached instance that was persisted - the cache must be disabled for this test", (address1 == address2 ? 1 : 0) != 0);
            AdvancedJPAJunitTest.assertTrue((String)"Address not found using stored procedure", (address1.getID() == address2.getID() ? 1 : 0) != 0);
            AdvancedJPAJunitTest.assertTrue((String)"Address.street data returned doesn't match persisted address.street", (boolean)address1.getStreet().equalsIgnoreCase(address2.getStreet()));
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testNamedStoredProcedureQueryWithRawData() {
        if (!this.supportsStoredProcedures()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Address address1 = new Address();
            address1.setCity("Ottawa");
            address1.setPostalCode("K1G6P3");
            address1.setProvince("ON");
            address1.setStreet("123 Street");
            address1.setCountry("Canada");
            em.persist((Object)address1);
            this.commitTransaction(em);
            Query aQuery = em.createNamedQuery("SProcInOutReturningRawData").setParameter("ADDRESS_ID", (Object)address1.getID());
            Object[] objectdata = (Object[])aQuery.getSingleResult();
            AdvancedJPAJunitTest.assertTrue((String)"Address data not found or returned using stored procedure", (objectdata != null && objectdata.length == 2 ? 1 : 0) != 0);
            AdvancedJPAJunitTest.assertTrue((String)"Address Id data returned doesn't match persisted address", (address1.getID() == ((Integer)objectdata[0]).intValue() ? 1 : 0) != 0);
            AdvancedJPAJunitTest.assertTrue((String)"Address Street data returned doesn't match persisted address", (boolean)address1.getStreet().equals(objectdata[1]));
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testNonTriggerLazyForSProc() {
        if (!this.supportsStoredProcedures()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee employee1 = new Employee();
            employee1.setFirstName("Me");
            employee1.setId(Integer.valueOf(11));
            HugeProject hp = new HugeProject("big proj");
            employee1.setHugeProject(hp);
            em.persist((Object)hp);
            em.persist((Object)employee1);
            this.commitTransaction(em);
            em.clear();
            this.beginTransaction(em);
            Query q = em.createNamedQuery("SProcEmployee");
            q.setParameter("EMP_ID", (Object)employee1.getId());
            q.setFlushMode(FlushModeType.COMMIT);
            q.setHint("eclipselink.refresh", (Object)"True");
            q.setHint("eclipselink.refresh.cascade", (Object)"CascadeByMapping");
            Employee employee2 = (Employee)q.getSingleResult();
            ProviderUtil util = new PersistenceProvider().getProviderUtil();
            AdvancedJPAJunitTest.assertFalse((String)"ProviderUtil returned LOADED for isLoaded for hugeProject when it should not.", (boolean)util.isLoadedWithReference((Object)employee2, "hugeProject").equals((Object)LoadState.LOADED));
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testOptimisticLockExceptionOnMerge() {
        RuntimeException caughtException;
        EntityManager em1;
        block5: {
            em1 = this.createEntityManager();
            this.beginTransaction(em1);
            caughtException = null;
            try {
                Employee emp = new Employee();
                emp.setLastName("OptimisticLockExceptionOnMerge");
                emp.setVersion(Integer.valueOf(10));
                em1.persist((Object)emp);
                this.commitTransaction(em1);
                this.closeEntityManager(em1);
                em1 = this.createEntityManager();
                this.beginTransaction(em1);
                emp = (Employee)em1.find(Employee.class, (Object)emp.getId());
                em1.remove((Object)emp);
                this.commitTransaction(em1);
                this.closeEntityManager(em1);
                em1 = this.createEntityManager();
                this.beginTransaction(em1);
                em1.merge((Object)emp);
                this.commitTransaction(em1);
            }
            catch (RuntimeException e) {
                caughtException = e;
                if (!this.isTransactionActive(em1)) break block5;
                this.rollbackTransaction(em1);
            }
        }
        this.closeEntityManager(em1);
        if (caughtException == null) {
            AdvancedJPAJunitTest.fail((String)"Optimistic lock exception was not thrown.");
        } else if (!(caughtException instanceof OptimisticLockException)) {
            throw caughtException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOptimisticLockExceptionOnMergeWithAssumeExists() {
        org.eclipse.persistence.sessions.Project project = AdvancedJPAJunitTest.getServerSession().getProject();
        ClassDescriptor descriptor = project.getDescriptor(Employee.class);
        int existencePolicy = descriptor.getQueryManager().getDoesExistQuery().getExistencePolicy();
        descriptor.getQueryManager().assumeExistenceForDoesExist();
        try {
            this.testOptimisticLockExceptionOnMerge();
        }
        finally {
            descriptor.getQueryManager().getDoesExistQuery().setExistencePolicy(existencePolicy);
        }
    }

    public void testModifyNamedStoredProcedureQueryWithRawData() {
        if (!this.supportsStoredProcedures()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Address address1 = new Address();
            address1.setCity("Ottawa");
            address1.setPostalCode("K1G6P3");
            address1.setProvince("ON");
            address1.setStreet("123 Street");
            address1.setCountry("Canada");
            em.persist((Object)address1);
            this.commitTransaction(em);
            this.beginTransaction(em);
            em.createNamedQuery("SProcInOutReturningRawData").setParameter("ADDRESS_ID", (Object)address1.getID()).getSingleResult();
        }
        catch (RuntimeException exception) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw exception;
        }
        this.commitTransaction(em);
        this.closeEntityManager(em);
    }

    public void testRemoveDepartmentWithPrivateOwnedEquipment() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Department department = (Department)em.find(Department.class, (Object)deptId);
            if (department == null) {
                AdvancedJPAJunitTest.fail((String)("Department with id=" + deptId + ", was not found."));
            } else {
                Collection equipment = department.getEquipment().values();
                if (equipment.isEmpty()) {
                    AdvancedJPAJunitTest.fail((String)("Department with id=" + deptId + ", did not have any equipment."));
                } else {
                    em.remove((Object)department);
                    this.commitTransaction(em);
                    AdvancedJPAJunitTest.assertNull((String)"Department itself was not removed.", (Object)em.find(Department.class, (Object)deptId));
                    for (Equipment e : equipment) {
                        AdvancedJPAJunitTest.assertNull((String)"New equipment was not deleted.", (Object)em.find(Equipment.class, (Object)e.getId()));
                    }
                }
            }
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testRelationshipReadDuringClone() {
        EntityManager em = this.createEntityManager();
        ServerSession session = AdvancedJPAJunitTest.getServerSession();
        ClassDescriptor departmentDesc = session.getDescriptor(Department.class);
        DescriptorEventAdapter listener = new DescriptorEventAdapter(){

            public void postClone(DescriptorEvent event) {
                ((Department)event.getObject()).getEquipment().size();
            }
        };
        departmentDesc.getDescriptorEventManager().addListener((DescriptorEventListener)listener);
        em.createQuery("SELECT e from Equipment e where e.department is not null").getResultList();
        departmentDesc.getDescriptorEventManager().removeListener((DescriptorEventListener)listener);
        departmentDesc.getDescriptorEventManager().initialize((AbstractSession)session);
        this.closeEntityManager(em);
    }

    public void testUpdateReadOnlyEquipmentCode() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Query query = em.createNamedQuery("findSQLEquipmentCodeA");
            EquipmentCode equipmentCode = (EquipmentCode)query.getSingleResult();
            equipmentCode.setCode("Z");
            this.commitTransaction(em);
            try {
                query = em.createNamedQuery("findSQLEquipmentCodeA");
                query.getSingleResult();
            }
            catch (Exception e) {
                AdvancedJPAJunitTest.fail((String)"The read only EquipmentA was modified");
            }
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testMethodBasedTransformationMapping() {
        this.internalTestTransformationMapping("normalHours");
    }

    public void testClassBasedTransformationMapping() {
        this.internalTestTransformationMapping("overtimeHours");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransformationMappingWithColumnAnnotation() {
        Door door = new Door();
        door.setId(100);
        door.setHeight(8);
        door.setWidth(5);
        door.setRoom(null);
        int year = 2013;
        int month = 1;
        int day = 30;
        door.setSaleDate(Helper.dateFromYearMonthDate((int)year, (int)(month - 1), (int)day));
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.persist((Object)door);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        int id = door.getId();
        String errorMsg = "";
        try {
            this.clearCache();
            em = this.createEntityManager();
            door = (Door)em.find(Door.class, (Object)100);
            Calendar calendarSaleDate = Calendar.getInstance();
            calendarSaleDate.setTime(door.getSaleDate());
            if (calendarSaleDate.get(1) != year || calendarSaleDate.get(2) != month - 1 || calendarSaleDate.get(5) != day) {
                errorMsg = "saleDate = " + door.getSaleDate().toString() + " is wrong";
            }
        }
        catch (RuntimeException ex) {
            AdvancedJPAJunitTest.fail((String)("Failed to fetch data for testTransformationMappingWithColumnAnnotation" + ex.getMessage()));
        }
        this.beginTransaction(em);
        try {
            door = (Door)em.find(Door.class, (Object)door.getId());
            em.remove((Object)door);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        if (errorMsg.length() != 0) {
            AdvancedJPAJunitTest.fail((String)errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalTestTransformationMapping(String attributeName) {
        int startHour = 8;
        int startMin = 30;
        int startSec = 15;
        int endHour = 17;
        int endMin = 15;
        int endSec = 45;
        String firstName = attributeName;
        Employee employee = new Employee();
        employee.setFirstName(firstName);
        if (attributeName.equals("normalHours")) {
            employee.setStartTime(Helper.timeFromHourMinuteSecond((int)startHour, (int)startMin, (int)startSec));
            employee.setEndTime(Helper.timeFromHourMinuteSecond((int)endHour, (int)endMin, (int)endSec));
        } else if (attributeName.equals("overtimeHours")) {
            employee.setStartOvertime(Helper.timeFromHourMinuteSecond((int)startHour, (int)startMin, (int)startSec));
            employee.setEndOvertime(Helper.timeFromHourMinuteSecond((int)endHour, (int)endMin, (int)endSec));
        } else {
            throw new RuntimeException("Unknown attributeName");
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.persist((Object)employee);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        int id = employee.getId();
        this.clearCache();
        em = this.createEntityManager();
        employee = (Employee)em.find(Employee.class, (Object)id);
        Calendar calendarStart = Calendar.getInstance();
        Calendar calendarEnd = Calendar.getInstance();
        if (attributeName.equals("normalHours")) {
            calendarStart.setTime(employee.getStartTime());
            calendarEnd.setTime(employee.getEndTime());
        } else if (attributeName.equals("overtimeHours")) {
            calendarStart.setTime(employee.getStartOvertime());
            calendarEnd.setTime(employee.getEndOvertime());
        }
        String errorMsg = "";
        if (calendarStart.get(11) != startHour || calendarStart.get(12) != startMin || calendarStart.get(13) != startSec) {
            if (attributeName.equals("normalHours")) {
                errorMsg = "startTime = " + employee.getStartTime().toString() + " is wrong";
            } else if (attributeName.equals("overtimeHours")) {
                errorMsg = "startOvertime = " + employee.getStartOvertime().toString() + " is wrong";
            }
        }
        if (calendarEnd.get(11) != endHour || calendarEnd.get(12) != endMin || calendarEnd.get(13) != endSec) {
            if (errorMsg.length() > 0) {
                errorMsg = errorMsg + "; ";
            }
            if (attributeName.equals("normalHours")) {
                errorMsg = "endTime = " + employee.getEndTime().toString() + " is wrong";
            } else if (attributeName.equals("overtimeHours")) {
                errorMsg = "endOvertime = " + employee.getEndOvertime().toString() + " is wrong";
            }
        }
        this.beginTransaction(em);
        try {
            employee = (Employee)em.find(Employee.class, (Object)employee.getId());
            em.remove((Object)employee);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        if (errorMsg.length() > 0) {
            AdvancedJPAJunitTest.fail((String)errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCursorStream() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Room room1 = new Room();
        Door east = new Door();
        try {
            room1.setId(10001);
            east.setId(100);
            east.setHeight(8);
            east.setWidth(5);
            int year = 2013;
            int month = 1;
            int day = 30;
            east.setSaleDate(Helper.dateFromYearMonthDate((int)year, (int)(month - 1), (int)day));
            east.setRoom(room1);
            room1.addDoor(east);
            try {
                em.persist((Object)room1);
                this.commitTransaction(em);
            }
            finally {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
            }
            em = this.createEntityManager();
            Query resultsXferQuery = em.createQuery("SELECT r, d FROM Room r JOIN FETCH r.doors LEFT JOIN Door d WHERE d MEMBER OF r.doors");
            resultsXferQuery.setHint("eclipselink.cursor", (Object)true);
            try {
                CursoredStream stream = (CursoredStream)resultsXferQuery.getSingleResult();
                while (!stream.atEnd()) {
                    stream.read();
                }
                stream.clear();
                stream.close();
            }
            catch (NullPointerException npe) {
                AdvancedJPAJunitTest.fail((String)"CursoredStream with join threw an NPE");
            }
            this.beginTransaction(em);
            room1 = (Room)em.find(Room.class, (Object)room1.getId());
            em.remove((Object)room1);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testProperty() {
        EntityManager em = this.createEntityManager();
        ClassDescriptor descriptor = AdvancedJPAJunitTest.getServerSession().getDescriptorForAlias("Employee");
        ClassDescriptor aggregateDescriptor = AdvancedJPAJunitTest.getServerSession().getDescriptor(EmploymentPeriod.class);
        this.closeEntityManager(em);
        String errorMsg = "";
        if (descriptor == null) {
            errorMsg = errorMsg + " Descriptor for Employee alias was not found;";
        }
        if (aggregateDescriptor == null) {
            errorMsg = errorMsg + " Descriptor for EmploymentPeriod.class was not found;";
        }
        if (errorMsg.length() > 0) {
            AdvancedJPAJunitTest.fail((String)errorMsg);
        }
        errorMsg = errorMsg + this.verifyPropertyValue(descriptor, "entityName", String.class, (Object)"Employee");
        errorMsg = errorMsg + this.verifyPropertyValue(descriptor, "entityIntegerProperty", Integer.class, (Object)new Integer(1));
        for (DatabaseMapping mapping : descriptor.getMappings()) {
            errorMsg = errorMsg + this.verifyPropertyValue(mapping, "attributeName", String.class, (Object)mapping.getAttributeName());
        }
        DatabaseMapping mapping = descriptor.getMappingForAttributeName("lastName");
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "BooleanProperty", Boolean.class, (Object)Boolean.TRUE);
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "ByteProperty", Byte.class, (Object)new Byte(1));
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "CharacterProperty", Character.class, (Object)new Character('A'));
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "DoubleProperty", Double.class, (Object)new Double(1.0));
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "FloatProperty", Float.class, (Object)new Float(1.0f));
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "IntegerProperty", Integer.class, (Object)new Integer(1));
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "LongProperty", Long.class, (Object)new Long(1L));
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "ShortProperty", Short.class, (Object)new Short(1));
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "BigDecimalProperty", BigDecimal.class, (Object)BigDecimal.ONE);
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "BigIntegerProperty", BigInteger.class, (Object)BigInteger.ONE);
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "byte[]Property", byte[].class, (Object)new byte[]{1, 2, 3, 4});
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "char[]Property", char[].class, (Object)new char[]{'a', 'b', 'c'});
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "Byte[]Property", Byte[].class, (Object)new byte[]{1, 2, 3, 4});
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "Character[]Property", Character[].class, (Object)new char[]{'a', 'b', 'c'});
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "TimeProperty", Time.class, (Object)Helper.timeFromString((String)"13:59:59"));
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "TimeStampProperty", Timestamp.class, (Object)Helper.timestampFromString((String)"2008-04-10 13:59:59"));
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "DateProperty", Date.class, (Object)Helper.dateFromString((String)"2008-04-10"));
        if ((errorMsg = errorMsg + this.verifyPropertyValue(aggregateDescriptor, "embeddableClassName", String.class, (Object)"EmploymentPeriod")).length() > 0) {
            AdvancedJPAJunitTest.fail((String)errorMsg);
        }
    }

    protected String verifyPropertyValue(ClassDescriptor descriptor, String propertyName, Class expectedPropertyValueType, Object expectedPropertyValue) {
        return this.verifyPropertyValue(propertyName, descriptor.getProperty(propertyName), expectedPropertyValueType, expectedPropertyValue, Helper.getShortClassName((Class)descriptor.getJavaClass()) + " descriptor");
    }

    protected String verifyPropertyValue(DatabaseMapping mapping, String propertyName, Class expectedPropertyValueType, Object expectedPropertyValue) {
        return this.verifyPropertyValue(propertyName, mapping.getProperty((Object)propertyName), expectedPropertyValueType, expectedPropertyValue, mapping.getAttributeName() + " attribute");
    }

    protected String verifyPropertyValue(String propertyName, Object propertyValue, Class expectedPropertyValueType, Object expectedPropertyValue, String masterName) {
        String errorMsg = "";
        String errorPrefix = " property " + propertyName + " for " + masterName;
        if (expectedPropertyValueType == null) {
            if (propertyValue != null) {
                errorMsg = errorPrefix + " value is " + propertyValue.toString() + " , was expected to be null.";
            }
            return errorMsg;
        }
        if (propertyValue == null) {
            errorMsg = errorPrefix + " is missing;";
        } else if (!expectedPropertyValueType.isInstance(propertyValue)) {
            errorMsg = errorPrefix + " is instance of " + propertyValue.getClass().getName() + ", " + expectedPropertyValueType.getName() + " was expected;";
        } else if (propertyValue.getClass().isArray()) {
            if (Array.getLength(propertyValue) != Array.getLength(expectedPropertyValue)) {
                errorMsg = errorPrefix + " has array value of size " + Array.getLength(propertyValue) + ", " + Array.getLength(expectedPropertyValue) + " was expected;";
            } else {
                for (int i = 0; i < Array.getLength(propertyValue); ++i) {
                    if (Array.get(propertyValue, i).equals(Array.get(expectedPropertyValue, i))) continue;
                    errorMsg = errorPrefix + " has array with " + i + "th element value " + Array.get(propertyValue, i).toString() + ", " + Array.get(expectedPropertyValue, i).toString() + " was expected;";
                }
            }
        } else if (!propertyValue.equals(expectedPropertyValue)) {
            errorMsg = errorPrefix + " has value " + propertyValue.toString() + ", " + expectedPropertyValue.toString() + " was expected;";
        }
        return errorMsg;
    }

    public void testUnidirectionalPersist() {
        String lastName = "testUnidirectionalPersist";
        List<Employee> employeesPersisted = this.persistEmployeesWithUnidirectionalMappings(lastName);
        this.clearCache();
        EntityManager em = this.createEntityManager();
        List employeesRead = em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.lastName = '" + lastName + "'").getResultList();
        this.closeEntityManager(em);
        if (employeesPersisted.size() != employeesRead.size()) {
            this.deleteEmployeesWithUnidirectionalMappings(lastName);
            AdvancedJPAJunitTest.fail((String)("Persisted " + employeesPersisted.size() + " employees, but read back " + employeesRead.size()));
        }
        ServerSession session = JUnitTestCase.getServerSession();
        String errorMsg = "";
        for (int i = 0; i < employeesPersisted.size(); ++i) {
            for (int j = 0; j < employeesRead.size(); ++j) {
                if (!employeesPersisted.get(i).getFirstName().equals(((Employee)employeesRead.get(j)).getFirstName()) || session.compareObjects((Object)employeesPersisted.get(i), employeesRead.get(j))) continue;
                errorMsg = errorMsg + "Employee " + employeesPersisted.get(i).getFirstName() + "  was not persisted correctly.";
            }
        }
        this.deleteEmployeesWithUnidirectionalMappings(lastName);
        if (errorMsg.length() > 0) {
            AdvancedJPAJunitTest.fail((String)errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnidirectionalUpdate() {
        String lastName = "testUnidirectionalUpdate";
        EntityManager em = this.createEntityManager();
        List<Employee> employeesPersisted = this.persistEmployeesWithUnidirectionalMappings(lastName, em);
        this.beginTransaction(em);
        try {
            employeesPersisted.get(0).addDealer(new Dealer("New", lastName));
            employeesPersisted.get(1).getDealers().remove(1);
            employeesPersisted.get(1).addDealer((Dealer)employeesPersisted.get(0).getDealers().remove(0));
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        this.clearCache();
        em = this.createEntityManager();
        List employeesRead = em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.lastName = '" + lastName + "'").getResultList();
        if (employeesPersisted.size() != employeesRead.size()) {
            this.deleteEmployeesWithUnidirectionalMappings(lastName);
            AdvancedJPAJunitTest.fail((String)("Updated " + employeesPersisted.size() + " employees, but read back " + employeesRead.size()));
        }
        ServerSession session = JUnitTestCase.getServerSession();
        this.beginTransaction(em);
        String errorMsg = "";
        try {
            for (int i = 0; i < employeesPersisted.size(); ++i) {
                for (int j = 0; j < employeesRead.size(); ++j) {
                    if (AdvancedJPAJunitTest.isOnServer()) {
                        Employee emp1 = (Employee)em.find(Employee.class, (Object)employeesPersisted.get(i).getId());
                        Employee emp2 = (Employee)em.find(Employee.class, (Object)((Employee)employeesRead.get(j)).getId());
                        if (!emp1.getFirstName().equals(emp2.getFirstName()) || session.compareObjects((Object)emp1, (Object)emp2)) continue;
                        errorMsg = errorMsg + "Employee " + emp1.getFirstName() + "  was not updated correctly.";
                        continue;
                    }
                    if (!employeesPersisted.get(i).getFirstName().equals(((Employee)employeesRead.get(j)).getFirstName()) || session.compareObjects((Object)employeesPersisted.get(i), employeesRead.get(j))) continue;
                    errorMsg = errorMsg + "Employee " + employeesPersisted.get(i).getFirstName() + "  was not updated correctly.";
                }
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        this.deleteEmployeesWithUnidirectionalMappings(lastName);
        if (errorMsg.length() > 0) {
            AdvancedJPAJunitTest.fail((String)errorMsg);
        }
    }

    public void testUnidirectionalFetchJoin() {
        String lastName = "testUnidirectionalFetchJoin";
        this.persistEmployeesWithUnidirectionalMappings(lastName);
        this.clearCache();
        EntityManager em = this.createEntityManager();
        List employeesRead = em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.lastName = '" + lastName + "'").getResultList();
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        List employeesReadWithFetchJoin = em.createQuery("SELECT e FROM Employee e JOIN FETCH e.dealers WHERE e.lastName = '" + lastName + "'").getResultList();
        this.closeEntityManager(em);
        ArrayList employeesControl = new ArrayList();
        for (int i = 0; i < employeesRead.size(); ++i) {
            int nDialers = ((Employee)employeesRead.get(i)).getDealers().size();
            for (int j = 0; j < nDialers; ++j) {
                employeesControl.add(employeesRead.get(i));
            }
        }
        ServerSession session = JUnitTestCase.getServerSession();
        String errorMsg = JoinedAttributeTestHelper.compareCollections(employeesControl, (Collection)employeesReadWithFetchJoin, (ClassDescriptor)session.getClassDescriptor(Employee.class), (AbstractSession)session);
        this.deleteEmployeesWithUnidirectionalMappings(lastName);
        if (errorMsg.length() > 0) {
            AdvancedJPAJunitTest.fail((String)errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnidirectionalTargetLocking_AddRemoveTarget() {
        Dealer dealer3;
        Dealer dealer;
        String lastName = "testUnidirectionalTargetLocking_ART";
        EntityManager em = this.createEntityManager();
        List<Employee> employeesPersisted = this.persistEmployeesWithUnidirectionalMappings(lastName, em);
        this.beginTransaction(em);
        try {
            Employee emp1 = (Employee)em.find(Employee.class, (Object)employeesPersisted.get(1).getId());
            dealer = (Dealer)emp1.getDealers().remove(1);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
                this.closeEntityManager(em);
            }
        }
        String errorMsg = "";
        int version2 = this.getVersion(em, dealer);
        if (version2 != 2) {
            errorMsg = errorMsg + "In the cache the removed dealer's version is " + version2 + " (2 was expected); ";
        }
        this.beginTransaction(em);
        try {
            Dealer dealer2 = (Dealer)em.find(Dealer.class, (Object)dealer.getId());
            em.refresh((Object)dealer2);
            version2 = this.getVersion(em, dealer2);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
        if (version2 != 2) {
            errorMsg = errorMsg + "In the db the removed dealer's version is " + version2 + " (2 was expected); ";
        }
        this.beginTransaction(em);
        try {
            Employee emp2 = (Employee)em.find(Employee.class, (Object)employeesPersisted.get(1).getId());
            dealer3 = (Dealer)em.find(Dealer.class, (Object)dealer.getId());
            emp2.getDealers().add(dealer3);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
                this.closeEntityManager(em);
            }
        }
        int version3 = this.getVersion(em, dealer3);
        if (version3 != 3) {
            errorMsg = errorMsg + "In the cache the added dealer's version is " + version3 + " (3 was expected); ";
        }
        this.beginTransaction(em);
        try {
            Dealer dealer4 = (Dealer)em.find(Dealer.class, (Object)dealer3.getId());
            em.refresh((Object)dealer4);
            version3 = this.getVersion(em, dealer4);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
        if (version3 != 3) {
            errorMsg = errorMsg + "In the db the added dealer's version is " + version3 + " (3 was expected)";
        }
        this.closeEntityManager(em);
        this.deleteEmployeesWithUnidirectionalMappings(lastName);
        if (errorMsg.length() > 0) {
            AdvancedJPAJunitTest.fail((String)errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnidirectionalTargetLocking_DeleteSource() {
        String lastName = "testUnidirectionalTargetLocking_DS";
        List<Employee> persistedEmployees = this.persistEmployeesWithUnidirectionalMappings(lastName);
        ArrayList<Integer> dealersIds = new ArrayList<Integer>();
        for (int i = 0; i < persistedEmployees.size(); ++i) {
            Employee emp = persistedEmployees.get(i);
            for (int j = 0; j < emp.getDealers().size(); ++j) {
                dealersIds.add(((Dealer)emp.getDealers().get(j)).getId());
            }
        }
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        List readEmployees = em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.lastName = '" + lastName + "'").getResultList();
        ((Employee)readEmployees.get(1)).getDealers().size();
        try {
            for (Employee emp : readEmployees) {
                em.remove((Object)emp);
            }
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
                this.closeEntityManager(em);
            }
        }
        this.beginTransaction(em);
        String errorMsg = "";
        try {
            for (int i = 0; i < dealersIds.size(); ++i) {
                Dealer dealer = (Dealer)em.find(Dealer.class, dealersIds.get(i));
                int version2 = this.getVersion(em, dealer);
                if (version2 != 2) {
                    errorMsg = errorMsg + "In the cache dealer " + dealer.getFirstName() + "'s version is " + version2 + " (2 was expected); ";
                }
                em.refresh((Object)dealer);
                version2 = this.getVersion(em, dealer);
                if (version2 == 2) continue;
                errorMsg = errorMsg + "In the db dealer " + dealer.getFirstName() + "'s version is " + version2 + " (2 was expected); ";
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
        this.closeEntityManager(em);
        this.deleteEmployeesWithUnidirectionalMappings(lastName);
        if (errorMsg.length() > 0) {
            AdvancedJPAJunitTest.fail((String)errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnumeratedPrimaryKeys() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            ViolationCode codeA = new ViolationCode();
            codeA.setId(ViolationCode.ViolationCodeId.A);
            codeA.setDescription("Violation A");
            em.persist((Object)codeA);
            ViolationCode codeB = new ViolationCode();
            codeB.setId(ViolationCode.ViolationCodeId.B);
            codeB.setDescription("Violation B");
            em.persist((Object)codeB);
            ViolationCode codeC = new ViolationCode();
            codeC.setId(ViolationCode.ViolationCodeId.C);
            codeC.setDescription("Violation C");
            em.persist((Object)codeC);
            ViolationCode codeD = new ViolationCode();
            codeD.setId(ViolationCode.ViolationCodeId.D);
            codeD.setDescription("Violation D");
            em.persist((Object)codeD);
            Violation violation = new Violation();
            violation.setId(Violation.ViolationID.V1);
            violation.getViolationCodes().add(codeA);
            violation.getViolationCodes().add(codeC);
            violation.getViolationCodes().add(codeD);
            em.persist((Object)violation);
            this.commitTransaction(em);
            this.clearCache();
            em.clear();
            Violation refreshedViolation = (Violation)em.find(Violation.class, (Object)violation.getId());
            AdvancedJPAJunitTest.assertNotNull((String)"Unable to read back the violation", (Object)refreshedViolation);
            AdvancedJPAJunitTest.assertTrue((String)"Violation object did not match after refresh", (boolean)AdvancedJPAJunitTest.getServerSession().compareObjects((Object)violation, (Object)refreshedViolation));
        }
        catch (Exception e) {
            AdvancedJPAJunitTest.fail((String)("An error occurred: " + e.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProjectToEmployeeWithBatchFetchJoinFetch() {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = new QuerySQLTracker((Session)AdvancedJPAJunitTest.getServerSession());
        try {
            TypedQuery query = em.createQuery("SELECT p FROM Project p", Project.class);
            query.setHint("eclipselink.batch", (Object)"p.teamMembers");
            query.setHint("eclipselink.batch", (Object)"p.teamMembers.projects");
            query.setHint("eclipselink.batch", (Object)"p.teamMembers.phoneNumbers.owner");
            query.setHint("eclipselink.batch.type", (Object)BatchFetchType.IN);
            query.setHint("eclipselink.join-fetch", (Object)"p.teamMembers.address");
            query.setHint("eclipselink.join-fetch", (Object)"p.teamMembers.phoneNumbers");
            List results = query.getResultList();
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > 9) {
                AdvancedJPAJunitTest.fail((String)("Should have been 9 queries but was: " + counter.getSqlStatements().size()));
            }
            for (Project project : results) {
                AdvancedJPAJunitTest.assertNotNull((String)"Project cannot be null", (Object)project);
                Employee employee = project.getTeamLeader();
                if (employee == null) continue;
                employee.getProjects().size();
            }
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > 18) {
                AdvancedJPAJunitTest.fail((String)("Should have been 18 queries but was: " + counter.getSqlStatements().size()));
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmployeeToPhoneNumberWithBatchFetchJoinFetch() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Employee emp1 = new Employee();
            emp1.setMale();
            emp1.setFirstName("Mickey");
            emp1.setLastName("O'Neil");
            Employee emp2 = new Employee();
            emp2.setMale();
            emp2.setFirstName("Tony");
            emp2.setLastName("Bullet Tooth");
            em.persist((Object)emp1);
            em.persist((Object)emp2);
            em.flush();
            TypedQuery query = em.createQuery("SELECT e FROM Employee e", Employee.class);
            query.setHint("eclipselink.batch", (Object)"e.projects");
            query.setHint("eclipselink.batch", (Object)"e.projects.teamMembers");
            query.setHint("eclipselink.batch", (Object)"e.phoneNumbers.owner");
            query.setHint("eclipselink.batch.type", (Object)BatchFetchType.IN);
            query.setHint("eclipselink.join-fetch", (Object)"e.address");
            query.setHint("eclipselink.join-fetch", (Object)"e.phoneNumbers");
            List results = query.getResultList();
            for (Employee employee : results) {
                AdvancedJPAJunitTest.assertNotNull((String)"Employee cannot be null", (Object)employee);
                Collection phoneNumbers = employee.getPhoneNumbers();
                for (PhoneNumber phoneNumber : phoneNumbers) {
                    AdvancedJPAJunitTest.assertNotNull((String)"PhoneNumber cannot be null", (Object)phoneNumber);
                }
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmployeeToAddressWithBatchFetchJoinFetch() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Employee emp1 = new Employee();
            emp1.setMale();
            emp1.setFirstName("Mickey");
            emp1.setLastName("O'Neil");
            Employee emp2 = new Employee();
            emp2.setMale();
            emp2.setFirstName("Tony");
            emp2.setLastName("Bullet Tooth");
            em.persist((Object)emp1);
            em.persist((Object)emp2);
            em.flush();
            TypedQuery query = em.createQuery("SELECT e FROM Employee e", Employee.class);
            query.setHint("eclipselink.batch", (Object)"e.projects");
            query.setHint("eclipselink.batch", (Object)"e.projects.teamMembers");
            query.setHint("eclipselink.batch", (Object)"e.phoneNumbers.owner");
            query.setHint("eclipselink.batch.type", (Object)BatchFetchType.IN);
            query.setHint("eclipselink.join-fetch", (Object)"e.address");
            query.setHint("eclipselink.join-fetch", (Object)"e.phoneNumbers");
            List results = query.getResultList();
            for (Employee employee : results) {
                AdvancedJPAJunitTest.assertNotNull((String)"Employee cannot be null", (Object)employee);
                String string = String.valueOf(employee.getAddress());
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmployeeFetchWithAlias() {
        EntityManager em = this.createEntityManager();
        try {
            TypedQuery query = em.createQuery("SELECT d FROM Employee d join fetch d.phoneNumbers p", Employee.class);
            List results = query.getResultList();
            AdvancedJPAJunitTest.assertTrue((String)"Test failed because extra join resulted in too many results", (results.size() < 30 ? 1 : 0) != 0);
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJoinFetchWithRefreshOnRelatedEntity() {
        Employee emp = null;
        Department dept = null;
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            emp = new Employee("Bob", "Robertson");
            dept = new Department("Pomology");
            emp.setDepartment(dept);
            em.persist((Object)emp);
            em.persist((Object)dept);
            this.commitTransaction(em);
        }
        finally {
            this.closeEntityManager(em);
        }
        em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Session session = ((JpaEntityManager)em.getDelegate()).getActiveSession();
            if (session.getDatasourcePlatform().isSQLServer()) {
                session.executeNonSelectingSQL("UPDATE t0 SET t0.F_NAME='Joe', t0.L_NAME='Josephson' FROM CMP3_EMPLOYEE t0 WHERE t0.EMP_ID=" + emp.getId());
                session.executeNonSelectingSQL("UPDATE t1 SET t1.NAME='Xenobiology' FROM CMP3_DEPT t1 WHERE t1.ID=" + dept.getId());
            } else {
                session.executeNonSelectingSQL("UPDATE CMP3_EMPLOYEE t0 SET t0.F_NAME='Joe', t0.L_NAME='Josephson' WHERE t0.EMP_ID=" + emp.getId());
                session.executeNonSelectingSQL("UPDATE CMP3_DEPT t1 SET t1.NAME='Xenobiology' WHERE t1.ID=" + dept.getId());
            }
            this.commitTransaction(em);
        }
        finally {
            this.closeEntityManager(em);
        }
        em = this.createEntityManager();
        try {
            Query query = em.createQuery("select e from Employee e where e.id = :pk");
            query.setParameter("pk", (Object)emp.getId());
            query.setHint("eclipselink.refresh", (Object)"True");
            Employee empReturned = (Employee)query.getSingleResult();
            AdvancedJPAJunitTest.assertNotNull((String)"Employee should not be null", (Object)empReturned);
            Department deptReturned = empReturned.getDepartment();
            AdvancedJPAJunitTest.assertNotNull((String)"Department should not be null", (Object)deptReturned);
            AdvancedJPAJunitTest.assertEquals((String)"Employee should have the same id", (Object)emp.getId(), (Object)empReturned.getId());
            AdvancedJPAJunitTest.assertEquals((String)"Department should have the same id", (Object)dept.getId(), (Object)deptReturned.getId());
            AdvancedJPAJunitTest.assertEquals((String)"Employee's firstName should be refreshed", (String)"Joe", (String)empReturned.getFirstName());
            AdvancedJPAJunitTest.assertEquals((String)"Employee's lastName should be refreshed", (String)"Josephson", (String)empReturned.getLastName());
            AdvancedJPAJunitTest.assertEquals((String)"Department's name should be refreshed", (String)"Xenobiology", (String)deptReturned.getName());
        }
        finally {
            this.closeEntityManager(em);
        }
        em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.remove(em.find(Employee.class, (Object)emp.getId()));
            em.remove(em.find(Department.class, (Object)dept.getId()));
            this.commitTransaction(em);
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHistoryRelationshipQueryInitialization() {
        EntityManager em = this.createEntityManager();
        Oyster oyster = null;
        Pearl pearl = null;
        try {
            this.beginTransaction(em);
            oyster = new Oyster();
            oyster.setColor("Black");
            pearl = new Pearl();
            pearl.setName("Bob");
            oyster.setPearl(pearl);
            pearl.setOyster(oyster);
            em.persist((Object)oyster);
            em.flush();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            oyster.getPearl().setName("Doug");
            this.commitTransaction(em);
        }
        finally {
            this.closeEntityManager(em);
        }
        em = this.createEntityManager();
        try {
            Calendar asOfDate = Calendar.getInstance();
            asOfDate.set(1999, 1, 1, 12, 0, 0);
            ClientSession client = JpaHelper.getServerSession((EntityManagerFactory)em.getEntityManagerFactory()).acquireClientSession();
            Session historical = client.acquireHistoricalSession(new AsOfClause(asOfDate));
            List oysters = historical.readAllObjects(Oyster.class);
            AdvancedJPAJunitTest.assertTrue((String)"Historical query: Oysters should be non-empty", (oysters.size() > 0 ? 1 : 0) != 0);
            for (Oyster oysterElem : oysters) {
                AdvancedJPAJunitTest.assertNull((String)"Historical query: Oyster should not have a pearl", (Object)oysterElem.getPearl());
            }
            oysters = em.createQuery("SELECT e FROM Oyster e", Oyster.class).getResultList();
            AdvancedJPAJunitTest.assertTrue((String)"JPA query: Oysters should be non-empty", (oysters.size() > 0 ? 1 : 0) != 0);
            for (Oyster oysterElem : oysters) {
                AdvancedJPAJunitTest.assertNotNull((String)"JPA query: Oyster should have a pearl, historical query executed", (Object)oysterElem.getPearl());
            }
        }
        finally {
            this.closeEntityManager(em);
        }
        em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            oyster = (Oyster)em.find(Oyster.class, (Object)oyster.getId());
            if (oyster != null) {
                em.remove((Object)oyster);
            }
            if ((pearl = (Pearl)em.find(Pearl.class, (Object)pearl.getId())) != null) {
                em.remove((Object)pearl);
            }
            this.commitTransaction(em);
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryJoinBasicCollectionTableUsingQueryResultsCache() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            String commonName = "My List";
            String commonItem = "Feed the cat";
            ToDoList bobsList = new ToDoList(1, commonName);
            bobsList.addItem(commonItem);
            bobsList.addItem("Cook dinner");
            bobsList.addItem("Watch TV");
            ToDoList jensList = new ToDoList(2, commonName);
            jensList.addItem("Feed the dog");
            jensList.addItem("Hire and fire");
            jensList.addItem("Eat chocolate");
            ToDoList bertsList = new ToDoList(3, commonName);
            bertsList.addItem(commonItem);
            bertsList.addItem("Feed the kids");
            bertsList.addItem("Feed the wife");
            em.persist((Object)bobsList);
            em.persist((Object)jensList);
            em.persist((Object)bertsList);
            em.flush();
            Query query = em.createQuery("SELECT tdl FROM ToDoList tdl JOIN tdl.items items WHERE tdl.name = :p_name AND items = :p_itemName");
            query.setHint("eclipselink.query-results-cache", (Object)"True");
            query.setParameter("p_name", (Object)commonName);
            query.setParameter("p_itemName", (Object)commonItem);
            List listsReturned = query.getResultList();
            AdvancedJPAJunitTest.assertNotNull((String)"Query results should not be null", (Object)listsReturned);
            AdvancedJPAJunitTest.assertSame((String)"Query results size", (Object)2, (Object)listsReturned.size());
            for (ToDoList aList : listsReturned) {
                AdvancedJPAJunitTest.assertEquals((String)commonName, (String)aList.getName());
                AdvancedJPAJunitTest.assertTrue((boolean)aList.getItems().contains(commonItem));
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransparentIndirectionValueHolderSessionReset() {
        Employee emp = null;
        Dealer dealer = null;
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            dealer = new Dealer();
            dealer.setFirstName("Angle");
            dealer.setLastName("Bracket");
            em.persist((Object)dealer);
            this.commitTransaction(em);
        }
        finally {
            this.closeEntityManager(em);
            this.clearCache();
        }
        em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            emp = new Employee();
            emp.setFemale();
            emp.setFirstName("Case");
            emp.setLastName("Statement");
            em.persist((Object)emp);
            Query query = em.createQuery("select d from Dealer d where d.firstName = :firstName and d.lastName = :lastName");
            query.setParameter("firstName", (Object)dealer.getFirstName());
            query.setParameter("lastName", (Object)dealer.getLastName());
            List resultsList = query.getResultList();
            AdvancedJPAJunitTest.assertTrue((String)"List returned should be non-empty", (resultsList.size() > 0 ? 1 : 0) != 0);
            Dealer dealerFound = (Dealer)resultsList.get(0);
            emp.addDealer(dealerFound);
            this.commitTransaction(em);
            Server parentSession = JpaHelper.getServerSession((EntityManagerFactory)em.getEntityManagerFactory());
            Dealer cachedDealer = (Dealer)parentSession.getIdentityMapAccessor().getFromIdentityMap((Object)dealer);
            AdvancedJPAJunitTest.assertNotNull((String)("Dealer with id should be in the cache: " + dealer.getId()), (Object)cachedDealer);
            ClassDescriptor descriptor = parentSession.getDescriptor(Dealer.class);
            DatabaseMapping mapping = descriptor.getMappingForAttributeName("customers");
            IndirectCollection indirectCollection = (IndirectCollection)mapping.getAttributeValueFromObject((Object)cachedDealer);
            AdvancedJPAJunitTest.assertFalse((String)"Collection VH should be uninstantiated", (boolean)indirectCollection.isInstantiated());
            DatabaseValueHolder dbValueHolder = (DatabaseValueHolder)indirectCollection.getValueHolder();
            AdvancedJPAJunitTest.assertFalse((String)"Referenced VH should be uninstantiated", (boolean)dbValueHolder.isInstantiated());
            AbstractSession vhSession = dbValueHolder.getSession();
            AdvancedJPAJunitTest.assertSame((String)"Dealer.customers VH session should reference the shared session", (Object)parentSession, (Object)vhSession);
        }
        finally {
            this.closeEntityManager(em);
        }
        em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            if (emp != null) {
                em.remove((Object)emp);
            }
            if ((dealer = (Dealer)em.find(Dealer.class, (Object)dealer.getId())) != null) {
                em.remove((Object)dealer);
            }
            this.commitTransaction(em);
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransparentIndirectionQuerySessionReset() {
        Bill bill = null;
        BillLine billLine = null;
        BillLineItem billLineItem = null;
        BillAction billAction = null;
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            bill = new Bill();
            bill.setOrderIdentifier("Test Bill");
            billLine = new BillLine();
            billLine.setQuantity(6);
            bill.addBillLine(billLine);
            billLineItem = new BillLineItem();
            billLineItem.setItemName("Test Widget");
            billLine.addBillLineItem(billLineItem);
            em.persist((Object)bill);
            em.persist((Object)billLine);
            em.persist((Object)billLineItem);
            this.commitTransaction(em);
            AdvancedJPAJunitTest.assertNotNull((String)"bill should be non-null", (Object)bill);
            AdvancedJPAJunitTest.assertNotNull((String)"bill's id should be non-null", (Object)bill.getId());
            AdvancedJPAJunitTest.assertNotNull((String)"billLine should be non-null", (Object)billLine);
            AdvancedJPAJunitTest.assertNotNull((String)"billLine's id should be non-null", (Object)billLine.getId());
            AdvancedJPAJunitTest.assertNotNull((String)"billLineItem should be non-null", (Object)billLineItem);
            AdvancedJPAJunitTest.assertNotNull((String)"billLineItem's id should be non-null", (Object)billLineItem.getId());
        }
        finally {
            this.closeEntityManager(em);
            this.clearCache();
        }
        try {
            ReadQuery query;
            Bill billReRead;
            em = this.createEntityManager();
            try {
                this.beginTransaction(em);
                billReRead = (Bill)em.createQuery("SELECT b FROM Bill b where b.id=" + bill.getId(), Bill.class).getSingleResult();
                AdvancedJPAJunitTest.assertNotNull((Object)billReRead);
                BillLine billLineReRead = (BillLine)billReRead.getBillLines().get(0);
                AdvancedJPAJunitTest.assertNotNull((Object)billLineReRead);
                billAction = new BillAction();
                billAction.setBillLine(billLineReRead);
                billAction.setPriority(2);
                em.persist((Object)billAction);
                em.refresh((Object)billLineReRead);
                this.commitTransaction(em);
            }
            finally {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
            }
            em = this.createEntityManager();
            try {
                this.beginTransaction(em);
                billReRead = (Bill)em.createQuery("SELECT b FROM Bill b where b.id=" + bill.getId(), Bill.class).getSingleResult();
                billReRead.setStatus("PROCESSING");
                BillAction billActionReRead = (BillAction)em.createQuery("SELECT a FROM BillAction a where a.id=" + billAction.getId(), BillAction.class).getSingleResult();
                AdvancedJPAJunitTest.assertNotNull((Object)billActionReRead);
                BillLine billLineReRead = billActionReRead.getBillLine();
                AdvancedJPAJunitTest.assertNotNull((Object)billLineReRead);
                billLineReRead.getBillLineItems().size();
                this.commitTransaction(em);
            }
            finally {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
            }
            ServerSession srv = AdvancedJPAJunitTest.getServerSession();
            ClassDescriptor descriptor = srv.getDescriptor((Object)billLine);
            Long blId = billLine.getId();
            BillLine cachedBillLine = (BillLine)srv.getIdentityMapAccessor().getFromIdentityMap((Object)blId, BillLine.class);
            AdvancedJPAJunitTest.assertNotNull((String)("BillLine from shared cache is null with id: " + blId), (Object)cachedBillLine);
            OneToManyMapping mapping = (OneToManyMapping)srv.getDescriptor((Object)cachedBillLine).getMappingForAttributeName("billLineItems");
            IndirectContainer billLineItemsVH = (IndirectContainer)mapping.getAttributeValueFromObject((Object)cachedBillLine);
            AdvancedJPAJunitTest.assertNotNull((String)"BillLineItems ValueHolder should not be null", (Object)billLineItemsVH);
            ValueHolderInterface wrappedVH = billLineItemsVH.getValueHolder();
            AdvancedJPAJunitTest.assertNotNull((String)"Wrapped ValueHolder should not be null", (Object)wrappedVH);
            if (wrappedVH instanceof QueryBasedValueHolder && (query = ((QueryBasedValueHolder)wrappedVH).getQuery()).getSession() != null && query.getSession().isUnitOfWork()) {
                AdvancedJPAJunitTest.fail((String)"UnitOfWork referenced in Query from wrapped QueryBasedValueHolder in shared cache");
            }
        }
        finally {
            em = this.createEntityManager();
            try {
                this.beginTransaction(em);
                bill = (Bill)em.find(Bill.class, (Object)bill.getId());
                if (bill != null) {
                    em.remove((Object)bill);
                }
                if ((billLine = (BillLine)em.find(BillLine.class, (Object)billLine.getId())) != null) {
                    em.remove((Object)billLine);
                }
                if ((billLineItem = (BillLineItem)em.find(BillLineItem.class, (Object)billLineItem.getId())) != null) {
                    em.remove((Object)billLineItem);
                }
                if (billAction != null && (billAction = (BillAction)em.find(BillAction.class, (Object)billAction.getId())) != null) {
                    em.remove((Object)billAction);
                }
                this.commitTransaction(em);
            }
            finally {
                this.closeEntityManager(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmployeeToProjectWithBatchFetchTypeInReverseIteration() {
        String lastName = "testEmployeeToProject";
        HashSet<Employee> employeesToRemove = new HashSet<Employee>();
        EntityManager em = this.createEntityManager();
        for (int i = 0; i < 100; ++i) {
            this.beginTransaction(em);
            Employee employee = new Employee();
            employee.setLastName("testEmployeeToProject");
            employeesToRemove.add(employee);
            em.persist((Object)employee);
            for (int j = 0; j < 20; ++j) {
                Project project = new Project();
                employee.addProject(project);
                em.persist((Object)project);
            }
            this.commitTransaction(em);
        }
        JpaEntityManager jpaEntityManager = (JpaEntityManager)em.getDelegate();
        jpaEntityManager.getUnitOfWork().getIdentityMapAccessor().initializeAllIdentityMaps();
        try {
            ExpressionBuilder exp = new ExpressionBuilder(Employee.class);
            EJBQueryImpl query = (EJBQueryImpl)jpaEntityManager.createQuery((Expression)exp, Employee.class);
            ((ReadAllQuery)query.getDatabaseQuery()).addBatchReadAttribute("projects");
            ((ReadAllQuery)query.getDatabaseQuery()).setBatchFetchType(BatchFetchType.IN);
            ((ReadAllQuery)query.getDatabaseQuery()).setBatchFetchSize(10);
            List employees = query.getResultList();
            Collections.reverse(employees);
            int count = 0;
            try {
                for (Employee employee : employees) {
                    if (!"testEmployeeToProject".equals(employee.getLastName())) continue;
                    for (Project project : employee.getProjects()) {
                        ++count;
                    }
                }
                Assert.assertEquals((String)"Project objects received are not as many as expected", (long)2000L, (long)count);
            }
            catch (ArrayIndexOutOfBoundsException x) {
                Assert.fail((String)Helper.printStackTraceToString((Throwable)x));
            }
        }
        finally {
            this.beginTransaction(em);
            for (Employee employee : employeesToRemove) {
                employee = (Employee)em.merge((Object)employee);
                for (Project project : employee.getProjects()) {
                    em.remove(em.merge((Object)project));
                }
                em.remove((Object)employee);
            }
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmployeeToProjectWithBatchFetchTypeInCustomIteration() {
        String lastName = "testEmployeeToProject";
        HashSet<Employee> employeesToRemove = new HashSet<Employee>();
        EntityManager em = this.createEntityManager();
        for (int i = 0; i < 100; ++i) {
            this.beginTransaction(em);
            Employee employee = new Employee();
            employee.setLastName("testEmployeeToProject");
            employeesToRemove.add(employee);
            em.persist((Object)employee);
            for (int j = 0; j < 20; ++j) {
                Project project = new Project();
                employee.addProject(project);
                em.persist((Object)project);
            }
            this.commitTransaction(em);
        }
        JpaEntityManager jpaEntityManager = (JpaEntityManager)em.getDelegate();
        jpaEntityManager.getUnitOfWork().getIdentityMapAccessor().initializeAllIdentityMaps();
        try {
            ExpressionBuilder exp = new ExpressionBuilder(Employee.class);
            EJBQueryImpl query = (EJBQueryImpl)jpaEntityManager.createQuery((Expression)exp, Employee.class);
            ((ReadAllQuery)query.getDatabaseQuery()).addBatchReadAttribute("projects");
            ((ReadAllQuery)query.getDatabaseQuery()).setBatchFetchType(BatchFetchType.IN);
            ((ReadAllQuery)query.getDatabaseQuery()).setBatchFetchSize(10);
            List employees = query.getResultList();
            employees.add(employees.remove(0));
            int count = 0;
            try {
                for (Employee employee : employees) {
                    if (!"testEmployeeToProject".equals(employee.getLastName())) continue;
                    for (Project project : employee.getProjects()) {
                        ++count;
                    }
                }
                Assert.assertEquals((String)"Project objects received are not as many as expected", (long)2000L, (long)count);
            }
            catch (ArrayIndexOutOfBoundsException x) {
                Assert.fail((String)Helper.printStackTraceToString((Throwable)x));
            }
        }
        finally {
            this.beginTransaction(em);
            for (Employee employee : employeesToRemove) {
                employee = (Employee)em.merge((Object)employee);
                for (Project project : employee.getProjects()) {
                    em.remove(em.merge((Object)project));
                }
                em.remove((Object)employee);
            }
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmployeeToProjectWithBatchFetchTypeInRandomIteration() {
        String lastName = "testRandomEmployeeToProject";
        HashSet<Employee> employeesToRemove = new HashSet<Employee>();
        EntityManager em = this.createEntityManager();
        for (int i = 0; i < 100; ++i) {
            this.beginTransaction(em);
            Employee employee = new Employee();
            employee.setLastName("testRandomEmployeeToProject");
            employeesToRemove.add(employee);
            em.persist((Object)employee);
            for (int j = 0; j < 20; ++j) {
                Project project = new Project();
                employee.addProject(project);
                em.persist((Object)project);
            }
            this.commitTransaction(em);
        }
        JpaEntityManager jpaEntityManager = (JpaEntityManager)em.getDelegate();
        jpaEntityManager.getUnitOfWork().getIdentityMapAccessor().initializeAllIdentityMaps();
        try {
            Expression exp = new ExpressionBuilder(Employee.class).get("lastName").equal((Object)"testRandomEmployeeToProject");
            EJBQueryImpl query = (EJBQueryImpl)jpaEntityManager.createQuery(exp, Employee.class);
            ((ReadAllQuery)query.getDatabaseQuery()).addBatchReadAttribute("projects");
            ((ReadAllQuery)query.getDatabaseQuery()).setBatchFetchType(BatchFetchType.IN);
            ((ReadAllQuery)query.getDatabaseQuery()).setBatchFetchSize(99);
            List employees = query.getResultList();
            Collections.shuffle(employees);
            int count = 0;
            try {
                for (Employee employee : employees) {
                    for (Project project : employee.getProjects()) {
                        ++count;
                    }
                }
                Assert.assertEquals((String)"Project objects received are not as many as expected", (long)2000L, (long)count);
            }
            catch (ArrayIndexOutOfBoundsException x) {
                Assert.fail((String)Helper.printStackTraceToString((Throwable)x));
            }
        }
        finally {
            this.beginTransaction(em);
            for (Employee employee : employeesToRemove) {
                employee = (Employee)em.merge((Object)employee);
                for (Project project : employee.getProjects()) {
                    em.remove(em.merge((Object)project));
                }
                em.remove((Object)employee);
            }
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNullValueInCollectionWithOrderColumn() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        OrderedEntityA newEntityA1 = new OrderedEntityA(Long.valueOf(1L), "Entity-A1");
        OrderedEntityA newEntityA2 = null;
        OrderedEntityZ newEntityZ1 = new OrderedEntityZ(Long.valueOf(1L), "Entity-Z1");
        OrderedEntityZ newEntityZ2 = new OrderedEntityZ(Long.valueOf(2L), "Entity-Z2");
        newEntityZ1.addEntityA(newEntityA1);
        em.persist((Object)newEntityA1);
        em.persist((Object)newEntityZ1);
        em.persist((Object)newEntityZ2);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        try {
            em = this.createEntityManager();
            this.beginTransaction(em);
            OrderedEntityZ entityZ2 = (OrderedEntityZ)em.createQuery("SELECT z FROM OrderedEntityZ z WHERE z.id = 2", OrderedEntityZ.class).getSingleResult();
            entityZ2.setDescription("Entity-Z2-MODIFIED");
            em.persist((Object)entityZ2);
            OrderedEntityZ entityZ1 = (OrderedEntityZ)em.createQuery("SELECT z FROM OrderedEntityZ z WHERE z.id = 1", OrderedEntityZ.class).getSingleResult();
            entityZ1.removeEntityA((OrderedEntityA)entityZ1.getEntityAs().get(0));
            newEntityA2 = new OrderedEntityA(Long.valueOf(2L), "Entity-A2");
            entityZ1.addEntityA(newEntityA2);
            em.persist((Object)newEntityA2);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            em = this.createEntityManager();
            entityZ1 = (OrderedEntityZ)em.createQuery("SELECT z FROM OrderedEntityZ z WHERE z.id = 1", OrderedEntityZ.class).getSingleResult();
            List entityAList = entityZ1.getEntityAs();
            AdvancedJPAJunitTest.assertEquals((String)"invalid collection size", (int)1, (int)entityAList.size());
            OrderedEntityA firstEntityA = (OrderedEntityA)entityAList.get(0);
            AdvancedJPAJunitTest.assertNotNull((String)"null value in collection", (Object)firstEntityA);
            AdvancedJPAJunitTest.assertEquals((String)"wrong description in entity", (String)newEntityA2.getDescription(), (String)firstEntityA.getDescription());
            this.closeEntityManager(em);
        }
        finally {
            if (em != null && em.isOpen()) {
                this.closeEntityManager(em);
            }
            em = this.createEntityManager();
            this.beginTransaction(em);
            newEntityA1 = (OrderedEntityA)em.find(OrderedEntityA.class, (Object)newEntityA1.getId());
            if (newEntityA1 != null) {
                em.remove((Object)newEntityA1);
            }
            if (newEntityA2 != null && (newEntityA2 = (OrderedEntityA)em.find(OrderedEntityA.class, (Object)newEntityA2.getId())) != null) {
                em.remove((Object)newEntityA2);
            }
            if ((newEntityZ1 = (OrderedEntityZ)em.find(OrderedEntityZ.class, (Object)newEntityZ1.getId())) != null) {
                em.remove((Object)newEntityZ1);
            }
            if ((newEntityZ2 = (OrderedEntityZ)em.find(OrderedEntityZ.class, (Object)newEntityZ2.getId())) != null) {
                em.remove((Object)newEntityZ2);
            }
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJoinWithOrderByOnElementCollectionList() {
        EntityManager em = this.createEntityManager();
        try {
            String jpql = "SELECT resp FROM Employee e JOIN e.responsibilities AS resp WHERE e.lastName = 'Smith' ORDER BY resp";
            TypedQuery query = em.createQuery(jpql, String.class);
            List list = query.getResultList();
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJoinWithOrderByOnElementCollectionMap() {
        EntityManager em = this.createEntityManager();
        try {
            String jpql = "SELECT value(mapEntry) FROM Buyer b JOIN b.creditCards mapEntry WHERE key(mapEntry) = 'VI' ORDER BY value(mapEntry)";
            TypedQuery query = em.createQuery(jpql, Long.class);
            List list = query.getResultList();
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    protected int getVersion(EntityManager em, Dealer dealer) {
        Vector<Integer> pk = new Vector<Integer>(1);
        pk.add(dealer.getId());
        return (Integer)AdvancedJPAJunitTest.getServerSession().getDescriptor(Dealer.class).getOptimisticLockingPolicy().getWriteLockValue((Object)dealer, pk, (AbstractSession)AdvancedJPAJunitTest.getServerSession());
    }

    protected List<Employee> createEmployeesWithUnidirectionalMappings(String lastName) {
        int n = 2;
        ArrayList<Employee> employees = new ArrayList<Employee>(n);
        for (int i = 0; i < n; ++i) {
            Employee emp = new Employee();
            emp.setFirstName(Integer.toString(i + 1));
            emp.setLastName(lastName);
            employees.add(emp);
            for (int j = 0; j < n; ++j) {
                Dealer dealer = new Dealer();
                dealer.setFirstName(emp.getFirstName() + "_" + Integer.toString(j + 1));
                dealer.setLastName(lastName);
                emp.addDealer(dealer);
                for (int k = 0; k < n; ++k) {
                    Customer customer = new Customer();
                    customer.setFirstName(dealer.getFirstName() + "_" + Integer.toString(k + 1));
                    customer.setLastName(lastName);
                    dealer.addCustomer(customer);
                }
            }
        }
        return employees;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Employee> persistEmployeesWithUnidirectionalMappings(String lastName) {
        EntityManager em = this.createEntityManager();
        try {
            List<Employee> list = this.persistEmployeesWithUnidirectionalMappings(lastName, em);
            return list;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Employee> persistEmployeesWithUnidirectionalMappings(String lastName, EntityManager em) {
        List<Employee> employees = this.createEmployeesWithUnidirectionalMappings(lastName);
        this.beginTransaction(em);
        try {
            for (int i = 0; i < employees.size(); ++i) {
                em.persist((Object)employees.get(i));
            }
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
        return employees;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteEmployeesWithUnidirectionalMappings(String lastName) {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.createQuery("DELETE FROM AdvancedCustomer c WHERE c.lastName = '" + lastName + "'").executeUpdate();
            em.createQuery("DELETE FROM Dealer d WHERE d.lastName = '" + lastName + "'").executeUpdate();
            Query q = em.createQuery("SELECT e FROM Employee e WHERE e.lastName = '" + lastName + "'");
            for (Object oldData : q.getResultList()) {
                em.remove(oldData);
            }
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            this.clearCache();
        }
    }

    static {
        visa = 1234567890L;
        amex = 1987654321L;
        diners = 1192837465L;
        mastercard = 1647382910L;
        rbc = 4783L;
        scotia = 8732L;
        td = 839362L;
        cibc = 948274L;
        newResponsibility = "The most useless responsibility ever.";
    }
}

